#include "Data_VehicleSpeed.h"
#include "Gauges.h"
#include "GaugesInterface.h"
#include "TimerB.h"

#define VEH_FILTER_LEN    7

static struct
{
    uint8_t Count ;
    uint16_t Data[VEH_FILTER_LEN] ;
} VehcleFilter;

static uint32_t SPEED_PPK = 159246ul ;
static uint32_t SPEED_RADIO = 637 ;

uint16_t Vehicle_ACT_Speed;
uint16_t Vehicle_DISP_Speed;
uint8_t VehicleSpeedValid;
uint8_t Vehicle_CurSeg ;

static uint16_t Cal_VehSpeed(uint16_t Fre, uint8_t Len);

void Speed_KL30_Init(void)
{
    uint8_t i ;
    Vehicle_ACT_Speed = 0u;
    Vehicle_DISP_Speed = 0u;
    VehicleSpeedValid = 0u;
    Vehicle_CurSeg = 0u;
    VehcleFilter.Count = 0 ;
    for (i = 0 ; i < VEH_FILTER_LEN ; i ++)
    {
        VehcleFilter.Data[ i ] = 0 ;
    }

    Set_Speed_PPK(159246ul);
}
void Speed_KL15_ON_Init(void)
{
    uint8_t i ;
    Vehicle_ACT_Speed = 0u;
    Vehicle_DISP_Speed = 0u;
    VehicleSpeedValid = 0u;
    Vehicle_CurSeg = 0u;
    VehcleFilter.Count = 0 ;
    for (i = 0 ; i < VEH_FILTER_LEN ; i ++)
    {
        VehcleFilter.Data[ i ] = 0 ;
    }

    Veh_Fre_Init(Get_Speed_PPK() / 10);
}
void Speed_KL15_OFF_Init(void)
{
    uint8_t i ;
    Vehicle_ACT_Speed = 0u;
    Vehicle_DISP_Speed = 0u;
    VehicleSpeedValid = 0u;
    Vehicle_CurSeg = 0u;
    VehcleFilter.Count = 0 ;
    for (i = 0 ; i < VEH_FILTER_LEN ; i ++)
    {
        VehcleFilter.Data[ i ] = 0 ;
    }
}
void Speed_Wakeup_Init(void)
{
    uint8_t i ;
    Vehicle_ACT_Speed = 0u;
    Vehicle_DISP_Speed = 0u;
    VehicleSpeedValid = 0u;
    Vehicle_CurSeg = 0u;
    for (i = 0 ; i < VEH_FILTER_LEN ; i ++)
    {
        VehcleFilter.Data[ i ] = 0 ;
    }
}
void Speed_Sleep_Init(void)
{
    uint8_t i ;
    Vehicle_ACT_Speed = 0u;
    Vehicle_DISP_Speed = 0u;
    VehicleSpeedValid = 0u;
    Vehicle_CurSeg = 0u;
    for (i = 0 ; i < VEH_FILTER_LEN ; i ++)
    {
        VehcleFilter.Data[ i ] = 0 ;
    }
}

void Speed_Processing_Service(void)
{
    uint32_t VehValTmp = 0u;
    uint32_t PPK = 0u;
    //if(Get_Veh_Fre_Event())
    //{
    //    VehValTmp = Cal_VehSpeed(Get_Veh_Fre(),VEH_FILTER_LEN) ;

    //    VehValTmp *= 3600 ;
    //    VehValTmp *= 10 ;
    //    VehValTmp *= 10 ;
    //    VehValTmp /= PPK ;

    //    Vehicle_ACT_Speed = VehValTmp ;
    //}

    PPK = Get_Speed_PPK();
    VehValTmp = Cal_Veh_Frequency();

    VehValTmp *= 3600 ;
    VehValTmp *= 10 ;
    VehValTmp *= 10 ;
    VehValTmp /= PPK ;



    //VehValTmp = Cal_Veh_Frequency();
    //VehValTmp *= 3600 ;
    //VehValTmp *= 10 ;
    //VehValTmp /= PPK ;

    if (VehValTmp > 2250)
    {
        VehValTmp = 0 ;
        VehicleSpeedValid = 0 ;
    }
    else
    {
        VehicleSpeedValid = 1 ;
    }
    Vehicle_ACT_Speed = VehValTmp ;

//传入表头
    VehValTmp = VehSpeedAmplification((uint16_t)VehValTmp);
    SetGaugesPara(VehGauges, (uint16_t)VehValTmp);

//获得显示格和显示车速
    Vehicle_CurSeg = GetGaugesCurrentPos(VehGauges);
    Vehicle_DISP_Speed = GetVehDisVal(Vehicle_CurSeg, &GaugesInfo_Init_Table[VehGauges]);


}

static uint16_t Cal_VehSpeed(uint16_t Fre, uint8_t Len)
{
    static uint16_t u16Result = 0 ;
    if (Fre > 2000)
    {
        //do nothing
    }
    else
    {
        if (VehcleFilter.Count < Len)
        {
            VehcleFilter.Data[VehcleFilter.Count] = Fre ;
            VehcleFilter.Count ++ ;
        }
        else
        {
            VehcleFilter.Count = 0 ;
            App_SortNByte(VehcleFilter.Data, Len);

            u16Result = VehcleFilter.Data[2] ;
            u16Result += VehcleFilter.Data[3] ;
            u16Result += VehcleFilter.Data[3] ;
            u16Result += VehcleFilter.Data[4] ;
            u16Result /= 4 ;
        }
    }

    return u16Result ;
}

/*-------------------------------------------------------------------------
 * Function Name  : Set_Speed_PPK
 * Description    : 设置PPK值,初始化 或需要改变时调用
 * Input          : 10倍的PPK
 * Output         : None
 * Return         : None
 * onther         : PPK = 频率 * 3600 / 车速
 --------------------------------------------------------------------------*/
void Set_Speed_PPK(uint32_t PPK)
{
    SPEED_PPK = PPK ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Set_Speed_PPK
 * Description    : 设置速比值,初始化 或需要改变时调用
 * Input          : 速比
 * Output         : None
 * Return         : None
 * onther         : 速比 = PPK / 脉冲
 --------------------------------------------------------------------------*/
void Set_Speed_Ratio(uint32_t Ratio)
{
    SPEED_RADIO = Ratio ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Get_Speed_PPK
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : 10倍PPK值
 * onther         :
 --------------------------------------------------------------------------*/
uint32_t Get_Speed_PPK(void)
{
    uint32_t u32Result = 0u;
    u32Result = SPEED_PPK ;
    return u32Result ;
}

uint16_t Speed_Get_ActualValue(void)
{
    uint16_t u16Result = 0u;
    u16Result = Vehicle_ACT_Speed;
    return u16Result;
}
uint16_t Speed_Get_Display_Value(void)
{
    uint16_t u16Result = 0u;
    u16Result = Vehicle_DISP_Speed;
    return u16Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : Speed_Get_CurSeg
 * Description    : 车速当前格
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 应用于断码
 --------------------------------------------------------------------------*/
uint8_t Speed_Get_CurSeg(void)
{
    return Vehicle_CurSeg ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Speed_Get_Valid
 * Description    : 车速有效？
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t Speed_Get_Valid(void)
{
    return VehicleSpeedValid ;
}


