#ifndef __CD4051_H_
#define __CD4051_H_

#include "TYW_stdint.h"

#define CD4051B_A_MCU CD4051A_A_MCU_OUT
#define CD4051B_B_MCU CD4051A_B_MCU_OUT
#define CD4051B_C_MCU CD4051A_C_MCU_OUT

#define CD4051B_InputGOIO_Com1 CD4051A_COM1_MCU_IN
#define CD4051B_InputGOIO_Com2 CD4051A_COM2_MCU_IN
#define CD4051B_InputGOIO_Com3 CD4051A_COM3_MCU_IN
#define CD4051B_InputGOIO_Com4 CD4051A_COM4_MCU_IN
#define CD4051B_InputGOIO_Com5 CD4051A_COM5_MCU_IN
#define CD4051B_InputGOIO_Com6 CD4051A_COM6_MCU_IN
#define CD4051B_InputGOIO_Com7 CD4051A_COM7_MCU_IN

#define CD4051B_DEBOUNCE_High_TIME 20u
#define CD4051B_DEBOUNCE_Low_TIME 20u
#define CD4051B_DEBOUNCE_High_CNT CD4051B_DEBOUNCE_High_TIME / 20u
#define CD4051B_DEBOUNCE_Low_CNT CD4051B_DEBOUNCE_Low_TIME / 20u
/*通道枚举*/
typedef enum
{
    Channel0 = 0u,
    Channel1,
    Channel2,
    Channel3,
    Channel4,
    Channel5,
    Channel6,
    Channel7,
    MaxChannel,
} CD4051BChannel;
typedef enum
{
    COM1 = 0u,
    COM2,
    COM3,
    COM4,
    COM5,
    COM6,
    COM7,
    COMTotal,
} CD4051B_COMNumber;
/*结构体*/
typedef struct
{
    uint16_t time;
    uint16_t Last;
} CD4051CtrStruct;

extern uint16_t CD4051B_GeneralCOM_Cache[COMTotal][MaxChannel];
extern uint16_t CD4051B_GeneralCOM_Value[COMTotal][MaxChannel];
//-----------------外部应用需要时调用----------------------
/*COM1映射PCB*/
#define CD4051_COM1_X0_IN (CD4051B_GeneralCOM_Value[COM1][Channel0]) /*A36*/
#define CD4051_COM1_X1_IN (CD4051B_GeneralCOM_Value[COM1][Channel1]) /*   */
#define CD4051_COM1_X2_IN (CD4051B_GeneralCOM_Value[COM1][Channel2]) /*   */
#define CD4051_COM1_X3_IN (CD4051B_GeneralCOM_Value[COM1][Channel3]) /*A34*/
#define CD4051_COM1_X4_IN (CD4051B_GeneralCOM_Value[COM1][Channel4]) /*A21*/
#define CD4051_COM1_X5_IN (CD4051B_GeneralCOM_Value[COM1][Channel5]) /*A25*/
#define CD4051_COM1_X6_IN (CD4051B_GeneralCOM_Value[COM1][Channel6]) /*A22*/
#define CD4051_COM1_X7_IN (CD4051B_GeneralCOM_Value[COM1][Channel7]) /*A23*/
/*COM2映射PCB*/
#define CD4051_COM2_X0_IN (CD4051B_GeneralCOM_Value[COM2][Channel0]) /*A31*/
#define CD4051_COM2_X1_IN (CD4051B_GeneralCOM_Value[COM2][Channel1]) /*A32*/
#define CD4051_COM2_X2_IN (CD4051B_GeneralCOM_Value[COM2][Channel2]) /*A33*/
#define CD4051_COM2_X3_IN (CD4051B_GeneralCOM_Value[COM2][Channel3]) /*A30*/
#define CD4051_COM2_X4_IN (CD4051B_GeneralCOM_Value[COM2][Channel4]) /*A26*/
#define CD4051_COM2_X5_IN (CD4051B_GeneralCOM_Value[COM2][Channel5]) /*A29*/
#define CD4051_COM2_X6_IN (CD4051B_GeneralCOM_Value[COM2][Channel6]) /*A27*/
#define CD4051_COM2_X7_IN (CD4051B_GeneralCOM_Value[COM2][Channel7]) /*A28*/
/*COM3映射PCB*/
#define CD4051_COM3_X0_IN (CD4051B_GeneralCOM_Value[COM3][Channel0]) /*A19*/
#define CD4051_COM3_X1_IN (CD4051B_GeneralCOM_Value[COM3][Channel1]) /*B19*/
#define CD4051_COM3_X2_IN (CD4051B_GeneralCOM_Value[COM3][Channel2]) /*B18*/
#define CD4051_COM3_X3_IN (CD4051B_GeneralCOM_Value[COM3][Channel3]) /*A15*/
#define CD4051_COM3_X4_IN (CD4051B_GeneralCOM_Value[COM3][Channel4]) /*A10*/
#define CD4051_COM3_X5_IN (CD4051B_GeneralCOM_Value[COM3][Channel5]) /*A20*/
#define CD4051_COM3_X6_IN (CD4051B_GeneralCOM_Value[COM3][Channel6]) /*A06*/
#define CD4051_COM3_X7_IN (CD4051B_GeneralCOM_Value[COM3][Channel7]) /*A03*/
/*COM4映射PCB*/
#define CD4051_COM4_X0_IN (CD4051B_GeneralCOM_Value[COM4][Channel0]) /*B35*/
#define CD4051_COM4_X1_IN (CD4051B_GeneralCOM_Value[COM4][Channel1]) /*B34*/
#define CD4051_COM4_X2_IN (CD4051B_GeneralCOM_Value[COM4][Channel2]) /*B33*/
#define CD4051_COM4_X3_IN (CD4051B_GeneralCOM_Value[COM4][Channel3]) /*B36*/
#define CD4051_COM4_X4_IN (CD4051B_GeneralCOM_Value[COM4][Channel4]) /*B20*/
#define CD4051_COM4_X5_IN (CD4051B_GeneralCOM_Value[COM4][Channel5]) /*B37*/
#define CD4051_COM4_X6_IN (CD4051B_GeneralCOM_Value[COM4][Channel6]) /*B40*/
#define CD4051_COM4_X7_IN (CD4051B_GeneralCOM_Value[COM4][Channel7]) /*B38*/
/*COM5映射PCB*/
#define CD4051_COM5_X0_IN (CD4051B_GeneralCOM_Value[COM5][Channel0]) /*B23*/
#define CD4051_COM5_X1_IN (CD4051B_GeneralCOM_Value[COM5][Channel1]) /*B22*/
#define CD4051_COM5_X2_IN (CD4051B_GeneralCOM_Value[COM5][Channel2]) /*B21*/
#define CD4051_COM5_X3_IN (CD4051B_GeneralCOM_Value[COM5][Channel3]) /*B24*/
#define CD4051_COM5_X4_IN (CD4051B_GeneralCOM_Value[COM5][Channel4]) /*B32*/
#define CD4051_COM5_X5_IN (CD4051B_GeneralCOM_Value[COM5][Channel5]) /*B26*/
#define CD4051_COM5_X6_IN (CD4051B_GeneralCOM_Value[COM5][Channel6]) /*B31*/
#define CD4051_COM5_X7_IN (CD4051B_GeneralCOM_Value[COM5][Channel7]) /*B30*/
/*COM6映射PCB*/
#define CD4051_COM6_X0_IN (CD4051B_GeneralCOM_Value[COM6][Channel0]) /*A06*/
#define CD4051_COM6_X1_IN (CD4051B_GeneralCOM_Value[COM6][Channel1]) /*B07*/
#define CD4051_COM6_X2_IN (CD4051B_GeneralCOM_Value[COM6][Channel2]) /*B08*/
#define CD4051_COM6_X3_IN (CD4051B_GeneralCOM_Value[COM6][Channel3]) /*B05*/
#define CD4051_COM6_X4_IN (CD4051B_GeneralCOM_Value[COM6][Channel4]) /*B01*/
#define CD4051_COM6_X5_IN (CD4051B_GeneralCOM_Value[COM6][Channel5]) /*B04*/
#define CD4051_COM6_X6_IN (CD4051B_GeneralCOM_Value[COM6][Channel6]) /*B02*/
#define CD4051_COM6_X7_IN (CD4051B_GeneralCOM_Value[COM6][Channel7]) /*B03*/
/*COM7映射PCB*/
#define CD4051_COM7_X0_IN (CD4051B_GeneralCOM_Value[COM7][Channel0]) /*B15*/
#define CD4051_COM7_X1_IN (CD4051B_GeneralCOM_Value[COM7][Channel1]) /*B16*/
#define CD4051_COM7_X2_IN (CD4051B_GeneralCOM_Value[COM7][Channel2]) /*B17*/
#define CD4051_COM7_X3_IN (CD4051B_GeneralCOM_Value[COM7][Channel3]) /*B14*/
#define CD4051_COM7_X4_IN (CD4051B_GeneralCOM_Value[COM7][Channel4]) /*B10*/
#define CD4051_COM7_X5_IN (CD4051B_GeneralCOM_Value[COM7][Channel5]) /*B13*/
#define CD4051_COM7_X6_IN (CD4051B_GeneralCOM_Value[COM7][Channel6]) /*B11*/
#define CD4051_COM7_X7_IN (CD4051B_GeneralCOM_Value[COM7][Channel7]) /*B12*/

/******************************************************************************
函数
******************************************************************************/
extern void CD4051B_KL15Init(void);
extern void CD4051B_ChannelSet(CD4051BChannel Ch);
extern CD4051BChannel CD4051B_ChannelGet(void);
extern void CD4051B_ReadSignal_Serviece(void);
extern void CD4051B_Debounce_Service(void);
extern uint16_t CD4051B_GetComValue(uint8_t num, uint8_t ch);

#endif
