

#ifndef _POPUP_LIST_H_
#define _POPUP_LIST_H_

#include <stddef.h>
#include "Popup_Message_List.h"
#include "Sound_List.h"

/******************************************************************************
报警名称列表

注意：1. 报警名称所指代的序号应与该报警位于报警属性表中的序号一一对应
      2. 标注有的"[报警类]"的为报警类名称,不可直接用于报警的申请与删除,但可用于
         该类报警的查询
******************************************************************************/
enum PopupName
{
	 POPUP1_BRAKE_BLACK 	=0x00u		 ,//0.紧急警报-刹车
     POPUP1_BRAKE_BRAKE	 				 ,//1.紧急警报-紧急制动
     POPUP1_BRAKE_SPACING_R	 			 ,//2.车间距警报-刹车(红字)
     POPUP1_BRAKE_SPACING_COLLISION		 ,//3.车间距警报-碰撞报警
     POPUP1_BRAKE_SPACING_Y	 			 ,//4.车间距警报-刹车(黄字)
     POPUT1_ASR_OPERATE					 ,//5.ASR工作
     POPUT2_PTO	 						 ,//6.PTO紧急警报-刹车
     POPUP2_PARKING_BRAKE	 			 ,//7.忘记松手刹车
     POPUP2_AIRMATIC_HIGHT	 			 ,//8.遥控调整车辆高度(有车速)
     POPUP3_CRUISE	 					 ,//9.自动巡航模式
     POPUP3_VARIABLE_SLD	 			 ,//10.可变SLD 模式
     POPUT4_ABNORMAL_CHARGE	 			 ,//11.充电异常（系统检测）
     POPUP4_OIL_PRESSURE	 			 ,//12.油压（系统检测）
     POPUP4_AMT_INIT_EXCE	 			 ,//13.AMT初始化异常
     POPUP4_ADBLUE_QUALITY	 			 ,//14.尿素品质异常（系统检测）
     POPUP4_ADBLUE_SPRAY	 			 ,//15.尿素喷射异常（系统检测）
     POPUP4_ADBLUE_SUPPLY	 			 ,//16.尿素水补给（系统检测）
     POPUP4_START_ENG       	 		 ,//17.AMT初始化结束
     POPUP4_DPD_AUTO	 				 ,//18.DPD自动再生
     POPUP5_OVER_HEAT_SPEED	 			 ,//19.过热（过热，请在安全的场所停车）
     POPUP5_OVER_HEAT					 ,//20.过热（冷却液温度过高）
     POPUP5_LOW_COOLANT_SPEED       	 ,//21.冷却水（冷却液不足）
     POPUP5_LOW_COOLANT				 	 ,//22.冷却水（冷却水不足）
     POPUP5_ENGINE_OIL_PRESSURE_SPEED	 ,//23.油压(机油)请在安全场所停车
     POPUP5_ENGINE_OIL_PRESSURE		 	 ,//24.油压异常
     POPUP5_METER_FAILURE_SPEED    	 	 ,//25.仪表故障-请在安全场所停车
     POPUP5_METER_FAILURE  			 	 ,//26.仪表故障-请与五十铃公司联系
     POPUP5_CAN_ERROR_SPEED         	 ,//27.通信系统-请在安全场所停车 
     POPUP5_CAN_ERROR	 				 ,//28.通信系统-请与五十铃公司联系
     POPUP5_SPEED_LIMIT_SPEED     	 	 ,//29.车速限制-图1
     POPUP5_SPEED_LIMIT				 	 ,//30.车速限制-图2
     POPUP5_TORQUE_REDUCTION_SPEED	 	 ,//31.扭矩限制-图1
     POPUP5_TORQUE_REDUCTION			 ,//32.扭矩限制-图2
     POPUP5_SPEED_TORQUE				 ,//33.扭矩限制、车速限制 交互 显示-->扭矩限制
     POPUP5_INCORRECT_ADBLUE_SPEED		 ,//34.尿素品质异常-图1
     POPUP5_INCORRECT_ADBLUE  			 ,//35.尿素品质异常-图2
     POPUP5_CRITICAL_EMISSION_SPEED	 	 ,//36.临界排放故障-图1
     POPUP5_CRITICAL_EMISSION			 ,//37.临界排放故障-图2
     POPUP5_AMT_SPANNER_WARNING_SPEED 	 ,//38.AMT异常-图1
     POPUP5_AMT_SPANNER_WARNING		 	 ,//39.AMT异常-请重启发动机
     POPUP5_AMT_LOW_AIR_WARNING_SPEED  	 ,//40.AMT异常(气压低下)-图1
     POPUP5_AMT_LOW_AIR_WARNING		 	 ,//41.AMT异常(气压低下)-图2
     POPUP5_LOW_PRESSURE_ALARM_SPEED  	 ,//42.低圧警報-轮胎漏气警告
     POPUP5_LOW_PRESSURE_ALARM			 ,//43.同——44
     POPUP5_APP_ADBLUE_SPEED         	 ,//44.尿素补给-补充尿素溶液-图1
     POPUP5_APP_ADBLUE			    	 ,//45.尿素补给-补充尿素溶液-图2
     POPUP5_ADBLUE_LEVEL_LOW_SPEED       ,//46.尿素余量少-有车速-图1
     POPUP5_ADBLUE_LEVEL_LOW			 ,//47.尿素余量少-无车速-图2
     POPUP5_LOW_FAILURE_SPEED         	 ,//48.低圧警報（低下）
     POPUP5_LOW_FAILURE 				 ,//49.同——50
     POPUP5_CAMERA_POLLUTION_SPEED       ,//50.摄像头有污染-图1
     POPUP5_CAMERA_POLLUTION			 ,//51.摄像头有污染-请与五十铃公司联系
     POPUP5_AdBlue_LEVEL_LOW_SPEED    	 ,//52.尿素喷射异常（停止）-图1
     POPUP5_AdBlue_LEVEL_LOW			 ,//53.尿素喷射异常（停止）-图2
     POPUP5_AdBlue_INJ_SYSTEM_SPEED   	 ,//54.尿素喷射异常（消耗量）-图1
     POPUP5_AdBlue_INJ_SYSTEM			 ,//55.尿素喷射异常（消耗量）-图2
     POPUP5_TPMS_HIGH_AIR        		 ,//56.高圧警報-轮胎高压警告
     POPUP5_TPMS_HIGH_TEMP       		 ,//57.高温警報-轮胎高温警告
     POPUP5_AdBlue_DOS_MALFUNC			 ,//58.尿素喷射异常(停止、消耗量)交互显示
     POPUP5_PUSH_DPD_SWITCH1_SPEED    	 ,//59.DPD手动再生要求1-DPD需要再生
     POPUP5_PUSH_DPD_SWITCH1			 ,//60.DPD手动再生要求1-请按下DPD开关
     POPUP5_PUSH_DPD_SWITCH2_SPEED    	 ,//61.DPD手动再生要求2-DPD需要再生
     POPUP5_PUSH_DPD_SWITCH2			 ,//62.DPD手动再生要求2-请按下DPD开关
     POPUP5_TPMS_FAILURE         		 ,//63.TPMS故障-轮胎监控失败
     POPUP5_TPMS_MONITOR_DROP    		 ,//64.TPMS電池低下-轮胎监控传感器电压下降
     POPUP6_PUSH_DPD	                 ,//65.DPD手动再生中 
     POPUP6_HEIGHT_CONTROL				 ,//66.遥控车辆高度调整中(无车速)
     POPUP6_PTO_STOP					 ,//67.PTO(停车中)
     POPUP7_CHARGE_ABNORMAL_SPEED     	 ,//68.充电异常-请在安全的场所停车
     POPUP7_CHARGE_ABNORMAL			 	 ,//69.充电异常-请与五十铃公司联系
     POPUP7_AMT_ERROR_SPEED           	 ,//70.AMT異常-AMT异常
     POPUP7_AMT_ERROR					 ,//71.AMT異常-请联系经销商
     POPUP8_REFUEL       			  	 ,//72.补充燃料-油箱单位
     POPUP8_ATM_CLUCH_OVERHEATING_SPEED  ,//73.过热-离合器过载
     POPUP8_ATM_CLUCH_OVERHEATING		 ,//74.过热-选择合适的档位
     POPUP8_ATM_WORN_OUT              	 ,//75.AMT磨耗-离合器磨损
     POPUP8_LOW_VOLTAGE_SPEED            ,//76.低电压报警
     POPUP8_OVERVOLTAGE     			 ,//77.过电压报警
     POPUP8_DPD_AUTO_SPEED     		 	 ,//78.DPD自动再生-DPD自动再生中
     POPUP8_DPD_AUTO					 ,//79.DPD自动再生-再生将自动完成，不需要操作开关 
     POPUP9_AIR_PRESSURE_SPEED    		 ,//80.气压过低-气压过低请注意
     POPUP9_AIR_PRESSURE				 ,//81.气压过低-请冲入空气
     POPUP9_EBS_ERROR_SPEED       		 ,//82.EBS故障（红）-请在安全的场所停车
     POPUP9_EBS_ERROR 					 ,//83.EBS故障（红）-请与五十铃公司联系
     POPUP10_RAPID_ACC            		 ,//84.省油耗建议-急加速
     POPUP10_RAPID_SUB            		 ,//85.省油耗建议-急减速
     POPUP10_REVAL_ENGINE         		 ,//86.省油耗建议-请降低发动机转速
     POPUP10_REVAL_SPEED          		 ,//87.省油耗建议-请降低速度
     POPUP11_ENGINE_OIL_FILTER_ERROR     ,//88.发动机机油＆滤清器
     POPUP11_FUEL_FILTER_ERROR           ,//89.燃油滤清器
     POPUP11_T_MISSION_OIL_ERROR         ,//90.变速箱油
     POPUP11_DIFF_OIL_ERROR           	 ,//91.差速器油
     POPUP11_CLUTCH_OIL_ERROR            ,//92.顺畅系统离合器油
     POPUP11_P_STEERING_FRUID_ERROR      ,//93.动力转向液
     POPUP11_TIRE_ROTATION           	 ,//94.更换轮胎・轮胎位置

  POPUP_MAX
};

#define   POPUP_NONE                        0xFFFF  /*无报警*/

/******************************************************************************
报警成员列表
******************************************************************************/
/*static const uint8_t PopupMbrListHOOVES[] =
{
    POPUP_LF_HOOVES_ERROR,
    POPUP_RF_HOOVES_ERROR,
    POPUP_LR_HOOVES_ERROR,
    POPUP_RR_HOOVES_ERROR,
};*/

/******************************************************************************
报警类型定义
******************************************************************************/
#define   POPUP_TYPE_FATAL                  0x00  /*严重报警信息*/
#define   POPUP_TYPE_HINT                   0x01  /*提示信息*/
#define   POPUP_TYPE_WARNING                0x02  /*报警信息*/
#define   POPUP_TYPE_EXCEPTION              0x04  /*特殊信息 */

/******************************************************************************
显示/声音模式
******************************************************************************/
#define   POPUP_MODE_MULTI                  0x00  /*可多次触发*/
#define   POPUP_MODE_SINGLE                 0x01  /*只触发一次*/

/******************************************************************************
+15 On / Off
******************************************************************************/
#define   POPUP_IGN_OFF                             0x00
#define   POPUP_IGN_ON                              0x01
#define   POPUP_IGN_ON_OFF                          0x02

/******************************************************************************
报警属性结构
******************************************************************************/
typedef struct
{
    uint8_t        Type;
    uint8_t        Priority;
    uint8_t        SubPriority;
    uint8_t        IGNStatus;
    uint8_t        Class;
    const uint8_t  *pMbrList;
    uint8_t        MbrCnt;
    uint8_t        Message;
    uint8_t        DispMode;
    uint8_t        Snd;
    uint8_t        SndMode;
} PopupAttributeStruct;

/******************************************************************************
报警属性表
******************************************************************************/
static const PopupAttributeStruct PopupAttributeTable[] =
{
    /*===============================================================================================================================================================================================================================================================================
                  报警名称             		    |      报警类型     	 | 优先级 | 副优先级  |  +15 On/Off   |                 报警类                  |            成员列表            |           成员数量       |     文字消息            |     显示模式     |           报警音            |   声音提示模式
    -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
    {/*00 	POPUP1_BRAKE_BLACK 	=0x00u		         */		 POPUP_TYPE_FATAL   ,      1u,     1u,    POPUP_IGN_ON,  	POPUP1_BRAKE_BLACK 			 				, NULL,          1u,           POPUP1_MSG_BRAKE_BLACK 			 		    ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*01 	POPUP1_BRAKE_BRAKE	 				     */		 POPUP_TYPE_FATAL   ,      1u,     2u,    POPUP_IGN_ON,  	POPUP1_BRAKE_BRAKE	 				 		, NULL,          1u,           POPUP1_MSG_BRAKE_BRAKE	 				 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*02 	POPUP1_BRAKE_SPACING_R	 			     */		 POPUP_TYPE_FATAL   ,      1u,     3u,    POPUP_IGN_ON,  	POPUP1_BRAKE_SPACING_R	 			 		, NULL,          1u,           POPUP1_MSG_BRAKE_SPACING_R	 			 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*03 	POPUP1_BRAKE_SPACING_COLLISION		     */		 POPUP_TYPE_FATAL   ,      1u,     4u,    POPUP_IGN_ON,  	POPUP1_BRAKE_SPACING_COLLISION		 		, NULL,          1u,           POPUP1_MSG_BRAKE_SPACING_COLLISION		 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*04 	POPUP1_BRAKE_SPACING_Y	 			     */		 POPUP_TYPE_FATAL   ,      1u,     5u,    POPUP_IGN_ON,  	POPUP1_BRAKE_SPACING_Y	 			 		, NULL,          1u,           POPUP1_MSG_BRAKE_SPACING_Y	 				,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*05 	POPUT1_ASR_OPERATE					     */		 POPUP_TYPE_FATAL   ,      1u,     6u,    POPUP_IGN_ON,  	POPUT1_ASR_OPERATE					 		, NULL,          1u,           POPUT1_MSG_ASR_OPERATE					 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},    
	{/*06 	POPUT2_PTO	 						     */		 POPUP_TYPE_WARNING ,      2u,     1u,    POPUP_IGN_ON,  	POPUT2_PTO	 						 		, NULL,          1u,           POPUT2_MSG_PTO	 						 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*07 	POPUP2_PARKING_BRAKE	 			     */		 POPUP_TYPE_WARNING ,      2u,     2u,    POPUP_IGN_ON,  	POPUP2_PARKING_BRAKE	 			 		, NULL,          1u,           POPUP2_MSG_PARKING_BRAKE	 			 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*08 	POPUP2_AIRMATIC_HIGHT	 			     */		 POPUP_TYPE_WARNING ,      2u,     3u,    POPUP_IGN_ON,  	POPUP2_AIRMATIC_HIGHT	 			 		, NULL,          1u,           POPUP2_MSG_AIRMATIC_HIGHT	 			 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},   
	{/*09 	POPUP3_CRUISE	 					     */		 POPUP_TYPE_WARNING ,      3u,     1u,    POPUP_IGN_ON,  	POPUP3_CRUISE	 					 		, NULL,          1u,           POPUP3_MSG_CRUISE	 					 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*10 	POPUP3_VARIABLE_SLD	 			         */		 POPUP_TYPE_WARNING ,      3u,     2u,    POPUP_IGN_ON,  	POPUP3_VARIABLE_SLD	 			 		    , NULL,          1u,           POPUP3_MSG_VARIABLE_SLD	 			 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},   
	{/*11 	POPUT4_ABNORMAL_CHARGE	 			     */		 POPUP_TYPE_HINT    ,      4u,     1u,    POPUP_IGN_ON,  	POPUT4_ABNORMAL_CHARGE	 			 		, NULL,          1u,           POPUT4_MSG_ABNORMAL_CHARGE	 			 	,  POPUP_MODE_SINGLE,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*12 	POPUP4_OIL_PRESSURE	 			         */		 POPUP_TYPE_HINT    ,      4u,     2u,    POPUP_IGN_ON,  	POPUP4_OIL_PRESSURE	 			 			, NULL,          1u,           POPUP4_MSG_OIL_PRESSURE	 			 		,  POPUP_MODE_SINGLE,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*13 	POPUP4_AMT_INIT_EXCE	 			     */		 POPUP_TYPE_HINT    ,      4u,     3u,    POPUP_IGN_ON,  	POPUP4_AMT_INIT_EXCE	 			 		, NULL,          1u,           POPUP4_MSG_AMT_INIT_EXCE	 			 		,  POPUP_MODE_SINGLE,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*14 	POPUP4_ADBLUE_QUALITY	 			     */		 POPUP_TYPE_HINT    ,      4u,     4u,    POPUP_IGN_ON,  	POPUP4_ADBLUE_QUALITY	 			 		, NULL,          1u,           POPUP4_MSG_ADBLUE_QUALITY	 			 	,  POPUP_MODE_SINGLE,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*15 	POPUP4_ADBLUE_SPRAY	 			         */		 POPUP_TYPE_HINT    ,      4u,     5u,    POPUP_IGN_ON,  	POPUP4_ADBLUE_SPRAY	 			 			, NULL,          1u,           POPUP4_MSG_ADBLUE_SPRAY	 			 		,  POPUP_MODE_SINGLE,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*16 	POPUP4_ADBLUE_SUPPLY	 			     */		 POPUP_TYPE_HINT    ,      4u,     6u,    POPUP_IGN_ON,  	POPUP4_ADBLUE_SUPPLY	 			 		, NULL,          1u,           POPUP4_MSG_ADBLUE_SUPPLY	 			 		,  POPUP_MODE_SINGLE,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*17 	POPUP4_START_ENG       	 		         */		 POPUP_TYPE_HINT    ,      4u,     7u,    POPUP_IGN_ON,  	POPUP4_START_ENG       	 		 			, NULL,          1u,           POPUP4_MSG_START_ENG       	 		 		,  POPUP_MODE_SINGLE,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*18 	POPUP4_DPD_AUTO	 				         */		 POPUP_TYPE_HINT    ,      4u,     8u,    POPUP_IGN_ON,  	POPUP4_DPD_AUTO	 				 			, NULL,          1u,           POPUP4_MSG_DPD_AUTO	 				 		,  POPUP_MODE_SINGLE,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*19 	POPUP5_OVER_HEAT_SPEED	 			     */		 POPUP_TYPE_WARNING ,      5u,     1u,    POPUP_IGN_ON,  	POPUP5_OVER_HEAT_SPEED	 			 		, NULL,          1u,           POPUP5_MSG_OVER_HEAT_SPEED	 			 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*20 	POPUP5_OVER_HEAT					     */		 POPUP_TYPE_WARNING ,      5u,     1u,   POPUP_IGN_ON,  	POPUP5_OVER_HEAT					 		, NULL,          1u,           POPUP5_MSG_OVER_HEAT					 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*21 	POPUP5_LOW_COOLANT_SPEED       	 	     */		 POPUP_TYPE_WARNING ,      5u,     2u,   POPUP_IGN_ON,  	POPUP5_LOW_COOLANT_SPEED       	 			, NULL,          1u,           POPUP5_MSG_LOW_COOLANT_SPEED       	 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},   
	{/*22 	POPUP5_LOW_COOLANT				 	   	 */		 POPUP_TYPE_WARNING ,      5u,     2u,    POPUP_IGN_ON,  	POPUP5_LOW_COOLANT				 	 		, NULL,          1u,           POPUP5_MSG_LOW_COOLANT				 	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*23 	POPUP5_ENGINE_OIL_PRESSURE_SPEED	   	 */		 POPUP_TYPE_WARNING ,      5u,     3u,    POPUP_IGN_ON,  	POPUP5_ENGINE_OIL_PRESSURE_SPEED	 		, NULL,          1u,           POPUP5_MSG_ENGINE_OIL_PRESSURE_SPEED	 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*24 	POPUP5_ENGINE_OIL_PRESSURE		 	   	 */		 POPUP_TYPE_WARNING ,      5u,     3u,    POPUP_IGN_ON,  	POPUP5_ENGINE_OIL_PRESSURE					, NULL,          1u,           POPUP5_MSG_ENGINE_OIL_PRESSURE		 	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*25 	POPUP5_METER_FAILURE_SPEED    	 	   	 */		 POPUP_TYPE_WARNING ,      5u,     4u,    POPUP_IGN_ON,  	POPUP5_METER_FAILURE_SPEED    	 	 		, NULL,          1u,           POPUP5_MSG_METER_FAILURE_SPEED    	 	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*26 	POPUP5_METER_FAILURE  			 	   	 */		 POPUP_TYPE_WARNING ,      5u,     4u,    POPUP_IGN_ON,  	POPUP5_METER_FAILURE  			 			, NULL,          1u,           POPUP5_MSG_METER_FAILURE  			 	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*27 	POPUP5_CAN_ERROR_SPEED         	 	     */		 POPUP_TYPE_WARNING ,      5u,     5u,    POPUP_IGN_ON,  	POPUP5_CAN_ERROR_SPEED         				, NULL,          1u,           POPUP5_MSG_CAN_ERROR_SPEED         	 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*28 	POPUP5_CAN_ERROR	 				   	 */		 POPUP_TYPE_WARNING ,      5u,     5u,    POPUP_IGN_ON,  	POPUP5_CAN_ERROR	 				 		, NULL,          1u,           POPUP5_MSG_CAN_ERROR	 				 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*29 	POPUP5_SPEED_LIMIT_SPEED     	 	   	 */		 POPUP_TYPE_WARNING ,      5u,     6u,    POPUP_IGN_ON,  	POPUP5_SPEED_LIMIT_SPEED     	 	 		, NULL,          1u,           POPUP5_MSG_SPEED_LIMIT_SPEED     	 	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*30 	POPUP5_SPEED_LIMIT				 	   	 */		 POPUP_TYPE_WARNING ,      5u,     6u,    POPUP_IGN_ON,  	POPUP5_SPEED_LIMIT				 	 		, NULL,          1u,           POPUP5_MSG_SPEED_LIMIT				 	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*31 	POPUP5_TORQUE_REDUCTION_SPEED	 	   	 */		 POPUP_TYPE_WARNING ,      5u,     7u,    POPUP_IGN_ON,  	POPUP5_TORQUE_REDUCTION_SPEED	 	 		, NULL,          1u,           POPUP5_MSG_TORQUE_REDUCTION_SPEED	 	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*32 	POPUP5_TORQUE_REDUCTION			 	     */		 POPUP_TYPE_WARNING ,      5u,     7u,    POPUP_IGN_ON,  	POPUP5_TORQUE_REDUCTION			 			, NULL,          1u,           POPUP5_MSG_TORQUE_REDUCTION			 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*33 	POPUP5_SPEED_TORQUE				 	     */		 POPUP_TYPE_WARNING ,      5u,     7u,    POPUP_IGN_ON,  	POPUP5_SPEED_TORQUE				 			, NULL,          1u,           POPUP5_MSG_SPEED_TORQUE				 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*34 	POPUP5_INCORRECT_ADBLUE_SPEED		   	 */		 POPUP_TYPE_WARNING ,      5u,     7u,    POPUP_IGN_ON,  	POPUP5_INCORRECT_ADBLUE_SPEED		 		, NULL,          1u,           POPUP5_MSG_INCORRECT_ADBLUE_SPEED		 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*35 	POPUP5_INCORRECT_ADBLUE  			   	 */		 POPUP_TYPE_WARNING ,      5u,     7u,    POPUP_IGN_ON,  	POPUP5_INCORRECT_ADBLUE  			 		, NULL,          1u,           POPUP5_MSG_INCORRECT_ADBLUE  			 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*36 	POPUP5_CRITICAL_EMISSION_SPEED	 	   	 */		 POPUP_TYPE_WARNING ,      5u,     7u,    POPUP_IGN_ON,  	POPUP5_CRITICAL_EMISSION_SPEED	 	 		, NULL,          1u,           POPUP5_MSG_CRITICAL_EMISSION_SPEED	 	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*37 	POPUP5_CRITICAL_EMISSION			   	 */		 POPUP_TYPE_WARNING ,      5u,     7u,    POPUP_IGN_ON,  	POPUP5_CRITICAL_EMISSION			 		, NULL,          1u,           POPUP5_MSG_CRITICAL_EMISSION			 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*38 	POPUP5_AMT_SPANNER_WARNING_SPEED 	   	 */		 POPUP_TYPE_WARNING ,      5u,     8u,    POPUP_IGN_ON,  	POPUP5_AMT_SPANNER_WARNING_SPEED 	 		, NULL,          1u,           POPUP5_MSG_AMT_SPANNER_WARNING_SPEED 	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*39 	POPUP5_AMT_SPANNER_WARNING		 	   	 */		 POPUP_TYPE_WARNING ,      5u,     8u,    POPUP_IGN_ON,  	POPUP5_AMT_SPANNER_WARNING		 	 		, NULL,          1u,           POPUP5_MSG_AMT_SPANNER_WARNING		 	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*40 	POPUP5_AMT_LOW_AIR_WARNING_SPEED  	   	 */		 POPUP_TYPE_WARNING ,      5u,     9u,    POPUP_IGN_ON,  	POPUP5_AMT_LOW_AIR_WARNING_SPEED  	 		, NULL,          1u,           POPUP5_MSG_AMT_LOW_AIR_WARNING_SPEED  	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*41 	POPUP5_AMT_LOW_AIR_WARNING		 	   	 */		 POPUP_TYPE_WARNING ,      5u,     9u,    POPUP_IGN_ON,  	POPUP5_AMT_LOW_AIR_WARNING		 	 		, NULL,          1u,           POPUP5_MSG_AMT_LOW_AIR_WARNING		 	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*42 	POPUP5_LOW_PRESSURE_ALARM_SPEED  	   	 */		 POPUP_TYPE_WARNING ,      5u,     10u,    POPUP_IGN_ON,  	POPUP5_LOW_PRESSURE_ALARM_SPEED  	 		, NULL,          1u,           POPUP5_MSG_LOW_PRESSURE_ALARM_SPEED  	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*43 	POPUP5_LOW_PRESSURE_ALARM			   	 */		 POPUP_TYPE_WARNING ,      5u,     10u,    POPUP_IGN_ON,  	POPUP5_LOW_PRESSURE_ALARM			 		, NULL,          1u,           POPUP5_MSG_LOW_PRESSURE_ALARM			 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*44 	POPUP5_APP_ADBLUE_SPEED         	   	 */		 POPUP_TYPE_WARNING ,      5u,     10u,    POPUP_IGN_ON,  	POPUP5_APP_ADBLUE_SPEED         	 		, NULL,          1u,           POPUP5_MSG_APP_ADBLUE_SPEED         	 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*45 	POPUP5_APP_ADBLUE			    	   	 */		 POPUP_TYPE_WARNING ,      5u,     10u,   POPUP_IGN_ON,  	POPUP5_APP_ADBLUE			    	 		, NULL,          1u,           POPUP5_MSG_APP_ADBLUE			    	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*46 	POPUP5_ADBLUE_LEVEL_LOW_SPEED        	 */		 POPUP_TYPE_WARNING ,      5u,    11u,   POPUP_IGN_ON,  	POPUP5_ADBLUE_LEVEL_LOW_SPEED       		, NULL,          1u,           POPUP5_MSG_ADBLUE_LEVEL_LOW_SPEED       		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*47 	POPUP5_ADBLUE_LEVEL_LOW			 	     */		 POPUP_TYPE_WARNING ,      5u,    11u,   POPUP_IGN_ON,  	POPUP5_ADBLUE_LEVEL_LOW			 			, NULL,          1u,           POPUP5_MSG_ADBLUE_LEVEL_LOW			 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*48 	POPUP5_LOW_FAILURE_SPEED         	   	 */		 POPUP_TYPE_WARNING ,      5u,    12u,   POPUP_IGN_ON,  	POPUP5_LOW_FAILURE_SPEED         	 		, NULL,          1u,           POPUP5_MSG_LOW_FAILURE_SPEED         	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*49 	POPUP5_LOW_FAILURE 				 	     */		 POPUP_TYPE_WARNING ,      5u,    12u,   POPUP_IGN_ON,  	POPUP5_LOW_FAILURE 				 			, NULL,          1u,           POPUP5_MSG_LOW_FAILURE 				 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*50 	POPUP5_CAMERA_POLLUTION_SPEED        	 */		 POPUP_TYPE_WARNING ,      5u,    12u,   POPUP_IGN_ON,  	POPUP5_CAMERA_POLLUTION_SPEED       		, NULL,          1u,           POPUP5_MSG_CAMERA_POLLUTION_SPEED       		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*51 	POPUP5_CAMERA_POLLUTION			 	     */		 POPUP_TYPE_WARNING ,      5u,    12u,   POPUP_IGN_ON,  	POPUP5_CAMERA_POLLUTION			   			, NULL,          1u,           POPUP5_MSG_CAMERA_POLLUTION			 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*52 	POPUP5_AdBlue_LEVEL_LOW_SPEED    	   	 */		 POPUP_TYPE_WARNING ,      5u,    12u,   POPUP_IGN_ON,  	POPUP5_AdBlue_LEVEL_LOW_SPEED    	 		, NULL,          1u,           POPUP5_MSG_AdBlue_LEVEL_LOW_SPEED    	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*53 	POPUP5_AdBlue_LEVEL_LOW			 	     */		 POPUP_TYPE_WARNING ,      5u,    12u,   POPUP_IGN_ON,  	POPUP5_AdBlue_LEVEL_LOW			 			, NULL,          1u,           POPUP5_MSG_AdBlue_LEVEL_LOW			 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*54 	POPUP5_AdBlue_INJ_SYSTEM_SPEED   	   	 */		 POPUP_TYPE_WARNING ,      5u,    13u,   POPUP_IGN_ON,  	POPUP5_AdBlue_INJ_SYSTEM_SPEED   	 		, NULL,          1u,           POPUP5_MSG_AdBlue_INJ_SYSTEM_SPEED   	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*55 	POPUP5_AdBlue_INJ_SYSTEM			   	 */		 POPUP_TYPE_WARNING ,      5u,    13u,   POPUP_IGN_ON,  	POPUP5_AdBlue_INJ_SYSTEM			 		, NULL,          1u,           POPUP5_MSG_AdBlue_INJ_SYSTEM			 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*56 	POPUP5_TPMS_HIGH_AIR        		   	 */		 POPUP_TYPE_WARNING ,      5u,    14u,   POPUP_IGN_ON,  	POPUP5_TPMS_HIGH_AIR        		 		, NULL,          1u,           POPUP5_MSG_TPMS_HIGH_AIR        		 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*57 	POPUP5_TPMS_HIGH_TEMP       		   	 */		 POPUP_TYPE_WARNING ,      5u,    14u,   POPUP_IGN_ON,  	POPUP5_TPMS_HIGH_TEMP       		 		, NULL,          1u,           POPUP5_MSG_TPMS_HIGH_TEMP       		 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*58 	POPUP5_AdBlue_DOS_MALFUNC			   	 */		 POPUP_TYPE_WARNING ,      5u,    14u,   POPUP_IGN_ON,  	POPUP5_AdBlue_DOS_MALFUNC			 		, NULL,          1u,           POPUP5_MSG_AdBlue_DOS_MALFUNC			 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*59 	POPUP5_PUSH_DPD_SWITCH1_SPEED    	   	 */		 POPUP_TYPE_WARNING ,      5u,    15u,   POPUP_IGN_ON,  	POPUP5_PUSH_DPD_SWITCH1_SPEED    	 		, NULL,          1u,           POPUP5_MSG_PUSH_DPD_SWITCH1_SPEED    	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*60 	POPUP5_PUSH_DPD_SWITCH1			 	     */		 POPUP_TYPE_WARNING ,      5u,    15u,   POPUP_IGN_ON,  	POPUP5_PUSH_DPD_SWITCH1			 			, NULL,          1u,           POPUP5_MSG_PUSH_DPD_SWITCH1			 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*61 	POPUP5_PUSH_DPD_SWITCH2_SPEED    	   	 */		 POPUP_TYPE_WARNING ,      5u,    16u,   POPUP_IGN_ON,  	POPUP5_PUSH_DPD_SWITCH2_SPEED   			, NULL,          1u,           POPUP5_MSG_PUSH_DPD_SWITCH2_SPEED    	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*62 	POPUP5_PUSH_DPD_SWITCH2			 	     */		 POPUP_TYPE_WARNING ,      5u,    16u,   POPUP_IGN_ON,  	POPUP5_PUSH_DPD_SWITCH2			 			, NULL,          1u,           POPUP5_MSG_PUSH_DPD_SWITCH2			 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*63 	POPUP5_TPMS_FAILURE         		   	 */		 POPUP_TYPE_WARNING ,      5u,    17u,   POPUP_IGN_ON,  	POPUP5_TPMS_FAILURE         		 		, NULL,          1u,           POPUP5_MSG_TPMS_FAILURE         		 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},  
	{/*64 	POPUP5_TPMS_MONITOR_DROP    		   	 */		 POPUP_TYPE_WARNING ,      5u,    17u,    POPUP_IGN_ON,  	POPUP5_TPMS_MONITOR_DROP    		 		, NULL,          1u,           POPUP5_MSG_TPMS_MONITOR_DROP    		 	    ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*65 	POPUP6_PUSH_DPD	                 	     */		 POPUP_TYPE_WARNING ,      6u,     1u,    POPUP_IGN_ON,  	POPUP6_PUSH_DPD	                 			, NULL,          1u,           POPUP6_MSG_PUSH_DPD	                 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*66 	POPUP6_HEIGHT_CONTROL				   	 */		 POPUP_TYPE_WARNING ,      6u,     2u,    POPUP_IGN_ON,  	POPUP6_HEIGHT_CONTROL				 		, NULL,          1u,           POPUP6_MSG_HEIGHT_CONTROL				 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},  
	{/*67 	POPUP6_PTO_STOP					 	     */		 POPUP_TYPE_WARNING ,      6u,     3u,    POPUP_IGN_ON,  	POPUP6_PTO_STOP					 			, NULL,          1u,           POPUP6_MSG_PTO_STOP					 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*68 	POPUP7_CHARGE_ABNORMAL_SPEED     	   	 */		 POPUP_TYPE_WARNING ,      7u,     1u,    POPUP_IGN_ON,  	POPUP7_CHARGE_ABNORMAL_SPEED     	 		, NULL,          1u,           POPUP7_MSG_CHARGE_ABNORMAL_SPEED     	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*69 	POPUP7_CHARGE_ABNORMAL			 	   	 */		 POPUP_TYPE_WARNING ,      7u,     1u,    POPUP_IGN_ON,  	POPUP7_CHARGE_ABNORMAL			 	 		, NULL,          1u,           POPUP7_MSG_CHARGE_ABNORMAL			 	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*70 	POPUP7_AMT_ERROR_SPEED           	   	 */		 POPUP_TYPE_WARNING ,      7u,     3u,    POPUP_IGN_ON,  	POPUP7_AMT_ERROR_SPEED           	 		, NULL,          1u,           POPUP7_MSG_AMT_ERROR_SPEED           	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
	{/*71 	POPUP7_AMT_ERROR					   	 */		 POPUP_TYPE_WARNING ,      7u,     3u,    POPUP_IGN_ON,  	POPUP7_AMT_ERROR					 		, NULL,          1u,           POPUP7_MSG_AMT_ERROR					 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*72 	POPUP8_REFUEL       			  	   	 */		 POPUP_TYPE_WARNING ,      8u,     1u,    POPUP_IGN_ON,  	POPUP8_REFUEL       			  	 		, NULL,          1u,           POPUP8_MSG_REFUEL       			  	 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*73 	POPUP8_ATM_CLUCH_OVERHEATING_SPEED   	 */		 POPUP_TYPE_WARNING ,      8u,     2u,    POPUP_IGN_ON,  	POPUP8_ATM_CLUCH_OVERHEATING_SPEED  		, NULL,          1u,           POPUP8_MSG_ATM_CLUCH_OVERHEATING_SPEED  		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*74 	POPUP8_ATM_CLUCH_OVERHEATING		   	 */		 POPUP_TYPE_WARNING ,      8u,     2u,    POPUP_IGN_ON,  	POPUP8_ATM_CLUCH_OVERHEATING		 		, NULL,          1u,           POPUP8_MSG_ATM_CLUCH_OVERHEATING		 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*75 	POPUP8_ATM_WORN_OUT              	   	 */		 POPUP_TYPE_WARNING ,      8u,     4u,    POPUP_IGN_ON,  	POPUP8_ATM_WORN_OUT              	 		, NULL,          1u,           POPUP8_MSG_ATM_WORN_OUT              	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*76 	POPUP8_LOW_VOLTAGE_SPEED             	 */		 POPUP_TYPE_WARNING ,      8u,     3u,    POPUP_IGN_ON,  	POPUP8_LOW_VOLTAGE_SPEED            		, NULL,          1u,           POPUP8_MSG_LOW_VOLTAGE_SPEED            		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*77 	POPUP8_OVERVOLTAGE     			 	     */		 POPUP_TYPE_WARNING ,      8u,     3u,    POPUP_IGN_ON,  	POPUP8_OVERVOLTAGE     			 			, NULL,          1u,           POPUP8_MSG_OVERVOLTAGE     			 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*78 	POPUP8_DPD_AUTO_SPEED     		 	   	 */		 POPUP_TYPE_WARNING ,      8u,     5u,    POPUP_IGN_ON,  	POPUP8_DPD_AUTO_SPEED     		 	 		, NULL,          1u,           POPUP8_MSG_DPD_AUTO_SPEED     		 	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
	{/*79 	POPUP8_DPD_AUTO					 	     */		 POPUP_TYPE_WARNING ,      8u,     5u,    POPUP_IGN_ON,  	POPUP8_DPD_AUTO					 			, NULL,          1u,           POPUP8_MSG_DPD_AUTO					 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*80 	POPUP9_AIR_PRESSURE_SPEED    		 	 */		 POPUP_TYPE_WARNING ,      9u,     1u,    POPUP_IGN_ON,  	POPUP9_AIR_PRESSURE_SPEED    		 		, NULL,          1u,           POPUP9_MSG_AIR_PRESSURE_SPEED    		 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*81 	POPUP9_AIR_PRESSURE				 	 	 */		 POPUP_TYPE_WARNING ,      9u,     1u,    POPUP_IGN_ON,  	POPUP9_AIR_PRESSURE				 			, NULL,          1u,           POPUP9_MSG_AIR_PRESSURE				 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*82 	POPUP9_EBS_ERROR_SPEED       		 	 */		 POPUP_TYPE_WARNING ,      9u,     2u,    POPUP_IGN_ON,  	POPUP9_EBS_ERROR_SPEED       		 		, NULL,          1u,           POPUP9_MSG_EBS_ERROR_SPEED       		 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
	{/*83 	POPUP9_EBS_ERROR 					 	 */		 POPUP_TYPE_WARNING ,      9u,     2u,    POPUP_IGN_ON,  	POPUP9_EBS_ERROR 					 		, NULL,          1u,           POPUP9_MSG_EBS_ERROR 					 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*84 	POPUP10_RAPID_ACC            		 	 */		 POPUP_TYPE_WARNING ,      10u,    1u,    POPUP_IGN_ON,  	POPUP10_RAPID_ACC            		 		, NULL,          1u,           POPUP10_MSG_RAPID_ACC            		 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*85 	POPUP10_RAPID_SUB            		 	 */		 POPUP_TYPE_WARNING ,      10u,    2u,    POPUP_IGN_ON,  	POPUP10_RAPID_SUB            		 		, NULL,          1u,           POPUP10_MSG_RAPID_SUB            		 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*86 	POPUP10_REVAL_ENGINE         		 	 */		 POPUP_TYPE_WARNING ,      10u,    3u,    POPUP_IGN_ON,  	POPUP10_REVAL_ENGINE         		 		, NULL,          1u,           POPUP10_MSG_REVAL_ENGINE         		 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
	{/*87 	POPUP10_REVAL_SPEED          		 	 */		 POPUP_TYPE_WARNING ,      10u,    4u,    POPUP_IGN_ON,  	POPUP10_REVAL_SPEED          		 		, NULL,          1u,           POPUP10_MSG_REVAL_SPEED          		 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*88 	POPUP11_ENGINE_OIL_FILTER_ERROR     	 */		 POPUP_TYPE_WARNING ,      11u,    1u,    POPUP_IGN_ON,  	POPUP11_ENGINE_OIL_FILTER_ERROR     		, NULL,          1u,           POPUP11_MSG_ENGINE_OIL_FILTER_ERROR     		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*89 	POPUP11_FUEL_FILTER_ERROR           	 */		 POPUP_TYPE_WARNING ,      11u,    2u,    POPUP_IGN_ON,  	POPUP11_FUEL_FILTER_ERROR           		, NULL,          1u,           POPUP11_MSG_FUEL_FILTER_ERROR           		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*90 	POPUP11_T_MISSION_OIL_ERROR         	 */		 POPUP_TYPE_WARNING ,      11u,    3u,    POPUP_IGN_ON,  	POPUP11_T_MISSION_OIL_ERROR         		, NULL,          1u,           POPUP11_MSG_T_MISSION_OIL_ERROR         		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*91 	POPUP11_DIFF_OIL_ERROR           	 	 */		 POPUP_TYPE_WARNING ,      11u,    4u,    POPUP_IGN_ON,  	POPUP11_DIFF_OIL_ERROR           	 		, NULL,          1u,           POPUP11_MSG_DIFF_OIL_ERROR           	 	,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*92 	POPUP11_CLUTCH_OIL_ERROR            	 */		 POPUP_TYPE_WARNING ,      11u,    5u,    POPUP_IGN_ON,  	POPUP11_CLUTCH_OIL_ERROR            		, NULL,          1u,           POPUP11_MSG_CLUTCH_OIL_ERROR            		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
    {/*93 	POPUP11_P_STEERING_FRUID_ERROR      	 */		 POPUP_TYPE_WARNING ,      11u,    6u,    POPUP_IGN_ON,  	POPUP11_P_STEERING_FRUID_ERROR      		, NULL,          1u,           POPUP11_MSG_P_STEERING_FRUID_ERROR      		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},
	{/*94	POPUP11_TIRE_ROTATION           	 	 */		 POPUP_TYPE_WARNING ,      11u,    7u,    POPUP_IGN_ON,  	POPUP11_TIRE_ROTATION           	 		, NULL,          1u,           POPUP11_MSG_TIRE_ROTATION           	 		,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_SINGLE,},


    /*=============================================================================================================================================================================================================================================================================*/
};
/******************************************************************************
报警属性表统计信息
******************************************************************************/
#define   POPUP_NUMBER_TOTAL                (sizeof(PopupAttributeTable) / sizeof(PopupAttributeStruct))
#define   POPUP_NUMBER_FATAL                1
#define   POPUP_NUMBER_HINT                 1
#define   POPUP_NUMBER_WARNING              1

#define   POPUP_PRIORITY_NUMBER_FATAL       3
#define   POPUP_PRIORITY_NUMBER_HINT        1
#define   POPUP_PRIORITY_NUMBER_WARNING     5

#endif