#include "GUI.h"

#include "r_typedefs.h"
//#include "r_ddb_api.h"
//#include "r_cdi_api.h"
//#include "r_wm_api.h"
//#include "davehd_driver.h"
//#include "main.h"
//#include "Graphic.h"
//#include "r_drw2d_os.h"
//#include "r_drw2d_api.h"
//#include "r_config_drw2d.h"
//#include "r_drw2d_ctx_dhd.h"
//#include "r_jcua_api.h"
//#include "r_gpio_api.h"
//#include "r_dev_pin_types.h"
//#include "r_dev_api.h"
////#include "sflash.h"
#include "loc_graphics.h"
//#include "write.h"
#include "images.h"
#include "jcua.h"
#include "Watchdog.h"
#include "Menu.h"

#include "GUI_Interface.h"

#include "CAN_Communication_Matrix.h"
#include "Services_Mileage.h"
#include "RTE_ADC.h"
#include "GaugesInterface.h"

#include "Service_TPMS.h"
#include "DisplaySch_user.h"
#include "CD4051.h"


#include "Data_Gear.h"


#include "Maintenance.h"
#include "Data_FuelConsump.h"
#include "Common_Interface.h"

#include "System_Monitor.h"
#include "Flash_synchronizer.h"

#include "GUI_VC66_Include.h"


#include "Popups.h"

#include "Data_Fuel_User.h"

/*-------------------------------------------------------------------------
 * Function Name  : GUI_Display_KL15_ON_Init
 * Description    : 
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void GUI_Display_KL15_ON_Init(void)
{
    loc_enable_mem(WET_Sprite, Calendar_Sprite); 
    GUI_Display_background();   
}
/*-------------------------------------------------------------------------
 * Function Name  : GUI_Display_KL15_OFF_Init
 * Description    : 
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void GUI_Display_KL15_OFF_Init(void)
{
    loc_Del_Sprite(WET_Sprite, Calendar_Sprite);
    loc_free_mem(WET_Sprite, Calendar_Sprite);
}

/*-------------------------------------------------------------------------
 * Function Name  : GUI_Display_background
 * Description    : 显示底图
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void GUI_Display_background(void)
{
    GUI_General_Display(WET_Sprite, ditu, GUI_BLENDMODE_CUSTOM);      
}
/*-------------------------------------------------------------------------
 * Function Name  : GUI_Display_OftenShow_Group
 * Description    : 常显界面
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 常显功能界面均放在此处
 --------------------------------------------------------------------------*/
void GUI_Display_OftenShow_Group(void)
{
    Gui_Display_AC_AdBule();
    Gui_Display_AC_TEMP();
    Gui_Display_AC_WET();
    Gui_Display_ADAS();
    Gui_Display_Date();
    Gui_Display_DrivingSupport();
    Gui_Display_Gear();
    Gui_Display_ODO();
    Gui_Display_Time();
    Gui_Display_TRIPA();
}
/*-------------------------------------------------------------------------
 * Function Name  : GUI_Display_UsuallyConv
 * Description    : 通常显示选择
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void GUI_Display_UsuallyConv(en_USUALLY_GROUP Type)
{
    switch(Type)
    {
        case USUALLY_NULL:
        break ;
        case USUALLY_BLANK:
            GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
        break ;
        case USUALLY_TRIPA:
            GUI_Display_Usually_AvrFuelCons(0);
            GUI_Display_Usually_AvrSpeed(0);
        break ;
        case USUALLY_TRIPB:
            GUI_Display_Usually_AvrFuelCons(1);
            GUI_Display_Usually_AvrSpeed(1);
        break ;
        case USUALLY_VOLTMETER:
            GUI_Display_Usually_VoltMeter();
        break ;
        case USUALLY_CALENDAR:
            GUI_Display_Usually_Calendar();
        break ;
        case USUALLY_TIME_TABLE:
            GUI_Display_Usually_TimeTable();
        break ;
        case USUALLY_DPD_ACCUMULATION:
            GUI_Display_Usually_DPD(0);
        break ;
        case USUALLY_DPD_REGENERATION:
            GUI_Display_Usually_DPD(1);
        break ;
        default:
        break ;
    }
}
/*-------------------------------------------------------------------------
 * Function Name  : GUI_wby_test_Display
 * Description    : 测试
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/

uint8_t wbyTestflag = 0 ;
uint16_t TestUnicode[4u] = {0x5ba4,0x5916,0x6e29,0x5ea6};
void GUI_wby_test_Display(void)
{
    //GUI_Unicode_Display(Temp_Sprite, 106, 45, TestUnicode, 4, 0xFFFFFFFF);

    GUI_Display_OftenShow_Group();

    switch(wbyTestflag)
    {
        case 0 :
                GUI_Display_UsuallyConv(USUALLY_BLANK);
        break ;
        case 1 :
                GUI_Display_UsuallyConv(USUALLY_TRIPA);    
        break ;
        case 2 :
                GUI_Display_UsuallyConv(USUALLY_TRIPB);
        break ;
        case 3 :
                GUI_Display_UsuallyConv(USUALLY_VOLTMETER);    
        break ;
        case 4 :
                GUI_Display_UsuallyConv(USUALLY_CALENDAR);    
        break ;
        case 5 :
                GUI_Display_UsuallyConv(USUALLY_TIME_TABLE);    
        break ;
        case 6 :
                GUI_Display_UsuallyConv(USUALLY_DPD_ACCUMULATION);    
        break ;
        case 7 :
                GUI_Display_UsuallyConv(USUALLY_DPD_REGENERATION);
                    
        break ;
        case 8 :
                GUI_General_Popup();
        break ;
        case 9 :
                
        break ;
        case 10 :
        break ;
        case 11 :
        break ;
        case 12 :
        break ;
        case 13 :
        break ;
    }


    

    //测试用
    uint16_t xx[4] = {75,60,45,30} ;
    //GUI_General_Digit_Display(WarningLight_Sprite, Fuel_Get_Res(), Nb_12_0, 4u, 3u, xx, 150, GUI_BLENDMODE_SRC_OVER);
    //GUI_General_Digit_Display(WarningLight_Sprite, Fuel_Get_Step(), Nb_12_0, 3u, 2u, xx, 200, GUI_BLENDMODE_SRC_OVER);
    GUI_General_Display(WarningLight_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    
    
}