#include "GUI_VC66_AC_WET.h"

/*ZH:*/

const uint16_t wet_picture[17] = 
{
    CN_qiyazouge_01,
    CN_qiyazouge_02,
    CN_qiyazouge_03,
    CN_qiyazouge_04,
    CN_qiyazouge_05,
    CN_qiyazouge_06,
    CN_qiyazouge_07,
    CN_qiyazouge_08,
    CN_qiyazouge_09,
    CN_qiyazouge_10,
    CN_qiyazouge_11,
    CN_qiyazouge_12,
    CN_qiyazouge_13,
    CN_qiyazouge_14,
    CN_qiyazouge_15,
    CN_qiyazouge_16,
    CN_qiyazouge_17,
}; // 建立数组存储17个气压格的图片枚举。

static uint8_t Logic_Processing(void); 


/*气压 显示*/
void Gui_Display_AC_WET(void)
{
    static uint8_t last_value = 18u;//上次调用本函数时的Logic_Processing()返回值。
    uint8_t current_value;//本次调用本函数时的Logic_Processing()返回值。
    
    uint8_t i;

    current_value = Logic_Processing();

    GUI_General_Display(WET_Sprite, CN_qiyafuhaodeng, GUI_BLENDMODE_SRC_OVER); // 刷气压符号灯。

    if (current_value > 17u)
    {
        ;//上层数据大于17时，不显示长条的气压表框。
    }
    else
    {
        GUI_General_Display(WET_Sprite, CN_qiya, GUI_BLENDMODE_SRC_OVER); // 刷长条的气压表框。

	    for (i = 0; i < current_value; i++)
	    {
		    GUI_General_Display(WET_Sprite, wet_picture[i], GUI_BLENDMODE_SRC_OVER); // current_value 为几，就显示几格气压。
	    }
    }
	
	
    if (current_value < last_value)//若本次要显示的格数小于上次显示的格数，则清空本次未刷的图。
    {
        GUI_General_Display(WET_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
    else if (current_value > 17u)//若本次要显示的格数 大于或等于18,则清空本次未刷的图。
    {
        GUI_General_Display(WET_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        ;
    }

/******************************************************************************************/

    last_value = current_value;//本句 尽可能 放在 本函数体 的结尾位置。
}




uint8_t Logic_Processing(void)
{
    uint8_t in_1 = 123u;
    uint8_t in_2 = 123u;
    uint8_t out;



    out = 10u;

    

    return out;
}

/*:ZH*/