#include "DisplaySch_user.h"
#include "Common_Interface.h"
#include "DispSch.h"
#include "DisplaySch.h"
#include "Popup_Scheduler.h"
#include "Popup_List.h"
#include "Key.h"
#include "CAN_Lib.h"
#include "GUI.h"
#include "Services_ODO_User.h"        /*清空总计里程函数*/
#include "Menu.h"
#include "GUI_VC66_INCLUDE.h"

uint32_t EnterTimer [ 10 ];
uint8_t  UE_EN [ Display_MAX ];
#pragma alignvar(8)
#pragma ghs section bss = default
uint8_t             Mem [ 32 ];
#pragma ghs section bss = default

#pragma ghs section  bss = ".myNonInitArea"
UE_CtrlInfo_Struct_t UE_CtrlInfo;
#pragma ghs section  bss = default

uint32_t       HMI_StartAnimationFrameCnt;

static uint8_t MenuBGStatus    = 0u;
static uint8_t MenuBGStatusOLD = 0u;

static uint8_t Menu_ModeSelection_Fsm(Menu_Key_en_t enMenuKey);

static void switch_branch(void);

uint8_t Get_Pwr(void)
{
    return Common_Get_IG_Sts( );
}
uint32_t Get_IG_ON(void)
{
    return Common_GetIgnOnTime( );
}
uint32_t Get_IG_Off(void)
{
    return Common_GetIgnOffTime( );
}

static const DispSch_Attr_st loc [] =
{
    {&UE_EN [ Display_StartAnimation ], UE_IGN_ON, Display_StartAnimation, (( void * )0), Display_StartAnimationEnter, Display_StartAnimationService, Display_StartAnimationExit},
    {&UE_EN [ Display_Menu ], UE_IGN_ON, Display_Menu, (( void * )0), (( void * )0), Display_MenuService, (( void * )0)},
    {&UE_EN [ Display_Alarm ], UE_IGN_ON, Display_Alarm, (( void * )0), (( void * )0), Display_AlarmService, (( void * )0)},
};

void DispSch_TotalInit(void)
{
    uint8_t        i;
    DispSch_Ext_st m_st;
    m_st.Get_Power        = Get_Pwr;
    m_st.Get_IG_ON_Timer  = Get_IG_ON;
    m_st.Get_IG_OFF_Timer = Get_IG_Off;
    m_st.Get_IG_OFF_Timer = Get_IG_Off;
    m_st.TotalSize        = Display_MAX;
    DispSch_Init(Mem, loc, &m_st, 0u);
    for ( i = 0u; i < Display_MAX; i++ )
    {
        UE_EN [ i ] = UE_Disable;
    }
}

void DisplayServices(void)
{
    uint32_t PowerOnTimer;
    uint32_t PowerOFFTimer;
    uint8_t  PowerStatus;
    uint16_t popupID = 0xFFFFu;
    Menu_Item_en_t DisplayIdx = MENU_ITEM_MAX;

    DisplayIdx = Menu_Get_Current_Cursor_Information();

    PowerStatus      = Common_Get_IG_Sts( );
    PowerOnTimer     = Common_GetIgnOnTime( );
    PowerOFFTimer    = Common_GetIgnOffTime( );

    if ( (PowerOnTimer <= StartAnimationEnd) && (PowerOnTimer >= StartAnimationStart) )
    {
        UE_EN [ Display_StartAnimation ] = UE_Enable;
        UE_EN [ Display_Menu ]           = UE_Disable;
        UE_EN [ Display_Alarm ]          = UE_Disable;
    }
    else
    {
        //if (DisplayIdx < MENU_ITEM_PassWord_1)
        {
            popupID = Popup_Get_Current_Message( );
        }

        if ( popupID != 0xffffu )
        {
            UE_EN [ Display_Alarm ]         = UE_Enable;
        }
        else
        {
            UE_EN [ Display_Alarm ]          = UE_Disable;
            if ( PowerStatus == COMMON_POWER_ON )
            {
                UE_EN [ Display_Menu ] = UE_Enable;
            }
            else
            {
                UE_EN [ Display_Menu ] = UE_Disable;
            }
        }
    }
    DispSch_xxxMs_Logic(10u);
}

void Display_StartAnimationEnter(void)
{
    HMI_StartAnimationFrameCnt = 0u;
    MenuBGStatus               = 0u;
    MenuBGStatusOLD            = 0xff;
    GUI_Display_background();
}

void Display_StartAnimationService(void)
{
    uint16_t m16_FrameCnt;

    HMI_StartAnimationFrameCnt++;
    m16_FrameCnt = HMI_StartAnimationFrameCnt;
    if ( (m16_FrameCnt % 3) == 0 )
    {
        loc_Disable_Window_App( );
        //GUI_Display_Animation_Frame(m16_FrameCnt / 3u);
        GUI_Display_background();
    }
}

void Display_StartAnimationExit(void)
{

    loc_Enable_Window_App( );

    MenuBGStatusOLD = MenuBGStatus;
}

void Display_MenuService(void)
{




    if ( MenuBGStatusOLD != MenuBGStatus )
    {
        MenuBGStatusOLD = MenuBGStatus; 
        //GUI_Display_background(MenuBGStatus);
    }
    /*更換底圖位置結束*/

    Menu_Item_en_t pstMenuBuf = MENU_ITEM_MAX;
    pstMenuBuf = Menu_Get_Current_Cursor_Information( );

    //if ( pstMenuBuf != MENU_ITEM_ENTRANCE_FIX )
    //{
    //    if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_MENU == KEY_EVENT_SHORT_PRESS )
    //    {
    //        UE_CtrlInfo.HMI_TIMER.u32MENU_Timer = DisplayMenuTime;
    //        HMI_Clear_KEY_MENU( );
    //    }
    //}
    if ( UE_CtrlInfo.HMI_TIMER.u32MENU_Timer != 0u )
    {
        //if (
        //    (pstMenuBuf == MENU_ITEM_TRIP_CLEAR_SUCCEED) || \
        //    (pstMenuBuf == MENU_ITEM_MAINTENACE_CLEAR_SUCCEED) || \
        //    (pstMenuBuf == MENU_ITEM_WEIGHT_DETECTION)
        //)
        //{
        //    UE_CtrlInfo.HMI_TIMER.u32MENU_Timer--;
        //}
    }
    else
    {
        Menu_Service(MENU_KEY_TIMEOUT);
    }

    if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_UP == KEY_EVENT_SHORT_PRESS )
    {
        Menu_Service(MENU_KEY_UP_SHORT);
        UE_CtrlInfo.HMI_KEYInfo.u8KEY_UP    = 0U;
        UE_CtrlInfo.HMI_TIMER.u32MENU_Timer = DisplayMenuTime;
    }
    else if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_UP == KEY_EVENT_LONG_PRESS )
    {
        Menu_Service(MENU_KEY_UP_LONG);
        UE_CtrlInfo.HMI_KEYInfo.u8KEY_UP    = 0U;
        UE_CtrlInfo.HMI_TIMER.u32MENU_Timer = DisplayMenuTime;
    }
    else if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_DOWN == KEY_EVENT_SHORT_PRESS )
    {
        Menu_Service(MENU_KEY_DOWN_SHORT);
        UE_CtrlInfo.HMI_KEYInfo.u8KEY_DOWN  = 0U;
        UE_CtrlInfo.HMI_TIMER.u32MENU_Timer = DisplayMenuTime;
    }
    else if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_DOWN == KEY_EVENT_LONG_PRESS )
    {
        Menu_Service(MENU_KEY_DOWN_LONG);
        UE_CtrlInfo.HMI_KEYInfo.u8KEY_DOWN  = 0U;
        UE_CtrlInfo.HMI_TIMER.u32MENU_Timer = DisplayMenuTime;
    }
    else if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_CONFIRM == KEY_EVENT_SHORT_PRESS )
    {
        Menu_Service(MENU_KEY_CONFIRM_SHORT);
        UE_CtrlInfo.HMI_KEYInfo.u8KEY_CONFIRM = 0U;
        UE_CtrlInfo.HMI_TIMER.u32MENU_Timer   = DisplayMenuTime;
    }
    else if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_CONFIRM == KEY_EVENT_LONG_PRESS )
    {
        Menu_Item_en_t MenuValueSta = 0u;
        UE_CtrlInfo.HMI_TIMER.u32MENU_Timer  = DisplayMenuTime;
        Menu_Service(MENU_KEY_CONFIRM_LONG);

        //if ( MenuValueSta == MENU_ITEM_TRIP_CLEAR_SUCCEED )
        //{
        //    Data_ODO_Clear_Mileage_Num( );
        //}
        UE_CtrlInfo.HMI_KEYInfo.u8KEY_CONFIRM = 0U;
    }
    else if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_CONFIRM == KEY_EVENT_SUPER_LONG_PRESS )
    {
        TYW_Data_ODO_Clear( );
        UE_CtrlInfo.HMI_KEYInfo.u8KEY_CONFIRM = 0U;
        UE_CtrlInfo.HMI_TIMER.u32MENU_Timer   = DisplayMenuTime;
    }
    else if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_CANCEL == KEY_EVENT_SHORT_PRESS )
    {
        Menu_Service(MENU_KEY_CANCEL_SHORT);
        UE_CtrlInfo.HMI_KEYInfo.u8KEY_CANCEL = 0U;
    }
    else if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_CANCEL == KEY_EVENT_LONG_PRESS )
    {
        Menu_Service(MENU_KEY_CANCEL_LONG);
        UE_CtrlInfo.HMI_KEYInfo.u8KEY_CANCEL = 0U;
    }
    else if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_MENU == KEY_EVENT_SHORT_PRESS )
    {
        UE_CtrlInfo.HMI_KEYInfo.u8KEY_MENU  = 0U;
        UE_CtrlInfo.HMI_TIMER.u32MENU_Timer = DisplayMenuTime;
        switch_branch();//按键切菜单分支
    }
    else if ( UE_CtrlInfo.HMI_KEYInfo.u8KEY_MENU == KEY_EVENT_LONG_PRESS )
    {
        UE_CtrlInfo.HMI_KEYInfo.u8KEY_MENU  = 0U;
        UE_CtrlInfo.HMI_TIMER.u32MENU_Timer = DisplayMenuTime;
    }
    else
    {
        ;/*do nothing!*/
    }

    /*-------------------------------------------------------------------------------------*/
    //SOC_Value = Get_ID_18FFDC21_Sig_SOC();
    //SOH_Value = Get_ID_18FFDC21_Sig_SOH();
    //CPD2_0x18FFDC21x_Msg = CAN_MSG_Status(ID_CPD2_0x18FFDC21x_Msg_Count);

    //if (((SOC_Value == 0xFFu) && (SOH_Value == 0xFFu)) || (CPD2_0x18FFDC21x_Msg == CAN_SIG_LOST))
    //{
    //    Menu_Item_Exist_Condition_Set(MENU_ITEM_Battery_Sts, 0u);
    //}
    //else
    //{
    //    Menu_Item_Exist_Condition_Set(MENU_ITEM_Battery_Sts, 1u);
    //}

    //ACCCanStatus = Common_Get_ACC1_ACC_10FE6F2Ax_Msg_Sta();



    /*-------------------------------------------------------------------------------------*/
}
void Display_AlarmService(void)
{
    uint16_t popupID = 0xFFFFu;
    Menu_Item_en_t DisplayIdx = MENU_ITEM_MAX;

    DisplayIdx = Menu_Get_Current_Cursor_Information();

    //if (DisplayIdx < MENU_ITEM_PassWord_1)
    //{
    //    popupID = Popup_Get_Current_Message( );
    //}
    //else
    //{
    //    popupID = 0xFFFFu;
    //}


}

Menu_Item_en_t DisplayIdx = MENU_ITEM_MAX;
void GUI_DisplayServices(void)
{
    UElib_uint16_t  HMI_MENU_Sta = 0u;;
    
    uint8_t MENU_Battery_Sts = 0u;
    uint8_t  PowerStatus;

    PowerStatus  = Common_Get_IG_Sts( );
    HMI_MENU_Sta = Get_Cur_HMI();
    DisplayIdx = Menu_Get_Current_Cursor_Information();
    //MENU_Battery_Sts = Menu_Item_Exist_Condition_Get(MENU_ITEM_Battery_Sts);
    if(HMI_MENU_Sta != Display_StartAnimation)
    {
        if(PowerStatus == COMMON_POWER_ON)
        {
            GUI_wby_test_Display();
             /*显示函数开始*/
#if 0      
            GUI_Display_OftenShow_Group();       
            switch ( DisplayIdx )
            {
                default :
                break ;
                case MENU_ITEM_DRIVE_INFOR_TRIPA: /*TRIPA 平均油耗／平均车速显示画面*/                    
                    GUI_Display_UsuallyConv(USUALLY_TRIPA);

                    break;
                case MENU_ITEM_DRIVE_INFOR_TRIPB: /*TRIPB 平均油耗／平均车速显示画面*/
                    GUI_Display_UsuallyConv(USUALLY_TRIPB);
                    break;
                case MENU_ITEM_DRIVE_INFOR_VOLTMETER: /*电压计显示画面*/
                    GUI_Display_UsuallyConv(USUALLY_VOLTMETER);
                    break;
                case MENU_ITEM_DRIVE_INFOR_CALENDAR: /*日期/时钟显示画面*/
                    GUI_Display_UsuallyConv(USUALLY_CALENDAR);
                    break;
                case MENU_ITEM_DRIVE_INFOR_TIME_TABLE: /*计时表／油温计显示画面*/
                    GUI_Display_UsuallyConv(USUALLY_TIME_TABLE);
                    break;
                case MENU_ITEM_DRIVE_INFOR_DPD_ACCUMULATION: /*DPD堆积量显示画面*/
                    GUI_Display_UsuallyConv(USUALLY_DPD_ACCUMULATION);
                    break;
                case MENU_ITEM_DRIVE_INFOR_DPD_REGENERATION: /*DPD再生进度显示画面*/
                    GUI_Display_UsuallyConv(USUALLY_DPD_REGENERATION);
                    break;
                
            }
#endif            
            GUI_Display_Menu_Item(DisplayIdx, 0);
        }    
    }
    
    //if (
    //    (HMI_MENU_Sta == Display_Alarm) && \
    //    ((DisplayIdx == MENU_ITEM_ENTRANCE_FIX) || (DisplayIdx == MENU_ITEM_ENTRANCE_ALTER))
    //)
#if 0    
    if(HMI_MENU_Sta == Display_Alarm)
    {
        //loc_Del_Sprite(PotSelect_Sprite, Menu_Project_Sprite);

        //GUI_General_Popup();
    }
    else if (HMI_MENU_Sta == Display_Menu)
    {
        /*显示函数开始*/
        switch ( DisplayIdx )
        {
        case MENU_ITEM_DRIVE_INFOR_TRIPA: /*TRIPA 平均油耗／平均车速显示画面*/
            GUI_Display_OftenShow_Group();
            GUI_Display_UsuallyConv(USUALLY_TRIPA);

            break;
        case MENU_ITEM_DRIVE_INFOR_TRIPB: /*TRIPB 平均油耗／平均车速显示画面*/
            GUI_Display_OftenShow_Group();
            GUI_Display_UsuallyConv(USUALLY_TRIPB);
            break;
        case MENU_ITEM_DRIVE_INFOR_VOLTMETER: /*电压计显示画面*/
            GUI_Display_OftenShow_Group();
            GUI_Display_UsuallyConv(USUALLY_VOLTMETER);
            break;
        case MENU_ITEM_DRIVE_INFOR_CALENDAR: /*日期/时钟显示画面*/
            GUI_Display_OftenShow_Group();
            GUI_Display_UsuallyConv(USUALLY_CALENDAR);
            break;
        case MENU_ITEM_DRIVE_INFOR_TIME_TABLE: /*计时表／油温计显示画面*/
            GUI_Display_OftenShow_Group();
            GUI_Display_UsuallyConv(USUALLY_TIME_TABLE);
            break;
        case MENU_ITEM_DRIVE_INFOR_DPD_ACCUMULATION: /*DPD堆积量显示画面*/
            GUI_Display_OftenShow_Group();
            GUI_Display_UsuallyConv(USUALLY_DPD_ACCUMULATION);
            break;
        case MENU_ITEM_DRIVE_INFOR_DPD_REGENERATION: /*DPD再生进度显示画面*/
            GUI_Display_OftenShow_Group();
            GUI_Display_UsuallyConv(USUALLY_DPD_REGENERATION);
            break;
        case MENU_ITEM_LEVEL_1_DTC: /*故障代码*/

            break;
        case MENU_ITEM_LEVEL_1_MAINTAINTENANCE_NOTICE: /*维修通知*/

            break;
        case MENU_ITEM_LEVEL_1_MAINTAINTENANCE_NOTICE_SET: /*维修通知的设定*/

            break;
        case MENU_ITEM_LEVEL_1_USER_SET: /*用户设定*/

            break;
        case MENU_ITEM_LEVEL_1_ECO_STATUS: /*ECO状态显示*/

            break;
        case MENU_ITEM_LEVEL_1_SYS_MODE: /*系统演示模式*/

            break;
        

        default:
            break;
        }
    }
#endif 
}

void HMI_Set_KEY_UP(uint8_t u8KeyVal)
{
    UE_CtrlInfo.HMI_KEYInfo.u8KEY_UP = u8KeyVal;
}
void HMI_Set_KEY_DOWN(uint8_t u8KeyVal)
{
    UE_CtrlInfo.HMI_KEYInfo.u8KEY_DOWN = u8KeyVal;
}
void HMI_Set_KEY_CONFIRM(uint8_t u8KeyVal)
{
    UE_CtrlInfo.HMI_KEYInfo.u8KEY_CONFIRM = u8KeyVal;
}
void HMI_Set_KEY_CANCEL(uint8_t u8KeyVal)
{
    UE_CtrlInfo.HMI_KEYInfo.u8KEY_CANCEL = u8KeyVal;
}
void HMI_Set_KEY_MENU(uint8_t u8KeyVal)
{
    UE_CtrlInfo.HMI_KEYInfo.u8KEY_MENU = u8KeyVal;
}


void HMI_Clear_KEY_UP(void)
{
    UE_CtrlInfo.HMI_KEYInfo.u8KEY_UP = 0u;
}
void HMI_Clear_KEY_DOWN(void)
{
    UE_CtrlInfo.HMI_KEYInfo.u8KEY_DOWN = 0u;
}
void HMI_Clear_KEY_CONFIRM(void)
{
    UE_CtrlInfo.HMI_KEYInfo.u8KEY_CONFIRM = 0u;
}
void HMI_Clear_KEY_CANCEL(void)
{
    UE_CtrlInfo.HMI_KEYInfo.u8KEY_CANCEL = 0u;
}
void HMI_Clear_KEY_MENU(void)
{
    UE_CtrlInfo.HMI_KEYInfo.u8KEY_MENU = 0u;
}


enDisp_Type_t Get_Current_DispType(void)
{
    return UE_CtrlInfo.HMI_Type;
}



/*-------------------------------------------------------------------------
 * Function Name  : Menu_ModeSelection_Fsm
 * Description    : 菜单模式转换
 * Input          : None
 * Output         : None
 * Return         : 0 - 模式保持 1 - 模式更新
 * onther         : 344 - 6
 --------------------------------------------------------------------------*/
static uint8_t Menu_ModeSelection_Fsm(Menu_Key_en_t enMenuKey)
{
    uint8_t u8Result = 0 ;
    Menu_Branch_en_t  CurBranch ;

    CurBranch = stMenuItemAttribute[Menu_Get_Current_Cursor_Information()].enMenuLocateBranch ;
    
    switch(CurBranch)
    {
        case 0 :
        break ;
        case 1 :
        break ;
        case 2 :
        break ;
        case 3 :
        break ;
        default :
        break ;
    }

    return u8Result ;
}


/*************************************************
通过按键“MENU”在 行车电脑 和 用户模式菜单 之间切换：
**************************************************/
void switch_branch(void)
{
    if (stMenuItemAttribute[Menu_Get_Current_Cursor_Information()].enMenuLocateBranch == MENU_BRANCH_NORMAL_DISPLAY)
	{
		Menu_Change_Branch(MENU_BRANCH_USER_MODE_MENU, MENU_CHANGE_FIRST);
	}
	else
	{
		Menu_Change_Branch(MENU_BRANCH_NORMAL_DISPLAY, MENU_CHANGE_FIRST);
	}
}
    