/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : Loop guard macros
 ****************************************************************************
 * Version Control Information :
 *  $Revision: 11006 $
 *  $Date: 2016-11-07 17:32:44 +0100 (Mo, 07. Nov 2016) $
 *  $LastChangedBy: michael.golczewski $
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/

#ifndef DAVEHD_GUARDS_H_INCLUDED
#define DAVEHD_GUARDS_H_INCLUDED

#include "davehd_types.h"

/******************************************************************************
 * GUARD Macros
 *
 * Should be used to implement the loop guards, since they will be deactivated
 * for some platforms.
 *
 */

#ifdef DHD_GUARDED_LOOPS
  #ifndef DHD_DEBUG_GUARDED_LOOPS
    #define DHD_GUARD_VAR(var) unsigned int var = 0
    #define DHD_GUARD_CLEAR(var) var = 0
    #define DHD_GUARD_CHECK(var,guard) var++; if ((var) >= guard)
  #else
    #include "davehd_guards_debug.h"

    #define DHD_GUARD_DEBUG_SET(guard, value) _##guard = value
    #define DHD_GUARD_DEBUG_RESET(guard) _##guard = guard

    #define DHD_GUARD_VAR(var) unsigned int var = 0
    #define DHD_GUARD_CLEAR(var) var = 0
    #define DHD_GUARD_CHECK(var,guard) var++; if ((var) >= _##guard)
  #endif
#else
  /* Dummy implementation. Will lead to dead code in the if statement.*/
  #define DHD_GUARD_VAR(var) dhd_int32_t var = 0
  #define DHD_GUARD_CLEAR(var)
  #define DHD_GUARD_CHECK(var,guard) if (0 != var)
#endif

#define DHD_GUARD_ELSE else

/*----------------------------------------------------------------------------------------------------------*/
/* Platform specific part*/
/**/
#ifdef RENESAS_D1X
    #include "davehd_guards_d1x.h"
#else
    #include "davehd_guards_default.h"
#endif

#endif /* DAVEHD_GUARDS_H_INCLUDED */
