#include "r_typedefs.h"
#include "GPIO.h"

#define GPIO_STB_PROTECTED_WRITE(preg, pstatus, reg, value) \
    do                                                      \
    {                                                       \
        (preg) = 0xA5U;                                     \
        (reg) = (value);                                    \
        (reg) = ~(value);                                   \
        (reg) = (value);                                    \
    } while ((pstatus) == 1U)

const uint32_t g_u32GPIOConfigArray[][2U] =
{
    0x00010010ul,  /*Pin_P0_0 GPIO_IN SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00000053ul,  /*Pin_P0_0 INTP5 SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010010ul,  /*Pin_P0_1 GPIO_IN SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010010ul,  /*Pin_P0_1 GPIO_IN SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00400040ul,  /*Pin_P0_2 RLIN32TX TTLPDSC:L PU/PD:NULL P:L */
    0x00400040ul,  /*Pin_P0_2 RLIN32TX TTLPDSC:L PU/PD:NULL P:L */

    0x00400050ul,  /*Pin_P0_3 RLIN32RX/INTP2 TTLPDSC:L PU/PD:NULL P:L */
    0x00400050ul,  /*Pin_P0_3 RLIN32RX/INTP2 TTLPDSC:L PU/PD:NULL P:L */

    0x00000043ul,  /*Pin_P0_4 CAN0TX SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00000043ul,  /*Pin_P0_4 CAN0TX SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00000053ul,  /*Pin_P0_5 CAN0RX/INTP6 SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00000053ul,  /*Pin_P0_5 CAN0RX/INTP6 SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P0_6 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P0_6 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010010ul,  /*Pin_P0_7 GPIO_IN SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00000050ul,  /*Pin_P0_7 RLIN30RX/INTP8 SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00000043ul,  /*Pin_P0_8 CAN2TX SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00000043ul,  /*Pin_P0_8 CAN2TX SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00000053ul,  /*Pin_P0_9 CAN2RX/INTP10 SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00000053ul,  /*Pin_P0_9 CAN2RX/INTP10 SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P1_0 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P1_0 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P1_1 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P1_1 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P1_2 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P1_2 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P1_3 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P1_3 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P1_4 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P1_4 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P1_5 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P1_5 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P3_0 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P3_0 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P3_1 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P3_1 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P3_2 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P3_2 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P3_3 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P3_3 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P3_4 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P3_4 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P3_5 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P3_5 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P3_6 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P3_6 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00000061ul,  /*Pin_P3_7 SSIF1WS SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00000061ul,  /*Pin_P3_7 SSIF1WS SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00000061ul,  /*Pin_P3_8 SSIF1SCK SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00000061ul,  /*Pin_P3_8 SSIF1SCK SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010010ul,  /*Pin_P3_9 GPIO_IN SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010010ul,  /*Pin_P3_9 GPIO_IN SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010010ul,  /*Pin_P10_0 GPIO_IN COMS1PDSC:L PU/PD:NULL P:L */
    0x00010010ul,  /*Pin_P10_0 GPIO_IN COMS1PDSC:L PU/PD:NULL P:L */

    0x00010010ul,  /*Pin_P10_1 GPIO_IN COMS1PDSC:L PU/PD:NULL P:L */
    0x00010010ul,  /*Pin_P10_1 GPIO_IN COMS1PDSC:L PU/PD:NULL P:L */

    0x00000051ul,  /*Pin_P10_2 TAUB0I3 COMS1PDSC:L PU/PD:NULL P:L */
    0x00000051ul,  /*Pin_P10_2 TAUB0I3 COMS1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P10_3 GPIO_OUT COMS1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P10_3 GPIO_OUT COMS1PDSC:L PU/PD:NULL P:L */

    0x00010010ul,  /*Pin_P10_4 GPIO_IN COMS1PDSC:L PU/PD:NULL P:L */
    0x00010010ul,  /*Pin_P10_4 GPIO_IN COMS1PDSC:L PU/PD:NULL P:L */

    0x00010010ul,  /*Pin_P10_5 GPIO_IN COMS1PDSC:L PU/PD:NULL P:L */
    0x00010010ul,  /*Pin_P10_5 GPIO_IN COMS1PDSC:L PU/PD:NULL P:L */

    0x00010010ul,  /*Pin_P10_6 GPIO_IN COMS1PDSC:L PU/PD:NULL P:L */
    0x00010010ul,  /*Pin_P10_6 GPIO_IN COMS1PDSC:L PU/PD:NULL P:L */

    0x00010010ul,  /*Pin_P10_7 GPIO_IN COMS1PDSC:L PU/PD:NULL P:L */
    0x00010010ul,  /*Pin_P10_7 GPIO_IN COMS1PDSC:L PU/PD:NULL P:L */

    0x00010010ul,  /*Pin_P10_8 GPIO_IN COMS1PDSC:L PU/PD:NULL P:L */
    0x00010010ul,  /*Pin_P10_8 GPIO_IN COMS1PDSC:L PU/PD:NULL P:L */

    0x00010010ul,  /*Pin_P10_9 GPIO_IN COMS1PDSC:L PU/PD:NULL P:L */
    0x00010010ul,  /*Pin_P10_9 GPIO_IN COMS1PDSC:L PU/PD:NULL P:L */

    0x00010010ul,  /*Pin_P10_10 GPIO_IN COMS1PDSC:L PU/PD:NULL P:L */
    0x00010010ul,  /*Pin_P10_10 GPIO_IN COMS1PDSC:L PU/PD:NULL P:L */

    0x00010010ul,  /*Pin_P10_11 GPIO_IN COMS1PDSC:L PU/PD:NULL P:L */
    0x00010010ul,  /*Pin_P10_11 GPIO_IN COMS1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P11_0 GPIO_OUT COMS1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P11_0 GPIO_OUT COMS1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P11_1 GPIO_OUT COMS1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P11_1 GPIO_OUT COMS1PDSC:L PU/PD:NULL P:L */

    0x00010010ul,  /*Pin_P11_2 GPIO_IN COMS1PDSC:L PU/PD:NULL P:L */
    0x00010010ul,  /*Pin_P11_2 GPIO_IN COMS1PDSC:L PU/PD:NULL P:L */

    0x00010010ul,  /*Pin_P11_3 GPIO_IN COMS1PDSC:L PU/PD:NULL P:L */
    0x00010010ul,  /*Pin_P11_3 GPIO_IN COMS1PDSC:L PU/PD:NULL P:L */

    0x00010010ul,  /*Pin_P16_0 GPIO_IN SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010010ul,  /*Pin_P16_0 GPIO_IN SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P16_1 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P16_1 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010010ul,  /*Pin_P16_2 GPIO_IN SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010010ul,  /*Pin_P16_2 GPIO_IN SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00000042ul,  /*Pin_P16_3 TAUB0O7 SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P16_3 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P16_4 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P16_4 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00000042ul,  /*Pin_P16_5 TAUB0O11 SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00000050ul,  /*Pin_P16_5 TAUB0I11 SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P16_6 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P16_6 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P16_7 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P16_7 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P16_8 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P16_8 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010010ul,  /*Pin_P16_9 GPIO_IN SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010010ul,  /*Pin_P16_9 GPIO_IN SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P16_10 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P16_10 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00000041ul,  /*Pin_P16_11 TAUB1O15 SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00000050ul,  /*Pin_P16_11 TAUB2I3 SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00000041ul,  /*Pin_P17_0 TAUB2O1 SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00000050ul,  /*Pin_P17_0 TAUB2I4 SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P17_1 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P17_1 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010010ul,  /*Pin_P17_2 GPIO_IN SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010010ul,  /*Pin_P17_2 GPIO_IN SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010010ul,  /*Pin_P17_3 GPIO_IN SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010010ul,  /*Pin_P17_3 GPIO_IN SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P17_4 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P17_4 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P17_5 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P17_5 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P17_6 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P17_6 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P17_7 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P17_7 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P17_8 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P17_8 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P17_9 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P17_9 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P17_10 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P17_10 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P17_11 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P17_11 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x01000040ul,  /*Pin_P21_0 SFMA0CLK COMS1PDSC:H PU/PD:NULL P:L */
    0x00000040ul,  /*Pin_P21_0 SFMA0CLK COMS1PDSC:L PU/PD:NULL P:L */

    0x00000040ul,  /*Pin_P21_1 SFMA0SSL COMS1PDSC:L PU/PD:NULL P:L */
    0x00000040ul,  /*Pin_P21_1 SFMA0SSL COMS1PDSC:L PU/PD:NULL P:L */

    0x01000060ul,  /*Pin_P21_2 SFMA0O00 COMS1PDSC:H PU/PD:NULL P:L */
    0x00000060ul,  /*Pin_P21_2 SFMA0O00 COMS1PDSC:L PU/PD:NULL P:L */

    0x01000060ul,  /*Pin_P21_3 SFMA0O10 COMS1PDSC:H PU/PD:NULL P:L */
    0x00000060ul,  /*Pin_P21_3 SFMA0O10 COMS1PDSC:L PU/PD:NULL P:L */

    0x01000060ul,  /*Pin_P21_4 SFMA0O20 COMS1PDSC:H PU/PD:NULL P:L */
    0x00000060ul,  /*Pin_P21_4 SFMA0O20 COMS1PDSC:L PU/PD:NULL P:L */

    0x01000060ul,  /*Pin_P21_5 SFMA0O30 COMS1PDSC:H PU/PD:NULL P:L */
    0x00000060ul,  /*Pin_P21_5 SFMA0O30 COMS1PDSC:L PU/PD:NULL P:L */

    0x01000060ul,  /*Pin_P21_6 SFMA0O01 COMS1PDSC:H PU/PD:NULL P:L */
    0x00000060ul,  /*Pin_P21_6 SFMA0O01 COMS1PDSC:L PU/PD:NULL P:L */

    0x01000060ul,  /*Pin_P21_7 SFMA0O11 COMS1PDSC:H PU/PD:NULL P:L */
    0x00000060ul,  /*Pin_P21_7 SFMA0O11 COMS1PDSC:L PU/PD:NULL P:L */

    0x01000060ul,  /*Pin_P21_8 SFMA0O21 COMS1PDSC:H PU/PD:NULL P:L */
    0x00000060ul,  /*Pin_P21_8 SFMA0O21 COMS1PDSC:L PU/PD:NULL P:L */

    0x00000060ul,  /*Pin_P21_9 SFMA0O31 COMS1PDSC:L PU/PD:NULL P:L */
    0x00000060ul,  /*Pin_P21_9 SFMA0O31 COMS1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P22_10 GPIO_OUT COMS1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P22_10 GPIO_OUT COMS1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P42_0 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P42_0 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P42_1 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P42_1 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P42_2 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P42_2 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00000042ul,  /*Pin_P42_3 TAUB2O7 SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00000042ul,  /*Pin_P42_3 TAUB2O7 SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P42_4 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P42_4 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P42_5 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P42_5 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P42_6 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P42_6 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010010ul,  /*Pin_P42_7 GPIO_IN SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010010ul,  /*Pin_P42_7 GPIO_IN SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00000042ul,  /*Pin_P42_8 TAUB0O15 SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00000042ul,  /*Pin_P42_8 TAUB0O15 SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P42_9 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P42_9 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P42_10 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P42_10 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P42_11 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P42_11 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P42_12 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P42_12 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P42_13 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P42_13 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P42_14 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P42_14 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P42_15 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P42_15 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P43_0 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P43_0 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P43_1 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P43_1 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P44_0 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P44_0 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P44_1 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P44_1 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P44_2 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P44_2 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P44_3 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P44_3 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P44_4 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P44_4 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P44_5 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P44_5 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P44_6 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P44_6 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P44_7 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P44_7 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P44_8 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P44_8 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P44_9 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P44_9 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P44_10 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P44_10 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P44_11 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P44_11 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P45_0 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P45_0 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P45_1 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P45_1 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P45_2 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P45_2 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P45_3 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P45_3 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P45_4 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P45_4 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P45_5 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P45_5 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P45_6 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P45_6 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P45_7 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P45_7 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P45_8 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P45_8 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P45_9 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P45_9 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P45_10 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P45_10 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P45_11 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P45_11 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P45_12 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P45_12 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_P45_13 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_P45_13 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_JP0_0 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_JP0_0 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_JP0_1 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_JP0_1 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_JP0_2 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_JP0_2 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_JP0_3 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_JP0_3 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_JP0_4 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_JP0_4 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

    0x00010000ul,  /*Pin_JP0_5 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */
    0x00010000ul,  /*Pin_JP0_5 GPIO_OUT SCHMITT1PDSC:L PU/PD:NULL P:L */

};

static void GPIO_PIN_Init(GPIO_Config_Mode_en_t enGPIOConfigMode)
{
    PORT_AWOPCR0_0 = g_u32GPIOConfigArray[0U][enGPIOConfigMode];
    PORT_AWOPCR0_1 = g_u32GPIOConfigArray[1U][enGPIOConfigMode];
    PORT_AWOPCR0_2 = g_u32GPIOConfigArray[2U][enGPIOConfigMode];
    PORT_AWOPCR0_3 = g_u32GPIOConfigArray[3U][enGPIOConfigMode];
    PORT_AWOPCR0_4 = g_u32GPIOConfigArray[4U][enGPIOConfigMode];
    PORT_AWOPCR0_5 = g_u32GPIOConfigArray[5U][enGPIOConfigMode];
    PORT_AWOPCR0_6 = g_u32GPIOConfigArray[6U][enGPIOConfigMode];
    PORT_AWOPCR0_7 = g_u32GPIOConfigArray[7U][enGPIOConfigMode];
    PORT_AWOPCR0_8 = g_u32GPIOConfigArray[8U][enGPIOConfigMode];
    PORT_AWOPCR0_9 = g_u32GPIOConfigArray[9U][enGPIOConfigMode];

    PORT_ISOPCR1_0 = g_u32GPIOConfigArray[10U][enGPIOConfigMode];
    PORT_ISOPCR1_1 = g_u32GPIOConfigArray[11U][enGPIOConfigMode];
    PORT_ISOPCR1_2 = g_u32GPIOConfigArray[12U][enGPIOConfigMode];
    PORT_ISOPCR1_3 = g_u32GPIOConfigArray[13U][enGPIOConfigMode];
    PORT_ISOPCR1_4 = g_u32GPIOConfigArray[14U][enGPIOConfigMode];
    PORT_ISOPCR1_5 = g_u32GPIOConfigArray[15U][enGPIOConfigMode];

    PORT_ISOPCR3_0 = g_u32GPIOConfigArray[16U][enGPIOConfigMode];
    PORT_ISOPCR3_1 = g_u32GPIOConfigArray[17U][enGPIOConfigMode];
    PORT_ISOPCR3_2 = g_u32GPIOConfigArray[18U][enGPIOConfigMode];
    PORT_ISOPCR3_3 = g_u32GPIOConfigArray[19U][enGPIOConfigMode];
    PORT_ISOPCR3_4 = g_u32GPIOConfigArray[20U][enGPIOConfigMode];
    PORT_ISOPCR3_5 = g_u32GPIOConfigArray[21U][enGPIOConfigMode];
    PORT_ISOPCR3_6 = g_u32GPIOConfigArray[22U][enGPIOConfigMode];
    PORT_ISOPCR3_7 = g_u32GPIOConfigArray[23U][enGPIOConfigMode];
    PORT_ISOPCR3_8 = g_u32GPIOConfigArray[24U][enGPIOConfigMode];
    PORT_ISOPCR3_9 = g_u32GPIOConfigArray[25U][enGPIOConfigMode];

    PORT_ISOPCR10_0 = g_u32GPIOConfigArray[26U][enGPIOConfigMode];
    PORT_ISOPCR10_1 = g_u32GPIOConfigArray[27U][enGPIOConfigMode];
    PORT_ISOPCR10_2 = g_u32GPIOConfigArray[28U][enGPIOConfigMode];
    PORT_ISOPCR10_3 = g_u32GPIOConfigArray[29U][enGPIOConfigMode];
    PORT_ISOPCR10_4 = g_u32GPIOConfigArray[30U][enGPIOConfigMode];
    PORT_ISOPCR10_5 = g_u32GPIOConfigArray[31U][enGPIOConfigMode];
    PORT_ISOPCR10_6 = g_u32GPIOConfigArray[32U][enGPIOConfigMode];
    PORT_ISOPCR10_7 = g_u32GPIOConfigArray[33U][enGPIOConfigMode];
    PORT_ISOPCR10_8 = g_u32GPIOConfigArray[34U][enGPIOConfigMode];
    PORT_ISOPCR10_9 = g_u32GPIOConfigArray[35U][enGPIOConfigMode];
    PORT_ISOPCR10_10 = g_u32GPIOConfigArray[36U][enGPIOConfigMode];
    PORT_ISOPCR10_11 = g_u32GPIOConfigArray[37U][enGPIOConfigMode];

    PORT_ISOPCR11_0 = g_u32GPIOConfigArray[38U][enGPIOConfigMode];
    PORT_ISOPCR11_1 = g_u32GPIOConfigArray[39U][enGPIOConfigMode];
    PORT_ISOPCR11_2 = g_u32GPIOConfigArray[40U][enGPIOConfigMode];
    PORT_ISOPCR11_3 = g_u32GPIOConfigArray[41U][enGPIOConfigMode];

    PORT_ISOPCR16_0 = g_u32GPIOConfigArray[42U][enGPIOConfigMode];
    PORT_ISOPCR16_1 = g_u32GPIOConfigArray[43U][enGPIOConfigMode];
    PORT_ISOPCR16_2 = g_u32GPIOConfigArray[44U][enGPIOConfigMode];
    PORT_ISOPCR16_3 = g_u32GPIOConfigArray[45U][enGPIOConfigMode];
    PORT_ISOPCR16_4 = g_u32GPIOConfigArray[46U][enGPIOConfigMode];
    PORT_ISOPCR16_5 = g_u32GPIOConfigArray[47U][enGPIOConfigMode];
    PORT_ISOPCR16_6 = g_u32GPIOConfigArray[48U][enGPIOConfigMode];
    PORT_ISOPCR16_7 = g_u32GPIOConfigArray[49U][enGPIOConfigMode];
    PORT_ISOPCR16_8 = g_u32GPIOConfigArray[50U][enGPIOConfigMode];
    PORT_ISOPCR16_9 = g_u32GPIOConfigArray[51U][enGPIOConfigMode];
    PORT_ISOPCR16_10 = g_u32GPIOConfigArray[52U][enGPIOConfigMode];
    PORT_ISOPCR16_11 = g_u32GPIOConfigArray[53U][enGPIOConfigMode];

    PORT_ISOPCR17_0 = g_u32GPIOConfigArray[54U][enGPIOConfigMode];
    PORT_ISOPCR17_1 = g_u32GPIOConfigArray[55U][enGPIOConfigMode];
    PORT_ISOPCR17_2 = g_u32GPIOConfigArray[56U][enGPIOConfigMode];
    PORT_ISOPCR17_3 = g_u32GPIOConfigArray[57U][enGPIOConfigMode];
    PORT_ISOPCR17_4 = g_u32GPIOConfigArray[58U][enGPIOConfigMode];
    PORT_ISOPCR17_5 = g_u32GPIOConfigArray[59U][enGPIOConfigMode];
    PORT_ISOPCR17_6 = g_u32GPIOConfigArray[60U][enGPIOConfigMode];
    PORT_ISOPCR17_7 = g_u32GPIOConfigArray[61U][enGPIOConfigMode];
    PORT_ISOPCR17_8 = g_u32GPIOConfigArray[62U][enGPIOConfigMode];
    PORT_ISOPCR17_9 = g_u32GPIOConfigArray[63U][enGPIOConfigMode];
    PORT_ISOPCR17_10 = g_u32GPIOConfigArray[64U][enGPIOConfigMode];
    PORT_ISOPCR17_11 = g_u32GPIOConfigArray[65U][enGPIOConfigMode];

    PORT_ISOPCR21_0 = g_u32GPIOConfigArray[66U][enGPIOConfigMode];
    PORT_ISOPCR21_1 = g_u32GPIOConfigArray[67U][enGPIOConfigMode];
    PORT_ISOPCR21_2 = g_u32GPIOConfigArray[68U][enGPIOConfigMode];
    PORT_ISOPCR21_3 = g_u32GPIOConfigArray[69U][enGPIOConfigMode];
    PORT_ISOPCR21_4 = g_u32GPIOConfigArray[70U][enGPIOConfigMode];
    PORT_ISOPCR21_5 = g_u32GPIOConfigArray[71U][enGPIOConfigMode];
    PORT_ISOPCR21_6 = g_u32GPIOConfigArray[72U][enGPIOConfigMode];
    PORT_ISOPCR21_7 = g_u32GPIOConfigArray[73U][enGPIOConfigMode];
    PORT_ISOPCR21_8 = g_u32GPIOConfigArray[74U][enGPIOConfigMode];
    PORT_ISOPCR21_9 = g_u32GPIOConfigArray[75U][enGPIOConfigMode];

    PORT_ISOPCR22_10 = g_u32GPIOConfigArray[76U][enGPIOConfigMode];

    PORT_ISOPCR42_0 = g_u32GPIOConfigArray[77U][enGPIOConfigMode];
    PORT_ISOPCR42_1 = g_u32GPIOConfigArray[78U][enGPIOConfigMode];
    PORT_ISOPCR42_2 = g_u32GPIOConfigArray[79U][enGPIOConfigMode];
    PORT_ISOPCR42_3 = g_u32GPIOConfigArray[80U][enGPIOConfigMode];
    PORT_ISOPCR42_4 = g_u32GPIOConfigArray[81U][enGPIOConfigMode];
    PORT_ISOPCR42_5 = g_u32GPIOConfigArray[82U][enGPIOConfigMode];
    PORT_ISOPCR42_6 = g_u32GPIOConfigArray[83U][enGPIOConfigMode];
    PORT_ISOPCR42_7 = g_u32GPIOConfigArray[84U][enGPIOConfigMode];
    PORT_ISOPCR42_8 = g_u32GPIOConfigArray[85U][enGPIOConfigMode];
    PORT_ISOPCR42_9 = g_u32GPIOConfigArray[86U][enGPIOConfigMode];
    PORT_ISOPCR42_10 = g_u32GPIOConfigArray[87U][enGPIOConfigMode];
    PORT_ISOPCR42_11 = g_u32GPIOConfigArray[88U][enGPIOConfigMode];
    PORT_ISOPCR42_12 = g_u32GPIOConfigArray[89U][enGPIOConfigMode];
    PORT_ISOPCR42_13 = g_u32GPIOConfigArray[90U][enGPIOConfigMode];
    PORT_ISOPCR42_14 = g_u32GPIOConfigArray[91U][enGPIOConfigMode];
    PORT_ISOPCR42_15 = g_u32GPIOConfigArray[92U][enGPIOConfigMode];

    PORT_ISOPCR43_0 = g_u32GPIOConfigArray[93U][enGPIOConfigMode];
    PORT_ISOPCR43_1 = g_u32GPIOConfigArray[94U][enGPIOConfigMode];

    PORT_ISOPCR44_0 = g_u32GPIOConfigArray[95U][enGPIOConfigMode];
    PORT_ISOPCR44_1 = g_u32GPIOConfigArray[96U][enGPIOConfigMode];
    PORT_ISOPCR44_2 = g_u32GPIOConfigArray[97U][enGPIOConfigMode];
    PORT_ISOPCR44_3 = g_u32GPIOConfigArray[98U][enGPIOConfigMode];
    PORT_ISOPCR44_4 = g_u32GPIOConfigArray[99U][enGPIOConfigMode];
    PORT_ISOPCR44_5 = g_u32GPIOConfigArray[100U][enGPIOConfigMode];
    PORT_ISOPCR44_6 = g_u32GPIOConfigArray[101U][enGPIOConfigMode];
    PORT_ISOPCR44_7 = g_u32GPIOConfigArray[102U][enGPIOConfigMode];
    PORT_ISOPCR44_8 = g_u32GPIOConfigArray[103U][enGPIOConfigMode];
    PORT_ISOPCR44_9 = g_u32GPIOConfigArray[104U][enGPIOConfigMode];
    PORT_ISOPCR44_10 = g_u32GPIOConfigArray[105U][enGPIOConfigMode];
    PORT_ISOPCR44_11 = g_u32GPIOConfigArray[106U][enGPIOConfigMode];

    PORT_ISOPCR45_0 = g_u32GPIOConfigArray[107U][enGPIOConfigMode];
    PORT_ISOPCR45_1 = g_u32GPIOConfigArray[108U][enGPIOConfigMode];
    PORT_ISOPCR45_2 = g_u32GPIOConfigArray[109U][enGPIOConfigMode];
    PORT_ISOPCR45_3 = g_u32GPIOConfigArray[110U][enGPIOConfigMode];
    PORT_ISOPCR45_4 = g_u32GPIOConfigArray[111U][enGPIOConfigMode];
    PORT_ISOPCR45_5 = g_u32GPIOConfigArray[112U][enGPIOConfigMode];
    PORT_ISOPCR45_6 = g_u32GPIOConfigArray[113U][enGPIOConfigMode];
    PORT_ISOPCR45_7 = g_u32GPIOConfigArray[114U][enGPIOConfigMode];
    PORT_ISOPCR45_8 = g_u32GPIOConfigArray[115U][enGPIOConfigMode];
    PORT_ISOPCR45_9 = g_u32GPIOConfigArray[116U][enGPIOConfigMode];
    PORT_ISOPCR45_10 = g_u32GPIOConfigArray[117U][enGPIOConfigMode];
    PORT_ISOPCR45_11 = g_u32GPIOConfigArray[118U][enGPIOConfigMode];
    PORT_ISOPCR45_12 = g_u32GPIOConfigArray[119U][enGPIOConfigMode];
    PORT_ISOPCR45_13 = g_u32GPIOConfigArray[120U][enGPIOConfigMode];
    /*
    PORTJ_AWOJPCR0_0 = g_u32GPIOConfigArray[121U][enGPIOConfigMode];
    PORTJ_AWOJPCR0_1 = g_u32GPIOConfigArray[122U][enGPIOConfigMode];
    PORTJ_AWOJPCR0_2 = g_u32GPIOConfigArray[123U][enGPIOConfigMode];
    PORTJ_AWOJPCR0_3 = g_u32GPIOConfigArray[124U][enGPIOConfigMode];
    PORTJ_AWOJPCR0_4 = g_u32GPIOConfigArray[125U][enGPIOConfigMode];
    PORTJ_AWOJPCR0_5 = g_u32GPIOConfigArray[126U][enGPIOConfigMode];
	*/
}

void GPIO_Init(GPIO_Config_Mode_en_t enGPIOConfigMode)
{
    if (enGPIOConfigMode == GPIO_WAKEUP_MODE)
    {
        /*port buffer  exit hold state*/
        GPIO_STB_PROTECTED_WRITE(SYSPROTCMD0, SYSPROTS0, SYSIOHOLD, 0x00U);
        GPIO_PIN_Init(GPIO_WAKEUP_MODE);
    }
    else
    {
        GPIO_PIN_Init(GPIO_SLEEP_MODE);
        /*All ports except P0 into hold state*/
        GPIO_STB_PROTECTED_WRITE(SYSPROTCMD0, SYSPROTS0, SYSIOHOLD, 0x40U);
    }
}

void GPIO_Wakeup_PIN_Set(GPIO_Wakeup_PIN_en_t enGPIOWakeupPIN, GPIO_Wakeup_Trigger_Mode_en_t enGPIOTrigger)
{
    uint32_t u32GPIORegisterAddress = 0xFFC34000U + 0X4U * enGPIOWakeupPIN;
    uint32_t u32GPIORegisterValue = ~(0x01U << enGPIOWakeupPIN);
    if (enGPIOWakeupPIN >= GPIO_WAKEUP_PIN_P0_7)
    {
        u32GPIORegisterAddress += 0xE0U;
    }
    else
    {
        u32GPIORegisterAddress += 0U;
    }
    /*trigger type*/
    *(uint8_t *)u32GPIORegisterAddress = enGPIOTrigger;

    /*trigger PIN*/
    SYSWUFMSK0 &= u32GPIORegisterValue;
}

void GPIO_Config(GPIO_Config_st_t *pstGPIOConfig)
{

    uint32_t u32GPIORegisterAddress = 0xFF610000U + 0X40U * pstGPIOConfig->enGPIOPort + 0X04U * pstGPIOConfig->enGPIOPIN;
    uint32_t u32GPIORegisterValue = 0U;
    if (pstGPIOConfig->enGPIOPort == 0U)
    {
        u32GPIORegisterAddress += 0xA000U; /*0x8000U+0X2000U*/
    }
    else
    {
        u32GPIORegisterAddress += 0X2000U;
    }

    if (pstGPIOConfig->enGPIODrive == GPIO_Drive_Fast)
    {
        u32GPIORegisterValue |= 0x1000000U; /*bit 24U PDSC*/
    }
    else
    {
        u32GPIORegisterValue &= (~0x1000000U);
    }
    if (pstGPIOConfig->enGPIOPort == GPIO_PORT_GROUP_JP0)
    {
        /*Temporary not support*/
    }
    else if (pstGPIOConfig->enGPIOPort == GPIO_PORT_GROUP_0)
    {
        if (pstGPIOConfig->enGPIOCharacter == GPIO_Char_TTL)
        {
            u32GPIORegisterValue |= 0x400000U; /*bit 22U PISA*/
        }
        else if (pstGPIOConfig->enGPIOCharacter == GPIO_Char_Schmitt4)
        {
            u32GPIORegisterValue |= 0x100000U; /*bit 20U PIS*/
        }
        else /*GPIO_Char_Schmitt1*/
        {
            u32GPIORegisterValue &= (~0x500000U);
        }
    }
    /*10 ,11,21,22*/
    else if ((pstGPIOConfig->enGPIOPort == GPIO_PORT_GROUP_21) || (pstGPIOConfig->enGPIOPort == GPIO_PORT_GROUP_22) ||
             (pstGPIOConfig->enGPIOPort == GPIO_PORT_GROUP_10) || (pstGPIOConfig->enGPIOPort == GPIO_PORT_GROUP_11))
    {
        u32GPIORegisterValue &= (~0x500000U); /*CMOS1*/
    }
    /*1,3,16,17,42,43,44,45*/
    else
    {
        if (pstGPIOConfig->enGPIOCharacter == GPIO_Char_CMOS1)
        {
            u32GPIORegisterValue |= 0x400000U; /*bit 22 PISA*/
        }
        else if (pstGPIOConfig->enGPIOCharacter == GPIO_Char_Schmitt4)
        {
            u32GPIORegisterValue |= 0x100000U; /*bit 20 PIS*/
        }
        else /*GPIO_Char_Schmitt1*/
        {
            u32GPIORegisterValue &= (~0x500000U);
        }
    }

    if (pstGPIOConfig->enGPIOPull == GPIO_PULL_UP)
    {
        u32GPIORegisterValue |= 0x80000U; /*bit 19*/
    }
    else if (pstGPIOConfig->enGPIOPull == GPIO_PULL_DOWN)
    {
        u32GPIORegisterValue |= 0x40000U; /*bit 18*/
    }
    else /*GPIO_PULL_NONE*/
    {
        u32GPIORegisterValue &= (~0xC0000U);
    }

    if (pstGPIOConfig->enGPIOOutputValue == GPIO_Level_High)
    {
        u32GPIORegisterValue |= 0x1000U; /*bit 12 Pn*/
    }
    else
    {
        u32GPIORegisterValue &= (~0x1000U);
    }

    if (pstGPIOConfig->enGPIOMode == GPIO_MODE_PORT)
    {
        u32GPIORegisterValue &= (~0x40U); /*bit 6 */
        u32GPIORegisterValue |= 0x10000U; /*bit 16 GPIO_Input_Buf_Open*/
    }
    else
    {
        /*u32GPIORegisterValue |= (0x40U);*/
        if (pstGPIOConfig->enGPIOMode == GPIO_MODE_ALTER_DIRECT)
        {
            u32GPIORegisterValue |= 0x60U; /*bit 6 5*/
        }
        else /*GPIO_MODE_ALTER_SOFTWARE*/
        {
            u32GPIORegisterValue |= 0x40U;       /*bit 6 5*/
            u32GPIORegisterValue &= (~0x10000U); /*bit 16 GPIO_Input_Buf_Close*/
        }
    }

    if (pstGPIOConfig->enGPIODir == GPIO_DIR_IN)
    {
        u32GPIORegisterValue |= 0x10U; /*bit 4 PMn*/
    }
    else
    {
        u32GPIORegisterValue &= (~0x10U);
    }
    if (pstGPIOConfig->enGPIOAltFun <= GPIO_ALTER_FUN_6)
    {
        u32GPIORegisterValue |= (pstGPIOConfig->enGPIOAltFun);
    }
    else
    {
        u32GPIORegisterValue &= (~0x07U); /*default*/
    }
    /*Port JP0 not support*/
    if (pstGPIOConfig->enGPIOPort < GPIO_PORT_GROUP_JP0)
    {
        *(uint32_t *)u32GPIORegisterAddress = u32GPIORegisterValue;
    }
    else
    {
        u32GPIORegisterValue = 0U; /*don't care*/
    }
}

