#ifndef DISPLAY_USER__H
#define DISPLAY_USER__H

#include "TYW_stdint.h"
#include "stddef.h"
#include "Common_Interface.h"

#define UE_IGN_ON_OFF 255U
#define UE_IGN_ON     1U
#define UE_IGN_OFF    0U

#define UE_Disable    0U
#define UE_Enable     1U


#define DisplayAnimationTime 4500u
#define DisplayMenuTime      5000u / 10u
#define MAX_DriveInfoPage    6u
#define FUNC_ENABLE          1u
#define FUNC_DISABLE         0u

#define FRAMECNTFLAG         64u

typedef struct
{
    uint8_t u8KEY_UP;
    uint8_t u8KEY_DOWN;
    uint8_t u8KEY_CONFIRM;
    uint8_t u8KEY_CANCEL;
    uint8_t u8KEY_MENU;
    uint8_t u8KEY_ODOTRIP;

} HMI_KEY_Struct_t;

typedef struct
{
    uint32_t u32MENU_Timer;    //已使用
    uint32_t u32KEY_MENU;
} HMI_Timing_Struct_t;

typedef struct
{
    HMI_KEY_Struct_t    HMI_KEYInfo;
    HMI_Timing_Struct_t HMI_TIMER;
    uint16_t            HMI_Type;
} UE_CtrlInfo_Struct_t;

typedef enum
{
    Display_StartAnimation,
    Display_Menu,
    Display_Alarm,
    Display_Nothing,

    Display_MAX,
} DisplayName;

extern UE_CtrlInfo_Struct_t UE_CtrlInfo;

void DispSch_TotalInit(void);
void DisplayServices(void);

void Display_StartAnimationEnter(void);
void Display_StartAnimationService(void);
void Display_StartAnimationExit(void);

void Display_MenuEnter(void);
void Display_MenuService(void);

void Display_AlarmEnter(void);
void Display_AlarmService(void);

void Display_NothingEnter(void);
void Display_NothingService(void);

void GUI_DisplayServices(void);

void HMI_Set_KEY_UP(uint8_t u8KeyVal);
void HMI_Set_KEY_DOWN(uint8_t u8KeyVal);
void HMI_Set_KEY_CONFIRM(uint8_t u8KeyVal);
void HMI_Set_KEY_CANCEL(uint8_t u8KeyVal);
void HMI_Set_KEY_MENU(uint8_t u8KeyVal);
void HMI_Set_KEY_ODOTRIP(uint8_t u8KeyVal);

void HMI_Clear_KEY_UP(void);
void HMI_Clear_KEY_DOWN(void);
void HMI_Clear_KEY_CONFIRM(void);
void HMI_Clear_KEY_CANCEL(void);
void HMI_Clear_KEY_MENU(void);
void HMI_Clear_KEY_ODOTRIP(void);
void Meter_Mode_conversion(void);

uint16_t Common_GetHMI_StartAnimationFrameCnt(void);

#endif
