#ifndef MEMU_H__
#define MEMU_H__

#include "TYW_stdint.h"

//typedef signed char int8_t;
//typedef unsigned char uint8_t;
//typedef unsigned char INT8U;
//typedef int int16_t;
//typedef unsigned int uint16_t;
//typedef unsigned int INT16U;
//typedef long int32_t;
//typedef unsigned long uint32_t;
//typedef unsigned long INT32U;
//typedef long long int64_t;
//typedef unsigned long long uint64_t;
/*
使用注意事项：
1、当光标在某个分枝时，不可以把该分枝最顶层菜单界面的选项都设置成条件取消的状态。
	都取消了，光标往哪跳！！！
2、考虑上述问题，建议那些一个分枝就一个菜单项的那种，不要设置条件取消。
	不需要的时候不跳转到那个分枝就好。
3、所有函数请在主循环内调用，不要在中断内调用。

*/
//*********************************************************************************************************
//*********************************************************************************************************

/*所有  [菜单项]  的枚举
即使某些菜单项在显示上相同，但因隶属不同菜单界面，所以要用不同枚举区分
*/
typedef enum
{
	//行车信息
	MENU_ITEM_DRIVE_INFOR_TRIPA     =  0 		 ,/*00 TRIPA 平均油耗／平均车速显示画面 */
	MENU_ITEM_DRIVE_INFOR_TRIPB     	 		 ,/*01 TRIPB 平均油耗／平均车速显示画面 */
	MENU_ITEM_DRIVE_INFOR_VOLTMETER     	 	 ,/*02 电压计显示画面 */
	MENU_ITEM_DRIVE_INFOR_CALENDAR     	 		 ,/*03 日期/时钟显示画面 */
	MENU_ITEM_DRIVE_INFOR_TIME_TABLE     	 	 ,/*04 计时表／油温计显示画面 */
	MENU_ITEM_DRIVE_INFOR_DPD_ACCUMULATION     	 ,/*05 DPD堆积量显示画面 */
	MENU_ITEM_DRIVE_INFOR_DPD_REGENERATION     	 ,/*06 DPD再生进度显示画面 */










/*-----------------以下为菜单-----------------*/
/********************************************************************************************************
												用户模式
*********************************************************************************************************/
//一级菜单
//MENU
	MENU_ITEM_LEVEL_1_DTC 	  				 	 								,/*07 故障代码 */
	MENU_ITEM_LEVEL_1_MAINTENANCE_NOTICE 	 	 								,/*08 维修通知 */
	MENU_ITEM_LEVEL_1_MAINTENANCE_NOTICE_SET 	 								,/*09 维修通知的设定 */
	MENU_ITEM_LEVEL_1_USER_SET			 		 								,/*10 用户设定 */
	MENU_ITEM_LEVEL_1_SYS_DISPLAY_MODE			 								,/*12 系统演示模式 */
	MENU_ITEM_LEVEL_1_TIRE_STATUS_DISPLAY		 								,//轮胎状态显示
//*******************************************************************************************************

//二级菜单---维修通知(保养通知)
//MAINTENANCE_NOTICE
	MENU_ITEM_LEVEL_2_ENGINE_OIL_AND_FILTER	,//发动机机油和滤清器
	MENU_ITEM_LEVEL_2_FUEL_FILTER			,//燃油滤清器
	MENU_ITEM_LEVEL_2_TRANSMISSION_OIL		,//变速箱油
	MENU_ITEM_LEVEL_2_DIFFERENTIAL_OIL		,//差速器油
	MENU_ITEM_LEVEL_2_AIR_DRYER_DESICCANT	,//空气干燥器干燥剂
	MENU_ITEM_LEVEL_2_POWER_STEERING_FLUID	,//动力转向液
	MENU_ITEM_LEVEL_2_TIRE					,//轮胎
	MENU_ITEM_LEVEL_2_STARTER 				,//起动机

//二级菜单---维修通知的设定(保养通知的设定)
//MAINTENANCE_NOTICE_SET
	MENU_ITEM_LEVEL_2_REPLACE_ENGINE_OIL_AND_FILTER	,//更换发动机机油和滤清器
	MENU_ITEM_LEVEL_2_REPLACE_FUEL_FILTER_REPLACE  	,//更换燃油滤清器
	MENU_ITEM_LEVEL_2_REPLACE_TRANSMISSION_OIL	   	,//更换变速箱油
	MENU_ITEM_LEVEL_2_REPLACE_DIFFERENTIAL_OIL	   	,//更换差速器油
	MENU_ITEM_LEVEL_2_SMOOTHER_CLUTCH_OIL		   	,//SMOOTHER离合器油
	MENU_ITEM_LEVEL_2_REPLACE_POWER_STEERING_FLUID 	,//更换动力转向液
	MENU_ITEM_LEVEL_2_REPLACE_TIRE				   	,//更换轮胎
	MENU_ITEM_LEVEL_2_REPLACE_STARTER 		   	   	,//更换起动机

//二级菜单---用户设定
//USER_SET
	MENU_ITEM_LEVEL_2_SET_DATE					      	 ,//设定日期
	MENU_ITEM_LEVEL_2_SET_TIME					       	 ,//设定时间
	MENU_ITEM_LEVEL_2_SET_DISPLAY                    	 ,//设定显示
	MENU_ITEM_LEVEL_2_SET_SAVE_FUEL_DRIVE_SUGGESTION     ,//设定节油驾驶建议
	MENU_ITEM_LEVEL_2_SET_VEHICLE_SPACING_ALARM_VOLUME	 ,//设定车间距报警音量
	MENU_ITEM_LEVEL_2_METER_SET						  	 ,//仪表设定

//二级菜单---系统演示模式
//SYS_DISPLAY_MODE
	MENU_ITEM_LEVEL_2_LDWS_ALERT_DEMO				,//LDWS 警报演示
	MENU_ITEM_LEVEL_2_AEBS_FIRST_ALERT_DEMO			,//AEBS第1警报演示
	MENU_ITEM_LEVEL_2_AEBS_SECOND_ALERT_DEMO		,//AEBS第2警报演示
	MENU_ITEM_LEVEL_2_AEBS_FULL_BRAKING_ALERT_DEMO	,//AEBS全力制动警报演示
	
//二级菜单---轮胎状态显示
//TIRE_STATUS_DISPLAY
	MENU_ITEM_LEVEL_2_TIRE_PRESSURE	 ,//轮胎气压
	MENU_ITEM_LEVEL_2_TIRE_TEMP		 ,//轮胎温度

//*************************************************************

//三级菜单---设定日期（年）
//SET_DATE_YEAR
	MENU_ITEM_LEVEL_3_SET_DATE_YEAR,//设定年

//四级菜单---设定日期（月）
//SET_DATE_MONTH
	MENU_ITEM_LEVEL_4_SET_DATE_MONTH,//设定月

//五级菜单---设定日期（日）
//SET_DATE_DATE
	MENU_ITEM_LEVEL_5_SET_DATE_DATE,//设定日

//*************************************************************

//三级菜单---设定时间（小时）
//SET_TIME_HOUR
	MENU_ITEM_LEVEL_3_SET_TIME_HOUR,//设定小时

//四级菜单---设定时间（分钟）
//SET_TIME_MINUTE
	MENU_ITEM_LEVEL_4_SET_TIME_MINUTE,//设定分钟

//*************************************************************

//三级菜单---设定显示
//SET_DISPLAY
	MENU_ITEM_LEVEL_3_TIME,//时间
	MENU_ITEM_LEVEL_3_DATE,//日期

//三级菜单---设定节油驾驶建议
//SET_SAVE_FUEL_DRIVE_SUGGESTION
	MENU_ITEM_LEVEL_3_SPEED_SETTING_HIGH_SPEED_ROAD		,//速度设定－高速路
	MENU_ITEM_LEVEL_3_SPEED_SETTING_GENERAL_ROAD		,//速度设定－一般路
	MENU_ITEM_LEVEL_3_ENGINE_SPEED_SETTING				,//发动机转速设定
	MENU_ITEM_LEVEL_3_RAPID_ACCELERATION_SETTING		,//急加速设定
	MENU_ITEM_LEVEL_3_RAPID_DECELERATION_SETTING		,//急减速设定
	MENU_ITEM_LEVEL_3_LONG_IDLE_SETTING					,//长时间怠速设定
	MENU_ITEM_LEVEL_3_AUXILIARY_PARKING_RELEASE_SETTING	,//辅助驻车解除设定

//三级菜单---设定车间距报警音量
//SET_VEHICLE_SPACING_ALARM_VOLUME
	MENU_ITEM_LEVEL_3_SET_VEHICLE_SPACING_ALARM_VOLUME	,//设定车间距报警音量（图形界面）




	MENU_ITEM_MAX,

} Menu_Item_en_t;
















/*所有菜单  [界面]  的枚举*/
typedef enum
{
	MENU_INTF_ENTRANCE = 0U							,/*入口*/
	MENU_INTF_DRIVE_INFOR 							,/*行车信息 通常显示*/
//================用户模式==============================
	MENU_INTF_U_LEVEL_1_MENU						,//一级菜单
	MENU_INTF_U_MAINTENANCE_NOTICE					,//二级菜单---维修通知(保养通知)
	MENU_INTF_U_MAINTENANCE_NOTICE_SET				,//二级菜单---维修通知的设定(保养通知的设定)
	MENU_INTF_U_USER_SET							,//二级菜单---用户设定
	MENU_INTF_U_SYS_DISPLAY_MODE					,//二级菜单---系统演示模式
	MENU_INTF_U_TIRE_STATUS_DISPLAY					,//二级菜单---轮胎状态显示
	MENU_INTF_U_SET_DATE_YEAR						,//三级菜单---设定日期（年）
	MENU_INTF_U_SET_DATE_MONTH						,//四级菜单---设定日期（月）
	MENU_INTF_U_SET_DATE_DATE						,//五级菜单---设定日期（日）
	MENU_INTF_U_SET_TIME_HOUR						,//三级菜单---设定时间（小时）
	MENU_INTF_U_SET_TIME_MINUTE						,//四级菜单---设定时间（分钟）
	MENU_INTF_U_SET_DISPLAY							,//三级菜单---设定显示
	MENU_INTF_U_SET_SAVE_FUEL_DRIVE_SUGGESTION		,//三级菜单---设定节油驾驶建议
	MENU_INTF_U_SET_VEHICLE_SPACING_ALARM_VOLUME	,//三级菜单---设定车间距报警音量


	MENU_INTERFACE_MAX,

} Menu_Interface_en_t;














/*所有菜单  [分支]  */
typedef enum
{
	//MENU_BRANCH_ANIMATION = 0U	, /*开机动画*/
	MENU_BRANCH_NORMAL_DISPLAY = 0U	, /*通常显示(行车信息)*/
	MENU_BRANCH_USER_MODE_MENU		, /*  用户模式 菜单*/
	MENU_BRANCH_FACTORY_MODE_MENU	, /*  工厂模式 菜单*/
	MENU_BRANCH_DEALER_MODE_MENU	, /*经销商模式 菜单*/


	MENU_BRANCH_MAX,

} Menu_Branch_en_t;



/*--------------------------Do not modify the following--------------------------------*/
/*--------------------------Do not modify the following--------------------------------*/
/*--------------------------Do not modify the following--------------------------------*/

#define MENU_FIXED_PART_LEN 20U
#define MENU_VARIABLE_PART_1_LEN 4U
#define MENU_VARIABLE_PART_2_LEN 4U
#define MENU_VARIABLE_PART_3_LEN 8U
#define MENU_RAM_DATA_LEN (MENU_VARIABLE_PART_1_LEN * MENU_BRANCH_MAX + MENU_VARIABLE_PART_2_LEN * MENU_INTERFACE_MAX + MENU_VARIABLE_PART_3_LEN * MENU_ITEM_MAX + MENU_FIXED_PART_LEN)

/*-------------------------配置字说明---------------
预留位必须填0，其他位根据需要自行选择。
0x0001位：是否可循环,顶端底端循环衔接与否 1：可循环，0：不可循环
0x0002位：预留
0x0004位：预留
0x0008位：预留
0x0010位：预留
0x0020位：预留
0x0040位：预留
0x0080位：预留
0x0100位：预留
0x0200位：预留
0x0400位：预留
0x0800位：预留
0x1000位：预留
0x2000位：预留
0x4000位：预留
0x8000位：预留
--------------------------------------------*/

/*----菜单支持的按键类型-----------*/
typedef enum
{
	MENU_KEY_NONE = 0U,
	/*6个按键的短按动作*/
	MENU_KEY_UP_SHORT,
	MENU_KEY_DOWN_SHORT,
	MENU_KEY_LEFT_SHORT,
	MENU_KEY_RIGHT_SHORT,
	MENU_KEY_CANCEL_SHORT,
	MENU_KEY_CONFIRM_SHORT,

	/*仅针对菜单光标的特殊触发动作*/
	MENU_KEY_TIMEOUT, /*超时动作触发*/

	/*6个按键的长按动作*/
	MENU_KEY_UP_LONG,
	MENU_KEY_DOWN_LONG,
	MENU_KEY_LEFT_LONG,
	MENU_KEY_RIGHT_LONG,
	MENU_KEY_CANCEL_LONG,
	MENU_KEY_CONFIRM_LONG,
	/*6个按键的超长按动作*/
	MENU_KEY_UP_SUPER_LONG,
	MENU_KEY_DOWN_SUPER_LONG,
	MENU_KEY_LEFT_SUPER_LONG,
	MENU_KEY_RIGHT_SUPER_LONG,
	MENU_KEY_CANCEL_SUPER_LONG,
	MENU_KEY_CONFIRM_SUPER_LONG,

	/*针对具体功能的特殊操作按键*/
	MENU_KEY_FUNCTION_1_SHORT,
	MENU_KEY_FUNCTION_1_LONG,
	MENU_KEY_FUNCTION_1_SUPER_LONG,
	MENU_KEY_FUNCTION_2_SHORT,
	MENU_KEY_FUNCTION_2_LONG,
	MENU_KEY_FUNCTION_2_SUPER_LONG,

	MENU_KEY_MAX,

} Menu_Key_en_t;
/*------菜单操作方向-------------------------------------------
--------默认纵向时，上下按键实现菜单项切换，左右按键实现翻页功能-----------
--------横向时，左右按键实现菜单项切换，上下按键实现翻页功能--------------
-------------------------------*/
typedef enum
{
	MENU_DIRECTION_LONGITUDINAL = 0U, /*纵向*/
	MENU_DIRECTION_TRANSVERSE,		  /*横向*/

	MENU_DIRECTION_MAX,

} Menu_Direction_en_t;
/*------菜单跳转类型选择，菜单界面发生变化时，确定进入，按键返回，超时返回等-----------*/
typedef enum
{
	/*跳转到首个位置*/
	MENU_JUMP_FIRST = 0U,
	/*跳转到末尾位置*/
	MENU_JUMP_END,
	/*跳转到已选择的菜单项上，如果有多个，选择位置靠前的*/
	MENU_JUMP_SELECT,
	/*跳转到上一次光标位置*/
	MENU_JUMP_LAST_POSITION,

	MENU_JUMP_MAX,

} Menu_Jump_Type_en_t;

/*当发生分枝切换时，对目标分枝光标的处理方式*/
typedef enum
{
	/*修改光标位置到分枝的首个位置上*/
	MENU_CHANGE_FIRST = 0U,
	/*不修改光标位置，也就是记忆了光标位置。*/
	MENU_CHANGE_HOLD,
	/*修改光标位置到上一个菜单层级*/
	MENU_CHANGE_PREVIOUS,

	MENU_CHANGE_MAX,

} Menu_Change_Type_en_t;
/*
错误检查结果
*/
typedef enum
{
	MENU_ERROR_NONE = 0U,
	MENU_ERROR_1, /*菜单项所隶属的菜单界面信息错误*/
	MENU_ERROR_2, /*菜单项所隶属的菜单分支信息错误*/
	MENU_ERROR_3, /*屏幕上每列可显示的行数需要小于等于菜单界面的总数 */
	MENU_ERROR_4,
	MENU_ERROR_5,  /*确认、返回、超时三个触发动作的跳转方式错误 */
	MENU_ERROR_6,  /*界面内所有菜单项是按照顺序填写的,*/
	MENU_ERROR_7,  /*同一个菜单界面内所填总数数值是一致的*/
	MENU_ERROR_8,  /*同一个菜单界面内所有菜单项的上级菜单项也是一致的。*/
	MENU_ERROR_9,  /*同一个菜单界面内每列可显示的行数也是一致的。*/
	MENU_ERROR_10, /*菜单界面内每个菜单项对应的总数与实际填写的菜单项项数量需要对应*/
	MENU_ERROR_11, /*菜单界面枚举数量和实际填写的菜单界面数量能对应上*/
	MENU_ERROR_12, /*分枝内菜单项序号不连续*/
	MENU_ERROR_13, /*分枝内菜单项总数不一致*/
	MENU_ERROR_14, /*分枝内菜单项的总数与实际填写的数量不对应*/
	MENU_ERROR_15, /*菜单分枝枚举数量和实际填写的菜单分枝数量不对应*/
	MENU_ERROR_16, /*菜单项所填方向信息错误*/
	MENU_ERROR_17, /*不可以向上无限循环。enMenuBelongItem填写错误*/
	MENU_ERROR_18,
	MENU_ERROR_19, /*菜单界内的菜单项必须连续，不可分散排列。*/
	MENU_ERROR_20, /*菜单分枝内所有的菜单项必须连续排列。不可分散排列。*/
	MENU_ERROR_21, /*确认按键跳级或者多个菜单界面的上级菜单项共用了一个*/
	MENU_ERROR_22, /*确认按键不可以跨分枝跳转*/
	MENU_ERROR_23,
	MENU_ERROR_24,
	MENU_ERROR_25,

	/*多对一。多个菜单项上按下确认后都跳到同一个菜单界面上。
	在能确保多对一中，“多”代表的所有菜单项存在条件永远成立时，可忽略本条。
	*/
	MENU_WARNING_1,

	MENU_ERROR_MAX,

} Menu_Error_en_t;

/*菜单初始化类型*/
typedef struct
{
	Menu_Item_en_t enMenuItemLen;
	Menu_Interface_en_t enMenuInterfaceLen;
	Menu_Branch_en_t enMenuBranchLen;

	uint32_t u32MenuConfig;

} Menu_Init_st_t;

typedef void (*Logic_Operation)(Menu_Key_en_t enKeyType);

/*每个菜单项的固定属性*/
typedef struct
{
	
	Menu_Branch_en_t enMenuLocateBranch;/*定位在哪个分枝上*/
	
	Menu_Interface_en_t enMenuLocateInterface;/*定位在哪个菜单界面内*/
	
	Menu_Item_en_t enMenuBelongItem;/*归属哪个菜单项，上级菜单项。一般可以理解为在哪个菜单项上按确认按键进入的*/
	
	
	
	uint32_t u32MenuPositionInInterface;/*序号（该菜单项在其界面中的位置）-----------该菜单项所在界面的位置,一定顺序填写，从0开始*/
	
	uint32_t u32MenuItemTotalInInterface;//  /*总数------该菜单项所在界面的所有项数*/-------------------|___(有些界面不止一列，可能每列行数不同)
	uint32_t u32MenuTransverseNum;//  /*行数-------------屏幕内可显示的每一列最多有几个横向行*/---------|
	
	uint32_t u32MenuPositionInBranch;/*序号----------该菜单项所在分支的位置,一定顺序填写，从0开始。0表示首个位置*/
	
	uint32_t u32MenuItemTotalInBranch;/*总数---------该菜单项所在分支的所有项数*/
	
	
	
	
	Menu_Direction_en_t enMenuDirection;/*菜单方向*/
	
	uint32_t u32MenuKeyBit;/*本菜单项都支持哪些触发动作。待开发，暂定填0xFF即可*/

	
	Menu_Interface_en_t enMenuNextInterface;/*下一级菜单界面，也就是按下确认按键后需要跳转到的界面,如果没有下级菜单时填0xFFFF，不要填本身序号*/
	
	Menu_Jump_Type_en_t enMenuNextJumpPostion;/*按下确认按键，进入新菜单界面时，光标跳转类型*/
	
	Menu_Interface_en_t enMenuPreviousInterface;/*上一级菜单界面,也就是按下返回按键后需要跳转到的界面，如果没有上级菜单时填0xFFFF，不要填本身序号*/
	
	Menu_Jump_Type_en_t enMenuPreviousJumpPostion;/*按下返回按键，返回菜单界面时，光标跳转类型*/
	Menu_Interface_en_t enMenuTimeoutInterface;	/*按键超时时需要返回到的菜单界面,如果不需要返回（返回到自身）时填0xFFFF不要填本身序号*/

	Menu_Jump_Type_en_t enMenuTimeoutJumpPostion;	/*超时返回界面中光标跳转的类型*/


	/*----------------------------------------------------------*/
	Logic_Operation pfnLogicOperationCallBack;	/*   具体功能逻辑的回调函数，按键操作类型，上下左右确认返回    */


} Menu_Item_Attribute_st_t;

/*--------------------------------------------------------------------------------------------*/
extern const Menu_Item_Attribute_st_t stMenuItemAttribute[MENU_ITEM_MAX];
/*------------------------------------------------------------------------------------*/
/*
调试开发阶段使用，检测所填属性表是否有错误.
返回值是MENU_ERROR_NONE时，才可调用后续其他函数。
注意每次修改属性表，都调用一下该函数，确定属性表填写无误。
已经确认属性表无误之后可屏蔽该函数。

enItemMAX:最大菜单项数，也就是MENU_ITEM_MAX
enInterfaceMAX:最大菜单界面数，也就是MENU_INTERFACE_MAX
enBranchMAX:最大菜单分枝数，也就是MENU_BRANCH_MAX
*/

extern Menu_Error_en_t Menu_Attribute_Error_Check(uint8_t *pu8MenuRamData, const Menu_Item_Attribute_st_t *pstMenuAttribute, Menu_Init_st_t *pstMenuInit);
/*
首次上电调用一次即可，不必重复调用。
初始化默认所有菜单项有效，且没有被选中。

u32MenuItemLen:最大菜单项数，也就是MENU_ITEM_MAX
u32MenuInterfaceLen:最大菜单界面数，也就是MENU_INTERFACE_MAX
u32MenuBranchLen:最大菜单分枝数，也就是MENU_BRANCH_MAX
u32MenuConfig:配置字，根据实际需要填写。
*/
extern void Menu_Init(uint8_t *pu8MenuRamData, const Menu_Item_Attribute_st_t *pstMenuAttribute, Menu_Init_st_t *pstMenuInit);

/*
每次休眠后唤醒时调用一次。
*/
extern void Menu_Wake_Up_Init(uint8_t *pu8MenuRamData, const Menu_Item_Attribute_st_t *pstMenuAttribute, Menu_Init_st_t *pstMenuInit);
/*
菜单光标动作具体执行函数。
传入按键动作
主循环内调用！主循环内调用！主循环内调用！*/
extern void Menu_Cursor_Process(Menu_Key_en_t enMenuKey);
/*菜单逻辑回调函数的调用
具体菜单功能在此处调用执行*/
extern void Menu_Logic_Process(Menu_Key_en_t enMenuKey);

/*分枝切换
enMenuBranch：目标分枝
enMenuChangePostion:目标位置的类型
返回：实际切换到的菜单项
主循环内调用！主循环内调用！主循环内调用！
*/
extern Menu_Item_en_t Menu_Change_Branch(Menu_Branch_en_t enMenuBranch, Menu_Change_Type_en_t enMenuChangeType);

/*获取当前光标位置*/
extern Menu_Item_en_t Menu_Get_Current_Cursor_Information(void);
/*获取某个菜单界面内记忆的光标位置*/
extern Menu_Item_en_t Menu_Get_Cursor_In_Interface(Menu_Interface_en_t enMenuInterface);
/*获取某个分枝内记忆的光标位置*/
extern Menu_Item_en_t Menu_Get_Cursor_In_Branch(Menu_Branch_en_t enMenuBranch);
/*
某个菜单项存在条件的设置
0：不成立，菜单项不显示
1：成立，需要显示菜单项
主循环内调用！主循环内调用！主循环内调用！
*/
extern void Menu_Item_Exist_Condition_Set(Menu_Item_en_t enMenuItem, uint8_t u8ExistOrNot);

/*------获取某个菜单项的成立条件。0：不成立，1：成立-------*/
extern uint8_t Menu_Item_Exist_Condition_Get(Menu_Item_en_t enMenuItem);

/*
设置某个菜单项是否被选中
0：未选中，没有勾选
1：选中，被勾选了
*/
extern void Menu_Item_Select_Set(Menu_Item_en_t enMenuItem, uint8_t u8SelectOrNot);

/*
获取某个菜单项是否被选中
0：未选中，没有勾选
1：选中，被勾选了
*/
extern uint8_t Menu_Item_Select_Get(Menu_Item_en_t enMenuItem);
/*获取某个菜单项所属的界面*/
/*stMenuItemAttribute[某个菜单项].enMenuLocateInterface;*/
/*获取某个菜单项所属的分枝*/
/*stMenuItemAttribute[某个菜单项].enMenuLocateBranch;*/

/*-----------------------------------------------------------------------------------*/
extern uint8_t u8MenuRamData[MENU_RAM_DATA_LEN];
/*-----------------------------------------------------------------------------------*/
extern void Menu_Service(Menu_Key_en_t enMenuKey);
/*-----------------------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------------*/

#endif