#include "CD4051.h"
#include "GPIO.h"
volatile u_CD4051_Input CD4051_Input[ ID_MAX ];
unsigned char pChannel = 0;

void CD4051_Pin_Init(void){



    CD4051_Input[ID_COM1].Byte = 0x00;
    CD4051_Input[ID_COM2].Byte = 0x00;
	CD4051_Input[ID_COM3].Byte = 0x00;
	CD4051_Input[ID_COM4].Byte = 0x00;
	CD4051_Input[ID_COM5].Byte = 0x00;
	CD4051_Input[ID_COM6].Byte = 0x00;
	CD4051_Input[ID_COM7].Byte = 0x00;

    pChannel = 0;

    CD4051A_A_MCU_OUT = 0;
    CD4051A_B_MCU_OUT = 0;
    CD4051A_C_MCU_OUT = 0;
}

void CD4051_GetInputStatus(unsigned char Channel){

}

void CD4051_Choose_Channel(unsigned char Channel){
    CD4051A_A_MCU_OUT = Channel & 0x01;
    CD4051A_B_MCU_OUT = (Channel >> 1) & 0x01;
    CD4051A_C_MCU_OUT = (Channel >> 2) & 0x01;
    
}

void CD4051_IOStatus(unsigned char Channel){
    if(CD4051A_COM1_MCU_IN){
        CD4051_Input[ ID_COM1 ].Byte |= (1 << Channel);
    }else{
        CD4051_Input[ ID_COM1 ].Byte &= ~(1 << Channel);
    }
    if(CD4051A_COM2_MCU_IN){
        CD4051_Input[ ID_COM2 ].Byte |= (1 << Channel);
    }else{
        CD4051_Input[ ID_COM2 ].Byte &= ~(1 << Channel);
    }
	if(CD4051A_COM3_MCU_IN){
        CD4051_Input[ ID_COM3 ].Byte |= (1 << Channel);
    }else{
        CD4051_Input[ ID_COM3 ].Byte &= ~(1 << Channel);
    }
	if(CD4051A_COM4_MCU_IN){
        CD4051_Input[ ID_COM4 ].Byte |= (1 << Channel);
    }else{
        CD4051_Input[ ID_COM4 ].Byte &= ~(1 << Channel);
    }
	if(CD4051A_COM5_MCU_IN){
        CD4051_Input[ ID_COM5 ].Byte |= (1 << Channel);
    }else{
        CD4051_Input[ ID_COM5 ].Byte &= ~(1 << Channel);
    }
	if(CD4051A_COM6_MCU_IN){
        CD4051_Input[ ID_COM6 ].Byte |= (1 << Channel);
    }else{
        CD4051_Input[ ID_COM6 ].Byte &= ~(1 << Channel);
    }
	if(CD4051A_COM7_MCU_IN){
        CD4051_Input[ ID_COM7 ].Byte |= (1 << Channel);
    }else{
        CD4051_Input[ ID_COM7 ].Byte &= ~(1 << Channel);
    }
}

void CD4051_GetInputStatusProc(void){
    CD4051_IOStatus(pChannel);
    pChannel++;
    CD4051_Choose_Channel(pChannel);
    if(pChannel > 7){
        pChannel = 0;
    }
}