
#ifndef RTC_H__
#define RTC_H__
#include "r_typedefs.h"
#define RTC_MODE_MAIN 0U
#define RTC_MODE_SUB 1U

#define RTC_MODE_SELECT RTC_MODE_MAIN

/* RTC default time setting */
#ifndef RTC_DEFAULT_TIME
#define RTC_DEFAULT_TIME 1U
#define RTC_DEFAULT_YEAR 13U
#define RTC_DEFAULT_MONTH 1U
#define RTC_DEFAULT_DATE 1U
#define RTC_DEFAULT_HOUR 0U
#define RTC_DEFAULT_MINUTE 0U
#define RTC_DEFAULT_SECOND 0U
  
#endif

typedef struct
{
	uint8_t u8RTCYear;		 /*00~~99 in Dec*/
	uint8_t u8RTCMonth;		 /*01~~12 in Dec*/
	uint8_t u8RTCDayOfMonth; /*01~~31 in Dec*/
	uint8_t u8RTCHour;		 /*fix 24Hour Format 00~~23 in  Dec*/
	uint8_t u8RTCMinute;	 /*0~~59 in Dec*/
	uint8_t u8RTCSecond;	 /*0~~59 in Dec*/
	uint8_t u8RTCWeek ;      /*1~7 in Dec*/
} RTC_Information_st_t;

extern volatile uint8_t g_RTCLeapYear; /*1:LeapYear , 0:Not a leap year*/
extern volatile RTC_Information_st_t g_stRTCInformation;

/* RTC exported time register */
#define RTC_YEAR g_stRTCInformation.u8RTCYear
#define RTC_MONTH g_stRTCInformation.u8RTCMonth
#define RTC_DATE g_stRTCInformation.u8RTCDayOfMonth
#define RTC_HOUR g_stRTCInformation.u8RTCHour
#define RTC_MINUTE g_stRTCInformation.u8RTCMinute
#define RTC_SECOND g_stRTCInformation.u8RTCSecond
#define RTC_WEEK   g_stRTCInformation.u8RTCWeek
#define RTC_LEAP_YEAR g_RTCLeapYear

extern void RTC_Pre_Init(void);
extern void RTC_Init(void);
extern void RTC_Set_Time(RTC_Information_st_t *pstRTCTime);
extern void RTC_Timing_Service(void);

#endif
