#include "UDS_2EService_Internal.h"

/**
  *写入2E服务数据
  */
uint8_t write2EData(uint8_t writeType)
{
    uint8_t enResult = EEPROM_RW_PASS;
    if(writeType == WriteBootData)
    {
        enResult = WriteDFlashData(0x03u, (uint32_t *)&BootToDFlashInfo.Flag, sizeof(BootToDFlashInfo) / 4u, NeedWait);
    }
    else if(writeType == Write2EData)
    {
        enResult = WriteDFlashData(EEPROM_BLOCK_UDS_S2E, (uint32_t *)&Ser2EToDFlashInfo.Flag, sizeof(Ser2EToDFlashInfo) / 4u, NeedWait);
    }
    else if(writeType == WriteEOLData)
    {
        enResult = WriteDFlashData(EEPROM_BLOCK_UDS_CONFIG, (uint32_t *)&EOL_Data_Type.Flag, sizeof(EOL_Data_Type) / 4u, NeedWait);
    }
    else
    {
        enResult = EEPROM_RW_FAIL;
    }
    return enResult;
}
