﻿
#ifndef GUI_H_
#define GUI_H_

#include "loc_graphics.h"
#include "images.h"
#include "TYW_stdint.h"

#define TRAPA 0u
#define TRAPB 1u

#define Language_En 0u
#define Language_Cn 1u

#define FState_COilTimeOutNum 60u /*3S*/

typedef struct
{
    uint8_t FState_GZM;     /*故障码*/
    uint8_t FState_WXTZ;    /*维修提醒*/
    uint8_t FState_WXSD;    /*维修设定*/
    uint8_t FState_YHSD;    /*用户设定*/
    uint8_t FState_ECO;     /*ECO*/
    uint8_t FState_TPMS;    /*胎压显示*/
    uint8_t FState_TPMSSET; /*胎压设置*/
    uint8_t FState_SYSYS;   /*系统演示*/
    uint8_t WXTZ_FDJY;      /*发动机油*/
    uint8_t WXTZ_RYLQY;     /*燃油滤清油*/
    uint8_t WXTZ_BSXY;      /*变速箱油*/
    uint8_t WXTZ_CSQY;      /*差速器油*/
    uint8_t WXTZ_LHQY;      /*离合器油*/
    uint8_t WXTZ_KQGZJ;     /*空气干燥剂*/
    uint8_t WXTZ_DLZXY;     /*动力转向油*/
    uint8_t WXTZ_LT;        /*轮胎*/
    uint8_t WXTZ_QDJ;       /*起动机*/
    uint8_t WXSD_FDJY;      /*发动机*/
    uint8_t WXSD_RYLQY;     /*燃油滤清油*/
    uint8_t WXSD_BSXY;      /*变速箱油*/
    uint8_t WXSD_CSQY;      /*差速器油*/
    uint8_t WXSD_LHQY;      /*离合器油*/
    uint8_t WXSD_KQGZJ;     /*空气转向*/
    uint8_t WXSD_DLZXY;     /*动力转向*/
    uint8_t WXSD_LT;        /*轮胎*/
    uint8_t WXSD_QDJ;       /*起动机*/
    uint8_t USER_DATE;      /*日期设定*/
    uint8_t USER_TIME;      /*时间设定*/
    uint8_t USER_DISPLAY;   /*显示设定*/
    uint8_t USER_PROPOSAL;  /*省油设定*/
    uint8_t USER_HSA;       /*HAS*/
    uint8_t USER_VOLUEM;    /*音量设定*/
    uint8_t USER_LANGUAGE;  /*语言设定*/
    uint8_t USER_COMPANY;   /*单位设定*/
    uint8_t USER_LIGHT;     /*亮度设定*/
    uint8_t USER_SETIC;     /*仪表设定*/
    uint8_t DEMO_LDWS;
    uint8_t DEMO_AEBS1;
    uint8_t DEMO_AEBS2;
    uint8_t DEMO_AEBS3;

    uint8_t ENTER_RETURN;

    uint8_t Menu_Key_Static;

    uint8_t User_FDJYLQQ_FLAG;
    uint8_t User_RYLQQ_FLAG;
    uint8_t User_BSXY_FLAG;
    uint8_t User_CSQY_FLAG;
    uint8_t User_KQGZJ_FLAG;
    uint8_t User_DLZXY_FLAG;
    uint8_t User_LT_FLAG;
    uint8_t User_LHQY_FLAG;

    uint8_t FState_ClearOilTx;
    uint8_t FState_ClearOilRx;

    uint8_t FState_COilTimeOut;

} _Display_State_Flag;

extern volatile _Display_State_Flag State_Flag;
typedef struct
{
    uint16_t Year;            /*  年  */
    uint8_t Month;            /*  月  */
    uint8_t Date;             /*  日  */
    uint8_t Hour;             /*  时  */
    uint8_t Minute;           /*  分  */
    uint8_t Language;         /*  当前语言标识*/
    uint8_t LeapYear;         /*  设置闰年标识*/
    uint8_t User_Gsl;         /*  速度设定-高速路*/
    uint8_t User_Ybl;         /*  速度设定-一般路*/
    uint8_t User_Speed;       /*  发动机转速设定*/
    uint8_t User_JADD;        /*  急加速设定*/
    uint8_t User_JSUB;        /*  急减速设定*/
    uint8_t User_IDLING;      /*  长时间怠速*/
    uint8_t User_Parking;     /*  辅助驻车*/
    uint8_t User_Date;        /*  日期设置格式切换标识*/
    uint8_t User_Time;        /*  时间设置格式切换标识*/
    uint8_t Date_Time;        /*  显示时间日期标识*/
    uint8_t User_HSASET;      /*  HSA调整*/
    uint8_t User_Language;    /*  语言设置*/
    uint8_t User_Company;     /*  单位设定*/
    uint8_t User_Light;       /*  亮度调节*/
    uint8_t User_CarJL;       /*  车间距离报警*/
    uint32_t User_FDJYLQQ;    /*  发送机油      0 未设定 1-50000 数值*/
    uint32_t User_RYLQQ;      /*  燃油滤清器    0 未设定 1-50000 数值*/
    uint32_t User_BSXY;       /*  变速箱油  */
    uint32_t User_CSQY;       /*  差速器油*/
    uint32_t User_KQGZJ;      /*  空气干燥剂*/
    uint32_t User_DLZXY;      /*  动力转向油*/
    uint32_t User_LT;         /*  轮胎*/
    uint32_t User_QDJ;        /*  起动机*/
    uint32_t User_LHQY;       /*  离合器油*/
    uint8_t User_Tpms;        /*  当前是哪个轮子  0-12*/
    uint8_t User_TpmsStatus;  /*  当前胎压匹配界面 0 胎压未配置状态， 1 轮胎选中界面， 2 轮胎正在配置*/
    uint8_t User_Temp_Return; /*  取消胎压配置  0  1 取消配对标记*/
    uint8_t User_TpmsSend;    /*  胎压匹配报文发送请求次数3    0 不发*/
} _UserSet;

extern _UserSet User_set_Num;
extern _UserSet User_App;

typedef struct
{
    uint8_t T01;
    uint8_t T02;
    uint8_t T03;
    uint8_t T04;
    uint8_t T05;
    uint8_t T06;
    uint8_t T07;
    uint8_t T08;
    uint8_t T09;
    uint8_t T10;
    uint8_t T11;
    uint8_t T12;
    uint8_t FLAG;
} _TPMS;
extern _TPMS TPMS_Matching;

static const uint32_t GUIWedk[7u] = {CN_xingqiri, CN_xingqiyi, CN_xingqier, CN_xingqisan, CN_xingqisi, CN_xingqiwu, CN_xingqiliu};
static const uint32_t GUIMenuWedk[7u] = {CN_ri, CN_Mon, CN_Tue, CN_Wed, CN_Thu, CN_Fri, CN_Sat};
static const uint32_t GUIGear[12u] = {CN_dangwei_1, CN_dangwei_2, CN_dangwei_3, CN_dangwei_4, CN_dangwei_5, CN_dangwei_6, CN_dangwei_7, CN_dangwei_8, CN_dangwei_9, CN_dangwei_10, CN_dangwei_11, CN_dangwei_12};

static const uint16_t GUI_DISP_AC_TEMP[2] = {229u, 216u}; /*室外温度数字显示*/
static const uint16_t GUI_DISP_Hours[2] = {370u, 349u};
static const uint16_t GUI_DISP_Minutes[2] = {428u, 406u};
static const uint16_t GUI_DISP_Year[4] = {568u, 552u, 538u, 522u};
static const uint16_t GUI_DISP_Month[2] = {617u, 604u};
static const uint16_t GUI_DISP_Date[2] = {669u, 653u};
static const uint16_t GUI_DISP_TRIPA[5] = {676u, 648u, 629u, 610u, 591u};               /*TRIP*/
static const uint16_t GUI_DISP_ODO[7] = {676u, 657u, 638u, 619u, 600u, 581u, 562u};     /*ODO*/
static const uint16_t GUI_DISP_DrivingSupport[3] = {481u, 459u, 436u};                  /*定速巡航*/
static const uint16_t GUI_DISP_OILTEMP[7] = {729u, 697u, 676u, 655u, 634u, 613u, 592u}; /*油温时间*/
static const uint16_t GUI_DISP_MENUHours[2] = {578u, 560u};
static const uint16_t GUI_DISP_MENUMinutes[2] = {623u, 605u};
static const uint16_t GUI_DISP_MENUYear[4] = {495u, 477u, 459u, 441u}; /*年月日*/
static const uint16_t GUI_DISP_MENUMonth[2] = {572u, 554u};
static const uint16_t GUI_DISP_MENUDate[2] = {648u, 630u};
static const uint16_t GUI_DISP_MENUYear1[4] = {568u, 552u, 538u, 522u}; /*月日年*/
static const uint16_t GUI_DISP_MENUMonth1[2] = {617u, 604u};
static const uint16_t GUI_DISP_MENUDate1[2] = {669u, 653u};
static const uint16_t GUI_DISP_MENU_Y[4] = {150u, 198u, 246u, 294u}; /*菜单选项纵坐标*/
static const uint16_t GUI_TPMS_PIC_X[4] = {298u, 373u, 478u, 543u};
static const uint16_t GUI_TPMS_PIC_Y[4] = {115u, 140u, 214u, 238u};
static const uint16_t GUI_TPMS_NUM1_X[3] = {344u, 329u, 314u};
static const uint16_t GUI_TPMS_NUM2_X[3] = {419u, 404u, 389u};
static const uint16_t GUI_TPMS_NUM3_X[3] = {525u, 510u, 495u};
static const uint16_t GUI_TPMS_NUM4_X[3] = {589u, 574u, 559u};
static const uint16_t GUI_TPMS_NUM_Y[4] = {109u, 173u, 210u, 274u};
static const uint16_t GUI_TPMS_MIC3_X[4] = {314u, 389u, 495u, 559u};
static const uint16_t GUI_TPMS_MIC2_X[4] = {329u, 404u, 510u, 574u};

static const uint16_t GUI_REP1_X[6] = {582u, 565u, 547u, 521u, 503u, 485u};
static const uint16_t GUI_REP_X[4] = {582u, 565u, 547u, 521u};
static const uint16_t GUI_SETREP_X[6] = {520u, 503u, 485u, 458u, 441u, 424u};
static const uint16_t GUI_SYSSET_X[4] = {520u, 503u, 485u, 468u};
static const uint16_t GUI_SYSSPEED[2] = {485u, 468u};
static const uint16_t GUI_SYSJDD_X[2] = {469u, 441u};

static const uint16_t GUIUsetSetYPos[2] = {304u, 282u};
static const uint16_t GUIUsetSetYPosX[2] = {358u, 337u};
static const uint16_t GUIUsetSetMPosX[2] = {463u, 440u};
static const uint16_t GUIUsetSetDPosX[2] = {570u, 547u};

static const uint16_t GUIUsetSetHPosX[2] = {414u, 391u};
static const uint16_t GUIUsetSetMiPosX[2] = {490u, 467u};

static const uint16_t GUIBGAVGSpeedPosX[4] = {667u, 642u, 617u, 592u};
static const uint16_t GUIBGAVGFuelPosX[4] = {667u, 628u, 603u, 578u};

extern void GUI_Display_KL15_ON_Init(void);
extern void GUI_Display_KL15_OFF_Init(void);
extern void GUI_Display_Value_Init(void); /*显示数据初始化*/
extern void GUI_Display_background(void); /*刷底图*/
extern void GUI_OftenShow_Display(void);  /*常显界面*/
extern void GUI_Dynamic_DIsplay(void);

void GUI_AC_Temp_Dispaly(uint8_t Mode);                 /*室外温度显示*/
void GUI_Time_Dispaly(uint8_t Mode);                    /*时间显示*/
void GUI_Data_Dispaly(uint8_t Mode);                    /*日历显示*/
void GUI_TFTTelltales_Display(uint8_t Mode);            /*TFT指示灯*/
void GUI_WetGas_Dispaly(uint8_t Mode);                  /*wet气压*/
void GUI_AdBlue_Dispaly(uint8_t Mode);                  /**/
void Gui_TRIPA_Display(uint8_t Mode);                   /*TRIPA*/
void Gui_TRIPB_Display(uint8_t Mode);                   /*TRIPB*/
void Gui_ODO_Display(uint8_t Mode);                     /*ODO*/
void Gui_ADAS_Display(uint8_t Mode);                    /*ADAS*/
void Gui_DrivingSupport_Display(uint8_t Mode);          /*定速巡航*/
void Gui_Gear_Display(uint8_t Mode);                    /*挡位*/
void GUI_AVG_FuelSpeed_Display(uint8_t Mode);           /*平均车速，平均油耗*/
void GUI_Drive_Info_Avg_Speed_Display(uint16_t Speed);  /*平均车速*/
void GUI_Drive_Info_Avg_Fuel_Display(uint16_t Fuel);    /*平均油耗*/
void GUI_Battery_Display_Display(uint8_t Mode);         /*电池电量*/
void GUI_DPD_Display_Display(uint8_t Mode);             /*DPD*/
void GUI_Time_OilTemp_Display(uint8_t Mode);            /*转速时间-油温*/
void GUI_Time_OilTemp_OFF_Display(uint8_t Mode);        /*OFF 转速时间-油温*/
void GUI_Year_Month_Data_Display(uint8_t Mode);         /*年月日*/
void GUI_block_NULL_Display(uint8_t Mode);              /*……*/
void GUI_BG_Menu_Display(uint8_t Mode);                 /*一级菜单项*/
void GUI_BG_Menu1_Display(uint8_t Mode);                /**/
void GUI_BG_Menu2_Display(uint8_t Mode);                /**/
void GUI_BG_Menu3_Display(uint8_t Mode);                /**/
void GUI_BG_Menu4_Display(uint8_t Mode);                /**/
void GUI_BG_Menu5_Display(uint8_t Mode);                /**/
void GUI_BG_Menu6_Display(uint8_t Mode);                /**/
void GUI_BG_Errot_Display(uint8_t Mode);                /*二级菜单--故障码显示*/
void GUI_BG_Rep_Menu_Display(uint8_t Mode);             /*二级菜单--保养通知*/
void GUI_BG_RepMenu1_Display(uint8_t Mode);             /**/
void GUI_BG_RepMenu2_Display(uint8_t Mode);             /**/
void GUI_BG_RepMenu3_Display(uint8_t Mode);             /**/
void GUI_BG_RepMenu4_Display(uint8_t Mode);             /**/
void GUI_BG_RepMenu5_Display(uint8_t Mode);             /**/
void GUI_BG_RepMenu6_Display(uint8_t Mode);             /**/
void GUI_BG_RepMenu7_Display(uint8_t Mode);             /**/
void GUI_BG_RepMenu8_Display(uint8_t Mode);             /**/
void GUI_BG_RepMenu9_Display(uint8_t Mode);             /**/
void GUI_BG_RepSet_Menu_Display(uint8_t Mode);          /*二级菜单--保养通知设定*/
void GUI_BG_RepSetMenu1_Display(uint8_t Mode);          /**/
void GUI_BG_RepSetMenu2_Display(uint8_t Mode);          /**/
void GUI_BG_RepSetMenu3_Display(uint8_t Mode);          /**/
void GUI_BG_RepSetMenu4_Display(uint8_t Mode);          /**/
void GUI_BG_RepSetMenu5_Display(uint8_t Mode);          /**/
void GUI_BG_RepSetMenu6_Display(uint8_t Mode);          /**/
void GUI_BG_RepSetMenu7_Display(uint8_t Mode);          /**/
void GUI_BG_RepSetMenu8_Display(uint8_t Mode);          /**/
void GUI_BG_UserSet_Menu_Display(uint8_t Mode);         /*二级菜单--用户设定*/
void GUI_BG_UserSetMenu1_Display(uint8_t Mode);         /**/
void GUI_BG_UserSetMenu2_Display(uint8_t Mode);         /**/
void GUI_BG_UserSetMenu3_Display(uint8_t Mode);         /**/
void GUI_BG_UserSetMenu4_Display(uint8_t Mode);         /**/
void GUI_BG_UserSetMenu5_Display(uint8_t Mode);         /**/
void GUI_BG_UserSetMenu6_Display(uint8_t Mode);         /**/
void GUI_BG_UserSetMenu7_Display(uint8_t Mode);         /**/
void GUI_BG_Demo_Menu_Display(uint8_t Mode);            /*二级菜单--系统演示模式*/
void GUI_BG_DemoMenu1_Display(uint8_t Mode);            /**/
void GUI_BG_DemoMenu2_Display(uint8_t Mode);            /**/
void GUI_BG_DemoMenu3_Display(uint8_t Mode);            /**/
void GUI_BG_DemoMenu4_Display(uint8_t Mode);            /**/
void GUI_BG_TPMS_GasPIC_Display(uint8_t Mode);          /*二级菜单--TPMS*/
void GUI_BG_TPMS_GasNUM_Display(uint8_t Mode);          /**/
void GUI_BG_TPMS_TempPIC_Display(uint8_t Mode);         /**/
void GUI_BG_TPMS_TempNUM_Display(uint8_t Mode);         /**/
void GUI_BG_RepMenu_Display(uint8_t Mode);              /*三级菜单--保养通知*/
void GUI_BG_RepMenu_3_1_Display(uint8_t Mode);          /**/
void GUI_BG_RepMenu_3_2_Display(uint8_t Mode);          /**/
void GUI_BG_RepMenu_3_3_Display(uint8_t Mode);          /**/
void GUI_BG_RepMenu_3_4_Display(uint8_t Mode);          /**/
void GUI_BG_RepMenu_3_6_Display(uint8_t Mode);          /**/
void GUI_BG_RepMenu_3_7_Display(uint8_t Mode);          /**/
void GUI_BG_RepMenu_3_8_Display(uint8_t Mode);          /**/
void GUI_BG_RepMenuSet_Menu_Display(uint8_t Mode);      /**/
void GUI_BG_RepSetMenu_3_1_Display(uint8_t Mode);       /**/
void GUI_BG_RepSetMenu_3_2_Display(uint8_t Mode);       /**/
void GUI_BG_RepSetMenu_3_3_Display(uint8_t Mode);       /**/
void GUI_BG_RepSetMenu_3_4_Display(uint8_t Mode);       /**/
void GUI_BG_RepSetMenu_3_5_Display(uint8_t Mode);       /**/
void GUI_BG_RepSetMenu_3_6_Display(uint8_t Mode);       /**/
void GUI_BG_RepSetMenu_3_7_Display(uint8_t Mode);       /**/
void GUI_BG_UserSet_Display(uint8_t Mode);              /**/
void GUI_BG_UserSet_Date_Display(uint8_t Mode);         /**/
void GUI_BG_UserSet_Time_Display(uint8_t Mode);         /**/
void GUI_BG_UserSet_Language_Display(uint8_t Mode);     /*语言设定*/
void GUI_BG_UserSet_SYSD_Display(uint8_t Mode);         /*省油设置*/
void GUI_BG_UserSet_SYSD_1_Display(uint8_t Mode);       /**/
void GUI_BG_UserSet_SYSD_2_Display(uint8_t Mode);       /**/
void GUI_BG_UserSet_SYSD_3_Display(uint8_t Mode);       /**/
void GUI_BG_UserSet_SYSD_4_Display(uint8_t Mode);       /**/
void GUI_BG_UserSet_SYSD_5_Display(uint8_t Mode);       /**/
void GUI_BG_UserSet_SYSD_6_Display(uint8_t Mode);       /**/
void GUI_BG_UserSet_SYSD_7_Display(uint8_t Mode);       /**/
void GUI_BG_TPMS_PictureSet_Display(uint8_t Mode);      /**/
void GUI_BG_UserSet_SYSD_GSL_Display(uint8_t Mode);     /**/
void GUI_BG_UserSet_SYSD_Ybl_Display(uint8_t Mode);     /**/
void GUI_BG_UserSet_SYSD_Speed_Display(uint8_t Mode);   /**/
void GUI_BG_UserSet_SYSD_JADD_Display(uint8_t Mode);    /**/
void GUI_BG_UserSet_SYSD_JSUB_Display(uint8_t Mode);    /**/
void GUI_BG_UserSet_SYSD_IDLING_Display(uint8_t Mode);  /**/
void GUI_BG_UserSet_SYSD_Parking_Display(uint8_t Mode); /**/

void GUI_BG_Enter_Return_Display(uint8_t Mode); /**/

void Common_EOL_User_Server(void);

#endif