#include "BackLight_APP.h"
#include "RTE_PWM_OUT.h"
#include "Common_Interface.h"
#include "Popup_List.h"
#include "Popup_Scheduler.h"
#include "GPIO.h"
#include "dr7f701441.dvf.h"
#include "CAN_Communication_Matrix.h"
#include "BGLInterface.h"
#include "Line_in.h"
#include "RTE_ADC.h"
#include "TimerB.h"
#include "Data_Fuel_User.h"
#include "Menu.h"
#include "GUI.h"

typedef struct
{
    uint8_t Brightness;
    uint8_t Window;
} SEGLCDBackupStruct;

typedef struct
{
    uint8_t DoorStatusBackup;
    uint16_t Timer;
    uint16_t BackupPwm;
} BlOFFCtrlStruct;

BlOFFCtrlStruct BlOFFCtrl;
SEGLCDBackupStruct SEGLCDBackup;

uint16_t BackLightVLv = 10u;
uint16_t testBG = 500;
uint16_t BackLightOFF_TIME = 0u;
uint16_t BackLightOFFFlag = 0;
uint8_t BackLightTestIG = 1u;
uint8_t BackLightWakeFlag = 0u;
uint8_t BackLightTPostLight = 0u;
uint8_t WARNING_DOOR_STATUS;

uint32_t Left_Right_Delay;

void SEG_LCD_Window_Switch(uint8_t Sw);
void BL_Init(void)
{
    SEG_LCD_Init();
}

/*-------------------------------------------------------------------------
 * Function Name  : BL_Management_service
 * Description    : 100ms任务
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void BL_Management_service(void)
{
    uint8_t Msg;
    uint8_t LED_Pos = 0u;
    uint8_t LED_Left;
    uint8_t LED_Right;
    uint8_t LED_Plus;
    uint8_t WARNING_PARKING_BRAKE_TEL = 0u;
    uint8_t BCM_PositionLight = 0;
    uint8_t DutyCycle;
    uint8_t ILL = 0;
    uint32_t Get_Menu_Off_Time = 0u;
    uint32_t DNC_NumValue = 0u;

    if (Line_In_Get_Status(LINE_IN_ILLUMINATION))
    {
        if (bCurMenuIDX == _MN_DSP_LEVEL3_7_MENU_1)
        {
            ILL = 0;
            BackLightVLv = User_set_Num.User_Light1;
        }
        else
        {
            ILL = 2;
            BackLightVLv = User_set_Num.User_Light2;
        }
    }
    else
    {
        if (bCurMenuIDX == _MN_DSP_LEVEL3_7_MENU_2)
        {
            ILL = 2;
            BackLightVLv = User_set_Num.User_Light2;
        }
        else
        {
            ILL = 0;
            BackLightVLv = User_set_Num.User_Light1;
        }
    }

    if (Common_Get_IG_Sts() == COMMON_POWER_OFF)
    {
        BackLightOFFFlag = 0;

        Get_Menu_Off_Time = Coom_Get_Menu_Off_Time();

        //if (BackLightOFF_TIME < 3000)
        if ((State_Flag.Menu_Key_Static == 1u) && (Get_Menu_Off_Time < 7550))
        {
            BackLightOFF_TIME++;

            BackLightWakeFlag = 1u;
            SEG_LCD_Window_Switch(1);
        }
        else
        {
            State_Flag.Menu_Key_Static = 0;
            BackLightWakeFlag = 0u;
            SEG_LCD_Window_Switch(0);
        }
    }
    else
    {
        State_Flag.Menu_Key_Static = 0;

        if (BackLightOFFFlag <= 50)
        {
            BackLightOFFFlag++;
        }
        if (BackLightOFFFlag >= 5)
        {
            SEG_LCD_Window_Switch(1);
        }
        else
        {
            SEG_LCD_Window_Switch(0);
        }

        BackLightOFF_TIME = 0u;
        BackLightWakeFlag = 0u;
    }

    /*得到主题模式可自己在枚举中定义 在BackGroundLight.c里填表*/
    GetBGLTheme(0);

    /*得到工作模式 白天 傍晚 夜晚 在枚举中已定义*/
    GetBGLType(ILL);
    // GetBGLType(0);

    /*得到背光等级 可自己在枚举中定义 在BackGroundLight.c里填表*/
    GetBGLLvl((BackLightVLv - 1), LED_Pos);

    /*得到热敏电阻电压参数为100倍电压值*/
    DNC_NumValue = RTE_Read_NTC_R_Valid();
    GetBGLNTCVol((uint16_t)DNC_NumValue);

    /*主函数中调用第一个参数电源状态 1是 ON档 2 off 第二个参数 唤醒条件 1是TTF唤醒 2 是表盘唤醒 3 是表盘和屏都有唤醒，0无唤醒*/

    BackLightSchedu(Common_Get_IG_Sts(), BackLightWakeFlag);
}

void BL_PWM_Duty_Cycle_Capture_ISR(void)
{
}

void SEG_LCD_Init(void)
{
    SEGLCDBackup.Brightness = 0xFF;
    SEGLCDBackup.Window = 0x00;
    SEG0_MCU_OUT = 0;
    COMM_MCU_OUT = 0;
    BackLightOFF_TIME = 0u;
}

void SEG_LCD_Window_Switch(uint8_t Sw)
{
    if (Sw == SEGLCDBackup.Window)
        return;

    SEGLCDBackup.Window = Sw;

    if (Sw)
    {
        SEG0_MCU_OUT = 1;
        COMM_MCU_OUT = 0;
    }
    else
    {
        SEG0_MCU_OUT = 0;
        COMM_MCU_OUT = 0;
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : SEG_LCD_Window_Control_Service
 * Description    : 10ms任务 窗口翻转
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void SEG_LCD_Window_Control_Service(void)
{
    if (SEGLCDBackup.Window)
    {
        if (SEG0_MCU_OUT == 1)
        {
            SEG0_MCU_OUT = 0;
            COMM_MCU_OUT = 1;
        }
        else
        {
            SEG0_MCU_OUT = 1;
            COMM_MCU_OUT = 0;
        }
    }
    else
    {
        SEG0_MCU_OUT = 0;
        COMM_MCU_OUT = 0;
    }
}
