
#include "GPIO.h"
#include "Telltales.h"
#include "Telltales_user.h"
#include "CAN_Communication_Matrix.h"
#include "Flash_synchronizer.h"
#include "EOL_Para.h"
#include "Sound_Scheduler.h"
#include "SEG_DISPLAY.h"
#include "Maintenance.h"
#include "Line_in.h"
#include "IS31FL3236.h"
#include "Service_TPMS.h"
#include "Data_AirPressure.h"
#include "Data_CoolantTemperature.h"
#include "FuelConfig.h"
#include "Data_Fuel_User.h"
#include "kwp2000_service.h"
#include "Common_Interface.h"

static uint8_t L12_Air_Sta ;

TelltaleLRCtrlStruct TelltaleLRCtrl;

const LED_Attribute_st LED_Attribute[LED_Max] =
{
    /*  指示灯索引                             是否自检         外部信号自检       工作电源状态       自检开始时间    自检持续时间       指示灯点亮条件                           指示灯执行函数               */
    {   em_LED_INTER_DIFF_LOCK_T          , NoSelfCheck ,     ExterNalCheck ,  LED_IGN_ON_OFF ,      2500u,         4500ul,     LED_INTER_DIFF_LOCK_T_Judgement          , LED_INTER_DIFF_LOCK_T_Execution            },
    {   em_LED_FOUR_MUL_FOUR_T            , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_FOUR_MUL_FOUR_T_Judgement            , LED_FOUR_MUL_FOUR_T_Execution              },
    {   em_LED_EXH_BRAKE_T                , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_EXH_BRAKE_T_Judgement                , LED_EXH_BRAKE_T_Execution                  },
    {   em_LED_QOS_GLOW_T                 ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_QOS_GLOW_T_Judgement                 , LED_QOS_GLOW_T_Execution                   },
    {   em_LED_HI_BEAM_T                  , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON_OFF ,      2500u,         4500ul,     LED_HI_BEAM_T_Judgement                  , LED_HI_BEAM_T_Execution                    },
    {   em_LED_Rr_FOG_LAMP_T              , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON_OFF ,      2500u,         4500ul,     LED_Rr_FOG_LAMP_T_Judgement              , LED_Rr_FOG_LAMP_T_Execution                },
    {   em_LED_MIL_T                      ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_MIL_T_Judgement                      , LED_MIL_T_Execution                        },
    {   em_LED_SVS_T                      ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_SVS_T_Judgement                      , LED_SVS_T_Execution                        },
    {   em_LED_H_S_A__T                   , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_H_S_A_T_Judgement                    , LED_H_S_A_T_Execution                     },
    {   em_LED_RETARDER_T                 ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_RETARDER_T_Judgement                 , LED_RETARDER_T_Execution                   },
    {   em_LED_AUTO_LEVELING_T            , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_AUTO_LEVELING_T_Judgement            , LED_AUTO_LEVELING_T_Execution              },
    {   em_LED_ROWS_L                     , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_ROWS_L_Judgement                     , LED_ROWS_L_Execution                       },
    {   em_LED_BSM_OFF_L                  , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_BSM_OFF_L_Judgement                  , LED_BSM_OFF_L_Execution                    },
    {   em_LED_AEBS_OFF_L                 , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_AEBS_OFF_L_Judgement                 , LED_AEBS_OFF_L_Execution                   },
    {   em_LED_LDWS_L                     , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_LDWS_L_Judgement                     , LED_LDWS_L_Execution                       },
    {   em_LED_SRS_L                      , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_SRS_L_Judgement                      , LED_SRS_L_Execution                        },
    {   em_LED_ENG_OIL_L                  ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_ENG_OIL_L_Judgement                  , LED_ENG_OIL_L_Execution                    },
    {   em_LED_CHARG_L                    ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_CHARG_L_Judgement                    , LED_CHARG_L_Execution                      },
    {   em_LED_SEAT_BELT_L                ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_SEAT_BELT_L_Judgement                , LED_SEAT_BELT_L_Execution                  },
    {   em_LED_RR_DIFF_LOCK_L             ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_RR_DIFF_LOCK_L_Judgement             , LED_RR_DIFF_LOCK_L_Execution               },
    {   em_LED_TPMS_L                     ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_TPMS_L_Judgement                     , LED_TPMS_L_Execution                       },
    {   em_LED_ASR_or_EVSC_OFF_L          , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_ASR_or_EVSC_OFF_L_Judgement          , LED_ASR_or_EVSC_OFF_L_Execution            },
    {   em_LED_EVSC_L                     , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_EVSC_L_Judgement                     , LED_EVSC_L_Execution                       },
    {   em_LED_eco_stop_OFF_L             , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_eco_stop_OFF_L_Judgement             , LED_eco_stop_OFF_L_Execution               },
    {   em_LED_AMT_L                      , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_AMT_L_Judgement                      , LED_AMT_L_Execution                        },
    {   em_LED_WEAR_IND_L                 , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_WEAR_IND_L_Judgement                 , LED_WEAR_IND_L_Execution                   },
    {   em_LED_TRAILER_BRAKE_R            ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_TRAILER_BRAKE_R_Judgement            , LED_TRAILER_BRAKE_R_Execution              },
    {   em_LED_BRAKE_AIR_or_EBS_YELLOW_R  , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_BRAKE_AIR_or_EBS_YELLOW_R_Judgement  , LED_BRAKE_AIR_or_EBS_YELLOW_R_Execution    },
    {   em_LED_ACC_AIR_R                  , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_ACC_AIR_R_Judgement                  , LED_ACC_AIR_R_Execution                    },
    {   em_LED_ABS_R                      ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_ABS_R_Judgement                      , LED_ABS_R_Execution                        },
    {   em_LED_PARK_BRAKE_R               ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_PARK_BRAKE_R_Judgement               , LED_PARK_BRAKE_R_Execution                 },
    {   em_LED_BRAKE_AIR_or_EBS_RED_R     , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_BRAKE_AIR_or_EBS_RED_R_Judgement     , LED_BRAKE_AIR_or_EBS_RED_R_Execution       },
    {   em_LED_BRAKE_LOCK_R               , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_BRAKE_LOCK_R_Judgement               , LED_BRAKE_LOCK_R_Execution                 },
    {   em_LED_AIR_SUS_R                  ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_AIR_SUS_R_Judgement                  , LED_AIR_SUS_R_Execution                    },
    {   em_LED_TRAILER_ABS_U              ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_TRAILER_ABS_U_Judgement              , LED_TRAILER_ABS_U_Execution                },
    {   em_LED_WORKING_LAMP_U             , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_WORKING_LAMP_U_Judgement             , LED_WORKING_LAMP_U_Execution               },
    {   em_LED_TRAILER_ABS_INFO_U         , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_TRAILER_ABS_INFO_U_Judgement         , LED_TRAILER_ABS_INFO_U_Execution           },
    {   em_LED_TEMP                       , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_Temp_Judgement                       , LED_Temp_Execution                         },
    {   em_LED_FUEL                       , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,      2500u,         4500ul,     LED_Fuel_Judgement                       , LED_Fuel_Execution                         },
};

/*must put into 10ms task*/

void Telltales_Left_Right_KL30_Init(void);

void Telltales_Left_Right_KL30_Init(void)
{
    TelltaleLRCtrl.LastRight = 0u;
    TelltaleLRCtrl.LastLeft = 0u;
    TelltaleLRCtrl.Delay = 0u;

    L12_Air_Sta = 0u;
}

/*************************************

测试用

**************************************/
void Test_LED_AllLight(void)
{
    COMMON_PowerStatus_t u8IG_st;

    u8IG_st = Common_Get_IG_Sts();

    if (u8IG_st == COMMON_POWER_ON)
    {
        LED_Left_Right_Execution(LED_ON_State);
        LED_INTER_DIFF_LOCK_T_Execution(LED_ON_State);
        LED_FOUR_MUL_FOUR_T_Execution(LED_ON_State);
        LED_EXH_BRAKE_T_Execution(LED_ON_State);
        LED_QOS_GLOW_T_Execution(LED_ON_State);
        LED_HI_BEAM_T_Execution(LED_ON_State);
        LED_Rr_FOG_LAMP_T_Execution(LED_ON_State);
        LED_MIL_T_Execution(LED_ON_State);
        LED_SVS_T_Execution(LED_ON_State);
        LED_H_S_A_T_Execution(LED_ON_State);
        LED_RETARDER_T_Execution(LED_ON_State);
        LED_AUTO_LEVELING_T_Execution(LED_ON_State);
        LED_ROWS_L_Execution(LED_ON_State);
        LED_BSM_OFF_L_Execution(LED_ON_State);
        LED_AEBS_OFF_L_Execution(LED_ON_State);
        LED_LDWS_L_Execution(LED_ON_State);
        LED_SRS_L_Execution(LED_ON_State);
        LED_ENG_OIL_L_Execution(LED_ON_State);
        LED_CHARG_L_Execution(LED_ON_State);
        LED_SEAT_BELT_L_Execution(LED_ON_State);
        LED_RR_DIFF_LOCK_L_Execution(LED_ON_State);
        LED_TPMS_L_Execution(LED_ON_State);
        LED_ASR_or_EVSC_OFF_L_Execution(LED_ON_State);
        LED_EVSC_L_Execution(LED_ON_State);
        LED_eco_stop_OFF_L_Execution(LED_ON_State);
        LED_AMT_L_Execution(LED_ON_State);
        LED_WEAR_IND_L_Execution(LED_ON_State);
        LED_TRAILER_BRAKE_R_Execution(LED_ON_State);
        LED_BRAKE_AIR_or_EBS_YELLOW_R_Execution(LED_ON_State);
        LED_ACC_AIR_R_Execution(LED_ON_State);
        LED_ABS_R_Execution(LED_ON_State);
        LED_PARK_BRAKE_R_Execution(LED_ON_State);
        LED_BRAKE_AIR_or_EBS_RED_R_Execution(LED_ON_State);
        LED_BRAKE_LOCK_R_Execution(LED_ON_State);
        LED_AIR_SUS_R_Execution(LED_ON_State);
        LED_TRAILER_ABS_U_Execution(LED_ON_State);
        LED_WORKING_LAMP_U_Execution(LED_ON_State);
        LED_TRAILER_ABS_INFO_U_Execution(LED_ON_State);
        LED_Temp_Execution(LED_ON_State);
        LED_Fuel_Execution(LED_ON_State);
    }
    else
    {
        LED_Left_Right_Execution(LED_OFF_State);
        LED_INTER_DIFF_LOCK_T_Execution(LED_OFF_State);
        LED_FOUR_MUL_FOUR_T_Execution(LED_OFF_State);
        LED_EXH_BRAKE_T_Execution(LED_OFF_State);
        LED_QOS_GLOW_T_Execution(LED_OFF_State);
        LED_HI_BEAM_T_Execution(LED_OFF_State);
        LED_Rr_FOG_LAMP_T_Execution(LED_OFF_State);
        LED_MIL_T_Execution(LED_OFF_State);
        LED_SVS_T_Execution(LED_OFF_State);
        LED_H_S_A_T_Execution(LED_OFF_State);
        LED_RETARDER_T_Execution(LED_OFF_State);
        LED_AUTO_LEVELING_T_Execution(LED_OFF_State);
        LED_ROWS_L_Execution(LED_OFF_State);
        LED_BSM_OFF_L_Execution(LED_OFF_State);
        LED_AEBS_OFF_L_Execution(LED_OFF_State);
        LED_LDWS_L_Execution(LED_OFF_State);
        LED_SRS_L_Execution(LED_OFF_State);
        LED_ENG_OIL_L_Execution(LED_OFF_State);
        LED_CHARG_L_Execution(LED_OFF_State);
        LED_SEAT_BELT_L_Execution(LED_OFF_State);
        LED_RR_DIFF_LOCK_L_Execution(LED_OFF_State);
        LED_TPMS_L_Execution(LED_OFF_State);
        LED_ASR_or_EVSC_OFF_L_Execution(LED_OFF_State);
        LED_EVSC_L_Execution(LED_OFF_State);
        LED_eco_stop_OFF_L_Execution(LED_OFF_State);
        LED_AMT_L_Execution(LED_OFF_State);
        LED_WEAR_IND_L_Execution(LED_OFF_State);
        LED_TRAILER_BRAKE_R_Execution(LED_OFF_State);
        LED_BRAKE_AIR_or_EBS_YELLOW_R_Execution(LED_OFF_State);
        LED_ACC_AIR_R_Execution(LED_OFF_State);
        LED_ABS_R_Execution(LED_OFF_State);
        LED_PARK_BRAKE_R_Execution(LED_OFF_State);
        LED_BRAKE_AIR_or_EBS_RED_R_Execution(LED_OFF_State);
        LED_BRAKE_LOCK_R_Execution(LED_OFF_State);
        LED_AIR_SUS_R_Execution(LED_OFF_State);
        LED_TRAILER_ABS_U_Execution(LED_OFF_State);
        LED_WORKING_LAMP_U_Execution(LED_OFF_State);
        LED_TRAILER_ABS_INFO_U_Execution(LED_OFF_State);
        LED_Temp_Execution(LED_OFF_State);
        LED_Fuel_Execution(LED_OFF_State);
    }
}

/*---------------------------------------------------------------------------*/
#define XXXX  0u
#define LED_BRIGHTNESSR 0x3Fu
#define LED_BRIGHTNESSG 0x3Fu
#define LED_BRIGHTNESSY 0x3Fu
#define LED_BRIGHTNESSB 0x3Fu

#define LED_BRIGHTNESSGBL 0x08u
#define LED_BRIGHTNESSBBL 0x08u
/******************************************************************************
  T3 L16 U1 U4 U5无灯   左右转向单独 气压1 气压2 指示灯是背光
  R L5 L6 L7 L8 R1 R3 R4 (R2  水温)
  G T0 T2 T4 T10 T11 T13 L13  (T11例外)
  B T7
  Y (T1 T7 R2 R8 U2 燃油)
 ******************************************************************************/


/******************************************************************************
  T0 左转向   T13 右转向
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
void Telltales_Left_Right_Management_Service(void) /*10ms*/
{
    uint8_t Edge;
    uint8_t RIGHT_ST = 0x00u;
    uint8_t LEFT_ST = 0x00u;

    RIGHT_ST = Line_In_Get_Status(LINE_IN_TURN_R);
    LEFT_ST = Line_In_Get_Status(LINE_IN_TURN_L);

    Edge = 0xffu ;

    if (LEFT_ST == 1u)//左转向
    {
        SEG_LED_TURN_LEFT(7);//左转向断码屏开
        IS31_CHIP0_CHANNEL36 = LED_BRIGHTNESSG;
    }
    else
    {
        SEG_LED_TURN_LEFT(0);
        IS31_CHIP0_CHANNEL36 = 0x00u;
    }
    if (TelltaleLRCtrl.LastLeft != LEFT_ST)
    {
        TelltaleLRCtrl.LastLeft = LEFT_ST;
        Edge = LEFT_ST;
    }

    if (RIGHT_ST == 1u)//右转向
    {
        SEG_LED_TURN_RIGHT(7);//右转向断码屏开
        IS31_CHIP0_CHANNEL24 = LED_BRIGHTNESSG;
    }
    else
    {
        SEG_LED_TURN_RIGHT(0);
        IS31_CHIP0_CHANNEL24 = 0x00u;
    }

    if (TelltaleLRCtrl.LastRight != RIGHT_ST)
    {
        TelltaleLRCtrl.LastRight = RIGHT_ST;
        Edge = RIGHT_ST;
    }

//    if (TelltaleLRCtrl.Delay > 0u)
//    {
//        TelltaleLRCtrl.Delay--;
//    }
//    else
//    {
//        if (Edge != 0xFFu)
//        {
//            if (Edge)
//            {
//                Sound_Request(SND_TICK, 1u);
//            }
//            else
//            {
//                Sound_Request(SND_TOCK, 1u);
//            }
//
//            TelltaleLRCtrl.Delay = 10u; /*200ms内不允许重复播放声音*/
//        }
//        else
//        {
//            Sound_Delete(SND_TICK);
//            Sound_Delete(SND_TOCK);
//        }
//    }
}

void LED_Left_Right_Execution(uint8_t led_status)
{
    if (led_status == 1u)
    {
        SEG_LED_TURN_LEFT(7);/*左转向断码屏开*/
        IS31_CHIP0_CHANNEL36 = LED_BRIGHTNESSG;

        SEG_LED_TURN_RIGHT(7);/*右转向断码屏开*/
        IS31_CHIP0_CHANNEL24 = LED_BRIGHTNESSG;
    }
    else
    {
        SEG_LED_TURN_LEFT(0);/*左转向断码屏开*/
        IS31_CHIP0_CHANNEL36 = 0u;

        SEG_LED_TURN_RIGHT(0);/*右转向断码屏开*/
        IS31_CHIP0_CHANNEL24 = 0u;
    }
}

/******************************************************************************
  T1  INTER DIFF LOCK
  信号接口：  B36 HIGH
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_INTER_DIFF_LOCK_T_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_RR_DIFF_LOCK);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_INTER_DIFF_LOCK_T_Execution(uint8_t led_status)
{
    RR_DIFF_LOCK_MCU = led_status;

    if (led_status == 1)
    {
        SEG_LED_INTER_DIFF_LOCK_T(7);
    }
    else
    {
        SEG_LED_INTER_DIFF_LOCK_T(0);
    }
}

/******************************************************************************
  T2
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_FOUR_MUL_FOUR_T_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)XXXX;

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_FOUR_MUL_FOUR_T_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        if (Line_In_Get_Status(LINE_IN_ILLUMINATION))
        {
            IS31_CHIP0_CHANNEL35 = LED_BRIGHTNESSGBL;
        }
        else
        {
            IS31_CHIP0_CHANNEL35 = LED_BRIGHTNESSG;
        }
        SEG_LED_FOUR_MUL_FOUR_T(7);
    }
    else
    {
        IS31_CHIP0_CHANNEL35 = 0x00;
        SEG_LED_FOUR_MUL_FOUR_T(0);
    }
}

/******************************************************************************
  T4 EXH BRAKE
  信号接口： 0x18FF2300 Byte:2,bit:2-1==01(B)  功能调整----2022.05.10----
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_EXH_BRAKE_T_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)Get_ID_18FF2300_Sig_Exh_Lamp();


    if (m_Condition1 == 0x01u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_EXH_BRAKE_T_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        if (Line_In_Get_Status(LINE_IN_ILLUMINATION))
        {
            IS31_CHIP0_CHANNEL34 = LED_BRIGHTNESSGBL;
        }
        else
        {
            IS31_CHIP0_CHANNEL34 = LED_BRIGHTNESSG;
        }
        SEG_LED_EXH_BRAKE_T(7);
    }
    else
    {
        IS31_CHIP0_CHANNEL34 = 0x00;
        SEG_LED_EXH_BRAKE_T(0);
    }
}

/******************************************************************************
  T5 QOS(GLOW)
  信号接口： 0x18FF2300 Byte:2,bit:6-5==01(B)
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_QOS_GLOW_T_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)Get_ID_18FF2300_Sig_Glow_Lamp();

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_QOS_GLOW_T_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL33 = LED_BRIGHTNESSY;
        SEG_LED_QOS_GLOW_T(7);
    }
    else
    {
        IS31_CHIP0_CHANNEL33 = 0x00;
        SEG_LED_QOS_GLOW_T(0);
    }
}
/******************************************************************************
  T6 HI BEAM
  信号接口： A25  HIGH
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_HI_BEAM_T_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_HI_BEAM);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_HI_BEAM_T_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        if (Line_In_Get_Status(LINE_IN_ILLUMINATION))
        {
            IS31_CHIP0_CHANNEL32 = LED_BRIGHTNESSBBL;
        }
        else
        {
            IS31_CHIP0_CHANNEL32 = LED_BRIGHTNESSB;
        }
        SEG_LED_HI_BEAM_T(7);
    }
    else
    {
        IS31_CHIP0_CHANNEL32 = 0x00;
        SEG_LED_HI_BEAM_T(0);
    }
}

/******************************************************************************
  T7 Rr FOG LAMP
  信号接口： B14 HIGH
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_Rr_FOG_LAMP_T_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_Rr_FOG_LAMP);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_Rr_FOG_LAMP_T_Execution(uint8_t led_status)
{
    T7_LED_OUT = led_status;

    if (led_status == 1)
    {
        SEG_LED_Rr_FOG_LAMP_T(7);
    }
    else
    {
        SEG_LED_Rr_FOG_LAMP_T(0);
    }
}

/******************************************************************************
  T8 MIL
  信号接口： A31  GND   2022-05-10
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_MIL_T_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_MIL);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_MIL_T_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL31 = LED_BRIGHTNESSY;
        SEG_LED_MIL_T(7);
    }
    else
    {
        IS31_CHIP0_CHANNEL31 = 0x00;
        SEG_LED_MIL_T(0);
    }
}

/******************************************************************************
  T9 SVS
  信号接口： 0x18FED900 Byte:5,bit:8-7==01(B)
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_SVS_T_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)Get_ID_18FED900_Sig_SVS_Lamp_Status();

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_SVS_T_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL30 = LED_BRIGHTNESSY;
        SEG_LED_SVS_T(7);
    }
    else
    {
        IS31_CHIP0_CHANNEL30 = 0x00;
        SEG_LED_SVS_T(0);
    }
}

/******************************************************************************
  T10 H.S.A
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_H_S_A_T_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)XXXX;

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else if (m_Condition1 == 2u)
    {
        u8Result = 2u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_H_S_A_T_Execution(uint8_t led_status)
{
    if (led_status == 1u)
    {
        IS31_CHIP0_CHANNEL28 = 0x00;  /*绿灯 灭*/
        IS31_CHIP0_CHANNEL29 = LED_BRIGHTNESSY;    /*黄灯 亮*/
    }
    else if (led_status == 2u)
    {
        if (Line_In_Get_Status(LINE_IN_ILLUMINATION))
        {
            IS31_CHIP0_CHANNEL28 = LED_BRIGHTNESSGBL;    /*绿灯 亮*/
        }
        else
        {
            IS31_CHIP0_CHANNEL28 = LED_BRIGHTNESSG;    /*绿灯 亮*/
        }
        IS31_CHIP0_CHANNEL29 = 0x00;  /*黄灯 灭*/
    }
    else
    {
        IS31_CHIP0_CHANNEL28 = 0x00;  /*绿灯 灭*/
        IS31_CHIP0_CHANNEL29 = 0x00;  /*黄灯 灭*/
    }

    if (led_status != 0x00u)
    {
        SEG_LED_H_S_A_T(7);
    }
    else
    {
        SEG_LED_H_S_A_T(0);
    }
}

/******************************************************************************
  T11 RETARDER
  信号接口： 0x18FF5510 Byte:1,bit:1==01(B) 绿    ----  0x18FF5510  Byte1,Bit1 Byte:1,bit:1==10(B)  黄闪
  信号定义： 2022-02-09 取消EOL配置条件
  输出信号：
 ******************************************************************************/
uint8_t LED_RETARDER_T_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)Get_ID_18FF5510_Sig_Intarder_Pilot_Lamp_State();

    if (m_Condition1 == 2u)
    {
        u8Result = FLASH_SYNC_1Hz;
    }
    else if (m_Condition1 == 1u)
    {
        u8Result = 2u;
    }

    return u8Result;
}

void LED_RETARDER_T_Execution(uint8_t led_status)
{
    if (led_status == 1u)
    {
        IS31_CHIP0_CHANNEL27 = 0x00u; /* 绿灯 灭 */
        IS31_CHIP0_CHANNEL26 = 0xFFu;//LED_BRIGHTNESSY; /* 黄灯 亮 闪 */
    }
    else if (led_status == 2u)
    {
        if (Line_In_Get_Status(LINE_IN_ILLUMINATION))
        {
            IS31_CHIP0_CHANNEL27 = LED_BRIGHTNESSGBL; /* 绿灯 亮 */
        }
        else
        {
            IS31_CHIP0_CHANNEL27 = LED_BRIGHTNESSG; /* 绿灯 亮 */
        }
        IS31_CHIP0_CHANNEL26 = 0x00u; /* 黄灯 灭 */
    }
    else
    {
        IS31_CHIP0_CHANNEL27 = 0x00u; /* 绿灯 灭 */
        IS31_CHIP0_CHANNEL26 = 0x00u; /* 黄灯 灭 */
    }

    if (led_status != 0x00u)
    {
        SEG_LED_RETARDER_T(7);
    }
    else
    {
        SEG_LED_RETARDER_T(0);
    }
}

/******************************************************************************
  T12 AUTO LEVELING
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_AUTO_LEVELING_T_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)XXXX;

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}

void LED_AUTO_LEVELING_T_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL25 = LED_BRIGHTNESSY;
        SEG_LED_AUTO_LEVELING_T(7);
    }
    else
    {
        IS31_CHIP0_CHANNEL25 = 0x00;
        SEG_LED_AUTO_LEVELING_T(0);
    }
}

/******************************************************************************
  L1 ROWS
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_ROWS_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)XXXX;

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_ROWS_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL01 = LED_BRIGHTNESSY;
        SEG_LED_ROWS_L(7);
    }
    else
    {
        IS31_CHIP0_CHANNEL01 = 0x00;
        SEG_LED_ROWS_L(0);
    }
}

/******************************************************************************
  L2 BSM OFF
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_BSM_OFF_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)XXXX;

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_BSM_OFF_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL02 = LED_BRIGHTNESSY;
        SEG_LED_BSM_OFF_L(7);
    }
    else
    {
        IS31_CHIP0_CHANNEL02 = 0x00;
        SEG_LED_BSM_OFF_L(0);
    }
}

/******************************************************************************
  L3 AEBS OFF
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_AEBS_OFF_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    uint8_t m_Condition2 = 0u;
    uint8_t m_Condition3 = 0u;
    uint8_t m_Condition4 = 0u;
    uint8_t m_Condition5 = 0u;
    uint8_t m_Condition6 = 0u;
    uint8_t CanStatus1 = 0u;
    uint8_t CanStatus2 = 0u;
    uint8_t CanStatus3 = 0u;

    m_Condition1 = (uint8_t)Get_ID_CF02F2A_Sig_Advanced_Emerg_Braking_Sys_Sta();
    m_Condition2 = (uint8_t)Get_ID_CF02FA1_Sig_Advanced_Emerg_Braking_Sys_Sta();
    m_Condition3 = (uint8_t)Get_ID_CF02FA0_Sig_Advanced_Emerg_Braking_Sys_Sta();

    CanStatus1 = CAN_MSG_Status(ID_CanMsg0CF02F2A_Msg_Count);
    CanStatus2 = CAN_MSG_Status(ID_CanMsg0CF02FA1_Msg_Count);
    CanStatus3 = CAN_MSG_Status(ID_CanMsg0CF02FA0_Msg_Count);

    m_Condition4 = (uint8_t)Get_ID_18FECA2A_Sig_AebsOff();
    m_Condition5 = (uint8_t)Get_ID_18FECAA1_Sig_AebsOff();
    m_Condition6 = (uint8_t)Get_ID_18FECAA0_Sig_AebsOff();

    if (K_Line_Set.K_Line_LID28 == 0x01u)
    {
        if (
            (m_Condition1 == 0x02u) || (m_Condition2 == 0x02u) || (m_Condition3 == 0x02u) ||
            ((CanStatus1 == CAN_SIG_LOST) && (CanStatus2 == CAN_SIG_LOST) && (CanStatus3 == CAN_SIG_LOST)) ||
            (m_Condition4 == 0x01u) || (m_Condition5 == 0x01u) || (m_Condition6 == 0x01u)
        )
        {
            u8Result = 1u;
        }
        else if ((m_Condition1 == 0x0Eu) || (m_Condition2 == 0x0Eu) || (m_Condition3 == 0x0Eu))
        {
            u8Result = FLASH_SYNC_1Hz;
        }
        else
        {
            u8Result = 0u;
        }
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_AEBS_OFF_L_Execution(uint8_t led_status)
{
    if (K_Line_Set.K_Line_LID28 == 0x01u)
    {
        if (led_status == 1)
        {
            IS31_CHIP0_CHANNEL03 = LED_BRIGHTNESSY;
            SEG_LED_AEBS_OFF_L(7);
        }
        else
        {
            IS31_CHIP0_CHANNEL03 = 0x00;
            SEG_LED_AEBS_OFF_L(0);
        }
    }
    else
    {
        IS31_CHIP0_CHANNEL03 = 0x00;
        SEG_LED_AEBS_OFF_L(0);
    }
}

/******************************************************************************
  L4 LDWS
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_LDWS_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    uint8_t m_Condition2 = 0u;
    uint8_t CanStatus1 = 0u;
    uint8_t CanStatus2 = 0u;

    m_Condition1 = (uint8_t)Get_ID_18FE5BE8_Sig_Lane_Departure_Warning_Sys_Sta();
    m_Condition2 = (uint8_t)Get_ID_18FECAE8_Sig_Amber_Warning_Lamp_Status();

    CanStatus1 = CAN_MSG_Status(ID_CanMsg18FE5BE8_Msg_Count);
    CanStatus2 = CAN_MSG_Status(ID_CanMsg18FECAE8_Msg_Count);

    if (K_Line_Set.K_Line_LID27 == 0x01u)
    {
        if ((CanStatus1 == CAN_SIG_LOST) || (m_Condition1 == 0x02u) || (m_Condition2 == 0x01u))
        {
            u8Result = 1u;
        }
        else if ((m_Condition1 == 0x00u) || (m_Condition1 == 0x05u) || (m_Condition1 == 0x0Eu))
        {
            u8Result = FLASH_SYNC_1Hz;
        }
        else
        {
            u8Result = 0u;
        }
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_LDWS_L_Execution(uint8_t led_status)
{
    if (K_Line_Set.K_Line_LID27 == 0x01u)
    {
        if (led_status == 1)
        {
            IS31_CHIP0_CHANNEL04 = LED_BRIGHTNESSY;
            SEG_LED_LDWS_L(7);
        }
        else
        {
            IS31_CHIP0_CHANNEL04 = 0x00;
            SEG_LED_LDWS_L(0);
        }
    }
    else
    {
        IS31_CHIP0_CHANNEL04 = 0x00;
        SEG_LED_LDWS_L(0);
    }
}

/******************************************************************************
  L5 SRS
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_SRS_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)XXXX;

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_SRS_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL20 = LED_BRIGHTNESSR;
        SEG_LED_SRS_L(7);
    }
    else
    {
        IS31_CHIP0_CHANNEL20 = 0x00;
        SEG_LED_SRS_L(0);
    }
}

/******************************************************************************
  L6 ENG OIL
  信号接口： A32 LOW
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_ENG_OIL_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_ENG_OIL);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_ENG_OIL_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL21 = LED_BRIGHTNESSR;
        SEG_LED_ENG_OIL_L(7);
    }
    else
    {
        IS31_CHIP0_CHANNEL21 = 0x00;
        SEG_LED_ENG_OIL_L(0);
    }
}

/******************************************************************************
  L7 CHARG
  信号接口： A34 LOW
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_CHARG_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_CHARGE);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_CHARG_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL22 = LED_BRIGHTNESSB;
        SEG_LED_CHARG_L(7);
    }
    else
    {
        IS31_CHIP0_CHANNEL22 = 0x00;
        SEG_LED_CHARG_L(0);
    }
}

/******************************************************************************
  L8 SEAT BELT
  信号接口： A30 LOW
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_SEAT_BELT_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_SEAT_BELT);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_SEAT_BELT_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL23 = LED_BRIGHTNESSR;
        SEG_LED_SEAT_BELT_L(7);
    }
    else
    {
        IS31_CHIP0_CHANNEL23 = 0x00;
        SEG_LED_SEAT_BELT_L(0);
    }
}
/******************************************************************************
  L9 RR DIFF LOCK
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_RR_DIFF_LOCK_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = XXXX;

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_RR_DIFF_LOCK_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL16 = LED_BRIGHTNESSY;
        SEG_LED_RR_DIFF_LOCK_L(7);
    }
    else
    {
        IS31_CHIP0_CHANNEL16 = 0x00;
        SEG_LED_RR_DIFF_LOCK_L(0);
    }
}

/******************************************************************************
  L10 TPMS
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_TPMS_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t CanStatus1 = 0x00u;
    uint8_t Low_Presure = 0u;
    uint8_t High_Presure = 0u;
    uint8_t High_Temperature = 0u;
    uint8_t No_signal = 0u;
    uint8_t Sensor_fault = 0u;

    Low_Presure = (uint8_t)Get_TPMSLow_Presure_Sta();
    High_Presure = (uint8_t)Get_TPMSHigh_Presure_Sta();
    High_Temperature = (uint8_t)Get_TPMSHigh_Temperature_Sta();
    No_signal = (uint8_t)Get_TPMSNo_signal_Sta();
    Sensor_fault = (uint8_t)Get_TPMSSensor_fault_Sta();
    CanStatus1 = CAN_MSG_Status(ID_CanMsg18011733_Msg_Count);

    if (K_Line_Set.K_Line_LID3E == 0x01u)
    {
        if ((Low_Presure == 1u) || (High_Presure == 1u) || (High_Temperature == 1u))
        {
            u8Result = 1u;
        }
        else if ((No_signal == 1u) || (Sensor_fault == 1u) || (CanStatus1 == CAN_SIG_LOST))
        {
            u8Result = FLASH_SYNC_1Hz;
        }
        else
        {
            u8Result = 0u;
        }
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_TPMS_L_Execution(uint8_t led_status)
{
    if (K_Line_Set.K_Line_LID3E == 0x01u)
    {
        if (led_status == 1)
        {
            IS31_CHIP0_CHANNEL17 = LED_BRIGHTNESSY;
            SEG_LED_TPMS_L(7);
        }
        else
        {
            IS31_CHIP0_CHANNEL17 = 0x00;
            SEG_LED_TPMS_L(0);
        }
    }
    else
    {
        IS31_CHIP0_CHANNEL17 = 0x00u;
        SEG_LED_TPMS_L(0);
    }
}
/******************************************************************************
  L11 ASR/EVSC OFF
  信号接口： 18F0010B Byte:3 Bit:3-4==01(B)
  信号定义：
  输出信号：
  说明：调整依据 SXS-VC66-22_EBS WARNING & INDICATOR (7“LCD)改訂1-1_20211116
 ******************************************************************************/
uint8_t LED_ASR_or_EVSC_OFF_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)Get_ID_18F0010B_Sig_ASR_Offroad_Switch();

    if (K_Line_Set.K_Line_LID22 == 0x01u)
    {
        if (m_Condition1 == 1u)
        {
            u8Result = 1u;
        }
        else
        {
            u8Result = 0u;
        }
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_ASR_or_EVSC_OFF_L_Execution(uint8_t led_status)
{
    if (K_Line_Set.K_Line_LID22 == 0x01u)
    {
        if (led_status == 1)
        {
            IS31_CHIP0_CHANNEL18 = LED_BRIGHTNESSY;
            SEG_LED_ASR_or_EVSC_OFF_L(7);
        }
        else
        {
            IS31_CHIP0_CHANNEL18 = 0x00;
            SEG_LED_ASR_or_EVSC_OFF_L(0);
        }
    }
    else
    {
        IS31_CHIP0_CHANNEL18 = 0x0u;
        SEG_LED_ASR_or_EVSC_OFF_L(0);
    }
}

/******************************************************************************
  L12 EVSC
  信号接口：
  信号定义：
  输出信号：
  调整依据：SXS-VC66-22_EBS WARNING & INDICATOR (7“LCD)改訂1-1_20211116
 ******************************************************************************/
uint8_t LED_EVSC_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t CanStatus1 = 0u;
    uint8_t CanStatus2 = 0u;
    uint8_t LineStatus1 = 0u;
    uint8_t CanDataSta1 = 0u;
    uint8_t CanDataSta2 = 0u;
    uint8_t CanDataSta3 = 0u;
    uint8_t CanDataSta4 = 0u;
    uint8_t CanDataSta5 = 0u;
    uint16_t m_Condition6 = 0u;
    uint16_t m_Condition7 = 0u;
    uint8_t m_AirSta1 = 0u;
    uint8_t m_AirSta2 = 0u;

    LineStatus1 = (uint8_t)Line_In_Get_Status(LINE_IN_BRAKE_AIR_EBS); /*A28*/

    CanStatus2 = CAN_MSG_Status(ID_CanMsg18F0010B_Msg_Count);
    CanDataSta2 = (uint8_t)Get_ID_18F0010B_Sig_ASR_Lamp_State(); /*byte1 12*/
    CanDataSta3 = (uint8_t)Get_ID_18F0010B_Sig_ASR_Brake_Control_Active(); /*byte1 34*/
    CanDataSta1 = (uint8_t)Get_ID_18F0010B_Sig_EBS_Red_Warning_Lamp_State(); /*byte6 34*/
    (uint8_t)Get_ID_18F0010B_Sig_EBS_Amber_Warning_State();/*byte6 56*/
    (uint8_t)Get_ID_18F0010B_Sig_ATC_or_ASR_Lamp_State();/*byte6 78*/

    CanStatus1 = CAN_MSG_Status(ID_CanMsg18FE4F0B_Msg_Count);
    CanDataSta5 = (uint8_t)Get_ID_18FE4F0B_Sig_VDC_Lamp_State(); /*byte1 12*/
    CanDataSta4 = (uint8_t)Get_ID_18FE4F0B_Sig_VDC_Fully_operational(); /*byte1 34*/
    m_Condition6 = Common_Get_Air1_Data();  /*气压1 1.89以下*/
    m_Condition7 = Common_Get_Air2_Data();  /*气压1 1.89以下*/
    m_AirSta1 = Common_Get_Air1_Valid();
    m_AirSta2 = Common_Get_Air2_Valid();

    if (((m_Condition6 < 1890u) && (m_AirSta1 == 1u)) || ((m_Condition7 < 1890u) && (m_AirSta2 == 1u)))
    {
        L12_Air_Sta  = 1u;
    }
    else if (((m_Condition6 >= 1990u) && (m_Condition7 >= 1990u)) ||
             ((m_Condition6 >= 1990u) && (m_AirSta2 == 0u)) ||
             ((m_Condition7 >= 1990u) && (m_AirSta1 == 0u)) ||
             ((m_AirSta1 == 0u) && (m_AirSta2 == 0u)))
    {
        L12_Air_Sta = 0u;
    }

    if (
        (LineStatus1 == 1u) || (Common_Get_L12_Air_Sta() == 1u) ||
        (((CanDataSta1 == 1u) || (CanStatus2 == CAN_SIG_LOST)) && (K_Line_Set.K_Line_LID21 == 0x01u)) ||
        (((CanDataSta4 == 0u) || (CanStatus1 == CAN_SIG_LOST)) && (K_Line_Set.K_Line_LID22 == 0x01u))
    )
    {
        u8Result = 1u;
    }
    else if ((((CanDataSta2 == 1u) || (CanDataSta3 == 1u)) && (K_Line_Set.K_Line_LID21 == 0x01u)) ||
             ((CanDataSta5 == 1u) && (K_Line_Set.K_Line_LID22 == 0x01u)))
    {
        u8Result = FLASH_SYNC_2Hz;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_EVSC_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL19 = LED_BRIGHTNESSY;
        SEG_LED_EVSC_L(7);
    }
    else
    {
        IS31_CHIP0_CHANNEL19 = 0x00;
        SEG_LED_EVSC_L(0);
    }
}

/******************************************************************************
  L13 ECO STOP OFF
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_eco_stop_OFF_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)XXXX;

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_eco_stop_OFF_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        if (Line_In_Get_Status(LINE_IN_ILLUMINATION))
        {
            IS31_CHIP0_CHANNEL12 = LED_BRIGHTNESSGBL;  /* 绿灯 亮 */
        }
        else
        {
            IS31_CHIP0_CHANNEL12 = LED_BRIGHTNESSG;  /* 绿灯 亮 */
        }
        IS31_CHIP0_CHANNEL13 = 0x00u;  /* 黄灯 灭 */
    }
    else if (led_status == 2)
    {
        IS31_CHIP0_CHANNEL12 = 0x00u;  /* 绿灯 灭 */
        IS31_CHIP0_CHANNEL13 = LED_BRIGHTNESSY;  /* 黄灯 亮 */
    }
    else
    {
        IS31_CHIP0_CHANNEL12 = 0x00u;  /* 绿灯 灭 */
        IS31_CHIP0_CHANNEL13 = 0x00u;  /* 黄灯 灭 */
    }

    if ((led_status == 1) || (led_status == 2))
    {
        SEG_LED_eco_stop_OFF_L(7);
    }
    else
    {
        SEG_LED_eco_stop_OFF_L(0);
    }
}

/******************************************************************************
  L14 AMT
  信号接口：  无多包处理 /18EBFF03/18ECFF03  PGN:65226 DM1
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_AMT_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    uint8_t m_Condition2 = 0u;
    uint8_t m_Condition3 = 0u;
    uint8_t m_Condition4 = 0u;
    uint8_t m_Condition5 = 0u;
    uint8_t m_Condition6 = 0u;

    m_Condition1 = (uint8_t)Get_ID_18FECA03_Sig_Amber_Warning_Lamp_Status();
    m_Condition2 = (uint8_t)Get_ID_18FECA03_Sig_Malfunction_indicator_Lamp();

    if (K_Line_Set.K_Line_LID41 == 0x13u)
    {
        if ((m_Condition1 == 1u) || (m_Condition2 == 1u))
        {
            u8Result = 1u;
        }
        else
        {
            u8Result = 0u;
        }
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_AMT_L_Execution(uint8_t led_status)
{
    if (K_Line_Set.K_Line_LID41 == 0x13u)
    {
        if (led_status == 1)
        {
            IS31_CHIP0_CHANNEL14 = LED_BRIGHTNESSY;
            SEG_LED_AMT_L(7);
        }
        else
        {
            IS31_CHIP0_CHANNEL14 = 0x00;
            SEG_LED_AMT_L(0);
        }
    }
    else
    {
        IS31_CHIP0_CHANNEL14 = 0x00u;
        SEG_LED_AMT_L(0);
    }
}

/******************************************************************************
  L15 WEAR IND
  信号接口： B38 0V B40 0V
  信号定义：
  输出信号： 接地熄灭20220524
 ******************************************************************************/
uint8_t LED_WEAR_IND_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    uint8_t m_Condition2 = 0u;

    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_WEAR_IND);
    m_Condition2 = (uint8_t)Line_In_Get_Status(LINE_IN_WEAR2);

    if ((m_Condition1 == 0x01u) && (m_Condition2 == 0x01u))
    {
        u8Result = 0u;
    }
    else
    {
        u8Result = 1u;
    }

    return u8Result;
}
void LED_WEAR_IND_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL15 = LED_BRIGHTNESSY;
        SEG_LED_WEAR_IND_L(7);
    }
    else
    {
        IS31_CHIP0_CHANNEL15 = 0x00;
        SEG_LED_WEAR_IND_L(0);
    }
}

/******************************************************************************
 R1 PARK BRAKE
 信号接口： A23 GND
 信号定义：
 输出信号：
******************************************************************************/
uint8_t LED_PARK_BRAKE_R_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_PARK_BRAKE);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_PARK_BRAKE_R_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL08 = LED_BRIGHTNESSR;
        SEG_LED_PARK_BRAKE_R(7);
    }
    else
    {
        IS31_CHIP0_CHANNEL08 = 0x00;
        SEG_LED_PARK_BRAKE_R(0);
    }
}

/******************************************************************************
  R2 BRAKE AIR/EBS
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_BRAKE_AIR_or_EBS_RED_R_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t CanStatus = 0u;
    uint8_t m_Condition1 = 0u;
    uint8_t m_Condition3 = 0u;

    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_BRAKE_AIR_EBS);
    m_Condition3 = (uint8_t)Get_ID_18F0010B_Sig_EBS_Red_Warning_Lamp_State();

    CanStatus = CAN_MSG_Status(ID_CanMsg18F0010B_Msg_Count);

    if ((m_Condition1 == 0x01u) || (Common_Get_L12_Air_Sta() == 0x01u) ||
            ((K_Line_Set.K_Line_LID21 == 0x01u) && ((m_Condition3 == 1u) || (CanStatus == CAN_SIG_LOST))))
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_BRAKE_AIR_or_EBS_RED_R_Execution(uint8_t led_status)
{
    BRAKE_AIR_EBS_LED_MCU = led_status;

    if (led_status == 1)
    {
        SEG_LED_BRAKE_AIR_or_EBS_RED_R(7);
    }
    else
    {
        SEG_LED_BRAKE_AIR_or_EBS_RED_R(0);
    }
}

/******************************************************************************
  R3 BRAKE LOCK
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_BRAKE_LOCK_R_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)XXXX;

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_BRAKE_LOCK_R_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL07 = LED_BRIGHTNESSR;
        SEG_LED_BRAKE_LOCK_R(7);
    }
    else
    {
        IS31_CHIP0_CHANNEL07 = 0x00;
        SEG_LED_BRAKE_LOCK_R(0);
    }
}

/******************************************************************************
  R4 AIR SUS
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_AIR_SUS_R_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_AIR_SUS);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_AIR_SUS_R_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL06 = LED_BRIGHTNESSR;
        SEG_LED_AIR_SUS_R(7);
    }
    else
    {
        IS31_CHIP0_CHANNEL06 = 0x00;
        SEG_LED_AIR_SUS_R(0);
    }
}

/******************************************************************************
  R5 TRAILER BRAKE
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_TRAILER_BRAKE_R_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_TRAILER_BRAKE);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_TRAILER_BRAKE_R_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL10 = LED_BRIGHTNESSY;
        SEG_LED_TRAILER_BRAKE_R(7);
    }
    else
    {
        IS31_CHIP0_CHANNEL10 = 0x00;
        SEG_LED_TRAILER_BRAKE_R(0);
    }
}

/******************************************************************************
  R6 BRAKE AIR/EBS
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_BRAKE_AIR_or_EBS_YELLOW_R_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    //m_Condition1 = (uint8_t)Get_ID_18F0010B_Sig_EBS_Amber_Warning_State();

    if (m_Condition1 == 1u)
    {
        u8Result = 0u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_BRAKE_AIR_or_EBS_YELLOW_R_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL09 = LED_BRIGHTNESSY;
        SEG_LED_BRAKE_AIR_or_EBS_YELLOW_R(7);
    }
    else
    {
        IS31_CHIP0_CHANNEL09 = 0x00;
        SEG_LED_BRAKE_AIR_or_EBS_YELLOW_R(0);
    }
}

/******************************************************************************
  R7  ACC AIR
  信号接口：
  信号定义：
  输出信号： R6_LED_OUT
 ******************************************************************************/
uint8_t LED_ACC_AIR_R_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_ACC_AIR);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}

void LED_ACC_AIR_R_Execution(uint8_t led_status)
{
    R6_LED_OUT = led_status;

    if (led_status == 1)
    {
        SEG_LED_ACC_AIR_R(7);
    }
    else
    {
        SEG_LED_ACC_AIR_R(0);
    }
}
/******************************************************************************
  R8 ABS
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_ABS_R_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    uint8_t m_Condition2 = 0u;
    uint8_t CanStatus1 = 0u;

    m_Condition2 = (uint8_t)Get_ID_18F0010B_Sig_ABS_Fully_Operational();/*byte 6 12*/
    CanStatus1 = CAN_MSG_Status(ID_CanMsg18F0010B_Msg_Count);
    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_ABS);

    if ((((CanStatus1 == CAN_SIG_LOST) || (m_Condition2 == 0u)) && (K_Line_Set.K_Line_LID21 == 0x01u)) ||
            (m_Condition1 == 1u) && (K_Line_Set.K_Line_LID21 == 0x03u))
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_ABS_R_Execution(uint8_t led_status)
{
    ABS_LED_MCU_OUT = led_status;

    if (led_status == 1)
    {
        SEG_LED_ABS_R(7);
    }
    else
    {
        SEG_LED_ABS_R(0);
    }
}

/******************************************************************************
U2 TRAILER ABS
  信号接口：
  信号定义：
  输出信号：U2_LED_OUT
 ******************************************************************************/
uint8_t LED_TRAILER_ABS_U_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_TRAILER_ABS);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}

void LED_TRAILER_ABS_U_Execution(uint8_t led_status)
{
    TRAILER_ABS_LED_MCU_OUT = led_status;

    if (led_status == 1)
    {
        SEG_LED_TRAILER_ABS_U(7);
    }
    else
    {
        SEG_LED_TRAILER_ABS_U(0);
    }
}

/******************************************************************************
U3 WORKING LAMP
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_WORKING_LAMP_U_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)XXXX;

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_WORKING_LAMP_U_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL11 = LED_BRIGHTNESSY;
        SEG_LED_WORKING_LAMP_U(7);
    }
    else
    {
        IS31_CHIP0_CHANNEL11 = 0x00;
        SEG_LED_WORKING_LAMP_U(0);
    }
}

/******************************************************************************
U6 TRAILE ABS INFO
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_TRAILER_ABS_INFO_U_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_TRAILER_ABS_INFO);

    if (m_Condition1 == 0x01u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_TRAILER_ABS_INFO_U_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL05 = LED_BRIGHTNESSY;
        SEG_LED_TRAILER_ABS_INFO_U(7);
    }
    else
    {
        IS31_CHIP0_CHANNEL05 = 0x00;
        SEG_LED_TRAILER_ABS_INFO_U(0);
    }
}

/******************************************************************************
Temp
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_Temp_Judgement(void)
{
    static uint8_t u8Result = 0u;
    uint32_t u32IG_ON_Timer = 0x00u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = Coolant_Get_CurSeg();
    u32IG_ON_Timer = Common_GetIgnOnTime();

    if ((m_Condition1 >= 11u) &&  (Coolant_Get_Valid() == 1u)  && (u32IG_ON_Timer >= 5500))// && (K_Line_Set.K_Line_LID43 == 0x82u))
    {
        u8Result = 1u;
    }
    else if (m_Condition1 <= 9u)
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_Temp_Execution(uint8_t led_status)
{
    COMMON_PowerStatus_t u8IG_st;
    u8IG_st = Common_Get_IG_Sts();

    if (u8IG_st == COMMON_POWER_ON)
    {
        //if (led_status == 1u)
        if (0)
        {
            TEMP_R_LED_OUT = 1u ;/*水温红灯*/
            //Water_Temp_Led_R_MCU_OUT = 1u;

            TEMP_W_LED_OUT = 0u ;//水温字符白色指示灯
            //Water_Temp_Led_W_MCU_OUT = 1u;
        }
        else
        {
            TEMP_R_LED_OUT = 0u ;/*水温红灯*/
            //Water_Temp_Led_R_MCU_OUT = 0u;

            TEMP_W_LED_OUT = 1u ;//水温字符白色指示灯
            //Water_Temp_Led_W_MCU_OUT = 1u;
        }
    }
    else
    {
        TEMP_R_LED_OUT = 0u ;/*水温红灯*/
        //Water_Temp_Led_R_MCU_OUT = 0u;

        TEMP_W_LED_OUT = 0u ;//水温字符白色指示灯
        //Water_Temp_Led_W_MCU_OUT = 0u;
    }
}

/******************************************************************************
Fuel
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_Fuel_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t variable_1 = 0x00u;

    variable_1 = Fuel_Get_Popup_Sta();

    if (variable_1 == 1)//&& (K_Line_Set.K_Line_LID43 == 0x82u))
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_Fuel_Execution(uint8_t led_status)
{
    COMMON_PowerStatus_t u8IG_st;

    u8IG_st = Common_Get_IG_Sts();

    if (u8IG_st == COMMON_POWER_ON)
    {
        if (led_status == 1u)
        {
            FUEL_LED_Y_MCU = 1u ;
            //FUEL_W_LED_OUT = 0u ;
        }
        else
        {
            FUEL_LED_Y_MCU = 0u ;
            //FUEL_W_LED_OUT = 1u ;
        }
    }
    else
    {
        FUEL_LED_Y_MCU = 0u ;
        //FUEL_W_LED_OUT = 0u ;
    }
}

/******************************************************************************
Common_Get_L12_Air_Sta
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t Common_Get_L12_Air_Sta(void)
{
    return L12_Air_Sta ;
}