/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : Compiletime settings
 ****************************************************************************
 * Version Control Information :
 *  $Revision: 9286 $
 *  $Date: 2016-07-07 12:54:47 +0200 (Do, 07. Jul 2016) $
 *  $LastChangedBy: michael.golczewski $
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/    

#ifndef DAVEHD_SETTINGS_H_INCLUDED
#define DAVEHD_SETTINGS_H_INCLUDED

#ifdef DAVEHD_DOCUMENTATION
/*----------------------------------------------------------------------------------------------------------*/
/* List of all available configuration options. To enable/disable use the platform specific sections below*/
/**/


 #define DHD_INLINE_INTERFACE                      /* Set if usermode API function should be inlined where possible.*/
 
 #define DHD_DEBUG_MODE                            /* Add additional parameter validation (does not work with inline interface).*/
 
 #define DHD_DEBUG_GUARDED_LOOPS                   /* Enables debug mode for guarded loops (guard values can be set on runtime). Do NOT enable when compiling kernel only.*/
 
 #define DHD_DEBUG_STATE_CHECKSUM                  /* Add checksumming to dhd_get_state and dhd_set_state functions to detect corrupted states.*/
 
 #define DHD_KERNEL_DEBUG                          /* Add kernel internal debugging output.*/
 
 #define DHD_KERNEL_DEBUG_SCHEDULE                 /* Add debug output for each job schedule related action (slow).*/
 
 #define DHD_KERNEL_DEBUG_MEMORY                   /* Add debug output for video memory heap debugging (slow).*/
 
 #define DHD_KERNEL_DEBUG_MEMORY_VERBOSE           /* Increase verbosity level of DHD_KERNEL_DEBUG_MEMORY output.*/
 
 #define DHD_KERNEL_MEMORY_PATTERN                 /* Fill video memory with special debug patterns (does work only if CPU can read/write videomemory).*/
 
 #define DHD_KERNEL_DUMB_ALLOCATOR                 /* Use a simple O(n) video memory allocator instead of the optimized O(1) code (slow).*/
 
 #define DHD_KERNEL_DEBUG_ERROR                    /* Add debug output in case of an hardware error.*/

 #define DHD_KERNEL_DEBUG_TRACEVCD                 /* Add support to enable event traces (requires tracevcd module).*/
 
 #define DHD_KERNEL_TLIST_SUPPORT                  /* Add kernel tlist debugging support (must still be enabled by user mode).*/
 
 #define DHD_KERNEL_NON_LEVEL_IRQ                  /* Support HW with not level sensitive interrupt lines (requires extra handling of IRQs).*/

 #define DHD_KERNEL_SOFT_IRQ                       /* IRQ can be interrupted by normal code (only on softdave / emulated IRQs)*/

 #define DHD_SUPPORT_CASSERT                       /* Enable compiletime asserts (only disable these if your compiler does not support the involved macros).*/
 
 #define DHD_KERNEL_USE_POOLING                    /* Put all kernel memory allocations through the kernel pool allocator (no dynamic allocations).*/
 
 #define DHD_USER_USE_POOLING                      /* Put all user mode allocations through a pool allocator (not recommended).*/

 #define DHD_KERNEL_SYNCHRONOUS_ONLY               /* When defined all kernel calls are blocking.*/
 
 #define DHD_KERNEL_VALLOC_HOOK                    /* Report video ram allocations / frees to the platform specific layer*/

 #define DHD_MEMORY_MMU                            /* Enable support for memory managed systems (architectures using a MMU)*/

 #define DHD_MEMORY_NO_UMA                         /* Enable support for architectures without a uniformed memory*/

 #define DHD_JOB_CHECKSUM_SUPPORTED                /* Enable support for stream checksumming*/

 #define DHD_GUARDED_LOOPS                         /* Enable loop guards (prevents infinite loops).*/

 /*----------------------------------------------------------------------------------------------------------*/
#endif

/*----------------------------------------------------------------------------------------------------------*/
/* Defaults for the various compiletime constraints. Override in the platform specific section below.*/
/**/


#define DHD_MAX_GPU_COUNT               4             /* Maximum kernel mode driver instance count.*/
#define DHD_MAX_CONCURRENT_WAITS        64            /* Number of clients that can simultaneously block on wait_for_job (maximum size of the wait queue).*/
#define DHD_MAX_DEBUG_MESSAGE_SIZE      127           /* Maximum number of characters (excluding /0) per note. (only used when DHD_KERNEL_DEBUG is active).*/
#define DHD_MAX_DEBUG_BUFFER_SIZE       4096          /* Size of debug message buffer, must be larger than message_size*2 (only used when DHD_KERNEL_DEBUG is active).*/
#define DHD_MAX_KERNEL_CLIENTS          8             /* Maximum number of concurrent kernel clients / user threads (only used when DHD_KERNEL_USE_POOLING is active).*/
#define DHD_MAX_VIDMEM_CHUNKS           1024          /* Maximum number of vidmem chunks (each chunk can serve 64 blocks) (only used when DHD_KERNEL_USE_POOLING is active).*/
#define DHD_MAX_USER_BUFFERS            256           /* Maximum number of buffers per application (only used when DHD_USER_USE_POOLING is active).*/
#define DHD_MAX_USER_JOBS               64            /* Maximum number of jobs per application (only used when DHD_USER_USE_POOLING is active).*/
#define DHD_MAX_USER_SHADOW             (1024*1024*2) /* Maximum amount of shadow buffer space for non mappable buffers (only used when DHD_USER_USE_POOLING is active).*/
#define DHD_CACHELINE_SIZE              32            /* Size of one CPU cacheline in bytes.*/
#define DHD_VIDMEM_MINALIGN_LOG2        2ul           /* Log2 of the minimum possible alignment for vido memory allocations.*/
#define DHD_TLIST_ALIGN                 0             /* Additional memory alignment for TLIST debug output*/
#define DHD_MAX_CPU_REGISTER_ACCESS     4096          /* Number of registers (32bit) accessible by the CPU (has to be at least 32)*/
#define DHD_MIN_JOB_SIZE                1024          /* Number of bytes for minimum job size (depends on config, this is for maximum config)*/

/*----------------------------------------------------------------------------------------------------------*/
/* Function inline keyword may be overwritten in platforms*/
/**/
#define DHD_INLINE static


/*----------------------------------------------------------------------------------------------------------*/
/* ALTERA NIOS Platform*/
/**/


#ifdef __NIOS2__
  #include "davehd_settings_nios.h"
#endif

/*----------------------------------------------------------------------------------------------------------*/
/* Win32/Softdave Platform*/
/**/


#ifdef SOFTDAVE_WIN32
  #include "davehd_settings_win32.h"
#endif

/*----------------------------------------------------------------------------------------------------------*/
/* Renesas D1x Platform*/
/**/


#ifdef RENESAS_D1X
  #include "davehd_settings_d1x.h"
#endif

/*---------------------------------------------------------------------------------------------------------*/
/* Renesas D1Hx Platform*/
/**/


#ifdef RENESAS_D1HX
  #include "davehd_settings_d1hx.h"
#endif

/*---------------------------------------------------------------------------------------------------------*/
/* C5SoC ARM Linux Platform */
/**/


#ifdef __linux__
  #include "davehd_settings_linux.h"
#endif

/*----------------------------------------------------------------------------------------------------------*/

#endif /*DAVEHD_SETTINGS_H_INCLUDED*/
