/*===========================================================================*/
/* Module       = dr7f701412.ld                                              */
/* Version      = E1.00f                                                     */
/*                extracted from device file dr7f701412.dvf                  */
/*                by DeFiXRH850 0.7.2.3                                      */
/*===========================================================================*/
/*                                  COPYRIGHT                                */
/*===========================================================================*/
/* Copyright (c) 2014 by Renesas Electronics Europe GmbH,                    */
/*               a company of the Renesas Electronics Corporation            */
/*===========================================================================*/
/* Purpose:     Template of linker directive file                            */
/*                                                                           */
/*===========================================================================*/
/*                                                                           */
/* Warranty Disclaimer                                                       */
/*                                                                           */
/* Because the Product(s) is licensed free of charge, there is no warranty   */
/* of any kind whatsoever and expressly disclaimed and excluded by Renesas,  */
/* either expressed or implied, including but not limited to those for       */
/* non-infringement of intellectual property, merchantability and/or         */
/* fitness for the particular purpose.                                       */
/* Renesas shall not have any obligation to maintain, service or provide bug */
/* fixes for the supplied Product(s) and/or the Application.                 */
/*                                                                           */
/* Each User is solely responsible for determining the appropriateness of    */
/* using the Product(s) and assumes all risks associated with its exercise   */
/* of rights under this Agreement, including, but not limited to the risks   */
/* and costs of program errors, compliance with applicable laws, damage to   */
/* or loss of data, programs or equipment, and unavailability or             */
/* interruption of operations.                                               */
/*                                                                           */
/* Limitation of Liability                                                   */
/*                                                                           */
/* In no event shall Renesas be liable to the User for any incidental,       */
/* consequential, indirect, or punitive damage (including but not limited    */
/* to lost profits) regardless of whether such liability is based on breach  */
/* of contract, tort, strict liability, breach of warranties, failure of     */
/* essential purpose or otherwise and even if advised of the possibility of  */
/* such damages. Renesas shall not be liable for any services or products    */
/* provided by third party vendors, developers or consultants identified or  */
/* referred to the User by Renesas in connection with the Product(s) and/or  */
/* the Application.                                                          */
/*                                                                           */
/*===========================================================================*/
/* Environment:                                                              */
/*              Device:         R7F701412                                    */
/*              IDE:            GHS Multi for V800  V6.xx or later           */
/*===========================================================================*/

CONSTANTS
{
  zero_start = 0xffff8000
}

MEMORY
 {
  iROM_0         : ORIGIN = 0x00200400,  LENGTH = 2048k
  iRAM_0         : ORIGIN = 0xFEB80000,  LENGTH = 512k	/* RAM addres space seen by external bus masters */
  iRAM_1         : ORIGIN = 0xFED80000,  LENGTH = 512k	/* local RAM address space */
  iRAM_R0         : ORIGIN = 0x3FCE4000,  LENGTH = 1k
  iRAM_R         : ORIGIN = 0x3FCE4400,  LENGTH = 16k
 }

SECTIONS
 {

/* Start of internal ROM area (iROM_0) */

  .intvect                              :>iROM_0 /* start of interrupt vector */
  .intvect_end  0x200a00                  :>.      /* end   of interrupt vector */

  .text     align(4)                    :>.      /* program code area */

  .rozdata                              :>.      /* constant datas in ZDA area */
  .robase   align(4)                    :>.      /* initialize textpointer TP for SDA addressing */
  .rosdata  align(4)                    :>.      /* constant datas in SDA area */
  .rodata   align(4)                    :>.      /* constant datas in normal area */

  .fixaddr  align(4)                    :>.      /* ghs internal (compiler) */
  .fixtype  align(4)                    :>.      /* ghs internal (compiler) */
  .secinfo  align(4)                    :>.      /* ghs internal (runtime library) */
  .syscall  align(4)                    :>.      /* ghs internal (linker) */

  .romdata  ROM(.data)                  :>.      /* constant data to initialize variables (copied to RAM at startup)*/
  .romzdata ROM(.zdata)                 :>.      /* constant data to initialize variables in ZDA area (copied to RAM at startup)*/
  .romsdata ROM(.sdata)                 :>.      /* constant data to initialize variables in SDA area (copied to RAM at startup)*/
  .romtdata ROM(.tdata)                 :>.      /* constant data to initialize variables in TDA area (copied to RAM at startup)*/
  .ROM.ramfunc ROM(.ramfunc)            :>.      /* program code to be copied to RAM (copied to RAM at startup) */

/* Start of internal RAM area (iRAM) */

  .data                                 :>iRAM_0    /* initialized data */
  .bss      align(4)                    :>.         /* zero initialized data*/

  //.sdabase  align(4)             :>.      /* initialize globalpointer GP for SDA addressing */
  .sda_start  align(4)             :>. 
  .sdata    align(4)                    :>.         /* initialized data in SDA area*/
  .sbss     align(4)                    :>.         /* zero initialized data in SDA area*/
  .sda_end    align(4)             :>. 
  .zdata    align(4)                    :>.         /* initialized data in ZDA area*/
  .zbss     align(4)                    :>.         /* zero initialized data in ZDA area*/

  .tdata    align(4)   MAX_SIZE(0x0100) :>.         /* initialized and zero-initialized data in TDA area */
  .ramfunc  align(4)                    :>.         /* program code in RAM area */
  .stack    align(4)   pad(0x4000)      :>.         /* definition of stack size */

  .heapbase align(4)                    :>.
  .heap     align(4)
  	        pad(MEMENDADDR(iRAM_0)-addr(.heapbase))
  	        NOCLEAR	                    :>.      /* definition of heap size */ 

/* Start of internal retention RAM area (iRAM_R) */

  .absinitarea   align(4) NOCLEAR       :>iRAM_R0
  .rdata        align(4)                :>iRAM_R     /* user defined segment for for initialized data located in retention RAM  */
  .rbss         align(4)                :>.          /* user defined segment for zero initialized data located in retention RAM */
  .NonInitArea  align(4) NOCLEAR        :>.  					/* non initalised are in the BURAM */

/*  Symbols for compiler references */

  ___ghs_romstart   = MEMADDR(iROM_0);
  ___ghs_romend     = MEMENDADDR(iROM_0);

  ___ghs_ramstart   = MEMADDR(iRAM_0);
  ___ghs_ramend     = MEMENDADDR(iRAM_0);

  ___ghs_rramstart  = MEMADDR(iRAM_R);
  ___ghs_rramend    = MEMENDADDR(iRAM_R);

 }

/*===========================================================================*/
/*      End of File                                                          */
/*===========================================================================*/
