

#ifndef _KWP2000_SERVICE_H
#define _KWP2000_SERVICE_H

/*
*********************************************************************
* defines
*********************************************************************
*/
/* KWP2000 keybytes for initialization */
#define KWP2000_KEYBYTE1                                        0xE9u      /* Both Len type - Both header type - Normal timing */
#define KWP2000_KEYBYTE2                                        0x8Fu

/* Request Service Id */
#define KWP2000_STARTDIAGNOSTICSESSION_REQUEST                  0x10u
#define KWP2000_ECURESET_REQUEST                                0x11u
#define KWP2000_READFREEZEFRAMEDATA_REQUEST                     0x12u
#define KWP2000_READDIAGNOSTICTROUBLECODES_REQUEST              0x13u
#define KWP2000_CLEARDIAGNOSTICINFORMATION_REQUEST              0x14u
#define KWP2000_READNUMBEROFDIAGNOSTICTROUBLECODES_REQUEST      0x15u
#define KWP2000_READSTATUSOFDIAGNOSTICTROUBLECODES_REQUEST      0x17u
#define KWP2000_READDIAGNOSTICTROUBLECODESBYSTATUS_REQUEST      0x18u
#define KWP2000_READECUIDENTIFICATION_REQUEST                   0x1Au
#define KWP2000_STOPDIAGNOSTICSESSION_REQUEST                   0x20u
#define KWP2000_READDATABYLOCALIDENTIFIER_REQUEST               0x21u
#define KWP2000_READDATABYCOMMONIDENTIFIER_REQUEST              0x22u
#define KWP2000_READMEMORYBYADDRESS_REQUEST                     0x23u
#define KWP2000_SETDATARATES_REQUEST                            0x26u
#define KWP2000_SECURITYACCESS_REQUEST                          0x27u
#define KWP2000_DYNAMICALLYDEFINELOCALIDENTIFIER_REQUEST        0x2Cu
#define KWP2000_WRITEDATABYCOMMONIDENTIFIER_REQUEST             0x2Eu
#define KWP2000_INPUTOUTPUTCONTROLBYCOMMONIDENTIFIER_REQUEST    0x2Fu
#define KWP2000_INPUTOUTPUTCONTROLBYLOCALIDENTIFIER_REQUEST     0x30u
#define KWP2000_STARTROUTINEBYLOCALIDENTIFIER_REQUEST           0x31u
#define KWP2000_STOPROUTINEBYLOCALIDENTIFIER_REQUEST            0x32u
#define KWP2000_REQUESTROUTINERESULTSBYLOCALIDENTIFIER_REQUEST  0x33u
#define KWP2000_REQUESTDOWNLOAD_REQUEST                         0x34u
#define KWP2000_REQUESTUPLOAD_REQUEST                           0x35u
#define KWP2000_TRANSFERDATA_REQUEST                            0x36u
#define KWP2000_REQUESTTRANSFEREXIT_REQUEST                     0x37u
#define KWP2000_STARTROUTINEBYADDRESS_REQUEST                   0x38u
#define KWP2000_STOPROUTINEBYADDRESS_REQUEST                    0x39u
#define KWP2000_REQUESTROUTINERESULTSBYADDRESS_REQUEST          0x3Au
#define KWP2000_WRITEDATABYLOCALIDENTIFIER_REQUEST              0x3Bu
#define KWP2000_WRITEMEMORYBYADDRESS_REQUEST                    0x3Du
#define KWP2000_TESTERPRESENT_REQUEST                           0x3Eu
#define KWP2000_ESCCODE_REQUEST                                 0x80u
#define KWP2000_STARTCOMMUNICATION_REQUEST                      0x81u
#define KWP2000_STOPCOMMUNICATION_REQUEST                       0x82u
#define KWP2000_ACCESSTIMINGPARAMETER_REQUEST                   0x83u
#define KWP2000_STARTAPPLICATION_REQUEST                        0xA2u

/**/
#define KWP2000_POSITIVE_RESPONSE_OFFSET                        0x40

/* negative response */
#define KWP_NEGATIVE_RESPONSE                                   0x7F

/* Response codes for KWP2000 services */
#define KWP2000_generalReject                                   0x10u
#define KWP2000_serviceNotSupported                             0x11u
#define KWP2000_subFunctionNotSupported                         0x12u
#define KWP2000_busy_RepeatRequest                              0x21u
#define KWP2000_conditionsNotCorrect                            0X22u
#define KWP2000_routineNotComplete                              0x23u
#define KWP2000_requestOutOfRange                               0x31u
#define KWP2000_securityAccessDenied                            0x33u
#define KWP2000_invalidKey                                      0x35u
#define KWP2000_exceedNumberOfAttempts                          0x36u
#define KWP2000_requiredTimeDelayNotExpired                     0x37u
#define KWP2000_downloadNotAccepted                             0x40u
#define KWP2000_improperDownloadType                            0x41u
#define KWP2000_cannotDownloadToSpecifiedAddress                0x42u
#define KWP2000_cannotDownloadNumberOfBytesRequested            0x43u
#define KWP2000_uploadNotAccepted                               0x50u
#define KWP2000_improperUploadType                              0x51u
#define KWP2000_cannotUploadFromSpecifiedAddress                0x52u
#define KWP2000_cannotUploadNumberOfBytesRequested              0x53u
#define KWP2000_transferSuspended                               0x71u
#define KWP2000_transferAborted                                 0x72u
#define KWP2000_illegalAddressInBlockTransfer                   0x74u
#define KWP2000_illegalByteCountInBlockTransfer                 0x75u
#define KWP2000_illegalBlockTransferType                        0x76u
#define KWP2000_blockTransferDataChecksumError                  0x77u
#define KWP2000_reqCorrectlyRcvd_RspPending                     0x78u
#define KWP2000_incorrectByteCountDuringBlockTransfer           0x79u
#define KWP2000_serviceNotSupportedInActiveDiagnosticSession    0x80u
/*
*********************************************************************
* structure
*********************************************************************
*/
typedef struct
{
    unsigned char  ResponseCode;
} Kwp2000_Negative_t;

/*
*********************************************************************
* variable
*********************************************************************
*/
extern Kwp2000_Negative_t  Kwp2000_Negative;

/*
*********************************************************************
* function
*********************************************************************
*/
extern unsigned char kwp_NegativeResponse(unsigned char sId_u8, unsigned char NegRC_u8, unsigned char *blockByte);
extern unsigned char kwp_EcuReset(unsigned char *TxData, unsigned char *RequestData);
extern unsigned char kwp_TesterPresent(unsigned char *TxData, unsigned char *RequestData);
extern unsigned char kwp_StartCommunication(unsigned char *TxData, unsigned char *RequestData);
extern unsigned char kwp_StopCommunication(unsigned char *TxData, unsigned char *RequestData);
extern unsigned char kwp_readEcuIdentification(unsigned char *TxData, unsigned char *RequestData);
extern unsigned char kwp_writeDataByLocalIdentifier(unsigned char *TxData, unsigned char *RequestData);
extern unsigned char kwp_readDataByLocalIdentifier(unsigned char *TxData, unsigned char *RequestData);
extern unsigned char kwp_readDataByCommonIdentifier(unsigned char *TxData, unsigned char *RequestData);

extern unsigned char kwp_readDataStatusofDTC(unsigned char *TxData, unsigned char *RequestData);
extern unsigned char kwp_readDataAccessMode(unsigned char *TxData, unsigned char *RequestData);
extern unsigned char kwp_StartroutInebykocalIdentifier(unsigned char *TxData, unsigned char *RequestData);
extern unsigned char kwp_ClearDiagnosticInformation(unsigned char *TxData, unsigned char *RequestData);

typedef union
{
    unsigned char SendSeedEQUSRecvSeed;        /*密钥配对成功标识 0-失败 1-成功*/
    unsigned char RecvStart           ;        /*通讯开始标识    0-结束 1-开始*/
    unsigned char S_Regist            ;        /*是否注册标识*/
    unsigned char AccessMode2701      ;        /*27服务进入计时标志*/
} _K_LINE_SIGNAL_FLAG;

extern _K_LINE_SIGNAL_FLAG   K_LINE_SIGNAL_FLAG;

typedef union
{
    unsigned char ActiveSecurityAccess ;   /*修正值状态   0-未实施 1-实施后*/
    unsigned char SensorStatus         ;   /*传感器输入状态 0-LOW    1-HIGH*/
    unsigned char Security_Active      ;   /*锁定状态      0-未锁定 1-锁定*/
    unsigned char reserve              ;
} _ECUStatus;

extern    _ECUStatus        ECUStatusONE;

#define   ECUSTATUST_F      00             /*修正系数 EOL系数*2048*/

extern unsigned char        Sendseed1;      /*仪表计算*/
extern unsigned char        Sendseed2;
extern unsigned char        Sendseed3;
extern unsigned char        Sendseed4;

extern unsigned char        Recvseed1;      /*仪表接收*/
extern unsigned char        Recvseed2;
extern unsigned char        Recvseed3;
extern unsigned char        Recvseed4;

extern unsigned char Seed1, Seed2, Seed3, Seed4;

//extern unsigned long        SeedKey;
extern unsigned char        AccessMode2701KeyTimeFlag;
extern unsigned char        AccessMode2701KeyTime;

extern void App_Uds_Calc_Key(void);
extern unsigned char Cup_Key(unsigned char KLineseed, unsigned char Num, unsigned char Seed);
extern unsigned char BitReplace (unsigned char Data);
extern void sendkey(void);
#endif
