#include "UDS_22Service_Main.h"


/**
  *22服务函数入口
  *@param A_TA_type 收到数据的地址
  *@param A_Length 收到数据的长度
  *@param A_Data 收到数据的数据
  */
void UDS_Service_22_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data[])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if(NRC == positiveResponse)
    {
        NRC = UDS_22Service_NRC11();                                            /*22服务是否支持功能寻址*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_22Service_NRC7F();                                            /*22服务会话是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_22Service_NRC31();                                            /*22服务超出请求范围验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_22Service_NRC13_TotalLengthCheck();                           /*22服务总长度长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_22Service_NRC33();                                            /*22服务解锁等级验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_22Service_NRC22();                                            /*22服务条件验证*/
    }
    if(NRC == positiveResponse)         
    {
        UDS_22Service_DID();                                                    /*22服务DID判断*/
    }
    clearDiagMSG();                                                             /*清除诊断信息*/
}



/**
  *22服务子功能
  */
void UDS_22Service_DID(void)
{
    //ReadDFlashData(EEPROM_BLOCK_UDS_S2E, (uint32_t *)&BootToDFlashInfo.Flag, sizeof(BootToDFlashInfo) / 4u, BootToDFlashInfoInit);
    ReadDFlashData(EEPROM_BLOCK_UDS_S2E, (uint32_t *)&Ser2EToDFlashInfo.Flag, sizeof(Ser2EToDFlashInfo) / 4u, Ser2EToDFlashInfoInit);
    ReadDFlashData(EEPROM_BLOCK_UDS_CONFIG, (uint32_t *)&EOL_Data_Type.Flag, sizeof(EOL_Data_Type) / 4u, EOL_InitVal);
    switch(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L))/*22服务DID判断*/
    {
    case 0xF180u:
        UDS_22Service_DID_F180();                                                /*引导软件标识*/
        break;
    case 0xF181u:
        UDS_22Service_DID_F181();                                                /*应用软件标识*/
        break;
    case 0xF182u:
        UDS_22Service_DID_F182();                                                /*标定数据标识*/
        break;
    case 0xF183u:
        UDS_22Service_DID_F183();                                                /*引导软件数字指纹(预留)*/
        break;
    case 0xF184u:
        UDS_22Service_DID_F184();                                                /*应用软件数字指纹*/
        break;
    case 0xF185u:
        UDS_22Service_DID_F185();                                                /*应用数据数字指纹(预留)*/
        break;
    case 0xF187u:
        UDS_22Service_DID_F187();                                                /*IC 零件号*/
        break;
    case 0xF18Au:
        UDS_22Service_DID_F18A();                                                /*系统供应商编号*/
        break;
    case 0xF18Bu:
        UDS_22Service_DID_F18B();                                                /*IC 生产日期*/
        break;
    case 0xF18Cu:
        UDS_22Service_DID_F18C();                                                /*IC 系列号*/
        break;
    case 0xF190u:
        UDS_22Service_DID_F190();                                                /*车辆标识号 VIN*/
        break;
    case 0xF193u:
        UDS_22Service_DID_F193();                                                /*IC 硬件版本号*/
        break;
    case 0xF195u:
        UDS_22Service_DID_F195();                                                /*IC 逻辑程序软件版本号*/
        break;
    case 0xF1F0u:
        UDS_22Service_DID_F1F0();                                                /*IC 资源程序软件版本号*/
        break;
    case 0xF1F1u:
        UDS_22Service_DID_F1F1();                                                /*IC 总版本号*/
        break;
    case 0x6000u:
        UDS_22Service_DID_6000();                                                /*制动回路 1 气压信号本号*/
        break;
    case 0x6001u:
        UDS_22Service_DID_6001();                                                /*制动回路 2 气压信号*/
        break;
    case 0x6078u:
        UDS_22Service_DID_6078();                                                /*轮差速锁信号*/
        break;
    case 0x6079u:
        UDS_22Service_DID_6079();                                                /*轴差速锁信号*/
        break;
    case 0x607Au:
        UDS_22Service_DID_607A();                                                /*行车取力*/
        break;
    case 0x607Bu:
        UDS_22Service_DID_607B();                                                /*停车取力*/
        break;
    case 0x607Cu:
        UDS_22Service_DID_607C();                                                /*ADR 工作异常信号*/
        break;
    case 0x607Du:
        UDS_22Service_DID_607D();                                                /*燃气泄漏传感器 1 报警信号 */
        break;
    case 0x60C8u:
        UDS_22Service_DID_60C8();                                                /*燃气泄漏传感器 2 报警信号 */
        break;
    case 0x6005u:
        UDS_22Service_DID_6005();                                                /*全轮驱动工作信号*/
        break;
    case 0x600Bu:
        UDS_22Service_DID_600B();                                                /*分动器低档位信号 */
        break;
    case 0x607Eu:
        UDS_22Service_DID_607E();                                                /*挂车 ABS 指示信号 */
        break;
    case 0x607Fu:
        UDS_22Service_DID_607F();                                                /*蜂鸣器输入 */
        break;
    case 0x6080u:
        UDS_22Service_DID_6080();                                                /*喷淋壶液位低报警 */
        break;
    case 0x6002u:
        UDS_22Service_DID_6002();                                                /*主驾安全带开关信号 */
        break;
    case 0x600Fu:
        UDS_22Service_DID_600F();                                                /*驾驶室翻转信号 */
        break;
    case 0x6011u:
        UDS_22Service_DID_6011();                                                /*车厢举升信号 */
        break;
    case 0x600Eu:
        UDS_22Service_DID_600E();                                                /*空滤器阻塞报警开关信号 */
        break;
    case 0x6081u:
        UDS_22Service_DID_6081();                                                /*冷却液液位过低报警信号 */
        break;
    case 0x6009u:
        UDS_22Service_DID_6009();                                                /*机械变速器低档信号 */
        break;
    case 0x6010u:
        UDS_22Service_DID_6010();                                                /*发 电 机 充 电 指 示 信 号 ( 预留) */
        break;
    case 0x6082u:
        UDS_22Service_DID_6082();                                                /*转向机油液位报警器信号 */
        break;
    case 0x6083u:
        UDS_22Service_DID_6083();                                                /*盘式制动器磨损报警信号  */
        break;
    case 0x6084u:
        UDS_22Service_DID_6084();                                                /*前轮轮间差速锁指示信号  */
        break;
    case 0x600Au:
        UDS_22Service_DID_600A();                                                /*分动器高档位信号  */
        break;
    case 0x6085u:
        UDS_22Service_DID_6085();                                                /*浮动桥指示信号  */
        break;
    case 0x6086u:
        UDS_22Service_DID_6086();                                                /*油量信号  */
        break;
    case 0x6087u:
        UDS_22Service_DID_6087();                                                /*CNG 气量传感器信号  */
        break;
    case 0x6088u:
        UDS_22Service_DID_6088();                                                /*驱动桥 1 机油温度传感器信号*/
        break;
    case 0x6089u:
        UDS_22Service_DID_6089();                                                /*驱动桥 1 机油液位传感器信号*/
        break;
    case 0x608Au:
        UDS_22Service_DID_608A();                                                /*驱动桥 2 机油温度传感器信号*/
        break;
    case 0x608Bu:
        UDS_22Service_DID_608B();                                                /*驱动桥 2 机油液位传感器信号*/
        break;
    case 0x608Cu:
        UDS_22Service_DID_608C();                                                /*转向机油温度传感器信号*/
        break;
    case 0x608Du:
        UDS_22Service_DID_608D();                                                /*发动机机油温度传感器信号*/
        break;
    case 0x608Eu:
        UDS_22Service_DID_608E();                                                /*发动机机油液位传感器信号*/
        break;
    case 0x6029u:
        UDS_22Service_DID_6029();                                                /*主车驻车气室气压*/
        break;
    case 0x6090u:
        UDS_22Service_DID_6090();                                                /*挂车控制气室气压*/
        break;
    case 0x6013u:
        UDS_22Service_DID_6013();                                                /*自动驻车回路气压*/
        break;
    case 0x602Au:
        UDS_22Service_DID_602A();                                                /*进气预热指示灯*/
        break;
    case 0x6023u:
        UDS_22Service_DID_6023();                                                /*ESP 工作灯(预留)*/
        break;
    case 0x602Cu:
        UDS_22Service_DID_602C();                                                /*轴 差 速 锁 工 作 指 示 灯 ( 预留)*/
        break;
    case 0x60A2u:
        UDS_22Service_DID_60A2();                                                /*分动器低档指示灯(预留)*/
        break;
    case 0x60ABu:
        UDS_22Service_DID_60AB();                                                /*疲劳驾驶提示指示灯*/
        break;
    case 0x60ACu:
        UDS_22Service_DID_60AC();                                                /*后 轮 转 向 报 警 指 示 灯 (预留)*/
        break;
    case 0x605Cu:
        UDS_22Service_DID_605C();                                                /*LDWS(车道偏离)系统开关*/
        break;
    case 0x605Du:
        UDS_22Service_DID_605D();                                                /*AFS 系统开关*/
        break;
    case 0x605Eu:
        UDS_22Service_DID_605E();                                                /*HUD 系统开关*/
        break;
    case 0x605Fu:
        UDS_22Service_DID_605F();                                                /*ACC 系统开关*/
        break;
    case 0x6060u:
        UDS_22Service_DID_6060();                                                /*称重系统开关*/
        break;
    case 0x6062u:
        UDS_22Service_DID_6062();                                                /*车速里程表 K 值*/
        break;
    case 0x6063u:
        UDS_22Service_DID_6063();                                                /*发动机速比*/
        break;
    case 0x6064u:
        UDS_22Service_DID_6064();                                                /*单位*/
        break;
    case 0x6065u:
        UDS_22Service_DID_6065();                                                /*气量（LNG）*/
        break;
    case 0x6066u:
        UDS_22Service_DID_6066();                                                /*气量（CNG）*/
        break;
    case 0x6068u:
        UDS_22Service_DID_6068();                                                /*语言*/
        break;
    case 0x6069u:
        UDS_22Service_DID_6069();                                                /*钥匙开关 ON 档*/
        break;
    case 0x606Du:
        UDS_22Service_DID_606D();                                                /*轮胎防盗使能开关*/
        break;
    case 0x606Eu:
        UDS_22Service_DID_606E();                                                /*换挡提示设置*/
        break;
    case 0x606Fu:
        UDS_22Service_DID_606F();                                                /*油箱容量设置*/
        break;
    case 0x6070u:
        UDS_22Service_DID_6070();                                                /*HAS 系统开关*/
        break;
    case 0x6071u:
        UDS_22Service_DID_6071();                                                /*ESC 系统开关*/
        break;
    case 0x6072u:
        UDS_22Service_DID_6072();                                                /*盘式制动磨损报警功能*/
        break;
    case 0x6073u:
        UDS_22Service_DID_6073();                                                /*挂车设置*/
        break;
    case 0x6074u:
        UDS_22Service_DID_6074();                                                /*排放配置*/
        break;
    case 0x6075u:
        UDS_22Service_DID_6075();                                                /*超速报警车型信号 */
        break;
    case 0x6076u:
        UDS_22Service_DID_6076();                                                /*总里程（注：当总里程被写成任何值时，短里程都应该为 0） */
        break;
    case 0x6077u:
        UDS_22Service_DID_6077();                                                /*重 新 计 算 仪 表 综 合 油 耗（注：仪表重新计算当前油耗和综合油耗） */
        break;
    case 0x60C9u:
        UDS_22Service_DID_60C9();                                                /*尿素箱容积 */
        break;
    case 0x60CAu:
        UDS_22Service_DID_60CA();                                                /*主油箱容积 */
        break;
    case 0x60CBu:
        UDS_22Service_DID_60CB();                                                /*副油箱容积 */
        break;
    case 0x60CCu:
        UDS_22Service_DID_60CC();                                                /*油箱类型     */
        break;
    case 0x60CDu:
        UDS_22Service_DID_60CD();                                                /*发动机类型 */
        break;
    case 0x60CEu:
        UDS_22Service_DID_60CE();                                                /*TCU 类型 */
        break;
    case 0X60CFu:
        UDS_22Service_DID_60CF();                                                /*驱动能源类型 */
        break;
    case 0X60D0u:
        UDS_22Service_DID_60D0();                                                /*驱动形式 */
        break;
    case 0X60D1u:
        UDS_22Service_DID_60D1();                                                /*蓄电池容量 */
        break;
    case 0X60D2u:
        UDS_22Service_DID_60D2();                                                /*电池管理系统 */
        break;
    default:
        break;
    }
}

/**
  *22服务DIDF180
  * 引导软件标识
  */
void UDS_22Service_DID_F180(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, BootToDFlashInfo.DID_F180, sizeof(BootToDFlashInfo.DID_F180));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 7u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF181
  * 应用软件标识
  */
void UDS_22Service_DID_F181(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, BootToDFlashInfo.DID_F181, sizeof(BootToDFlashInfo.DID_F181));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 7u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF182
  * 标定数据标识
  */
void UDS_22Service_DID_F182(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, BootToDFlashInfo.DID_F182, sizeof(BootToDFlashInfo.DID_F182));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 7u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF183
  * 引导软件数字指纹(预留)
  */
void UDS_22Service_DID_F183(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F183, sizeof(Ser2EToDFlashInfo.DID_F183));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 42u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF184
  * 应用软件数字指纹
  */
void UDS_22Service_DID_F184(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F184, sizeof(Ser2EToDFlashInfo.DID_F184));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 42u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF185
  * 应用数据数字指纹(预留)
  */
void UDS_22Service_DID_F185(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F185, sizeof(Ser2EToDFlashInfo.DID_F185));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 42u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF187
  * IC 零件号
  */
void UDS_22Service_DID_F187(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F187, sizeof(Ser2EToDFlashInfo.DID_F187));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 13u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF18A
  * 系统供应商编号
  */
void UDS_22Service_DID_F18A(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F18A, sizeof(Ser2EToDFlashInfo.DID_F18A));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 8u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF18B
  * IC 生产日期
  */
void UDS_22Service_DID_F18B(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F18B, sizeof(Ser2EToDFlashInfo.DID_F18B));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 4u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF18C
  * IC 系列号
  */
void UDS_22Service_DID_F18C(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F18C, sizeof(Ser2EToDFlashInfo.DID_F18C));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 20u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF190
  * 车辆标识号 VIN
  */
void UDS_22Service_DID_F190(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F190, sizeof(Ser2EToDFlashInfo.DID_F190));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 17u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF193
  * IC硬件版本号
  */
void UDS_22Service_DID_F193(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F193, sizeof(Ser2EToDFlashInfo.DID_F193));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 6u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF195
  * IC系列号
  */
void UDS_22Service_DID_F195(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F195, sizeof(Ser2EToDFlashInfo.DID_F195));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 6u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF1F0
  * IC 资源程序软件版本号
  */
void UDS_22Service_DID_F1F0(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F1F0, sizeof(Ser2EToDFlashInfo.DID_F1F0));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 6u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF1F1
  * IC 总版本号
  */
void UDS_22Service_DID_F1F1(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F1F1, sizeof(Ser2EToDFlashInfo.DID_F1F1));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 6u, DiagMSG.msgData.Data);
}

/**
  *22服务DID6000
  * 制动回路 1 气压信号
  */
void UDS_22Service_DID_6000(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &BootToDFlashInfo.DID_6000, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID6001
  * 制动回路 2 气压信号
  */
void UDS_22Service_DID_6001(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &BootToDFlashInfo.DID_6001, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID6078
  * 轮差速锁信号
  */
void UDS_22Service_DID_6078(void)
{

}

/**
  *22服务DID6079
  * 轴差速锁信号 
  */
void UDS_22Service_DID_6079(void)
{

}

/**
  *22服务DID607A
  * 行车取力  
  */
void UDS_22Service_DID_607A(void)
{

}

/**
  *22服务DID607B
  * 停车取力  
  */
void UDS_22Service_DID_607B(void)
{

}

/**
  *22服务DID607C
  * ADR 工作异常信号  
  */
void UDS_22Service_DID_607C(void)
{

}

/**
  *22服务DID607D
  *  燃气泄漏传感器 1 报警信号  
  */
void UDS_22Service_DID_607D(void)
{

}

/**
  *22服务DID60C8
  *  燃气泄漏传感器 2 报警信号  
  */
void UDS_22Service_DID_60C8(void)
{

}

/**
  *22服务DID6005
  *  全轮驱动工作信号 
  */
void UDS_22Service_DID_6005(void)
{

}

/**
  *22服务DID600B
  *  分动器低档位信号  
  */
void UDS_22Service_DID_600B(void)
{

}

/**
  *22服务DID607E
  *  挂车ABS指示信号  
  */
void UDS_22Service_DID_607E(void)
{

}

/**
  *22服务DID607F
  *  蜂鸣器输入  
  */
void UDS_22Service_DID_607F(void)
{

}

/**
  *22服务DID6080
  *  喷淋壶液位低报警  
  */
void UDS_22Service_DID_6080(void)
{

}

/**
  *22服务DID6002
  *  主驾安全带开关信号  
  */
void UDS_22Service_DID_6002(void)
{

}

/**
  *22服务DID600F
  *  驾驶室翻转信号 
  */
void UDS_22Service_DID_600F(void)
{

}

/**
  *22服务DID6011
  *  车厢举升信号 
  */
void UDS_22Service_DID_6011(void)
{

}

/**
  *22服务DID600E
  *   空滤器阻塞报警开关信号 
  */
void UDS_22Service_DID_600E(void)
{

}

/**
  *22服务DID6081
  *   冷却液液位过低报警信号 
  */
void UDS_22Service_DID_6081(void)
{

}

/**
  *22服务DID6009
  *   机械变速器低档信号 
  */
void UDS_22Service_DID_6009(void)
{

}

/**
  *22服务DID6010
  *   发电机充电指示信号(预留) 
  */
void UDS_22Service_DID_6010(void)
{

}

/**
  *22服务DID6082
  *   转向机油液位报警器信号
  */
void UDS_22Service_DID_6082(void)
{

}

/**
  *22服务DID6083
  *    盘式制动器磨损报警信号
  */
void UDS_22Service_DID_6083(void)
{

}

/**
  *22服务DID6084
  *    前轮轮间差速锁指示信号
  */
void UDS_22Service_DID_6084(void)
{

}

/**
  *22服务DID600A
  *    分动器高档位信号
  */
void UDS_22Service_DID_600A(void)
{

}

/**
  *22服务DID6085
  *   浮动桥指示信号
  */
void UDS_22Service_DID_6085(void)
{

}

/**
  *22服务DID6086
  *   油量信号
  */
void UDS_22Service_DID_6086(void)
{

}

/**
  *22服务DID6087
  *   CNG 气量传感器信号
  */
void UDS_22Service_DID_6087(void)
{

}

/**
  *22服务DID6088
  *   驱动桥 1 机油温度传感器信号
  */
void UDS_22Service_DID_6088(void)
{

}

/**
  *22服务DID6089
  *   驱动桥 1 机油液位传感器信号
  */
void UDS_22Service_DID_6089(void)
{

}

/**
  *22服务DID608A
  *   驱动桥 2 机油温度传感器信号
  */
void UDS_22Service_DID_608A(void)
{

}

/**
  *22服务DID608B
  *    驱动桥 2 机油液位传感器信号
  */
void UDS_22Service_DID_608B(void)
{

}

/**
  *22服务DID608C
  *    转向机油温度传感器信号
  */
void UDS_22Service_DID_608C(void)
{

}

/**
  *22服务DID608D
  *    发动机机油温度传感器信号
  */
void UDS_22Service_DID_608D(void)
{

}

/**
  *22服务DID608E
  *    发动机机油液位传感器信号
  */
void UDS_22Service_DID_608E(void)
{

}

/**
  *22服务DID6029
  *    主车驻车气室气压
  */
void UDS_22Service_DID_6029(void)
{

}

/**
  *22服务DID6090
  *    挂车控制气室气压
  */
void UDS_22Service_DID_6090(void)
{

}

/**
  *22服务DID6013
  *    自动驻车回路气压
  */
void UDS_22Service_DID_6013(void)
{

}

/**
  *22服务DID602A
  *    进气预热指示灯
  */
void UDS_22Service_DID_602A(void)
{

}

/**
  *22服务DID6023
  *    ESP 工作灯(预留)
  */
void UDS_22Service_DID_6023(void)
{

}

/**
  *22服务DID602C
  *    轴差速锁工作指示灯(预留)
  */
void UDS_22Service_DID_602C(void)
{

}

/**
  *22服务DID60A2
  *    分动器低档指示灯(预留)
  */
void UDS_22Service_DID_60A2(void)
{

}

/**
  *22服务DID60AB
  *     疲劳驾驶提示指示灯(预留)
  */
void UDS_22Service_DID_60AB(void)
{

}

/**
  *22服务DID60AC
  *     后轮转向报警指示灯(预留) 
  */
void UDS_22Service_DID_60AC(void)
{

}

/**
  *22服务DID605C
  *  LDWS(车道偏离)系统开关 
  */
void UDS_22Service_DID_605C(void)
{

}

/**
  *22服务DID605D
  *  AFS 系统开关 
  */
void UDS_22Service_DID_605D(void)
{

}

/**
  *22服务DID605E
  *  HUD 系统开关 
  */
void UDS_22Service_DID_605E(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &EOL_Data_Type.DID_605E, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID605F
  *  ACC 系统开关 
  */
void UDS_22Service_DID_605F(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &EOL_Data_Type.DID_605F, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID6060
  *  称重系统开关 
  */
void UDS_22Service_DID_6060(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &EOL_Data_Type.DID_6060, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID6062
  *  车速里程表 K 值
  */
void UDS_22Service_DID_6062(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, EOL_Data_Type.DID_6062, sizeof(EOL_Data_Type.DID_6062));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 2u, DiagMSG.msgData.Data);
}

/**
  *22服务DID6063
  *  发动机速比
  */
void UDS_22Service_DID_6063(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &EOL_Data_Type.DID_6063, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID6064
  *  单位
  */
void UDS_22Service_DID_6064(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &EOL_Data_Type.DID_6064, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID6065
  *  气量（LNG） 
  */
void UDS_22Service_DID_6065(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &BootToDFlashInfo.DID_6065, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID6066
  *  气量（CNG） 
  */
void UDS_22Service_DID_6066(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &BootToDFlashInfo.DID_6066, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID6068
  *  语言  
  */
void UDS_22Service_DID_6068(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &EOL_Data_Type.DID_6068, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID6069
  *     钥匙开关 ON 档 
  */
void UDS_22Service_DID_6069(void)
{
    //memcpy(DiagMSG.msgData.DidDetail.Data, &BootToDFlashInfo.DID_6069, 1);
    DiagMSG.msgData.DidDetail.Data[0] = 0;
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID606D
  *  轮胎防盗使能开关  
  */
void UDS_22Service_DID_606D(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &EOL_Data_Type.DID_606D, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID606E
  *  换挡提示设置  
  */
void UDS_22Service_DID_606E(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &EOL_Data_Type.DID_606E, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID606F
  *  油箱容量设置   
  */
void UDS_22Service_DID_606F(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, EOL_Data_Type.DID_606F, sizeof(EOL_Data_Type.DID_606F));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 2u, DiagMSG.msgData.Data);
}

/**
  *22服务DID6070
  *  HAS 系统开关   
  */
void UDS_22Service_DID_6070(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &EOL_Data_Type.DID_6070, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID6071
  *   ESC 系统开关    
  */
void UDS_22Service_DID_6071(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &EOL_Data_Type.DID_6071, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID6072
  *   盘式制动磨损报警功能  
  */
void UDS_22Service_DID_6072(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &EOL_Data_Type.DID_6072, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID6073
  *   挂车设置 
  */
void UDS_22Service_DID_6073(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &EOL_Data_Type.DID_6073, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID6074
  *   排放配置 
  */
void UDS_22Service_DID_6074(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &EOL_Data_Type.DID_6074, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID6075
  *   超速报警车型信号 
  */
void UDS_22Service_DID_6075(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &EOL_Data_Type.DID_6075, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID6076
  *   总里程（注：当总里程被写成任何值时，短里程都应该为 0)
 */ 
void UDS_22Service_DID_6076(void)
{
    uint32_t Odometer;
    Odometer = getTotalOdometer();
    DiagMSG.msgData.DidDetail.Data[0] = (uint8_t)(Odometer >> 16u);
    DiagMSG.msgData.DidDetail.Data[1] = (uint8_t)(Odometer >> 8u);
    DiagMSG.msgData.DidDetail.Data[2] = (uint8_t)(Odometer);
    //memcpy(DiagMSG.msgData.DidDetail.Data, EOL_Data_Type.DID_6076, sizeof(EOL_Data_Type.DID_6076));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 3u, DiagMSG.msgData.Data);
}

/**
  *22服务DID6077
  * 重 新 计 算 仪 表 综 合 油 耗（注：仪表重新计算当前油耗和综合油耗）
  */
void UDS_22Service_DID_6077(void)
{
   // memcpy(DiagMSG.msgData.DidDetail.Data, &Ser2EToDFlashInfo.DID_6077, 1);
    DiagMSG.msgData.DidDetail.Data[0] = 0;
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID60C9
  *   尿素箱容积
  */
void UDS_22Service_DID_60C9(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &EOL_Data_Type.DID_60C9, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID60CA
  *   主油箱容积
  */
void UDS_22Service_DID_60CA(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, EOL_Data_Type.DID_60CA, sizeof(EOL_Data_Type.DID_60CA));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 2u, DiagMSG.msgData.Data);
}

/**
  *22服务DID60CB
  *   副油箱容积
  */
void UDS_22Service_DID_60CB(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, EOL_Data_Type.DID_60CB, sizeof(EOL_Data_Type.DID_60CB));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 2u, DiagMSG.msgData.Data);
}


/**
  *22服务DID60CC
  *   油箱类型 
  */
void UDS_22Service_DID_60CC(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &EOL_Data_Type.DID_60CC, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID60CD
  *   发动机类型
  */
void UDS_22Service_DID_60CD(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, EOL_Data_Type.DID_60CD, sizeof(EOL_Data_Type.DID_60CD));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 2u, DiagMSG.msgData.Data);
}

/**
  *22服务DID60CE
  *    TCU 类型
  */
void UDS_22Service_DID_60CE(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &EOL_Data_Type.DID_60CE, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID60CF
  *    驱动能源类型 
  */
void UDS_22Service_DID_60CF(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &EOL_Data_Type.DID_60CF, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID60D0
  *    驱动形式 
  */
void UDS_22Service_DID_60D0(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &EOL_Data_Type.DID_60D0, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID60D1
  *    蓄电池容量
  */
void UDS_22Service_DID_60D1(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &EOL_Data_Type.DID_60D1, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID60D2
  *    电池管理系统
  */
void UDS_22Service_DID_60D2(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, &EOL_Data_Type.DID_60D2, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}





















