#include "Service_Drive_Time.h"
#include "Common_Interface.h"
_DriveTimeInitStruct     DriveTimeInitPara;
_DriveTimeScheduleStruct DriveTimeSchedule;
/**@brief DriveTime KL30 Init
* @author TYW - xinyu
* @param[in] mode            : WorkMode
* @param[in] BaseTime        : start count value
* @param[in] ESpeedStartThre : ESpeed effective value
* @param[in] VSpeedRunThre   : VSpeed effective value
* @param[in] ESpeedStopThre  : ESpeed failure value
* @param[in] VSpeedStopThre  : VSpeed failure value
* @since 1.0.0.0
*/
void Service_Drive_Timing_KL30Init(DriveTimerMode mode,uint32_t BaseTime,uint16_t ESpeedStartThre,uint16_t ESpeedStartThreHyst,uint16_t VSpeedRunThre,uint16_t VSpeedRunThreHyst)
{
    if(BaseTime>=59999994ul)
    {
    	DriveTimeInitPara.BaseTime = 59999994ul;
    }
    else
    {
    	DriveTimeInitPara.BaseTime = BaseTime;
    }
    if(mode == Mode_ESpeed)
    {
        if(ESpeedStartThre<=ESpeedStartThreHyst)
        {
            DriveTimeInitPara.Mode            = Mode_Unavailable;
            DriveTimeInitPara.ESpeedStartThre = 0u;
            DriveTimeInitPara.ESpeedStopThre  = 0u;
            DriveTimeInitPara.VSpeedRunThre   = 0u;
            DriveTimeInitPara.VSpeedStopThre  = 0u;
        }
        else
        {
            DriveTimeInitPara.Mode            = Mode_ESpeed;
            DriveTimeInitPara.ESpeedStartThre = ESpeedStartThre;
            DriveTimeInitPara.ESpeedStopThre  = ESpeedStartThre - ESpeedStartThreHyst;
            DriveTimeInitPara.VSpeedRunThre   = 0u;
            DriveTimeInitPara.VSpeedStopThre  = 0u;
        }
    }
    else if(mode == Mode_VSpeed)
    {
        if(VSpeedRunThre<=VSpeedRunThreHyst)
        {
            DriveTimeInitPara.Mode            = Mode_Unavailable;
            DriveTimeInitPara.VSpeedRunThre   = 0u;
            DriveTimeInitPara.VSpeedStopThre  = 0u;
            DriveTimeInitPara.ESpeedStartThre = 0u;
            DriveTimeInitPara.ESpeedStopThre  = 0u;
        }
        else
        {
            DriveTimeInitPara.Mode            = Mode_VSpeed;
            DriveTimeInitPara.VSpeedRunThre   = VSpeedRunThre;
            DriveTimeInitPara.VSpeedStopThre  = VSpeedRunThre - VSpeedRunThreHyst;
            DriveTimeInitPara.ESpeedStartThre = 0u;
            DriveTimeInitPara.ESpeedStopThre  = 0u;
        }
    }
    else if(mode == Mode_BothSpeed)
    {
        if((ESpeedStartThre<=ESpeedStartThreHyst)||(VSpeedRunThre<=VSpeedRunThreHyst) )
        {
            DriveTimeInitPara.Mode            = Mode_Unavailable;
            DriveTimeInitPara.VSpeedRunThre   = 0u;
            DriveTimeInitPara.VSpeedStopThre  = 0u;
            DriveTimeInitPara.ESpeedStartThre = 0u;
            DriveTimeInitPara.ESpeedStopThre  = 0u;
        }
        else
        {
            DriveTimeInitPara.Mode            = Mode_BothSpeed;
            DriveTimeInitPara.ESpeedStartThre = ESpeedStartThre;
            DriveTimeInitPara.ESpeedStopThre  = ESpeedStartThre - ESpeedStartThreHyst;
            DriveTimeInitPara.VSpeedRunThre   = VSpeedRunThre;
            DriveTimeInitPara.VSpeedStopThre  = VSpeedRunThre - VSpeedRunThreHyst;
        }
    }
    else
    {
        DriveTimeInitPara.Mode = mode;
        DriveTimeInitPara.VSpeedRunThre   = 0u;
        DriveTimeInitPara.VSpeedStopThre  = 0u;
        DriveTimeInitPara.ESpeedStartThre = 0u;
        DriveTimeInitPara.ESpeedStopThre  = 0u;
    }
    DriveTimeSchedule.TimerStatus      = Timer_OFF;
    DriveTimeSchedule.Timer_Min        = 0u;
    DriveTimeSchedule.Timer_ms         = 0u;
}
/**@brief Reset Drive Time
* @author TYW - xinyu
* @param[in]   NONE
* @return[out] NONE
* @since 1.0.0.0
*/
void Service_Drive_Timing_Reset(void)
{
    DriveTimeSchedule.TimerStatus         = Timer_OFF;
    DriveTimeSchedule.Timer_Min           = 0u;
    DriveTimeSchedule.Timer_ms            = 0u;
    DriveTimeInitPara.BaseTime            = 0u;
}
/**@brief Get Drive Time .unit:min
* @author TYW - xinyu
* @param[in]   NONE
* @return[out] Drive Time
* @since 1.0.0.0
*/
uint32_t Service_Drive_Timing_GetMin(void)
{
    return (DriveTimeInitPara.BaseTime+DriveTimeSchedule.Timer_Min);
}
/**@brief DriveTime Process
* @author TYW - xinyu
* @param[in] Nms     : Task In N*1ms
* @param[in] ESpeed  : Current ESpeed
* @param[in] VSpeed  : Current VSpeed
* @return[out] NONE
* @since 1.0.0.0
*/
void Service_Drive_Timing_Process(uint16_t Nms,uint16_t ESpeed,uint16_t VSpeed)
{
    if(Common_Get_IG_Sts_Valid() == COMMON_Valid)
    {
        if(Common_Get_IG_Sts() == COMMON_POWER_ON)
        {
            switch(DriveTimeInitPara.Mode)
            {
            	case Mode_IGNON:
            		if((DriveTimeSchedule.Timer_Min+DriveTimeInitPara.BaseTime)<59999994ul)
            		{
        	    		DriveTimeSchedule.TimerStatus = Timer_ON;
            		}
            		else
            		{
            			DriveTimeSchedule.TimerStatus = Timer_OFF;
            		}
            	break;
            	case Mode_VSpeed:
                    if((DriveTimeSchedule.Timer_Min+DriveTimeInitPara.BaseTime)<59999994ul)
                    {
                        if(VSpeed>=DriveTimeInitPara.VSpeedRunThre)
                        {
                            DriveTimeSchedule.TimerStatus = Timer_ON;
                        }
                        else if(VSpeed<DriveTimeInitPara.VSpeedStopThre)
                        {
                            DriveTimeSchedule.TimerStatus = Timer_OFF;
                        }
                        else
                        {
                            ;
                        }
                    }
                    else
            		{
            			DriveTimeSchedule.TimerStatus = Timer_OFF;
            		}
            	break;
            	case Mode_ESpeed:
                    if((DriveTimeSchedule.Timer_Min+DriveTimeInitPara.BaseTime)<59999994ul)
                    {
                        if(ESpeed>=DriveTimeInitPara.ESpeedStartThre)
                        {
                            DriveTimeSchedule.TimerStatus = Timer_ON;
                        }
                        else if(ESpeed<DriveTimeInitPara.ESpeedStopThre)
                        {
                            DriveTimeSchedule.TimerStatus = Timer_OFF;
                        }
                        else
                        {
                            ;
                        }
                    }
                    else
            		{
            			DriveTimeSchedule.TimerStatus = Timer_OFF;
            		}
            	break;
            	case Mode_BothSpeed:
                    if((DriveTimeSchedule.Timer_Min+DriveTimeInitPara.BaseTime)<59999994ul)
                    {
                        if((VSpeed>=DriveTimeInitPara.VSpeedRunThre) && (ESpeed>=DriveTimeInitPara.ESpeedStartThre) )
                        {
                            DriveTimeSchedule.TimerStatus = Timer_ON;
                        }
                        else if((VSpeed<DriveTimeInitPara.VSpeedStopThre) || (ESpeed<DriveTimeInitPara.ESpeedStopThre) )
                        {
                            DriveTimeSchedule.TimerStatus = Timer_OFF;
                        }
                        else
                        {
                            ;
                        }
                    }
                    else
            		{
            			DriveTimeSchedule.TimerStatus = Timer_OFF;
            		}
            	break;
            	default:
                    DriveTimeSchedule.TimerStatus = Timer_OFF;
            	break;
            }
            if(DriveTimeSchedule.TimerStatus == Timer_ON)
            {
                DriveTimeSchedule.Timer_ms   += Nms;
                if(DriveTimeSchedule.Timer_ms>=60000u)
                {
                    DriveTimeSchedule.Timer_ms   = DriveTimeSchedule.Timer_ms - 60000u;
                    DriveTimeSchedule.Timer_Min += 1u;
                }
                else
                {
                    ;
                }
            }
            else
            {
                ;
            }
        }
        else
        {
            DriveTimeSchedule.TimerStatus = Timer_OFF;
        }
    }
}
