/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : Buffer related inline functions
 ****************************************************************************
 * Version Control Information :
 *  $Revision: 3935 $
 *  $Date: 2014-09-23 10:52:32 +0200 (Di, 23. Sep 2014) $
 *  $LastChangedBy: golczewskim $
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/    

#ifndef DAVEHD_DRIVER_BUF_INL_H_INCLUDED
#define DAVEHD_DRIVER_BUF_INL_H_INCLUDED

/* PRQA S 3406 ++ *//* $Misra: #INLINE_FUNCTION_DEFINED_IN_HEADER $*/

/*----------------------------------------------------------------------------------------------------------*/
/* Return GPU pointer to buffer. Returns 0 on error (only when driver is compiled with DHD_DEBUG_MODE setting).*/
/* Returns a pointer to the top left corner of the buffer to be used for the GPU.*/
/**/
/* Parameters:*/
/*  a_buffer : Pointer to an allocated dhd_buffer_t (see dhd_alloc_buffer)*/
/**/
DHD_API_INLINE dhd_gpu_ptr_t dhd_get_buffer_gpuptr(const dhd_buffer_t *a_buffer) {
  #ifdef DHD_DEBUG_MODE
  /* validate parameters*/
  if (a_buffer == 0) {
    return 0;
  }
  #endif

  return a_buffer->m_memory.m_gpu_address;
}


/*----------------------------------------------------------------------------------------------------------*/

#endif /*DAVEHD_DRIVER_BUF_INL_H_INCLUDED*/
