#include "None_NM.h"
#include "RTE_CAN_NM.h"

NM_Mode_t NM_Mode_Status;
uint32_t NM_Idle_Timer;


void None_NM_Init(void)
{
    NM_Mode_Status = NM_Mode_Sleep;
    NM_Idle_Timer = 0u;
}
/*
50us ++
4s
4000ms
4000000us
0080000 tick
*/
void None_NM_Service(void)
{
    uint8_t m_conditon;
    m_conditon = RTE_CAN_GetBusStatus();
    if (m_conditon == 1u)
    {
        NM_Mode_Status = NM_Mode_Wakeup;
        NM_Idle_Timer = 0u;
    }
    else
    {
        if (NM_Idle_Timer <= 1600000ul) /*休眠唤醒*/
        {
            NM_Idle_Timer++;
        }
        else
        {
            NM_Mode_Status = NM_Mode_Sleep;
        }
    }
}

NM_Mode_t None_NM_Mode(void)
{
    return NM_Mode_Status;
}



void None_NM_Request(void)
{
    NM_Mode_Status = NM_Mode_Wakeup;
    NM_Idle_Timer = 0u;
}
void None_NM_Release(void)
{

}