#include "GPIO.h"
#include "dr7f701441.dvf.h"

#include "RTE_CAN.h"
#include "CAN_Communication_Matrix.h"
#include "CAN_FUNC.h"
#include "CAN_Lib.h"
//#include "CAN_Signal_Tx.h"
#include "AlarmGeneralFilie.h"
#include "Diag_ID_Def.h"
#include "DoCAN_ISO15765.h"

#include "PowerManagement.h"
#include "UDS_Common.h"

#include "Watchdog.h"
#include "RSCAN.h"
#include "Link_Layer.h"
#include "kwp2000_service.h"

static uint16_t Can_Init_Lock = 0U;

void Can_Lock_Clr(void)
{
    Can_Init_Lock = 0u;
}

/***Middle***/
void Can_Init(void)
{
    /* filter 变量声明 */
    uint32_t IDFilterNum;

    uint8_t CH0_IDFilterNum;
    uint32_t CANLLCCh0NMIDRange[2];
    uint32_t CANLLCCh0MsgIDList[ID_TOTAL_MAX + 2u];
    uint32_t CANLLCCh0OwnIDList[4];

    uint32_t i;
    RSCAN0_Config_st_t CANLLCCh0Filter;

    CANLLCCh0Filter.stRSCANCh0.u32RSCANChEn = 1u;       /*通道是否使能*/
    if (K_Line_Set.K_Line_LID52 == 0x00u)
    {
        CANLLCCh0Filter.stRSCANCh0.enRSCANChBps = RSCAN_Baud_Rate_500K;       /*通道波特率*/
    }
    else if (K_Line_Set.K_Line_LID52 == 0x01u)
    {
        CANLLCCh0Filter.stRSCANCh0.enRSCANChBps = RSCAN_Baud_Rate_250K;       /*通道波特率*/
    }
    CANLLCCh0Filter.stRSCANCh0.u32RSCANChRuleSize = CANFD0_CH0_RX_RULE_SIZE; /*通道接收规则条数*/
    CANLLCCh0Filter.stRSCANCh0.pfnRSCANConfirmCallBack = Can_Confirm;  /*发送确认*/
    CANLLCCh0Filter.stRSCANCh0.pfnRSCANAbortConfirmCallBack = 0u; /*发送中止确认*/
    CANLLCCh0Filter.stRSCANCh0.pfnRSCANReadMsgCallBack = Can_Read_Msg; /*接收完成*/

    CANLLCCh0Filter.stRSCANCh1.u32RSCANChEn = 0u;       /*通道是否使能*/
    CANLLCCh0Filter.stRSCANCh1.enRSCANChBps = RSCAN_Baud_Rate_500K;       /*通道波特率*/
    CANLLCCh0Filter.stRSCANCh1.u32RSCANChRuleSize = CANFD0_CH1_RX_RULE_SIZE; /*通道接收规则条数*/
    CANLLCCh0Filter.stRSCANCh1.pfnRSCANConfirmCallBack = 0u;  /*发送确认*/
    CANLLCCh0Filter.stRSCANCh1.pfnRSCANAbortConfirmCallBack = 0u; /*发送中止确认*/
    CANLLCCh0Filter.stRSCANCh1.pfnRSCANReadMsgCallBack = 0u; /*接收完成*/

    CANLLCCh0Filter.stRSCANCh2.u32RSCANChEn = 1u;       /*通道是否使能*/
    CANLLCCh0Filter.stRSCANCh2.enRSCANChBps = RSCAN_Baud_Rate_500K;       /*通道波特率*/
    CANLLCCh0Filter.stRSCANCh2.u32RSCANChRuleSize = CANFD0_CH2_RX_RULE_SIZE; /*通道接收规则条数*/
    CANLLCCh0Filter.stRSCANCh2.pfnRSCANConfirmCallBack = Can_Confirm2;  /*发送确认*/
    CANLLCCh0Filter.stRSCANCh2.pfnRSCANAbortConfirmCallBack = 0u; /*发送中止确认*/
    CANLLCCh0Filter.stRSCANCh2.pfnRSCANReadMsgCallBack = Can_Read_Msg2; /*接收完成*/

    CANSTB_OUT  = 1U; /*CANSTB_OUT*/
    CANSTB2_OUT = 1U; /*CANSTB2_OUT*/

    RSCAN0_CH_Init(CANFD_RX_RULE_TABLE_LIST, &CANLLCCh0Filter);

    CANSTB_OUT  = 0U; /*CANSTB_OUT*/
    CANSTB2_OUT = 0U; /*CANSTB2_OUT*/
}

void Can_DeInit(void)
{
}

uint8_t Can_Write(_CAN_Msg *Msg)
{
    uint8_t i = 0u;
    CAN_Frame_st_t CANFrame;

    for (i = 0; i < 8u; i++)
    {
        CANFrame.unCANData.u8CANData[i] = Msg->Msg[i];
    }

    CANFrame.u32CANID = Msg->MsgID;
    CANFrame.u8CANLEN = Msg->MsgDLC;
    CANFrame.u8CANFrameIDE = Msg->MsgStd;


    if (Msg->MsgPro < RSCAN_CHANNEL_BUF_2)
    {
        RSCAN0_CH2_Set_TXBUF_Data(Msg->MsgPro, &CANFrame);
    }
    else if (Msg->MsgPro < RSCAN_CHANNEL_BUF_MAX)
    {
        RSCAN0_CH0_Set_TXBUF_Data(Msg->MsgPro, &CANFrame);
    }
    else if ((Msg->MsgPro >= 25u) && (Msg->MsgPro <= 27u))
    {
        RSCAN0_CH2_Set_FIFO0_Data(&CANFrame);
    }
    else
    {
        RSCAN0_CH0_Set_FIFO0_Data(&CANFrame);
    }

    return 0;
}

void Can_Sleep_Fun(void)
{
}

void Can_SleepController_Fun(void)
{
}

void Can_Wakeup_Fun(void)
{
}

/*诊断发送终止----20220320----*/
void Can_Uds_Abort(void)
{
    //CANFD_SetTX_Abort();
    RSCAN0_CH2_Abort(RSCAN_CHANNEL_BUF_0);
    RSCAN0_CH2_Abort(RSCAN_CHANNEL_BUF_1);
}

void Can_Abort_All(void)
{
}

/*****Lower*******/
void Can_Read_Msg(uint32_t m_id, uint8_t m_dlc, uint8_t m_Msg[])
{
    ReceivedMsg(m_id, m_dlc);

    Co_Can_Buff_Set(Co_Can_ConvertSubID(m_id), m_dlc, m_Msg);

    //if ((m_id == DIAG_ID_Rx_FUN) || (m_id == DIAG_ID_Rx_PHY))
    //{
    //    DoCAN_L_Data_Indication(m_id, m_dlc, m_Msg);
    //}
}

void Can_Read_Msg2(uint32_t m_id, uint8_t m_dlc, uint8_t m_Msg[])
{
    if (m_id == DIAG_ID_Rx_PHY)
    {
        LK_Link_main(DIAG_ID_Rx_PHY, (uint8_t*)m_Msg, (m_dlc & 0x0f));
    }
    if ((m_id == DIAG_ID_Rx_FUN) || (m_id == DIAG_ID_Rx_PHY))
    {
        DoCAN_L_Data_Indication(m_id, m_dlc, m_Msg);
    }
}

void Can_Confirm(uint32_t Identifier, uint8_t TransferStatus)
{
    switch (Identifier)
    {
    case RSCAN_CHANNEL_BUF_0:
        break;
    case RSCAN_CHANNEL_BUF_1:
        break;
    case RSCAN_CHANNEL_BUF_2:
        break;
    case RSCAN_CHANNEL_BUF_3:
        break;
    case RSCAN_CHANNEL_BUF_4:
        break;
    case RSCAN_CHANNEL_BUF_5:
        break;
    case RSCAN_CHANNEL_BUF_6:
        break;
    case RSCAN_CHANNEL_BUF_7:
        break;
    case RSCAN_CHANNEL_BUF_8:
        break;
    case RSCAN_CHANNEL_BUF_9:
        break;
    case RSCAN_CHANNEL_BUF_10:
        break;
    case RSCAN_CHANNEL_BUF_11:
        break;
    case RSCAN_CHANNEL_BUF_12:  Can_Msg_TX_SUCCESS(MSGID_18FFE517);
        break;
    case RSCAN_CHANNEL_BUF_13:
        break;
    default :
        break;
    }
}

void Can_Confirm2(uint32_t Identifier, uint8_t TransferStatus)
{
    switch (Identifier)
    {
    case RSCAN_CHANNEL_BUF_0: DoCAN_L_Data_Confirm(DIAG_ID_Tx, 1u);
        break;
    case RSCAN_CHANNEL_BUF_1: DoCAN_L_Data_Confirm(DIAG_ID_Tx, 1u);
        break;
    case RSCAN_CHANNEL_BUF_2: DoCAN_L_Data_Confirm(DIAG_ID_Tx, 1u);
        break;
    case RSCAN_CHANNEL_BUF_3:
        break;
    case RSCAN_CHANNEL_BUF_4:
        break;
    case RSCAN_CHANNEL_BUF_5:
        break;
    case RSCAN_CHANNEL_BUF_6:
        break;
    case RSCAN_CHANNEL_BUF_7:
        break;
    case RSCAN_CHANNEL_BUF_8:
        break;
    case RSCAN_CHANNEL_BUF_9:
        break;
    case RSCAN_CHANNEL_BUF_10:
        break;
    case RSCAN_CHANNEL_BUF_11:
        break;
    case RSCAN_CHANNEL_BUF_12:
        break;
    case RSCAN_CHANNEL_BUF_13:
        break;
    default :
        break;
    }
}


void CAN_BUSOFF_Recover(void)
{
    //CH0_BusOff_Recovery();
    RSCAN0_CH0_Busoff_Recover();
    RSCAN0_CH2_Busoff_Recover();
}
