/**********************************************************************************************************
* @file    loc_graphics_data.h
* @author  HZS
* @version V1.0.0
* @date    2021.04.09
* @brief   c header file
********************************************************************************************************/
#ifndef LOC_GRAPHICS_DATA_H_
#define LOC_GRAPHICS_DATA_H_

#include "loc_graphics_def.h"
#include "images.h"
#include "DisplaySch_user.h"

/*区域1 WET*/
#define MAX_WET_SUP_LAYER        25
MultiBufferSprite_t WETSpriteBuf;
uint8_t             WETIndex = 0u;
uint8_t             WETUpdate = 0u;
uint8_t             WETEn = 0u;
LogicLayerAttr_t    WETLogicLayerAttr[MAX_WET_SUP_LAYER];

/*区域1 AdBlue*/
#define MAX_ADBLUE_SUP_LAYER        10
MultiBufferSprite_t AdBlueSpriteBuf;
uint8_t             AdBlueIndex = 0u;
uint8_t             AdBlueUpdate = 0u;
uint8_t             AdBlueEn = 0u;
LogicLayerAttr_t    AdBlueLogicLayerAttr[MAX_ADBLUE_SUP_LAYER];

/*区域2 TRIP*/
#define MAX_TRIP_SUP_LAYER        15
MultiBufferSprite_t TRIPSpriteBuf;
uint8_t             TRIPIndex = 0u;
uint8_t             TRIPUpdate = 0u;
uint8_t             TRIPEn = 0u;
LogicLayerAttr_t    TRIPLogicLayerAttr[MAX_TRIP_SUP_LAYER];

/*区域2 ODO*/
#define MAX_ODO_SUP_LAYER        10
MultiBufferSprite_t ODOSpriteBuf;
uint8_t             ODOIndex = 0u;
uint8_t             ODOUpdate = 0u;
uint8_t             ODOEn = 0u;
LogicLayerAttr_t    ODOLogicLayerAttr[MAX_ODO_SUP_LAYER];

/*区域3 警告灯*/
#define MAX_WARNINGLIGHT_SUP_LAYER        10
MultiBufferSprite_t WarningLightSpriteBuf;
uint8_t             WarningLightIndex = 0u;
uint8_t             WarningLightUpdate = 0u;
uint8_t             WarningLightEn = 0u;
LogicLayerAttr_t    WarningLightLogicLayerAttr[MAX_WARNINGLIGHT_SUP_LAYER];

/*区域4 ADAS*/
#define MAX_ADAS_SUP_LAYER        15
MultiBufferSprite_t ADASSpriteBuf;
uint8_t             ADASIndex = 0u;
uint8_t             ADASUpdate = 0u;
uint8_t             ADASEn = 0u;
LogicLayerAttr_t    ADASLogicLayerAttr[MAX_ADAS_SUP_LAYER];

/*区域5 行车电脑*/
#define MAX_MULTIPURPOSE_SUP_LAYER        20
MultiBufferSprite_t MultiPurposeSpriteBuf;
uint8_t             MultiPurposeIndex = 0u;
uint8_t             MultiPurposeUpdate = 0u;
uint8_t             MultiPurposeEn = 0u;
LogicLayerAttr_t    MultiPurposeLogicLayerAttr[MAX_MULTIPURPOSE_SUP_LAYER];

/*区域6 定速巡航图标*/
#define MAX_CRUISE_SUP_LAYER        6
MultiBufferSprite_t CruiseSpriteBuf;
uint8_t             CruiseIndex = 0u;
uint8_t             CruiseUpdate = 0u;
uint8_t             CruiseEn = 0u;
LogicLayerAttr_t    CruiseLogicLayerAttr[MAX_CRUISE_SUP_LAYER];

/*区域7 挡位*/
#define MAX_GEAR_SUP_LAYER        5
MultiBufferSprite_t GearSpriteBuf;
uint8_t             GearIndex = 0u;
uint8_t             GearUpdate = 0u;
uint8_t             GearEn = 0u;
LogicLayerAttr_t    GearLogicLayerAttr[MAX_GEAR_SUP_LAYER];

/*区域8 室外温度*/
#define MAX_TEMP_SUP_LAYER        10
MultiBufferSprite_t TempSpriteBuf;
uint8_t             TempIndex = 0u;
uint8_t             TempUpdate = 0u;
uint8_t             TempEn = 0u;
LogicLayerAttr_t    TempLogicLayerAttr[MAX_TEMP_SUP_LAYER];

/*区域8 时间*/
#define MAX_TIME_SUP_LAYER        5
MultiBufferSprite_t TimeSpriteBuf;
uint8_t             TimeIndex = 0u;
uint8_t             TimeUpdate = 0u;
uint8_t             TimeEn = 0u;
LogicLayerAttr_t    TimeLogicLayerAttr[MAX_TIME_SUP_LAYER];

/*区域8 年月日*/
#define MAX_CALENDAR_SUP_LAYER        15
MultiBufferSprite_t CalendarSpriteBuf;
uint8_t             CalendarIndex = 0u;
uint8_t             CalendarUpdate = 0u;
uint8_t             CalendarEn = 0u;
LogicLayerAttr_t    CalendarLogicLayerAttr[MAX_CALENDAR_SUP_LAYER];

/**/
#define MAX_MENU_SUP_LAYER        115
MultiBufferSprite_t MENUSpriteBuf;
uint8_t             MENUIndex = 0u;
uint8_t             MENUUpdate = 0u;
uint8_t             MENUEn = 0u;
LogicLayerAttr_t    MENULogicLayerAttr[MAX_MENU_SUP_LAYER];

static const SpritesHandler_t SpriteHandler[Max_Sprite] =
{
    {WET_Sprite,          { 38u, 364u, 326u,  60u, 1u}, TARGET_SDRAM, &WETSpriteBuf,          &WETIndex,          WETLogicLayerAttr,          MAX_WET_SUP_LAYER         , &WETUpdate,            &WETEn,          GUI_DisplayServices},
    {AdBlue_Sprite,       { 38u, 428u, 326u,  48u, 1u}, TARGET_SDRAM, &AdBlueSpriteBuf,       &AdBlueIndex,       AdBlueLogicLayerAttr,       MAX_ADBLUE_SUP_LAYER      , &AdBlueUpdate,         &AdBlueEn,       R_NULL},
    {TRIP_Sprite,         {438u, 374u, 322u,  48u, 1u}, TARGET_SDRAM, &TRIPSpriteBuf,         &TRIPIndex,         TRIPLogicLayerAttr,         MAX_TRIP_SUP_LAYER        , &TRIPUpdate,           &TRIPEn,         R_NULL},
    {ODO_Sprite,          {438u, 424u, 324u,  42u, 1u}, TARGET_SDRAM, &ODOSpriteBuf,          &ODOIndex,          ODOLogicLayerAttr,          MAX_ODO_SUP_LAYER         , &ODOUpdate,            &ODOEn,          R_NULL},
    {WarningLight_Sprite, {  8u,  88u,  82u, 264u, 1u}, TARGET_SDRAM, &WarningLightSpriteBuf, &WarningLightIndex, WarningLightLogicLayerAttr, MAX_WARNINGLIGHT_SUP_LAYER, &WarningLightUpdate,   &WarningLightEn, R_NULL},
    {ADAS_Sprite,         {112u,  94u, 254u, 260u, 1u}, TARGET_SDRAM, &ADASSpriteBuf,         &ADASIndex,         ADASLogicLayerAttr,         MAX_ADAS_SUP_LAYER        , &ADASUpdate,           &ADASEn,         R_NULL},
    {MultiPurpose_Sprite, {382u, 182u, 410u, 176u, 1u}, TARGET_SDRAM, &MultiPurposeSpriteBuf, &MultiPurposeIndex, MultiPurposeLogicLayerAttr, MAX_MULTIPURPOSE_SUP_LAYER, &MultiPurposeUpdate ,  &MultiPurposeEn, R_NULL},
    {Cruise_Sprite,       {382u,  84u, 230u,  92u, 1u}, TARGET_SDRAM, &CruiseSpriteBuf,       &CruiseIndex,       CruiseLogicLayerAttr,       MAX_CRUISE_SUP_LAYER      , &CruiseUpdate,         &CruiseEn,       R_NULL},
    {Gear_Sprite,         {622u,  86u, 170u,  94u, 1u}, TARGET_SDRAM, &GearSpriteBuf,         &GearIndex,         GearLogicLayerAttr,         MAX_GEAR_SUP_LAYER        , &GearUpdate,           &GearEn,         R_NULL},
    {Temp_Sprite,         { 26u,  12u, 258u,  70u, 1u}, TARGET_SDRAM, &TempSpriteBuf,         &TempIndex,         TempLogicLayerAttr,         MAX_TEMP_SUP_LAYER        , &TempUpdate,           &TempEn,         R_NULL},
    {Time_Sprite,         {330u,  14u, 140u,  66u, 1u}, TARGET_SDRAM, &TimeSpriteBuf,         &TimeIndex,         TimeLogicLayerAttr,         MAX_TIME_SUP_LAYER        , &TimeUpdate,           &TimeEn,         R_NULL},
    {Calendar_Sprite,     {508u,  16u, 284u,  64u, 1u}, TARGET_SDRAM, &CalendarSpriteBuf,     &CalendarIndex,     CalendarLogicLayerAttr,     MAX_CALENDAR_SUP_LAYER    , &CalendarUpdate,       &CalendarEn,     R_NULL},
    {MENU_Sprite,         {100u,  82u, 694u, 278u, 1u}, TARGET_SDRAM, &MENUSpriteBuf,         &MENUIndex,         MENULogicLayerAttr,         MAX_MENU_SUP_LAYER        , &MENUUpdate,           &MENUEn,         R_NULL},
};

/*AutoCreateEnd*/
static const r_screen_attr_t ScreenAttr =
{
    800, 480, 896,      /* JEPG Window*/
    800, 480, 896,      /* Loc Window*/
    5,                  /* 刷新时间，50ms*/
    12,                 /* 主屏幕Sprite数量*/
    Max_Sprite,         /* 全部Sprite数量*/
    SpriteSize          /* 最大的图片数量*/
};

#endif