#include "UDS_2FService_Filter.h"

uint16_t S2FDLC[] = {1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,	   1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u,      1u     };
uint16_t S2FDID[] = {0x6048u, 0x6091u, 0x6046u, 0x6040u, 0x6092u, 0x6020u, 0x6093u, 0x6021u, 0x6094u, 0x601Bu, 0x601Cu, 0x601Du, 0x601Eu, 0x6038u, 0x601Au, 0x6095u, 0x6024u, 0x6025u, 0x603Du, 0x6035u, 0x6036u, 0x6034u, 0x6028u, 0x6090u, 0x6037u, 0x6022u, 0x601Fu, 0x6096u, 0x6097u, 0x6098u, 0x603Bu, 0x6018u, 0x6099u, 0x609Au, 0x604Bu, 0x609Bu, 0x6047u, 0x6026u, 0x6030u, 0x602Bu, 0x609Cu, 0x609Du, 0x609Eu, 0x609Fu, 0x60A0u, 0x60A1u, 0x6051u, 0x6052u, 0x60A3u, 0x60A4u, 0x60A5u, 0x60A6u, 0x60A7u, 0x60A8u, 0x60A9u, 0x6043u, 0x60ACu, 0x60ADu, 0x60AEu, 0x60AFu, 0x60B0u, 0x60B1u, 0x60B2u, 0x60B3u, 0x60B4u, 0x60B5u, 0x60B6u, 0x60B7u, 0x60B8u, 0x60B9u, 0x60BAu, 0x60BBu, 0x60BCu, 0x60BDu, 0x60BEu, 0x60BFu, 0x60C0u, 0x60C1u, 0x60C2u, 0x60C3u, 0x60C4u, 0x60C5u, 0x60C6u, 0x60C7u, 0x6065u, 0x6066u, 0x606Au, 0x606Bu, 0x606Cu, 0x6077u};

/**
  *2F服务是否支持功能寻址
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_2FService_NRC11(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgID == DIAG_ID_Rx_FUN)
    {
        NRC = serviceNotSupported;
    }
    return NRC;
}

/**
  *2F服务会话是否支持验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_2FService_NRC7F(void)
{
    uint8_t NRC = positiveResponse;
    if(getSessionType() == DefaultSession)
    {
        NRC = serviceNotSupportedInActiveSession;
        if(DiagMSG.msgID == DIAG_ID_Rx_PHY)
        {
            UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *2F服务解锁等级验证
  *@return 负反馈编号
  */
uint8_t UDS_2FService_NRC33(void)
{
    uint8_t NRC = positiveResponse;
    if(getSecurityLevel(1) == NormalKeyUnlock)
    {
        NRC = positiveResponse;
    }
    else
    {
        NRC = securityAccessDenied;
        UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }  
    return NRC;
}

/**
  *2F服务最小长度验证
  *@return 负反馈编号
  */
uint8_t UDS_2FService_NRC13_MinLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgDLC < 2u)
    {
        NRC = incorrectMessageLength;
        UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *2F服务超出请求范围验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_2FService_NRC31(void)
{
    uint8_t NRC;
    uint8_t i;
    NRC = requestOutOfRange;
    for(i = 0; i < DIM(S2FDID);i++)
    {
        if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == S2FDID[i])
        {
            NRC = positiveResponse;
        }        
    }
    if((NRC == requestOutOfRange) && (DiagMSG.msgID == DIAG_ID_Rx_PHY))
    {
        UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    return NRC;
}


/**
  *2F服务子参数超出请求范围验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_2FService_SubParameter_NRC31(void)
{
    uint8_t NRC;
    NRC = requestOutOfRange;
    if(DiagMSG.msgData.DidDetail.Data[0] == 0u)
    {
        NRC = positiveResponse;
    }
    if(DiagMSG.msgData.DidDetail.Data[0] == 3u)
    {
        if((DiagMSG.msgData.DidDetail.Data[1] == 0x00u) || (DiagMSG.msgData.DidDetail.Data[1] == 0xFFu))
        {
            NRC = positiveResponse;
        }
    }    
    /*if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == 0x62E1u)
    {
        if(DiagMSG.msgData.DidDetail.Data[0] == 0u)
        {
            NRC = positiveResponse;
        }
        if(DiagMSG.msgData.DidDetail.Data[0] == 3u)
        {
            if((DiagMSG.msgData.DidDetail.Data[1] == 0x00u) || (DiagMSG.msgData.DidDetail.Data[1] == 0xFFu))
            {
                NRC = positiveResponse;
            }
        }
    }
    if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == 0x62E2u)
    {
        if(DiagMSG.msgData.DidDetail.Data[0] == 0u)
        {
             NRC = positiveResponse;
        }
        if(DiagMSG.msgData.DidDetail.Data[0] == 3u)
        {
            if((DiagMSG.msgData.DidDetail.Data[1] >= 0x01u) && (DiagMSG.msgData.DidDetail.Data[1] <= 0x04u))
            {
                if(DiagMSG.msgData.DidDetail.Data[2] <= 0x02u)
                {
                    NRC = positiveResponse;
                }
            }
        }
    }
    if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == 0x62E4u)
    {
        if(DiagMSG.msgData.DidDetail.Data[0] == 0u)
        {
            NRC = positiveResponse;
        }
        if(DiagMSG.msgData.DidDetail.Data[0] == 3u)
        {
            if((DiagMSG.msgData.DidDetail.Data[1] == 0x00u) || (DiagMSG.msgData.DidDetail.Data[1] == 0xFFu))
            {
                NRC = positiveResponse;
            }
        }
    }*/
    if((NRC == requestOutOfRange) && (DiagMSG.msgID == DIAG_ID_Rx_PHY))
    {
        UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    return NRC;
}

/**
  *2F服务总长度长度验证
  *@return 负反馈编号
  */
uint8_t UDS_2FService_NRC13_TotalLengthCheck(void)
{
    uint8_t i;
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgData.DidDetail.Data[0] == 0u)
    {
        if(DiagMSG.msgDLC != 3u)
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
    }
    else
    {
       for(i = 0u; i < DIM(S2FDID); ++i)
        {
            if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == S2FDID[i])
            {
                if(DiagMSG.msgDLC != (S2FDLC[i] + 3))
                {
                    NRC = incorrectMessageLength;
                    UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
                }
                else
                {
                    NRC = positiveResponse;
                }
                break;
            }
        } /**/
    }
    return NRC;
}

/**
  *2F服务条件验证
  *@return 负反馈编号
  */
uint8_t UDS_2FService_NRC22(void)
{
    uint8_t NRC = positiveResponse;
    if(getSpeed() > 0u)
    {
        NRC = conditionsNotCorrect;
        UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    /*else if(getESpeed() > 400u)
    {
        NRC = conditionsNotCorrect;
        UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }*/
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}
