#include "Data_CoolantTemperature.h"

//-------------------------------------------
//水温滤波 zhouhang
//-------------------------------------------

#define COOLANT_FILTER_SLOW 200
#define COOLANT_FILTER_FAST 25




uint8_t Coolant_Temp_Filter(uint8_t ObjSeg, uint8_t Valid)
{
	static uint8_t Timer = 0u;
	static uint8_t Timer_group= 0u;//Timer_group == 1 代表格数上行计时，2代表下行计时
	static uint8_t CurSeg = 0u;

	if (Valid == 0u)
	{
		CurSeg = 0u;
		Timer = 0u;
		Timer_group = 0u;
	}
	else
	{
		if (ObjSeg > CurSeg)//上行
		{
			if (Timer_group != 1u)
			{
				Timer_group = 1u;
				Timer = 0u;
			}
			else
			{
				Timer++;
			}

			if ((ObjSeg - CurSeg) == 1u)
			{
				if (Timer > COOLANT_FILTER_SLOW)
				{
					CurSeg++;
					Timer = 0u;
				}
			}
			else
			{
				if (Timer > COOLANT_FILTER_FAST)
				{
					CurSeg++;
					Timer = 0u;
				}
			}
		}
		
		else if (ObjSeg == CurSeg)//保持
		{
			Timer = 0u;
		}
		
		else//下行
		{
			if (Timer_group != 2u)
			{
				Timer_group = 2u;
				Timer = 0u;
			}
			else
			{
				Timer++;
			}

			if (Timer > COOLANT_FILTER_FAST)
			{
				CurSeg--;
				Timer = 0u;
			}
		}
	}

	return CurSeg;
}



