#include "GUI_VC66_Popup.h"
#include "GUI_VC66_General.h"

#include "Popup_Message_List.h"
#include "Popup_Scheduler.h"
#include "Popups.h"

//---------------------------------------------------------
//wangboyu 2021年8月25日15:13:52
//---------------------------------------------------------
//347
//---------------------------------------------------------
//弹出报警显示
//---------------------------------------------------------

static void Popups_Displaying(uint8_t PopupMsg);
static void GUI_General_Popup_Display(uint16_t PopupMsg);
static void GUI_Torque_Speed_Popup_Display(void);
static void GUI_AdBule_anomaly_Popup_Display(void);




typedef struct 
{
    uint16_t Background     ;   //背景
    uint16_t Image          ;   //图片
    uint16_t firstText[3u]  ;   //文字1
    uint16_t secondText[3u] ;   //文字2
}GUIGeneralPopupStruct ;
/*************************************************************************************************************
报警显示表
*************************************************************************************************************/
static const GUIGeneralPopupStruct GUIGeneralPopupTable[] =
{

    {/*00 紧急警报-刹车*/
        CN_Alarm_01_image ,
        SpriteSize ,
        {CN_Alarm_01_wenzi1,CN_Alarm_01_wenzi1 ,CN_Alarm_01_wenzi1 },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    
    {/*01 紧急警报-紧急制动*/
        CN_Alarm_01_image ,
        SpriteSize ,
        {CN_Alarm_01_wenzi4 ,CN_Alarm_01_wenzi4  ,CN_Alarm_01_wenzi4  },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*02 车间距警报-刹车(红字)*/
        CN_Alarm_01_imageblack ,
        SpriteSize ,
        {CN_Alarm_01_wenzi2,CN_Alarm_01_wenzi2 ,CN_Alarm_01_wenzi2 },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*03 车间距警报-碰撞报警*/
        CN_Alarm_01_imageblack ,
        SpriteSize ,
        {CN_Alarm_01_wenzi5,CN_Alarm_01_wenzi5 ,CN_Alarm_01_wenzi5 },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*04 车间距警报-刹车(黄字)*/
        CN_Alarm_01_imageblack ,
        SpriteSize ,
        {CN_Alarm_01_wenzi3,CN_Alarm_01_wenzi3 ,CN_Alarm_01_wenzi3 },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*05 ASR工作*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_04_image ,
        {CN_Alarm_drive_04_wenzi ,CN_Alarm_drive_04_wenzi  ,CN_Alarm_drive_04_wenzi  },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
	/**2**/
    {/*06 PTO紧急警报-刹车*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_05_image ,
        {CN_Alarm_drive_05_wenzi,CN_Alarm_drive_05_wenzi ,CN_Alarm_drive_05_wenzi },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*07 忘记松手刹车*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_06_image ,
        {CN_Alarm_drive_06_wenzi,CN_Alarm_drive_06_wenzi ,CN_Alarm_drive_06_wenzi },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*08 遥控调整车辆高度(有车速)*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_10_image ,
        {CN_Alarm_drive_10_wenzi,CN_Alarm_drive_10_wenzi ,CN_Alarm_drive_10_wenzi },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
	/**3**/
    {/*09 自动巡航模式*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_12_image ,
        {CN_Alarm_drive_12_wenzi,CN_Alarm_drive_12_wenzi ,CN_Alarm_drive_12_wenzi },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*10 可变SLD 模式*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_14_image ,
        {CN_Alarm_drive_14_wenzi ,CN_Alarm_drive_14_wenzi  ,CN_Alarm_drive_14_wenzi  },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
	
	/**4**/
    {/*11 充电异常（系统检测）*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_TST_2_image ,
        {CN_Alarm_TST_1_wenzi,CN_Alarm_TST_1_wenzi ,CN_Alarm_TST_1_wenzi },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*12 油压（系统检测）*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_TST_1_image       ,
        {CN_Alarm_TST_1_wenzi,CN_Alarm_TST_1_wenzi ,CN_Alarm_TST_1_wenzi },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*13 AMT初始化异常*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_TST_3_image    ,
        {CN_Alarm_TST_3_wenzi1,CN_Alarm_TST_3_wenzi1 ,CN_Alarm_TST_3_wenzi1 },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*14 尿素品质异常（系统检测）*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_TST_5_image    ,
        {CN_Alarm_TST_1_wenzi,CN_Alarm_TST_1_wenzi ,CN_Alarm_TST_1_wenzi },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*15 尿素喷射异常（系统检测）*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_TST_6_image    ,
        {CN_Alarm_TST_1_wenzi,CN_Alarm_TST_1_wenzi ,CN_Alarm_TST_1_wenzi },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*16 尿素水补给（系统检测）*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_TST_7_image    ,
        {CN_Alarm_TST_1_wenzi    ,CN_Alarm_TST_1_wenzi       ,CN_Alarm_TST_1_wenzi       },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*17 AMT初始化结束*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_TST_4_image    ,
        {CN_Alarm_TST_4_wenzi1,CN_Alarm_TST_4_wenzi1 ,CN_Alarm_TST_4_wenzi1 },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*18 DPD自动再生*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_TST_8_image    ,
        {CN_Alarm_TST_1_wenzi,CN_Alarm_TST_1_wenzi ,CN_Alarm_TST_1_wenzi },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
	
	
	/**5**/
    {/*19 过热（过热，请在安全的场所停车）*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_1_image       ,
        {CN_Alarm_G5_1_wenzi1      ,CN_Alarm_G5_1_wenzi1       ,CN_Alarm_G5_1_wenzi1       },
        {CN_Alarm_G5_1_wenzi2      ,CN_Alarm_G5_1_wenzi2       ,CN_Alarm_G5_1_wenzi2       },
    },
    {/*20 过热（冷却液温度过高）*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_1_image              ,
        {CN_Alarm_G5_1_wenzi3            ,CN_Alarm_G5_1_wenzi3             ,CN_Alarm_G5_1_wenzi3             },
        {CN_Alarm_G5_1_wenzi4            ,CN_Alarm_G5_1_wenzi4             ,CN_Alarm_G5_1_wenzi4             },
    },  
    {/*21 冷却水（冷却液不足）*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_2_image          ,
        {CN_Alarm_G5_2_image2      ,CN_Alarm_G5_2_image2       ,CN_Alarm_G5_2_image2       },
        {CN_Alarm_G5_2_wenzi1      ,CN_Alarm_G5_2_wenzi1       ,CN_Alarm_G5_2_wenzi1       },
    },
    {/*22 冷却水（冷却水不足）*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_2_image          ,
        {CN_Alarm_G5_2_wenzi   	  ,CN_Alarm_G5_2_wenzi       ,CN_Alarm_G5_2_wenzi       },
        {CN_Alarm_G5_2_wenzi2     ,CN_Alarm_G5_2_wenzi2      ,CN_Alarm_G5_2_wenzi2      },
    },
    {/*23 油压(机油)请在安全场所停车*/
        CN_Alarm_01_imageblack    ,
        CN_Alarm_G5_3_mage       ,
        {CN_Alarm_G5_3_wenzi1      ,CN_Alarm_G5_3_wenzi1       ,CN_Alarm_G5_3_wenzi1       },
        {CN_Alarm_G5_3_wenzi4      ,CN_Alarm_G5_3_wenzi4       ,CN_Alarm_G5_3_wenzi4    },
    },
    {/*24 油压异常*/
        CN_Alarm_01_imageblack    ,
        CN_Alarm_G5_3_mage    ,
        {CN_Alarm_G5_3_wenzi3      ,CN_Alarm_G5_3_wenzi3       ,CN_Alarm_G5_3_wenzi3      },
        {CN_Alarm_G5_3_wenzi2      ,CN_Alarm_G5_3_wenzi2       ,CN_Alarm_G5_3_wenzi2       },
    },
    {/*25 仪表故障-请在安全场所停车*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_4_image          ,
        {CN_Alarm_G5_4_wenzi1      ,CN_Alarm_G5_4_wenzi1       ,CN_Alarm_G5_4_wenzi1       },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*26 仪表故障-请与五十铃公司联系*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_4_image       ,
        {CN_Alarm_G5_4_wenzi2      ,CN_Alarm_G5_4_wenzi2       ,CN_Alarm_G5_4_wenzi2       },
        {CN_Alarm_G5_4_wenzi3      ,CN_Alarm_G5_4_wenzi3       ,CN_Alarm_G5_4_wenzi3       },
    },
    {/*27 通信系统-请在安全场所停车*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_5_image          ,
        {CN_Alarm_G5_5_wenzi1      ,CN_Alarm_G5_5_wenzi1       ,CN_Alarm_G5_5_wenzi1       },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*28 通信系统-请与五十铃公司联系*/
        CN_Alarm_01_imageblack    ,
        CN_Alarm_G5_5_image       ,
        {CN_Alarm_G5_5_wenzi2        ,CN_Alarm_G5_5_wenzi2         ,CN_Alarm_G5_5_wenzi2       },
        {CN_Alarm_G5_5_wenzi3        ,CN_Alarm_G5_5_wenzi3         ,CN_Alarm_G5_5_wenzi3       },
    },
    {/*29 车速限制-图1*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_6_image          ,
        {CN_Alarm_G5_6_wenzi1      ,CN_Alarm_G5_6_wenzi1       ,CN_Alarm_G5_6_wenzi1       },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*30 车速限制-图2*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_6_image          ,
        {CN_Alarm_G5_6_wenzi2      ,CN_Alarm_G5_6_wenzi2       ,CN_Alarm_G5_6_wenzi2       },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*31 扭矩限制-图1*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_7_image          ,
        {CN_Alarm_G5_7_wenzi1      ,CN_Alarm_G5_7_wenzi1       ,CN_Alarm_G5_7_wenzi1       },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*32 扭矩限制-图2*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_7_image          ,
        {CN_Alarm_G5_7_wenzi2      ,CN_Alarm_G5_7_wenzi2       ,CN_Alarm_G5_7_wenzi2       },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*33 扭矩限制、车速限制 交互 显示*/
		SpriteSize ,
        SpriteSize ,
		{SpriteSize,SpriteSize ,SpriteSize  },
        {SpriteSize,SpriteSize ,SpriteSize  },
    },
    {/*34 尿素品质异常-图1*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_89_image          ,
        {CN_Alarm_G5_89_iwenzi4    ,CN_Alarm_G5_89_iwenzi4     ,CN_Alarm_G5_89_iwenzi4     },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*35 尿素品质异常-图2*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_89_image          ,
        {CN_Alarm_G5_89_iwenzi1        ,CN_Alarm_G5_89_iwenzi1         ,CN_Alarm_G5_89_iwenzi1         },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*36 临界排放故障-图1*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_89_image          ,
        {CN_Alarm_G5_89_iwenzi3      ,CN_Alarm_G5_89_iwenzi3       ,CN_Alarm_G5_89_iwenzi3     },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*37 临界排放故障-图2*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_89_image          ,
        {CN_Alarm_G5_89_iwenzi2        ,CN_Alarm_G5_89_iwenzi2         ,CN_Alarm_G5_89_iwenzi2         },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*38 AMT异常-图1*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_10_11_image                ,
        {CN_Alarm_G5_10_11_wenzi1        ,CN_Alarm_G5_10_11_wenzi1         ,CN_Alarm_G5_10_11_wenzi1         },
        {CN_Alarm_G5_10_11_wenzi5        ,CN_Alarm_G5_10_11_wenzi5         ,CN_Alarm_G5_10_11_wenzi5         },
    },
    {/*39 AMT异常-请重启发动机*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_10_11_image          ,
        {CN_Alarm_G5_10_11_wenzi5        ,CN_Alarm_G5_10_11_wenzi5          ,CN_Alarm_G5_10_11_wenzi5          },
        {CN_Alarm_G5_10_11_wenzi4        ,CN_Alarm_G5_10_11_wenzi4         ,CN_Alarm_G5_10_11_wenzi4          },
    },
    {/*40 AMT异常(气压低下)-图1*///*注意这里，文字颜色应为黄色，试刷黑色*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_10_11_image             ,
        {CN_Alarm_G5_10_11_wenzi2    ,CN_Alarm_G5_10_11_wenzi2         ,CN_Alarm_G5_10_11_wenzi2          },
        {SpriteSize   ,SpriteSize    ,SpriteSize    },
    },
    {/*41 AMT异常(气压低下)-图2*/
		CN_Alarm_01_imageblack ,
        CN_Alarm_G5_10_11_image                   ,
        {CN_Alarm_G5_10_11_wenzi3      ,CN_Alarm_G5_10_11_wenzi3       ,CN_Alarm_G5_10_11_wenzi3       },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
	
    {/*42 低圧警報-轮胎漏气警告*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_12__25_image          ,
        {CN_Alarm_G5_12__25_wenzi1      ,CN_Alarm_G5_12__25_wenzi1       ,CN_Alarm_G5_12__25_wenzi1       },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*43 同——42*///有无车速无差异
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_12__25_image            ,
        {CN_Alarm_G5_12__25_wenzi1      ,CN_Alarm_G5_12__25_wenzi1       ,CN_Alarm_G5_12__25_wenzi1       },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*44 尿素补给-补充尿素溶液-图1*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_13_14__image     ,
        {CN_Alarm_G5_13_14_weizhi5   ,CN_Alarm_G5_13_14_weizhi5      ,CN_Alarm_G5_13_14_weizhi5        },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*45 尿素补给-补充尿素溶液-图2*//*注意这里实际该为黑字黄底，实际刷黄白底*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_13_14__image      ,
        {CN_Alarm_G5_13_14__wenzi2   ,CN_Alarm_G5_13_14__wenzi2        ,CN_Alarm_G5_13_14__wenzi2    },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*46 尿素余量少-有车速-图1*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_13_14__image            ,
        {CN_Alarm_G5_13_14_wenzi      ,CN_Alarm_G5_13_14_wenzi       ,CN_Alarm_G5_13_14_wenzi       },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*47 尿素余量少-无车速-图2*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_13_14__image               ,
        {CN_Alarm_G5_13_14__wenzi1    ,CN_Alarm_G5_13_14__wenzi1     ,CN_Alarm_G5_13_14__wenzi1          },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
	
    {/*48 低圧警報（低下）*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_12__25_image                    ,
        {CN_Alarm_G5_12__25_wenzi2    ,CN_Alarm_G5_12__25_wenzi2     ,CN_Alarm_G5_12__25_wenzi2     },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*49 同——50*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_12__25_image       ,
        {CN_Alarm_G5_12__25_wenzi2    ,CN_Alarm_G5_12__25_wenzi2     ,CN_Alarm_G5_12__25_wenzi2     },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*50 摄像头有污染-图1*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_16_image          ,
        {CN_Alarm_G5_16_wenzi1      ,CN_Alarm_G5_16_wenzi1       ,CN_Alarm_G5_16_wenzi1       },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*51 摄像头有污染-请与五十铃公司联系*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_16_image         ,
        {CN_Alarm_G5_16_wenzi2      ,CN_Alarm_G5_16_wenzi2       ,CN_Alarm_G5_16_wenzi2    },
        {CN_Alarm_G5_16_wenzi3      ,CN_Alarm_G5_16_wenzi3      ,CN_Alarm_G5_16_wenzi3      },
    },
    {/*52 尿素喷射异常（停止）-图1*/
        CN_Alarm_01_imageblack ,
        CN_Alarm__G5_17_18_21_image2          ,
        {CN_Alarm__G5_17_18_21_wenzi1      ,CN_Alarm__G5_17_18_21_wenzi1       ,CN_Alarm__G5_17_18_21_wenzi1       },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*53 尿素喷射异常（停止）-图2*/
        CN_Alarm_01_imageblack ,
        CN_Alarm__G5_17_18_21_image2          ,
        {CN_Alarm__G5_17_18_21_wenzi2      ,CN_Alarm__G5_17_18_21_wenzi2       ,CN_Alarm__G5_17_18_21_wenzi2       },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*54 尿素喷射异常（消耗量）-图1*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_12_23_image       ,
        {CN_Alarm__G5_17_18_21_wenzi3      ,CN_Alarm__G5_17_18_21_wenzi3       ,CN_Alarm__G5_17_18_21_wenzi3                },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*55 尿素喷射异常（消耗量）-图2*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_12_23_image          ,
        {CN_Alarm__G5_17_18_21_wenzi5       ,CN_Alarm__G5_17_18_21_wenzi5      ,CN_Alarm__G5_17_18_21_wenzi5         },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*56 高圧警報-轮胎高压警告*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_12__25_image          ,
        {CN_Alarm_G5_12__25_weizhi8   ,CN_Alarm_G5_12__25_weizhi8    ,CN_Alarm_G5_12__25_weizhi8    },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*57 高温警報-轮胎高温警告*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_12__25_image          ,
        {CN_Alarm_G5_12__25_weizhi9   ,CN_Alarm_G5_12__25_weizhi9    ,CN_Alarm_G5_12__25_weizhi9    },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*58 尿素喷射异常(停止、消耗量)交互显示*/
        SpriteSize ,
        SpriteSize    ,
        {SpriteSize,SpriteSize ,SpriteSize },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*59 DPD手动再生要求1-DPD需要再生*/
        CN_Alarm_01_imageblack ,
        CN_Alarm__G5_17_18_21_image2             ,
        {CN_Alarm_G5_12_23_wenzi2          ,CN_Alarm_G5_12_23_wenzi2           ,CN_Alarm_G5_12_23_wenzi2       },
        {CN_Alarm__G5_17_18_21_wenzi4      ,CN_Alarm__G5_17_18_21_wenzi4       ,CN_Alarm__G5_17_18_21_wenzi4       },
    },
    {/*60 DPD手动再生要求1-请按下DPD开关*/
        CN_Alarm_01_imageblack ,
        CN_Alarm__G5_17_18_21_image2             ,
        {CN_Alarm_G5_12_23_wenzi1         ,CN_Alarm_G5_12_23_wenzi1          ,CN_Alarm_G5_12_23_wenzi1       },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*61 DPD手动再生要求2-DPD需要再生*/
        CN_Alarm_01_imageblack ,
        CN_Alarm__G5_17_18_21_image2             ,
        {CN_Alarm_G5_12_23_wenzi2      ,CN_Alarm_G5_12_23_wenzi2       ,CN_Alarm_G5_12_23_wenzi2       },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*62 DPD手动再生要求2-请按下DPD开关*/
        CN_Alarm_01_imageblack ,
        CN_Alarm__G5_17_18_21_image2             ,
        {CN_Alarm_G5_12_23_wenzi1      ,CN_Alarm_G5_12_23_wenzi1       ,CN_Alarm_G5_12_23_wenzi1       },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*63 TPMS故障-轮胎监控失败*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_12__25_image          ,
        {CN_Alarm_G5_12__25_weizhi7    ,CN_Alarm_G5_12__25_weizhi7     ,CN_Alarm_G5_12__25_weizhi7     },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*64 TPMS電池低下-轮胎监控传感器电压下降*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_G5_12__25_image          ,
        {CN_Alarm_G5_12__25_wenzi6     ,CN_Alarm_G5_12__25_wenzi6      ,CN_Alarm_G5_12__25_wenzi6       },
        {SpriteSize,SpriteSize ,SpriteSize },
    },	
    {/*65 DPD手动再生中*/////////////////这个个空的，占位
        CN_Alarm_01_imageblack ,
        CN_Alarm_TST_8_image    ,
        {CN_Alarm_TST_1_wenzi,CN_Alarm_TST_1_wenzi ,CN_Alarm_TST_1_wenzi },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
	
	
	/**6**/
    {/*66 遥控车辆高度调整中(无车速)*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_stop_31_image      ,
        {CN_Alarm_stop_31_wenzi1   ,CN_Alarm_stop_31_wenzi1    ,CN_Alarm_stop_31_wenzi1    },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*67 PTO(停车中)*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_stop_32_image      ,
        {CN_Alarm_stop_32_wenzi  ,CN_Alarm_stop_32_wenzi   ,CN_Alarm_stop_32_wenzi   },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
	
	/**7**/
    {/*68 充电异常-请在安全的场所停车*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_33_image       ,
        {CN_Alarm_drive_33_wenzi1   ,CN_Alarm_drive_33_wenzi1    ,CN_Alarm_drive_33_wenzi1    },
        {CN_Alarm_drive_33_wenzi2  ,CN_Alarm_drive_33_wenzi2   ,CN_Alarm_drive_33_wenzi2   },
    },
    {/*69 充电异常-请与五十铃公司联系*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_stop_36_image       ,
        {CN_Alarm_stop_36_wenzi1   ,CN_Alarm_stop_36_wenzi1    ,CN_Alarm_stop_36_wenzi1    },
        {CN_Alarm_stop_36_wenzi2   ,CN_Alarm_stop_36_wenzi2    ,CN_Alarm_stop_36_wenzi2    },
    },
	
    {/*70 AMT異常-AMT异常*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_55_image       ,
        {CN_Alarm_drive_55_wenzi1_1   ,CN_Alarm_drive_55_wenzi1_1    ,CN_Alarm_drive_55_wenzi1_1    },
        {CN_Alarm_drive_55_wenzi1_2  ,CN_Alarm_drive_55_wenzi1_2   ,CN_Alarm_drive_55_wenzi1_2   },
    },
    {/*71 AMT異常-请联系经销商*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_stop_55_image       ,
        {CN_Alarm_stop_55_wenzi1_1   ,CN_Alarm_stop_55_wenzi1_1    ,CN_Alarm_stop_55_wenzi1_1    },
        {CN_Alarm_stop_55_wenzi1_2  ,CN_Alarm_stop_55_wenzi1_2   ,CN_Alarm_stop_55_wenzi1_2   },
    },
    {/*72 补充燃料-油箱单位*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_37_image       ,
        {CN_Alarm_drive_37_wenzi   ,CN_Alarm_drive_37_wenzi    ,CN_Alarm_drive_37_wenzi    },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*73 过热-离合器过载*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_56_image       ,
        {CN_Alarm_drive_56_wenzi1  ,CN_Alarm_drive_56_wenzi1   ,CN_Alarm_drive_56_wenzi1   },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*74 过热-选择合适的档位*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_stop_56_image       ,
        {CN_Alarm_stop_56_wenzi1_1   ,CN_Alarm_stop_56_wenzi1_1    ,CN_Alarm_stop_56_wenzi1_1    },
        {CN_Alarm_stop_56_wenzi1_2   ,CN_Alarm_stop_56_wenzi1_2    ,CN_Alarm_stop_56_wenzi1_2    },
    },
    {/*75 AMT磨耗-离合器磨损*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_56_image       ,
        {CN_Alarm_drive_56_wenzi2  ,CN_Alarm_drive_56_wenzi2   ,CN_Alarm_drive_56_wenzi2   },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*76 低电压报警*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_39_image ,
        {CN_Alarm_drive_39_wenzi1   ,CN_Alarm_drive_39_wenzi1    ,CN_Alarm_drive_39_wenzi1    },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*77 过电压报警*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_39_image       ,
        {CN_Alarm_drive_39_wenzi2   ,CN_Alarm_drive_39_wenzi2    ,CN_Alarm_drive_39_wenzi2    },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*78 .DPD自动再生-DPD自动再生中*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_41_image       ,
        {CN_Alarm_drive_41_wenzi   ,CN_Alarm_drive_41_wenzi    ,CN_Alarm_drive_41_wenzi    },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*79 DPD自动再生-再生将自动完成，不需要操作开关 */
        CN_Alarm_01_imageblack ,
        CN_Alarm_stop_43_image          ,
        {CN_Alarm_stop_43_wenzi1  ,CN_Alarm_stop_43_wenzi1   ,CN_Alarm_stop_43_wenzi1   },
        {CN_Alarm_stop_43_wenzi2   ,CN_Alarm_stop_43_wenzi2    ,CN_Alarm_stop_43_wenzi2    },
    },
	/**9**/
    {/*80 气压过低-气压过低请注意*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_42_image        ,
        {CN_Alarm_drive_42_wenzi1   ,CN_Alarm_drive_42_wenzi1    ,CN_Alarm_drive_42_wenzi1    },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*81 气压过低-请冲入空气*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_stop_44_image       ,
        {CN_Alarm_stop_44_wenzi1_1     ,CN_Alarm_stop_44_wenzi1_1      ,CN_Alarm_stop_44_wenzi1_1      },
        {CN_Alarm_stop_44_wenzi1_2	   ,CN_Alarm_stop_44_wenzi1_2      ,CN_Alarm_stop_44_wenzi1_2      },
    },
    {/*82 EBS故障（红）-请在安全的场所停车*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_42_image        ,
        {CN_Alarm_drive_42_wenzi2_1   ,CN_Alarm_drive_42_wenzi2_1    ,CN_Alarm_drive_42_wenzi2_1    },
        {CN_Alarm_drive_42_wenzi2_2   ,CN_Alarm_drive_42_wenzi2_2    ,CN_Alarm_drive_42_wenzi2_2    },
    },
    {/*83 EBS故障（红）-请与五十铃公司联系*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_stop_44_image       ,
        {CN_Alarm_stop_44_wenzi2_1   ,CN_Alarm_stop_44_wenzi2_1    ,CN_Alarm_stop_44_wenzi2_1    },
        {CN_Alarm_stop_44_wenzi2_2   ,CN_Alarm_stop_44_wenzi2_2    ,CN_Alarm_stop_44_wenzi2_2    },
    },
	/**10**/
    {/*84 省油耗建议-急加速*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_43_image       ,
        {CN_Alarm_drive_43_wenzi1   ,CN_Alarm_drive_43_wenzi1    ,CN_Alarm_drive_43_wenzi1    },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*85 省油耗建议-急减速*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_43_image       ,
        {CN_Alarm_drive_43_wenzi2   ,CN_Alarm_drive_43_wenzi2    ,CN_Alarm_drive_43_wenzi2    },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*86 省油耗建议-请降低发动机转速*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_43_image       ,
        {CN_Alarm_drive_43_wenzi3   ,CN_Alarm_drive_43_wenzi3    ,CN_Alarm_drive_43_wenzi3    },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {/*87 省油耗建议-请降低发动机转速*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_43_image       ,
        {CN_Alarm_drive_43_wenzi4   ,CN_Alarm_drive_43_wenzi4    ,CN_Alarm_drive_43_wenzi4    },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
	/**11**/
    {/*88 发动机机油＆滤清器*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_44_image       ,
        {CN_Alarm_drive_44_wenzi1     ,CN_Alarm_drive_44_wenzi1      ,CN_Alarm_drive_44_wenzi1    },
        {CN_Alarm_drive_44_wenzi1_1   ,CN_Alarm_drive_44_wenzi1_1    ,CN_Alarm_drive_44_wenzi1_1    },
    },
    {/*89 燃油滤清器*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_44_image       ,
        {CN_Alarm_drive_44_wenzi1     ,CN_Alarm_drive_44_wenzi1      ,CN_Alarm_drive_44_wenzi1    },
        {CN_Alarm_drive_44_wenzi1_2   ,CN_Alarm_drive_44_wenzi1_2    ,CN_Alarm_drive_44_wenzi1_2    },
    },
    {/*90 变速箱油*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_44_image       ,
        {CN_Alarm_drive_44_wenzi1     ,CN_Alarm_drive_44_wenzi1      ,CN_Alarm_drive_44_wenzi1    },
        {CN_Alarm_drive_44_wenzi1_3   ,CN_Alarm_drive_44_wenzi1_3    ,CN_Alarm_drive_44_wenzi1_3    },
    },
    {/*91 差速器油*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_44_image       ,
        {CN_Alarm_drive_44_wenzi1     ,CN_Alarm_drive_44_wenzi1      ,CN_Alarm_drive_44_wenzi1    },
        {CN_Alarm_drive_44_wenzi1_4   ,CN_Alarm_drive_44_wenzi1_4    ,SpriteSize },
    },
    {/*92 顺畅系统离合器油*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_44_image       ,
        {CN_Alarm_drive_44_wenzi1     ,CN_Alarm_drive_44_wenzi1      ,CN_Alarm_drive_44_wenzi1    },
        {CN_Alarm_drive_44_wenzi1_7   ,CN_Alarm_drive_44_wenzi1_7    ,CN_Alarm_drive_44_wenzi1_7    },
    },
    {/*93 动力转向液*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_44_image       ,
        {CN_Alarm_drive_44_wenzi1     ,CN_Alarm_drive_44_wenzi1      ,CN_Alarm_drive_44_wenzi1    },
        {CN_Alarm_drive_44_wenzi1_5   ,CN_Alarm_drive_44_wenzi1_5    ,CN_Alarm_drive_44_wenzi1_5    },
    },
    {/*94 更换轮胎・轮胎位置*/
        CN_Alarm_01_imageblack ,
        CN_Alarm_drive_44_image       ,
        {CN_Alarm_drive_44_wenzi2     ,CN_Alarm_drive_44_wenzi2      ,CN_Alarm_drive_44_wenzi2    },
        {CN_Alarm_drive_44_wenzi2_1   ,CN_Alarm_drive_44_wenzi2_1    ,CN_Alarm_drive_44_wenzi2_1    },
    },
};
/*-------------------------------------------------------------------------
 * Function Name  : GUI_General_Popup
 * Description    : 报警显示
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
--------------------------------------------------------------------------*/
static uint16_t wbyPopupTest = 0 ;
static uint16_t wbyPopupTimer = 0 ;
void GUI_General_Popup(void)
{
    uint16_t PopupMsg = 0u;
    PopupMsg = Popup_Get_Current_Message();

    if(wbyPopupTimer < 100)
    {//20s
        wbyPopupTimer ++ ;
    }
    else
    {
        wbyPopupTimer = 0 ;
        if(wbyPopupTest < (POPUP_MSG_NUMBER_TOTAL - 1))
            wbyPopupTest ++ ;
        else
            wbyPopupTest = 0 ;
    }

    Popups_Displaying(wbyPopupTest);
    //Popups_Displaying(PopupMsg);

}
/*-------------------------------------------------------------------------
 * Function Name  : Popups_Displaying
 * Description    : 分类弹出信息显示程序
 * Input          : PopupID：弹出信息名称
 * Output         : None
 * Return         : None
 * onther         : None
--------------------------------------------------------------------------*/
static void Popups_Displaying(uint8_t PopupMsg)
{    
    if ( PopupMsg < POPUP_MSG_NUMBER_TOTAL )
    {
        switch ( PopupMsgAttributeTable [ PopupMsg ].Type )
        {
        case POPUP_TYPE_GENERAL:
            GUI_General_Popup_Display(PopupMsg);
            break;

        case POPUP_TYPE_TORQUE_SPEED :
            GUI_Torque_Speed_Popup_Display();
            break;

        case POPUP_TYPE_ADBULE_ANOMALY :
            GUI_AdBule_anomaly_Popup_Display();
            break;
        default:
            break;
        }
    }
}
/*-------------------------------------------------------------------------
 * Function Name  : GUI_General_Popup_Display
 * Description    : 通用弹出信息显示程序
 * Input          : PopupID：弹出信息名称
 * Output         : None
 * Return         : None
 * onther         : None
--------------------------------------------------------------------------*/
static void GUI_General_Popup_Display(uint16_t PopupMsg)
{
    if (PopupMsg >= POPUP_MSG_NUMBER_TOTAL)
        return;

    //背景
    if(GUIGeneralPopupTable[PopupMsg].Background == CN_Alarm_01_image)
    {//只刷红底
        GUI_General_Display(MultiPurpose_Sprite, GUIGeneralPopupTable[PopupMsg].Background, GUI_BLENDMODE_CUSTOM);//背景        
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
    }
    //图片
    if(GUIGeneralPopupTable[PopupMsg].Image == SpriteSize)
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, GUIGeneralPopupTable[PopupMsg].Image, GUI_BLENDMODE_CUSTOM);//图片
    }
    //文字1
    if(GUIGeneralPopupTable[PopupMsg].firstText[0] == SpriteSize)
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, GUIGeneralPopupTable[PopupMsg].firstText[0], GUI_BLENDMODE_CUSTOM);//文字
    }
    //文字2
    if(GUIGeneralPopupTable[PopupMsg].secondText[0] == SpriteSize)
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, GUIGeneralPopupTable[PopupMsg].secondText[0], GUI_BLENDMODE_CUSTOM);//文字
    }         
}
/*-------------------------------------------------------------------------
 * Function Name  : GUI_Torque_Speed_Popup_Display
 * Description    : 扭矩限制、车速限制 交互显示
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
--------------------------------------------------------------------------*/
const static GUIGeneralPopupStruct Torque_Speed_Interaction[2u] = 
{
    {
        CN_Alarm_01_imageblack  ,
        CN_Alarm_G5_6_image ,
        {CN_Alarm_G5_6_wenzi1,CN_Alarm_G5_6_wenzi1 ,CN_Alarm_G5_6_wenzi1 },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {
        CN_Alarm_01_imageblack  ,
        CN_Alarm_G5_7_image ,
        {CN_Alarm_G5_7_wenzi1,CN_Alarm_G5_7_wenzi1 ,CN_Alarm_G5_7_wenzi1 },
        {SpriteSize,SpriteSize ,SpriteSize },
    },

}; 
static void GUI_Torque_Speed_Popup_Display(void)
{    
    //背景
    //if(Torque_Speed_Interaction[FLASH_SYNC_05Hz].Background == SpriteSize)
    //{
    //    GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
    //}
    //else
    //{
    //    GUI_General_Display(MultiPurpose_Sprite, Torque_Speed_Interaction[FLASH_SYNC_05Hz].Background, GUI_BLENDMODE_CUSTOM);//背景
    //}
    //图片
    if(Torque_Speed_Interaction[FLASH_SYNC_05Hz].Image == SpriteSize)
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, Torque_Speed_Interaction[FLASH_SYNC_05Hz].Image, GUI_BLENDMODE_CUSTOM);//图片
    }
    //文字1
    if(Torque_Speed_Interaction[FLASH_SYNC_05Hz].firstText[0] == SpriteSize)
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, Torque_Speed_Interaction[FLASH_SYNC_05Hz].firstText[0], GUI_BLENDMODE_CUSTOM);//文字1
    }
    //文字2
    if(Torque_Speed_Interaction[FLASH_SYNC_05Hz].secondText[0] == SpriteSize)
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, Torque_Speed_Interaction[FLASH_SYNC_05Hz].secondText[0], GUI_BLENDMODE_CUSTOM);//文字2
    } 
}
/*-------------------------------------------------------------------------
 * Function Name  : GUI_AdBule_anomaly_Popup_Display
 * Description    : 尿素喷射异常(停止、消耗量)交互显示
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
--------------------------------------------------------------------------*/
const static GUIGeneralPopupStruct AdBule_anomaly_Interaction[2u] = 
{
    {
        CN_Alarm_01_imageblack  ,
        CN_Alarm__G5_17_18_21_image ,
        {CN_Alarm__G5_17_18_21_wenzi1 ,CN_Alarm__G5_17_18_21_wenzi1  ,CN_Alarm__G5_17_18_21_wenzi1 },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
    {
        CN_Alarm_01_imageblack  ,
        CN_Alarm__G5_17_18_21_image ,
        {CN_Alarm__G5_17_18_21_wenzi3 ,CN_Alarm__G5_17_18_21_wenzi3  ,CN_Alarm__G5_17_18_21_wenzi3  },
        {SpriteSize,SpriteSize ,SpriteSize },
    },
};

static void GUI_AdBule_anomaly_Popup_Display(void)
{    
    //背景
    //if(AdBule_anomaly_Interaction[FLASH_SYNC_05Hz].Background == SpriteSize)
    //{
    //    GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
    //}
    //else
    //{
    //    GUI_General_Display(MultiPurpose_Sprite, AdBule_anomaly_Interaction[FLASH_SYNC_05Hz].Background, GUI_BLENDMODE_CUSTOM);//背景
    //}
    //图片
    if(AdBule_anomaly_Interaction[FLASH_SYNC_05Hz].Image == SpriteSize)
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, AdBule_anomaly_Interaction[FLASH_SYNC_05Hz].Image, GUI_BLENDMODE_CUSTOM);//图片
    }
    //文字1
    if(AdBule_anomaly_Interaction[FLASH_SYNC_05Hz].firstText[0] == SpriteSize)
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, AdBule_anomaly_Interaction[FLASH_SYNC_05Hz].firstText[0], GUI_BLENDMODE_CUSTOM);//文字
    }
    //文字2
    if(AdBule_anomaly_Interaction[FLASH_SYNC_05Hz].secondText[0] == SpriteSize)
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, AdBule_anomaly_Interaction[FLASH_SYNC_05Hz].secondText[0], GUI_BLENDMODE_CUSTOM);//文字
    }    
}





