#ifndef	_FUELCONFIG_H                            	
#define _FUELCONFIG_H	

typedef unsigned short INT16U;
typedef unsigned char INT8U; 
typedef unsigned int INT32U;


#define DISPLAY_BOUNDARY_ES 	2300       
#define DISPLAY_BOUNDARY_1		2060              
#define DISPLAY_BOUNDARY_2		1850          
#define DISPLAY_BOUNDARY_3		1570
#define DISPLAY_BOUNDARY_4		1430
#define DISPLAY_BOUNDARY_5		1130
#define DISPLAY_BOUNDARY_6	  970
#define DISPLAY_BOUNDARY_7		550
#define DISPLAY_BOUNDARY_8	  460
#define DISPLAY_BOUNDARY_9	  460
#define DISPLAY_BOUNDARY_10	  460
#define DISPLAY_BOUNDARY_11	  460
#define DISPLAY_BOUNDARY_12	  460
#define DISPLAY_BOUNDARY_FS	  460

#define BOUNDARY_FUEL_ES 	0
#define BOUNDARY_FUEL_1		70
#define BOUNDARY_FUEL_2		130
#define BOUNDARY_FUEL_3		190
#define BOUNDARY_FUEL_4		250
#define BOUNDARY_FUEL_5		310
#define BOUNDARY_FUEL_6		370
#define BOUNDARY_FUEL_7		440
#define BOUNDARY_FUEL_8	  510
#define BOUNDARY_FUEL_9	  510
#define BOUNDARY_FUEL_10	510
#define BOUNDARY_FUEL_11	510
#define BOUNDARY_FUEL_12	510
#define BOUNDARY_FUEL_FS	510


#define FUEL_R_MIN_VAL	300		//10 X ohm
#define FUEL_R_MAX_VAL	2700    //10 X ohm


//Fuel Config
typedef struct _FuelStruct {
  INT16U FuelShortCircuitR;
  INT16U FuelOpenCircuitR;
  INT16U DisplayZoneBoundary[22];
	INT16U FuelCapacityBoundary[22];
}FuelStruct;

extern void InitFuelParamter(FuelStruct *para);
extern INT8U* GetFuelLibVersion(void);

extern void FuelFSM(INT16U FuelResistance);     //unit:ohm,accuracy:0.1

extern void SetMaxFuelBlockNum(INT8U n); //call after InitFuelParamter(),default 12,max 20

extern void SetFuelSensorRecoverGroupCnt(INT16U n);       //1:500ms,2:1000ms,3:1500ms.......,range:5s(10)-30min(3600)
extern void SetFuelSensorOpenCircuitGroupCnt(INT16U n);   //1:500ms,2:1000ms,3:1500ms.......,range:5s(10)-30min(3600) 
extern void SetFuelSensorShortCircuitGroupCnt(INT16U n);  //1:500ms,2:1000ms,3:1500ms.......,range:5s(10)-30min(3600)

extern void SetPowerSt(INT8U n);
extern INT8U GetFuelSeg(void); //Segment, range:0~8
extern INT8U GetFuelStep(void); //Pointer or Mono TFT stepless,range:0,10~((MaxFuelBlockNum + 1) * 10)  0,10:E,   ((MaxFuelBlockNum + 1) * 10):F 

extern INT16U GetFuelCapacityVal(void); //unit:L,accuracy:0.1

enum {
	FuelSensorNormal,
	FuelSensorShortCircuit,
	FuelSensorOpenCircuit,
	FuelSensorPreFault,
};
extern INT8U GetFuelSensorState(void); 

enum {
	FUEL_ST_IGN_ON_PROCESS = 1,		//1
	FUEL_ST_POWER_ON_ADD_FUEL,	//2
	FUEL_ST_VEHICLE_RUN,		//3
	FUEL_ST_IGN_OFF_PROCESS,	//4
	FUEL_ST_IGN_OFF,  			//5
}; 
extern INT8U GetFuelFSM_St(void);
extern INT16U GetFuelResistance(void); //unit:ohm,accuracy:0.1

extern void SetPowerDnStep(INT8U step);   //call every ign on  (after InitFuelParamter())
extern INT8U GetPowerDnStep(void);    //every 10km or ign off or refuel(FUEL_ST_POWER_ON_ADD_FUEL->FUEL_ST_VEHICLE_RUN) record
 

// AFC & DrivingRange
typedef struct _AFC_INIT {
	INT8U CalcAFCMaxNum;	//max 100km,default 50
	INT16U AFCMin;	//unit:L,accuracy:0.1
	INT16U AFCMax;	//unit:L,accuracy:0.1
	INT16U AFCPreinstall;	//unit:L,accuracy:0.1
	INT32U CurODO;		// unit:m,accuracy:1
	INT32U MaxDRMileage;	//unit:km,accuracy:0.01
}AFC_INIT;
extern void InitAFC(AFC_INIT *data);
extern void ResetAFC(AFC_INIT *data);

typedef struct _AFC_PARA {
	INT32U CurODO;		// unit:m,accuracy:1
	INT16U FuleConsume;	// unit:ul,accuracy:1
	INT16U RPM;			// unit:RPM,accuracy:1
	INT8U Speed;		// unit:km/h,accuracy:1
}AFC_PARA;
extern void SetAFCPara(AFC_PARA *data);

typedef struct _DAFC_PARA{
  INT32U DAFC_FuelConsumeSum;  //unit:ul    (ul:m->ml:km->L:1000km)
	INT32U DAFC_ODO;             //unit:m
}DAFC_PARA;
extern void DAFC_GetPowerDownPara(DAFC_PARA *data);   //call every 10km or ign off or reset afc 
extern void DAFC_SetPowerDownPara(DAFC_PARA *data);   //call every KL30 OFF -> KL30 ON (after InitAFC())

typedef struct _DR_PARA{
  INT32U DR_FuelConsumeSum;     //unit:ul    (ul:m->ml:km->L:1000km)
  INT32U DR_Mileage;            //unit:km,accuracy:0.01
}DR_PARA;
extern void DR_GetPowerDownPara(DR_PARA *data);      //call every 10km or ign off
extern void DR_SetPowerDownPara(DR_PARA *data);      //call every KL30 OFF -> KL30 ON (after InitAFC())

extern void AFCTimerCall(void); //must per 10ms interrupt
extern INT16U GetDRMileage(void);  //unit:km,accuracy:1
extern INT16U GetCurAFC(void); //unit:L,accuracy:0.1 


//display afc 
extern void DAFC_Reset(AFC_INIT *data);
extern INT16U DAFC_GetAFC(void);  //unit:L,accuracy:0.1
//display afc end 
  
  
#endif






