#ifndef _SEATBELT_H_
#define _SEATBELT_H_

#include "TYW_stdint.h"

typedef struct
{
    uint16_t  Timer;
    uint16_t  ConsEnMileage;
    uint8_t   Poplevel ;

    uint8_t   LowSpeed300m ; /*低速300发生状态*/
    uint16_t  Chk60s ;

    uint16_t EngineSpeed;
    uint8_t  EngineStoped;
    struct
    {
        uint8_t   Duty;
        uint8_t   Cyc;
        uint8_t   En;
        uint8_t   Sync;
    } TelBlink;

} WarningSeatbeltStruct;



/*** 主驾安全带 ***/

extern volatile uint8_t  WarningSeatbeltDrTel;
extern volatile uint8_t  WarningSeatbeltDrPopup;
extern volatile WarningSeatbeltStruct WarningSeatbeltDr;

/*** 副驾安全带 ***/

extern volatile uint8_t  WarningSeatbeltPaTel;
extern volatile uint8_t  WarningSeatbeltPaPopup;
extern volatile WarningSeatbeltStruct WarningSeatbeltPa;



extern   uint8_t setbeltsig_Dr;
extern   uint8_t setbeltsig_Pa;



/***************内部接口****************************/
void SeatbeltInit(void);
void sigInput(void);
void SeatbeltSelfCheck(void);

void Warning_Seatbelt_Dr_Processing(void);
void Warning_Seatbelt_Pa_Processing(void);

void SeatbeltTelltales(volatile WarningSeatbeltStruct * Seatbatile, volatile uint8_t *Popup, volatile uint8_t  *WarningTel);
void Seatbelt_logic(volatile WarningSeatbeltStruct * Seatbatile, volatile uint8_t *Popup , uint16_t Second);
void ResetSeatbeltWarning(volatile WarningSeatbeltStruct *Seatbatile, volatile uint8_t *Popup, uint8_t Clear) ;

/***************外部接口****************************/

extern uint8_t  Get_SND_SEATBELT_SYNC(void);    /*安全带报警声音播出时的标志*/
extern void ReSet_SND_SEATBELT_SYNC(void);        /*安全带报警声音播出标志清0*/
extern void Set_SND_SEATBELT_SYNC(void);
/***************对外接口****************************/
uint8_t Get_MainSetbeltTel(void); /*主报警灯状态返回  0，1 */
uint8_t Get_PassSetbeltTel(void); /*副报警灯状态返回  0，1 */
uint8_t  Get_SeatbeltPopupLevel(void);/*安全带报警等级信号 0，1，2，3*/

void SeatbeltService_CB100ms(void); /*主服务调用100ms*/
void SeatbeltInit(void);          /*参数初始化，30电 ，或 on ，off 时初始化数据*/
#endif

