//*********************************************************************************************************************************
//ZH修改2021年8月26日10:56:49
//*********************************************************************************************************************************


#include "GUI_VC66_DrivingSupport.h"
#include "Data_DrivingSupport.h"
/*ZH:*/

/*驾驶支持 显示*/

static const uint16_t GUI_DISP_DrivingSupport[3] = {481, 459, 436};

static void display(uint8_t number);//定速巡航图标显示函数，根据传入的参数，进行刷图。


void Gui_Display_DrivingSupport(void)
{
	static uint8_t Sys_Run_Sta_last_value = 0u;//上一次调用本函数时，SystemRunningState的值（即SystemRunningState的历史值）
	uint8_t SystemRunningState = 0u;
	uint8_t settingspeed = 0u;

//*************************************************************************************************	
    SystemRunningState = Gui_Get_SystemRunningState_DisplayMode();//定速巡航_系统运行状态
    settingspeed = Gui_Get_SetSpeed_DisplayMode();//设定车速

//*************************************************************************************************
//显示 定速巡航图标区域：
//************************************************
    if (SystemRunningState == 2u)
    {
        display(Sys_Run_Sta_last_value);
    }
    else
    {
        display(SystemRunningState);
        Sys_Run_Sta_last_value = SystemRunningState;//Gui_Get_SystemRunningState_DisplayMode()函数返回值不为2时，更新Sys_Run_Sta_last_value值。
    }


/********************************************************************
显示 设定车速区域：
********************************************************************/
    if (settingspeed == 0u)
    {
        //显示 -- km/h. :
        GUI_Translate_Display(SetSpeed_Sprite, Nb_21_hengxian, 455u, 118u, GUI_BLENDMODE_SRC_OVER); //显示 第一个横
        GUI_Translate_Display(SetSpeed_Sprite, Nb_21_hengxian, 470u, 118u, GUI_BLENDMODE_SRC_OVER); //显示 第二个横
        GUI_General_Display(SetSpeed_Sprite, CN_dingsuxunhangdanwei, GUI_BLENDMODE_SRC_OVER); //显示文字 “ km/h ”
    }
    else if (settingspeed <= 250u)
    {
        //显示km/h，显示设定车速:
        GUI_General_Digit_Display(SetSpeed_Sprite, settingspeed, Nb_21_0, 3u, 2u, GUI_DISP_DrivingSupport, 104u, GUI_BLENDMODE_SRC_OVER);/*显示 定速巡航设定车速 的数值*/
        GUI_General_Display(SetSpeed_Sprite, CN_dingsuxunhangdanwei, GUI_BLENDMODE_SRC_OVER); //显示文字 “ km/h ”
    }
    else
    {
        GUI_General_Display(SetSpeed_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
    }


}



/************************************** 
函数：
***************************************/
void display(uint8_t number)
{
    switch (number)
    {
        case 0u :
            {
                GUI_General_Display(Cruise_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
                GUI_General_Display(Cruise_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
            }
            break;
        
        case 1u :
            {
                GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(Cruise_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
            }
            break;
        
        case 3u :
            {
                GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang_SET, GUI_BLENDMODE_SRC_OVER);
            }
            break;

        case 4u :
            {
                GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang, GUI_BLENDMODE_SRC_OVER);
                if (FLASH_SYNC_1Hz)
                {
                    GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang_SET, GUI_BLENDMODE_SRC_OVER);
                }
                else
                {
                    GUI_General_Display(Cruise_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
                }
            }
            break;

        case 5u :
            {
                GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang_1, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(Cruise_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
            }
            break;

        case 6u :
            {
                GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang_1, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang_STANDBY, GUI_BLENDMODE_SRC_OVER);
            }
            break;

        case 7u :
            {
                GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang_1, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang_SET, GUI_BLENDMODE_SRC_OVER);
            }
            break;

        case 8u :
            {
                GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang_1, GUI_BLENDMODE_SRC_OVER);
                if (FLASH_SYNC_1Hz)
                {
                    GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang_SET, GUI_BLENDMODE_SRC_OVER);
                }
                else
                {
                    GUI_General_Display(Cruise_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
                }
            }
            break;

        default :
            {
                GUI_General_Display(Cruise_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
                GUI_General_Display(Cruise_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
            }
            break;

    }
}


/*:ZH*/