/**********************************************************************************************************
* @file    loc_graphics_data.h
* @author  HZS
* @version V1.0.0
* @date    2021.04.09
* @brief   c header file
********************************************************************************************************/
#ifndef LOC_GRAPHICS_DATA_H_
#define LOC_GRAPHICS_DATA_H_

//#include "r_typedefs.h"  
//#include "r_ddb_api.h"
//#include "r_cdi_api.h"
//#include "r_wm_api.h"
//#include "r_drw2d_os.h"
//#include "r_drw2d_api.h"
//#include "loc_graphics.h"
//#include "GUI.h"
#include "loc_graphics_def.h"
#include "images.h"
#include "DisplaySch_user.h"


/*AutoCreateBegin*/



#define MAX_WET_SUP_LAYER        20
MultiBufferSprite_t WETSpriteBuf;
uint8_t             WETIndex = 0u;
uint8_t             WETUpdate = 0u;
uint8_t             WETEn = 0u;
LogicLayerAttr_t    WETLogicLayerAttr[MAX_WET_SUP_LAYER];

#define MAX_ADBLUE_SUP_LAYER        10
MultiBufferSprite_t AdBlueSpriteBuf;
uint8_t             AdBlueIndex = 0u;
uint8_t             AdBlueUpdate = 0u;
uint8_t             AdBlueEn = 0u;
LogicLayerAttr_t    AdBlueLogicLayerAttr[MAX_ADBLUE_SUP_LAYER];

#define MAX_TRIP_SUP_LAYER        10
MultiBufferSprite_t TRIPSpriteBuf;
uint8_t             TRIPIndex = 0u;
uint8_t             TRIPUpdate = 0u;
uint8_t             TRIPEn = 0u;
LogicLayerAttr_t    TRIPLogicLayerAttr[MAX_TRIP_SUP_LAYER];

#define MAX_ODO_SUP_LAYER        10
MultiBufferSprite_t ODOSpriteBuf;
uint8_t             ODOIndex = 0u;
uint8_t             ODOUpdate = 0u;
uint8_t             ODOEn = 0u;
LogicLayerAttr_t    ODOLogicLayerAttr[MAX_ODO_SUP_LAYER];

#define MAX_WARNINGLIGHT_SUP_LAYER        10
MultiBufferSprite_t WarningLightSpriteBuf;
uint8_t             WarningLightIndex = 0u;
uint8_t             WarningLightUpdate = 0u;
uint8_t             WarningLightEn = 0u;
LogicLayerAttr_t    WarningLightLogicLayerAttr[MAX_WARNINGLIGHT_SUP_LAYER];

#define MAX_ADAS_SUP_LAYER        15
MultiBufferSprite_t ADASSpriteBuf;
uint8_t             ADASIndex = 0u;
uint8_t             ADASUpdate = 0u;
uint8_t             ADASEn = 0u;
LogicLayerAttr_t    ADASLogicLayerAttr[MAX_ADAS_SUP_LAYER];

#define MAX_MULTIPURPOSE_SUP_LAYER        20
MultiBufferSprite_t MultiPurposeSpriteBuf;
uint8_t             MultiPurposeIndex = 0u;
uint8_t             MultiPurposeUpdate = 0u;
uint8_t             MultiPurposeEn = 0u;
LogicLayerAttr_t    MultiPurposeLogicLayerAttr[MAX_MULTIPURPOSE_SUP_LAYER];

#define MAX_SETSPEED_SUP_LAYER        5
MultiBufferSprite_t SetSpeedSpriteBuf;
uint8_t             SetSpeedIndex = 0u;
uint8_t             SetSpeedUpdate = 0u;
uint8_t             SetSpeedEn = 0u;
LogicLayerAttr_t    SetSpeedLogicLayerAttr[MAX_SETSPEED_SUP_LAYER];

#define MAX_CRUISE_SUP_LAYER        3
MultiBufferSprite_t CruiseSpriteBuf;
uint8_t             CruiseIndex = 0u;
uint8_t             CruiseUpdate = 0u;
uint8_t             CruiseEn = 0u;
LogicLayerAttr_t    CruiseLogicLayerAttr[MAX_CRUISE_SUP_LAYER];

#define MAX_GEAR_SUP_LAYER        5
MultiBufferSprite_t GearSpriteBuf;
uint8_t             GearIndex = 0u;
uint8_t             GearUpdate = 0u;
uint8_t             GearEn = 0u;
LogicLayerAttr_t    GearLogicLayerAttr[MAX_GEAR_SUP_LAYER];

#define MAX_TEMP_SUP_LAYER        10
MultiBufferSprite_t TempSpriteBuf;
uint8_t             TempIndex = 0u;
uint8_t             TempUpdate = 0u;
uint8_t             TempEn = 0u;
LogicLayerAttr_t    TempLogicLayerAttr[MAX_TEMP_SUP_LAYER];

#define MAX_TIME_SUP_LAYER        5
MultiBufferSprite_t TimeSpriteBuf;
uint8_t             TimeIndex = 0u;
uint8_t             TimeUpdate = 0u;
uint8_t             TimeEn = 0u;
LogicLayerAttr_t    TimeLogicLayerAttr[MAX_TIME_SUP_LAYER];

#define MAX_CALENDAR_SUP_LAYER        15
MultiBufferSprite_t CalendarSpriteBuf;
uint8_t             CalendarIndex = 0u;
uint8_t             CalendarUpdate = 0u;
uint8_t             CalendarEn = 0u;
LogicLayerAttr_t    CalendarLogicLayerAttr[MAX_CALENDAR_SUP_LAYER];



static const SpritesHandler_t SpriteHandler[Max_Sprite] =
{
    {WET_Sprite,					{38,364,326,60,1},TARGET_SDRAM,				 &WETSpriteBuf,					&WETIndex,			 WETLogicLayerAttr, 			MAX_WET_SUP_LAYER           ,&WETUpdate,			&WETEn,			     GUI_DisplayServices},
    {AdBlue_Sprite,					{38,428,326,48,1},TARGET_SDRAM,				 &AdBlueSpriteBuf,				&AdBlueIndex,		 AdBlueLogicLayerAttr, 			MAX_ADBLUE_SUP_LAYER        ,&AdBlueUpdate,			&AdBlueEn,		     R_NULL},
    {TRIP_Sprite,					{438,374,322,48,1},TARGET_SDRAM,			 &TRIPSpriteBuf,				&TRIPIndex,			 TRIPLogicLayerAttr, 			MAX_TRIP_SUP_LAYER          ,&TRIPUpdate,			&TRIPEn,		     R_NULL},
    {ODO_Sprite,					{438,424,324,42,1},TARGET_SDRAM,			 &ODOSpriteBuf,					&ODOIndex,			 ODOLogicLayerAttr, 			MAX_ODO_SUP_LAYER           ,&ODOUpdate,			&ODOEn,			     R_NULL},
    {WarningLight_Sprite,			{8,88,82,264,1},TARGET_SDRAM,				 &WarningLightSpriteBuf,		&WarningLightIndex,	 WarningLightLogicLayerAttr, 	MAX_WARNINGLIGHT_SUP_LAYER  ,&WarningLightUpdate,	&WarningLightEn,	 R_NULL},
    {ADAS_Sprite,					{112,94,254,260,1},TARGET_SDRAM,			 &ADASSpriteBuf,				&ADASIndex,			 ADASLogicLayerAttr, 			MAX_ADAS_SUP_LAYER          ,&ADASUpdate,			&ADASEn,			 R_NULL},
    {MultiPurpose_Sprite,			{382,182,410,170,1},TARGET_SDRAM,			 &MultiPurposeSpriteBuf,		&MultiPurposeIndex,	 MultiPurposeLogicLayerAttr, 	MAX_MULTIPURPOSE_SUP_LAYER  ,&MultiPurposeUpdate ,  &MultiPurposeEn,	 R_NULL},
    {SetSpeed_Sprite,				{414,92,112,82,1},TARGET_SDRAM,				 &SetSpeedSpriteBuf,			&SetSpeedIndex,		 SetSpeedLogicLayerAttr, 		MAX_SETSPEED_SUP_LAYER      ,&SetSpeedUpdate,		&SetSpeedEn,		 R_NULL},
    {Cruise_Sprite,					{520,90,90,87,1},TARGET_SDRAM,				 &CruiseSpriteBuf,				&CruiseIndex,		 CruiseLogicLayerAttr, 			MAX_CRUISE_SUP_LAYER        ,&CruiseUpdate,			&CruiseEn,			 R_NULL},
    {Gear_Sprite,					{622,86,170,94,1},TARGET_SDRAM,				 &GearSpriteBuf,				&GearIndex,			 GearLogicLayerAttr, 			MAX_GEAR_SUP_LAYER          ,&GearUpdate,			&GearEn,			 R_NULL},
    {Temp_Sprite,					{26,12,258,70,1},TARGET_SDRAM,				 &TempSpriteBuf,				&TempIndex,			 TempLogicLayerAttr, 			MAX_TEMP_SUP_LAYER          ,&TempUpdate,			&TempEn,			 R_NULL},
    {Time_Sprite,					{330,14,140,66,1},TARGET_SDRAM,				 &TimeSpriteBuf,				&TimeIndex,			 TimeLogicLayerAttr, 			MAX_TIME_SUP_LAYER          ,&TimeUpdate,			&TimeEn,			 R_NULL},
    {Calendar_Sprite,				{508,16,284,64,1},TARGET_SDRAM,				 &CalendarSpriteBuf,			&CalendarIndex,		 CalendarLogicLayerAttr, 		MAX_CALENDAR_SUP_LAYER      ,&CalendarUpdate,		&CalendarEn,		 R_NULL},
};

/*AutoCreateEnd*/

static const r_screen_attr_t ScreenAttr =
{
    800, 480, 896,      /* JEPG Window*/
    800, 480, 896,      /* Loc Window*/
    5,                  /* 刷新时间，50ms*/
    Max_Sprite,         /* 主屏幕Sprite数量*/
    Max_Sprite,         /* 全部Sprite数量*/
    SpriteSize          /* 最大的图片数量*/
};


#endif

