
#ifndef _SOUND_LIST_H_
#define _SOUND_LIST_H_
#include "TYW_stdint.h"
#include "Sound_Source.h"

#define SND_TOTAL_NUMBER SND_INDEX_MAX

/******************************************************************************
声音报警列表
******************************************************************************/
typedef enum SoundName
{
    SND_Key_Notremoved = 0x00  , /*00 忘拔钥匙        */
    SND_LDWS            ,        /*   车道偏离*/
    SND_Collision_Level1,        /*   一级碰撞预警 长鸣*/
    SND_Collision_Level2,        /*   二级碰撞预警 4HZ*/
    SND_Collision_Level3,        /*   三级碰撞预警 2HZ*/
    SND_Braking         ,        /*01 制动           */
    SND_Air_Brake       ,        /*02 制动气压        */
    SND_BRAKE_LOCK      ,        /*03 BRAKE LOCK     */
    SND_Parking_Brake   ,        /*04 停车制动忘记复位  */
    SND_Car_Dump_SPEED  ,        /*05 车厢报警自卸蜂鸣器*/
    SND_Temp_High       ,        /*06 水温过热         */
    SND_Coolant_Low     ,        /*07 冷却水量         */
    SND_Oil_pressure_Low,        /*08 -(预留：油压)     */
    SND_ACC_AIR         ,        /*09 ACC AIR         */
    SND_BackUP_SPEED    ,        /*10 倒车警报         */
    SND_DS_SPEED        ,        /*11 DS 警报          */
    SND_ROWS_SPEED      ,        /*12 ROWS 警报        */
    SND_Roll_SPEED      ,        /*13 Roll 警报        */
    SND_EVSC_SPEED      ,        /*14 EVSC             */
    SND_DPD_SPEED1      ,        /*15 DPD 手动再生      */
    SND_DPD_SPEED2      ,        /*15 DPD 手动再生      */
    SND_DPD_SPEED4      ,        /*15 DPD 手动再生      */
    SND_NEES            ,        /*16 NEES             */
    SND_ECO_STOP        ,        /*17 eco stop         */
    SND_Cyclone_High4HZ ,        /*18 气悬车高调整       */
    SND_Cyclone_High0_5 ,        /*18 气悬车高调整       */
    SND_SEATBELT_SPEED  ,        /*19 安全带            */
    SND_Fuel_Saving     ,        /*20 省油耗建议         */
    SND_TICK            ,        /*21 转向              */
    SND_TOCK            ,        /*22 转向              */

    SND_INDEX_MAX       ,

} SoundName_en_t;

/******************************************************************************
伪声音列表
******************************************************************************/
#define SND_NONE 0xFF
//#define   SND_RADAR                         SND_RADAR_2Hz
//#define   SND_FASTEN_SEATBELT               SND_FASTEN_SEATBELT_DR_Level_1

/******************************************************************************
声音属性结构
******************************************************************************/
typedef struct
{
    SND_SRC_Index_en_t Src; //音源
    uint8_t Type;           //类型
} SoundAttributeStruct;

#define SND_TYPE_NORMAL 0x00   //普通声音类型
#define SND_TYPE_MULTI 0x01    //可多次触发的声音
#define SND_TYPE_RADAR 0x02    //雷达声音
#define SND_TYPE_SEATBELT 0x03 //安全带声音

/******************************************************************************
声音属性列表
******************************************************************************/
static const SoundAttributeStruct SoundList[SND_INDEX_MAX] =
{
    /*=====================================================================================
             声音名称                 |              音源              |        模式
    -------------------------------------------------------------------------------------*/
    {/*00  SND_Key_Notremoved  */ SND_SRC_Key_Notremoved   ,   SND_TYPE_NORMAL, },
    {/*    SND_LDWS            */ SND_SRC_LDWS             ,   SND_TYPE_NORMAL, },
    {/*    SND_Collision_Level1*/ SND_SRC_Collision_L1     ,   SND_TYPE_MULTI, },
    {/*    SND_Collision_Level2*/ SND_SRC_Collision_L2     ,   SND_TYPE_NORMAL, },
    {/*    SND_Collision_Level3*/ SND_SRC_Collision_L3     ,   SND_TYPE_NORMAL, },
    {/*01  SND_Braking         */ SND_SRC_Braking          ,   SND_TYPE_NORMAL, },
    {/*02  SND_Air_Brake       */ SND_SRC_Air_Brake        ,   SND_TYPE_NORMAL, },
    {/*03  SND_BRAKE_LOCK      */ SND_SRC_BRAKE_LOCK       ,   SND_TYPE_NORMAL, },
    {/*04  SND_Parking_Brake   */ SND_SRC_Parking_Brake    ,   SND_TYPE_NORMAL, },
    {/*05  SND_Car_Dump_SPEED  */ SND_SRC_Car_Dump_SPEED   ,   SND_TYPE_NORMAL, },
    {/*06  SND_Temp_High       */ SND_SRC_Temp_High        ,   SND_TYPE_NORMAL, },
    {/*07  SND_Coolant_Low     */ SND_SRC_Coolant_Low      ,   SND_TYPE_NORMAL, },
    {/*08  SND_Oil_pressure_Low*/ SND_SRC_Oil_pressure_Low ,   SND_TYPE_NORMAL, },
    {/*09  SND_ACC_AIR         */ SND_SRC_ACC_AIR          ,   SND_TYPE_NORMAL, },
    {/*10  SND_BackUP_SPEED    */ SND_SRC_BackUP_SPEED     ,   SND_TYPE_NORMAL, },
    {/*11  SND_DS_SPEED        */ SND_SRC_DS_SPEED         ,   SND_TYPE_NORMAL, },
    {/*12  SND_ROWS_SPEED      */ SND_SRC_ROWS_SPEED       ,   SND_TYPE_NORMAL, },
    {/*13  SND_Roll_SPEED      */ SND_SRC_Roll_SPEED       ,   SND_TYPE_NORMAL, },
    {/*14  SND_EVSC_SPEED      */ SND_SRC_EVSC_SPEED       ,   SND_TYPE_MULTI, },
    {/*15  SND_DPD_SPEED1      */ SND_SRC_DPD_SPEED1       ,   SND_TYPE_NORMAL, },
    {/*15  SND_DPD_SPEED2      */ SND_SRC_DPD_SPEED2       ,   SND_TYPE_NORMAL, },
    {/*15  SND_DPD_SPEED4      */ SND_SRC_DPD_SPEED4       ,   SND_TYPE_NORMAL, },
    {/*16  SND_NEES            */ SND_SRC_NEES             ,   SND_TYPE_NORMAL, },
    {/*17  SND_ECO_STOP        */ SND_SRC_ECO_STOP         ,   SND_TYPE_NORMAL, },
    {/*18  SND_Cyclone_High4HZ */ SND_SRC_Cyclone_High4HZ  ,   SND_TYPE_MULTI, },
    {/*18  SND_Cyclone_High0_5 */ SND_SRC_Cyclone_High0_5  ,   SND_TYPE_NORMAL, },
    {/*19  SND_SEATBELT_SPEED  */ SND_SRC_SEATBELT_SPEED   ,   SND_TYPE_NORMAL, },
    {/*20  SND_Fuel_Saving     */ SND_SRC_Fuel_Saving      ,   SND_TYPE_NORMAL, },
    {/*21  SND_TICK            */ SND_SRC_TICK             ,   SND_TYPE_NORMAL, },
    {/*22  SND_TOCK            */ SND_SRC_TOCK             ,   SND_TYPE_NORMAL, },

    /*====================================================================================*/
};

#endif