#include "BackLight.h"
#include "EOL_Para.h"
#include "TYW_stdint.h"
#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "Common_Interface.h"
#include "RTE_PWM.h"
#include "Popup_Scheduler.h"
#include "Popup_Message_List.h"
#include "RTE_GPIO.h"
#include "Analog_Signals.h"
#include "Telltales_user.h"
#include "Popups.h"
#include "Telltales_Lib.h"
#include "DisplaySch.h"
#include "LED_Map.h"
#include "./AMT630H/UartProtocol.h"
#include "Line_In_user.h"
#include "Line_in.h"
#include "PowerManag_user.h"
#include "PowerManagement.h"

uint8_t NTCDegree;
#define NTCDEGREE NTCDegree

#pragma ghs section bss = ".myNonInitArea"
BackLightCtrlStruct BackLightCtrl;
static uint8_t BackSend_Temp = 0U;
static uint8_t BackNight_Old;
static uint8_t BackDay_Old;
#pragma ghs section bss = default

uint32_t BackLight_Ctrl;
static uint8_t  tbl_index;
uint8_t Theme_Color;
uint8_t Theme_Color_Old;
uint8_t Theme_APP;
uint8_t Theme_APP_Old;


//void BackLight_Back_PWM_Init(void); /*PWM Channel Enable*/
void BackLight_Contrl_Init(void);

void BackLight_Get_Goal(void);
void BackLight_Goal_Monitor(void);
//void BackLight_PWM_Duty_Cycle_Delta(uint16_t Goal, uint16_t *Current, uint16_t *DampingTimer);

void BackLight_Back_Shutdown(void);
//void BackLight_Back_Set_Brightness(uint16_t Br);
/******************************************************************************
函数名：BackLight_Contrl_Init
�?  能：背光初�?�化
�?  数：�?
返回值：�?
******************************************************************************/
void BackLight_Ctrl_Service(void)
{
    if ( BackLight_Ctrl == 0 )
    {
        BackLight_Goal_Monitor();
        BackLight_PWM_Duty_Cycle_Delta(BackLightCtrl.BackGoal, &BackLightCtrl.BackCurrent, &BackLightCtrl.BackDampingTimer);
        if (Common_Get_IG_Sts() == COMMON_POWER_OFF)
        {
            if ((Popup_Get_Current_Message() == 0) || (Get_Sleep_Count <= 10))
            {
                PWM_Channel_Set_Duty(9U, 0U);
                PWM_Channel_Set_Duty(7U, BackLightCtrl.BackCurrent);
            }
            else
            {
                PWM_Channel_Set_Duty(9U, 0U);
                PWM_Channel_Set_Duty(7U, 0U);
            }
        }
        else 
        {
            if ((Get_HMI_Sys_Type() >= Disp_SelfCheck) && (GetLcdInitSt() == 1))
            {
                PWM_Channel_Set_Duty(9U, BackLightCtrl.BackCurrent);
                PWM_Channel_Set_Duty(7U, BackLightCtrl.BackCurrent);
                // PWM_Channel_Set_Duty(15, 200);
            }
            else
            {
                PWM_Channel_Set_Duty(9U, 0U);
                PWM_Channel_Set_Duty(7U, 0U);
            }
        }
    }
}

/******************************************************************************
函数名：BackLight_Get_Level
�?  能：获取�?标�?
�?  数：�?
返回值：�?
******************************************************************************/
void BackLight_Get_Goal(void)
{
    uint8_t         BrightFactor  = 0U;
    uint32_t        tmpBr         = 0U;
    static uint32_t BackGoal_Temp = 0U;

    // if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_HU_51A_Msg_Count) == CAN_SIG_NORMAL)
    // {
    //     if(Get_CAN_CH0_ID_51A_Sig_HU_IPDayNightControl() == 1)
    //     {
    //         tbl_index = 1; //白天
    //     }
    //     else 
    //     {
    //         if(Get_CAN_CH0_ID_51A_Sig_HU_IPDayNightControl() == 2)
    //         {
    //             tbl_index = 0;
    //         }
    //     }
    // }
    // else 
    // {
    //     if(Get_CAN_CH0_ID_389_Sig_BCM_PositionLampSwitchStatus() == 2)
    //     {
    //         tbl_index = 0;  //黑夜
    //     }
    //     else 
    //     {
    //         tbl_index = 1;
    //     }
    // }
    if(Line_In_Get_Status(LINE_IN_LAMPLET) == 0)
    {
        BackGoal_Temp = 800;
        SetLED_PWM(1);
    }
    else
    {
        BackGoal_Temp = 200;
        SetLED_PWM(0);
    }
    

    tmpBr                  = ( uint32_t )(BackGoal_Temp );
    BackLightCtrl.BackGoal = ( uint16_t )tmpBr;

    BackLightCtrl.BackGoalBackUp = BackLightCtrl.BackGoal;
}

uint8_t Get_BackDay_LV_App(void)
{
    return BackDay_Old;
}
uint8_t Get_BackNight_LV_App(void)
{
    return BackNight_Old;
}
uint8_t Get_BackSend_Temp(void)
{
    return BackSend_Temp;
}

void Set_Theme_Color(void)
{

}

uint8_t Get_Theme_App(void)
{
    return Theme_APP;
}

uint8_t GET_BackLight_APP_TX(void)
{
    return tbl_index;
}
/******************************************************************************
函数名：BackLight_Ctrl_Service
�?  能：�?标值监�?
�?  数：�?
返回值：�?
******************************************************************************/
void BackLight_Goal_Monitor(void)
{
    BackLight_Get_Goal( );
    Set_Theme_Color();
}

/******************************************************************************
函数名：BL_PWM_Duty_Cycle_Delta
�?  能：背光阻尼处理
�?  数：�?
返回值：�?
******************************************************************************/
void BackLight_PWM_Duty_Cycle_Delta(uint16_t Goal, uint16_t *Current, uint16_t *DampingTimer)
{

    uint16_t Delta  = 0;
    uint16_t Delta1 = 0;

    if ( Goal > (*Current) )    //�?标值大于当前�?
    {
        Delta  = Goal - (*Current);
        Delta1 = Goal - (*Current);

        (*DampingTimer)++;

        if ( (*DampingTimer) >= 1 )
        {
            (*DampingTimer) = 0;

            Delta /= 3;

            if ( Delta == 0 )
            {
                Delta = 1;
            }

            if ( (*Current) < Goal )
            {
                (*Current) += Delta;
            }
            if ( (*Current) > Goal )
            {
                (*Current)      = Goal;
                (*DampingTimer) = 0;
            }
        }
    }
    else if ( Goal < (*Current) )    //�?标值小于当前�?
    {
        Delta = (*Current) - Goal;

        (*DampingTimer)++;

        if ( (*DampingTimer) >= 1 )
        {
            (*DampingTimer) = 0;

            Delta /= 3;

            if ( Delta == 0 )
            {
                Delta = 1;
            }
            if ( (*Current) > Goal )
            {
                (*Current) -= Delta;
            }
            if ( (*Current) < Goal )
            {
                (*Current)      = Goal;
                (*DampingTimer) = 0;
            }
        }
    }
}

void BackLight_Back_PWM_Init(void)
{
    PWM_Channel_Init(7, 0, 0, 0, 0);
    PWM_Channel_Set_Freq(7, 1000);
    PWM_Channel_Init(9, 0, 0, 0, 0);
    PWM_Channel_Set_Freq(9, 1000);
    PWM_Channel_Init(15, 0, 0, 0, 0);
    PWM_Channel_Set_Freq(15, 1500);
}
void BackLight_Back_Set_Brightness(uint16_t Br)
{
    if ( Br != BackLightCtrl.BackBrightness )
    {
        BackLightCtrl.BackBrightness = Br;
    }
}
void BackLight_Back_Shutdown(void)
{
    PWM_Channel_Stop(7);
    PWM_Channel_Stop(9);
    PWM_Channel_Stop(15);
}

void BackLight_Contrl_Init(void)
{
    NTCDEGREE                      = 0U;
    BackLightCtrl.BackGoal         = 0U;
    BackLightCtrl.BackCurrent      = 0U;
    BackLightCtrl.BackBrightness   = 0U;
    BackLightCtrl.LostTimer        = 0U;
    BackLightCtrl.BackGoalBackUp   = 0U;
    BackLightCtrl.BackLightValid   = 0U;
    BackLightCtrl.FactorLevelBack  = 0U;
    BackLightCtrl.BackDampingTimer = 0U;
    BackLightCtrl.Ntc_Timer        = 0U;
    BackLightCtrl.Ntc_Factor       = 100U;
    BackLightCtrl.Off_Delay_Timer  = 0U;
    BackLightCtrl.Bl_delay         = 0U;
    BackLightCtrl.Delay_Tag        = 0U;
    BackLightCtrl.BackLightSYNC    = 0U;
    BackLightCtrl.led_Delay_Timer  = 0U;
    BackLightCtrl.led_status       = 0U;
    BackLight_Ctrl                 = 0U;
    tbl_index                      = 1u;
    // SetLED_PWM(1u);
}
void BackLight_30_Init(void)
{
    BackLight_Back_PWM_Init( );
    BackLight_Contrl_Init( );
    BackLightCtrl.SleepStatus = 0U;
}

void BackLight_LV_30_Init(void)
{
    Theme_Color = 1;
    Theme_Color_Old = 1;
    Theme_APP = 5;
    BackNight_Old = 0xFFu;
    BackDay_Old = 0xFFu;
}

void BackLight_15_Init(void)
{
    tbl_index = 1u;
    // SetLED_PWM(1u);
}
void BackLight_WakeUp_Init(void)
{
    BackLight_Back_PWM_Init( );
    BackLight_Contrl_Init( );
}
void BackLight_Sleep_Init(void)
{
    BackLight_Contrl_Init( );
    PWM_Channel_Set_Duty(7U, 0U);
    PWM_Channel_Set_Duty(9U, 0U);
    PWM_Channel_Set_Duty(15U, 0U);

    BackLightCtrl.SleepStatus = 1U;
}

/**
 * [Remote_Start_Signal description]
 * @return  [1:Remote Start 0 Not Remote Start]
 */
uint8_t Remote_Start_Signal(void)
{
    uint8_t value = 0u;

    return value;
}

// #define AD_AVE_BUFF_LEN (5)

/*typedef struct
{
    uint16_t Voltage;    // AD采集电压值
    uint8_t  Degree;     //温度值
} NTCStaticAttrStruct;

//温度数组长度
#define NTC_TEMP_ARRAY_LEN (11)
static const NTCStaticAttrStruct NTCStaticAttrs [ NTC_TEMP_ARRAY_LEN ] = {
    {2312, 75},
    {2359, 76},
    {2405, 77},
    {2452, 78},
    {2498, 79},
    {2544, 80},
    {2589, 81},
    {2634, 82},
    {2679, 83},
    {2724, 84},
    {2770, 85},
};

//根据电压值，确定热敏电阻的温度(摄氏度)
uint8_t ADProcess_NTC_Temp_Get(uint16_t NTCVoltage)
{
    uint8_t i;

    if ( NTCVoltage < 2312 )
        return 0;

    if ( NTCVoltage > 5000 )
        return 0;

    if ( (NTCVoltage > 2770) && (NTCVoltage < 5000) )
        return 85;

    //寻找所在的温度段
    for ( i = 0; i < NTC_TEMP_ARRAY_LEN; i++ )
    {
        if ( NTCVoltage <= NTCStaticAttrs [ i ].Voltage )
            return NTCStaticAttrs [ i ].Degree;
    }
    return 0;
}*/

//获取热敏电阻采集温度服务
//周期：20ms
// void ADProcess_NTC_Temp_Service(void)
// {
//     //热敏电阻电压采集消抖
//     static uint8_t  CalcCnt          = 0;
//     static uint32_t Calc             = 0;
//     uint32_t        AnalogNtcVoltage = 0;

//     if ( ADC_Read_Signal_Valid(ADC_CH_NTC_R) == 1 )
//     {
//         AnalogNtcVoltage = ADC_Read_Signal_Voltage(ADC_CH_NTC_R);
//         AnalogNtcVoltage *= 5000;
//         AnalogNtcVoltage /= 4096;
//         if ( AnalogNtcVoltage < 5000 )
//         {

//             //采集次数增加
//             CalcCnt++;
//             //采集值累计
//             Calc += AnalogNtcVoltage;

//             //采集次数超过50次，取平均值（50*20ms=1S）
//             if ( CalcCnt >= 50 )
//             {
//                 //热敏电阻的采集电压有效，获取对应的温度值
//                 NTCDegree = ADProcess_NTC_Temp_Get(Calc / 50);
//                 //重新采集50次
//                 CalcCnt = 0;
//                 Calc    = 0;
//             }
//         }
//         // end
//     }
//     //采集的电压异常
// }