#include "EOL_Para.h"
#include "RTE_CAN.h"
#include "CAN_Lib.h"
#include "CAN_APP.h"
#include "CAN_APP_TX.h"
#include "Services_Mileage.h"
#include "Common_Interface.h"
#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "Services_Mileage_User.h"
#include "Data_IGN_OFF_Timing.h"
#include "Analog_Signals.h"
#include "DisplaySch.h"
#include "Data_VSpeed.h"
#include "Sound_Scheduler.h"
#include "Popup_Message_List.h"
#include "Popup_Scheduler.h"
#include "BackLight.h"
#include "Popups.h"
#include "Popup_List.h"
#include "Line_In_user.h"
#include "Line_in.h"
#include "DisplaySch.h"
#include "Telltales_user.h"
#include "Telltales_Lib.h"
#include "Transmission_oil_Tem_Table.h"
#include "Display.h"
#include "Configuration.h"

static uint8_t          EngineCoolanTemperatureHighBackup = 0;
uint8_t                 Three_Timer                       = 0u;
static volatile uint8_t CarWashModeFeedback               = 0u;
static volatile uint8_t CarWashModeFeedbackCnt            = 0u;
static uint8_t          ShortTermClrFlg                   = 0u;
static uint8_t          LongTermClrFlg                    = 0u;
static uint8_t          WholeTermClrFlg                   = 0u;
static uint8_t          RefuelEndClrFlg                   = 0u;
static uint8_t          ShortTermClrFlgTimer              = 0u;
static uint8_t          LongTermClrFlgTimer               = 0u;
static uint8_t          WholeTermClrFlgTimer              = 0u;
static uint8_t          RefuelEndClrFlgTimer              = 0u;
static uint8_t IPRaceModeMemCnt = 0u;
static uint8_t     soundSumBkp = 0u;

static uint8_t Fuel_Low_Old = 0;
uint8_t Fuel_Low_Old_6s = 0;
static uint16_t Popup_ID_Old;
uint8_t LDW_Failure_1S;

void Data_CAN_APP_Init(void)
{
    Fuel_Low_Old_6s = 0;
}

uint8_t CRC8_SAE_J1850(uint8_t *u8_data, uint8_t u8_len)
{
    uint8_t i, j;
    uint8_t u8_crc8;
    uint8_t u8_poly;

    u8_crc8 = 0xFF;
    u8_poly = 0x1D;

    for ( i = 0; i < u8_len; i++ )
    {
        u8_crc8 ^= u8_data [ i ];

        for ( j = 0; j < 8; j++ )
        {
            if ( u8_crc8 & 0x80 )
            {
                u8_crc8 = (( uint8_t )((u8_crc8 << 1) ^ u8_poly));
            }
            else
            {
                u8_crc8 <<= 1;
            }
        }
    }

    u8_crc8 ^= ( uint8_t )0xFF;
    return u8_crc8;
}
void Can_Write_Fun_APP(void)
{
}

void Can_Abort_Confirm(uint32_t Identifier, uint8_t TransferStatus)
{
}

void CAN_QuickTimer_Init(void)
{
}

void NODE_26D_SET_Confirm(void)
{
}

void Can_BusOff_Fun(void)
{
}

void Set_CarWashModeFeedback(uint8_t status)
{
    if ( status == 1U )
    {
        if ( CarWashModeFeedback != status )
        {
            CarWashModeFeedback    = 1U;
            CarWashModeFeedbackCnt = 0U;
        }
    }
    else if ( status == 2 )
    {
        if ( CarWashModeFeedback == 1 )
        {
            CarWashModeFeedback    = status;
            CarWashModeFeedbackCnt = 0u;
        }
    }
    else
    {
        CarWashModeFeedback    = 0u;
        CarWashModeFeedbackCnt = 0u;
    }
}

void Can_Set_Buff_0CFE6C17(canlib_uint8_t CopyData [])
{
    CANMsg0CFE6C17Union *p0CFE6C17;
    uint32_t             vSpeed_Val;
    uint8_t              i = 0;
    for ( i = 0; i < 8; i++ )
    {
        CopyData [ i ] = 0xFFU;
    }

    p0CFE6C17 = ( CANMsg0CFE6C17Union * )CopyData;
    if ( p0CFE6C17 != ( void * )0 )
    {
        CopyData [ 6 ] = 0x00u;
        CopyData [ 7 ] = 0x02u;
    }
}


void Can_Set_Buff_0CFE6CEE(uint8_t CopyData [])
{
	uint8_t i = 0;
	CANMsg0CFE6CEEUnion *pCANMsg0CFE6CEE;
	pCANMsg0CFE6CEE = ( CANMsg0CFE6CEEUnion * )CopyData;
	if ( pCANMsg0CFE6CEE != ( void * )0 )
	{
		for ( i = 0u; i < 8u; i++ )
		{
			pCANMsg0CFE6CEE->Msg [ i ] = 0;
		}
	}
}

void Can_Set_Buff_18EA0017(uint8_t CopyData [])
{
	uint8_t i = 0;
    static uint8_t Signal = 0u;
    static uint8_t Signal_Last = 0u;
	CANMsg18EA0017Union *pCANMsg18EA0017;
	pCANMsg18EA0017 = ( CANMsg18EA0017Union * )CopyData;
	if ( pCANMsg18EA0017 != ( void * )0 )
	{
		for ( i = 0u; i < 8u; i++ )
		{
			pCANMsg18EA0017->Msg [ i ] = 0;
		}

        if (Signal == 0u) // 发动机怠速时间外发   50ms切换
        {
            if (((Get_Stater_Type() == SHANGCHAI) || (Get_Stater_Type() == KANGMINGSI) || (Get_Stater_Type() == YUNNEI) ||
                 (Get_Stater_Type() == YUCHAI) || (Get_Stater_Type() == LUOTUO)) &&
                (Common_Get_IG_Sts() == COMMON_POWER_ON))
            {
                pCANMsg18EA0017->Sig.IP_PGN_A = 0xDC;
                pCANMsg18EA0017->Sig.IP_PGN_B = 0xFE;
                pCANMsg18EA0017->Sig.IP_PGN_C = 0;
                Signal = 4u;
                Signal_Last = 0u;
            }
            else
            {
                Signal = 1u;
            }
        }

        if (Signal == 1u) // 发动机运行时间外发  50ms切换
        {
            if (Common_Get_IG_Sts() == COMMON_POWER_ON)
            {
                pCANMsg18EA0017->Sig.IP_PGN_A = 0xE5;
                pCANMsg18EA0017->Sig.IP_PGN_B = 0xFE;
                pCANMsg18EA0017->Sig.IP_PGN_C = 0;
                Signal = 4u;
                Signal_Last = 1u;
            }
            else
            {
                Signal = 2u;
            }
        }

        if (Signal == 2u) // 发动机怠速油耗外发   50ms切换
        {
            if (((Get_Stater_Type() == SHANGCHAI) || (Get_Stater_Type() == KANGMINGSI) || (Get_Stater_Type() == YUNNEI) ||
                 (Get_Stater_Type() == YUCHAI) || (Get_Stater_Type() == LUOTUO)) &&
                (Common_Get_IG_Sts() == COMMON_POWER_ON))
            {
                pCANMsg18EA0017->Sig.IP_PGN_A = 0xDC;
                pCANMsg18EA0017->Sig.IP_PGN_B = 0xFE;
                pCANMsg18EA0017->Sig.IP_PGN_C = 0;
                Signal = 4u;
                Signal_Last = 2u;
            }
            else
            {
                Signal = 3u;
            }
        }

        if (Signal == 3u) // 总计油耗外发   50ms切换
        {
            if ((Common_Get_IG_Sts() == COMMON_POWER_ON))
            {
                pCANMsg18EA0017->Sig.IP_PGN_A = 0xE9;
                pCANMsg18EA0017->Sig.IP_PGN_B = 0xFE;
                pCANMsg18EA0017->Sig.IP_PGN_C = 0;
                Signal = 4u;
                Signal_Last = 3u;
            }
            else
            {
                Signal = 4u;
            }
        }

        if(Signal == 4u)
        {
            Signal_Last++;
            if(Signal_Last >= 4)
            {
                Signal_Last = 0u;
            }
            Signal = Signal_Last;
        }
    }
}

void Can_Set_Buff_18EA0021(uint8_t CopyData [])
{
	uint8_t i = 0;
    static uint8_t Signal = 0u;
    static uint8_t Signal_Last = 0u;
	CANMsg18EA0021Union *pCANMsg18EA0021;
	pCANMsg18EA0021 = ( CANMsg18EA0021Union * )CopyData;
	if ( pCANMsg18EA0021 != ( void * )0 )
	{
		for ( i = 0u; i < 8u; i++ )
		{
			pCANMsg18EA0021->Msg [ i ] = 0;
		}
        
        if (Signal == 0u) // 发动机怠速时间外发   50ms切换
        {
            if (((Get_Stater_Type() == SHANGCHAI) || (Get_Stater_Type() == KANGMINGSI) || (Get_Stater_Type() == YUNNEI) ||
                 (Get_Stater_Type() == YUCHAI) || (Get_Stater_Type() == LUOTUO)) &&
                (Common_Get_IG_Sts() == COMMON_POWER_ON))
            {
                pCANMsg18EA0021->Sig.IP_PGN_A = 0xDC;
                pCANMsg18EA0021->Sig.IP_PGN_B = 0xFE;
                pCANMsg18EA0021->Sig.IP_PGN_C = 0;
                Signal = 4u;
                Signal_Last = 0u;
            }
            else
            {
                Signal = 1u;
            }
        }

        if (Signal == 1u) // 发动机运行时间外发  50ms切换
        {
            if (Common_Get_IG_Sts() == COMMON_POWER_ON)
            {
                pCANMsg18EA0021->Sig.IP_PGN_A = 0xE5;
                pCANMsg18EA0021->Sig.IP_PGN_B = 0xFE;
                pCANMsg18EA0021->Sig.IP_PGN_C = 0;
                Signal = 4u;
                Signal_Last = 1u;
            }
            else
            {
                Signal = 2u;
            }
        }

        if (Signal == 2u) // 发动机怠速油耗外发   50ms切换
        {
            if (((Get_Stater_Type() == SHANGCHAI) || (Get_Stater_Type() == KANGMINGSI) || (Get_Stater_Type() == YUNNEI) ||
                 (Get_Stater_Type() == YUCHAI) || (Get_Stater_Type() == LUOTUO)) &&
                (Common_Get_IG_Sts() == COMMON_POWER_ON))
            {
                pCANMsg18EA0021->Sig.IP_PGN_A = 0xDC;
                pCANMsg18EA0021->Sig.IP_PGN_B = 0xFE;
                pCANMsg18EA0021->Sig.IP_PGN_C = 0;
                Signal = 4u;
                Signal_Last = 2u;
            }
            else
            {
                Signal = 3u;
            }
        }

        if (Signal == 3u) // 总计油耗外发   50ms切换
        {
            if ((Common_Get_IG_Sts() == COMMON_POWER_ON))
            {
                Signal = 4u;
                Signal_Last = 3u;
            }
            else
            {
                Signal = 4u;
            }
        }

        if (Signal == 4u)
        {
            Signal_Last++;
            if (Signal_Last >= 4)
            {
                Signal_Last = 0u;
            }
            Signal = Signal_Last;
        }
    }
}

void Can_Set_Buff_18FEFB17(uint8_t CopyData [])
{
	uint8_t i = 0;
	CANMsg18FEFB17Union *pCANMsg18FEFB17;
	pCANMsg18FEFB17 = ( CANMsg18FEFB17Union * )CopyData;
	if ( pCANMsg18FEFB17 != ( void * )0 )
	{
		for ( i = 0u; i < 8u; i++ )
		{
			pCANMsg18FEFB17->Msg [ i ] = 0;
		}
        if ( Get_Hydraulic_Oil_Resistance_Temperature() > 120 )  //错误状态
        {
            pCANMsg18FEFB17->Sig.IP_HydraulicOilTemperature = 0xFF;
        }
        else
        {
            pCANMsg18FEFB17->Sig.IP_HydraulicOilTemperature = (Get_Hydraulic_Oil_Resistance_Temperature() + 40);
        }
	}
}

void Can_Set_Buff_18FEB117(uint8_t CopyData [])
{
	uint8_t i = 0;
	CANMsg18FEB117Union *pCANMsg18FEB117;
	pCANMsg18FEB117 = ( CANMsg18FEB117Union * )CopyData;
	if ( pCANMsg18FEB117 != ( void * )0 )
	{
		for ( i = 0u; i < 8u; i++ )
		{
			pCANMsg18FEB117->Msg [ i ] = 0;
		}

        if(Get_TelltalesLedSts(m_LED_Coolant) != 0)
        {
            pCANMsg18FEB117->Sig.IP_CoolantTemperatureHigh = 1;
        }
        else
        {
            pCANMsg18FEB117->Sig.IP_CoolantTemperatureHigh = 0;
        }

        if (Get_TelltalesLedSts(m_LED_Transmission_High) == 1 ||
            Get_Transmission_Oil_Temperature_Flash_status() == 1)
        {
            pCANMsg18FEB117->Sig.IP_TransmissionOilTemperatureHigh = 1;
        }
        else
        {
             pCANMsg18FEB117->Sig.IP_TransmissionOilTemperatureHigh = 0;
        }

        if ((Get_TelltalesLedSts(m_LED_BrakePressure) == 1 )|| 
            (Get_Brake_Pressure_Flash_status() == 1))
        {
            pCANMsg18FEB117->Sig.IP_AirPressureWarning = 1;
        }
        else
        {
            pCANMsg18FEB117->Sig.IP_AirPressureWarning = 0;
        }

        if (Get_TelltalesLedSts(m_LED_High_Exhaust_Temperature) == 1)
        {
            pCANMsg18FEB117->Sig.IP_ExhaustedGasTemperatureHigh = 1;
        }
        else
        {
             pCANMsg18FEB117->Sig.IP_ExhaustedGasTemperatureHigh = 0;
        }

        if (Get_TelltalesLedSts(m_LED_Engine_Stop) == 1 || Get_TelltalesLedSts(m_LED_Engine_Stop) == 2 || Get_TelltalesLedSts(m_LED_Engine_Stop) == 3)
        {
            pCANMsg18FEB117->Sig.IP_EngineStop = 1;
        }
        else
        {
             pCANMsg18FEB117->Sig.IP_EngineStop = 0;
        }

        if (Get_TelltalesLedSts(m_LED_Air_Filter_Blocked) == 1)
        {
            pCANMsg18FEB117->Sig.IP_AirFilterBlocked = 1;
        }
        else
        {
             pCANMsg18FEB117->Sig.IP_AirFilterBlocked = 0;
        }

        if (Get_TelltalesLedSts(m_LED_Fuel_Filter_Plugging) == 1)
        {
            pCANMsg18FEB117->Sig.IP_FuelFilterBlocked = 1;
        }
        else
        {
             pCANMsg18FEB117->Sig.IP_FuelFilterBlocked = 0;
        }

        if (Get_TelltalesLedSts(m_LED_Safety_Belt) == 1)
        {
            pCANMsg18FEB117->Sig.IP_Seatbelt = 1;
        }
        else
        {
             pCANMsg18FEB117->Sig.IP_Seatbelt = 0;
        }

        if (Get_TelltalesLedSts(m_LED_Oil_Water_Separation) == 1)
        {
            pCANMsg18FEB117->Sig.IP_WaterInFuelPreheating = 1;
        }
        else
        {
             pCANMsg18FEB117->Sig.IP_WaterInFuelPreheating = 0;
        }

        if (Get_TelltalesLedSts(m_LED_Reversal_Cooling_fan) == 1)
        {
            pCANMsg18FEB117->Sig.IP_CoolingFanReversal = 1;
        }
        else
        {
             pCANMsg18FEB117->Sig.IP_CoolingFanReversal = 0;
        }

        if (Get_TelltalesLedSts(m_LED_Power_cut_off) == 1)
        {
            pCANMsg18FEB117->Sig.IP_PowerCutoff  = 1;
        }
        else
        {
             pCANMsg18FEB117->Sig.IP_PowerCutoff  = 0;
        }

        if (Get_TelltalesLedSts(m_LED_Emergency_Steering) == 1)
        {
            pCANMsg18FEB117->Sig.IP_EmergencySteering   = 1;
        }
        else
        {
             pCANMsg18FEB117->Sig.IP_EmergencySteering   = 0;
        }

        if (Get_TelltalesLedSts(m_LED_Bridge_Oil_Temperature_Is_High) == 1)
        {
            pCANMsg18FEB117->Sig.IP_AxleOilTemperature   = 1;
        }
        else
        {
             pCANMsg18FEB117->Sig.IP_AxleOilTemperature   = 0;
        }

        if (Get_TelltalesLedSts(m_LED_Low_Cooling_Level) == 1)
        {
            pCANMsg18FEB117->Sig.IP_CoolantLevelLow    = 1;
        }
        else
        {
             pCANMsg18FEB117->Sig.IP_CoolantLevelLow   = 0;
        }

        if(Get_TelltalesLedSts(m_LED_Bridgefilterblocked)==1u)
        {
            pCANMsg18FEB117->Sig.IP_AxleFilterBlocked = 1u;
        }
        else
        {
            pCANMsg18FEB117->Sig.IP_AxleFilterBlocked = 0u;
        }

        if(Get_TelltalesLedSts(m_LED_Wheeldifferentiallock)==1u)
        {
            pCANMsg18FEB117->Sig.IP_AxleDifferentialLocked = 1u;
        }
        else
        {
            pCANMsg18FEB117->Sig.IP_AxleDifferentialLocked = 0u;
        }

        if(Get_TelltalesLedSts(m_LED_Hydraulicoilfilterblockagesignal)==1u)
        {
            pCANMsg18FEB117->Sig.IP_HydraulicOilFilterBlocked = 1u;
        }
        else
        {
            pCANMsg18FEB117->Sig.IP_HydraulicOilFilterBlocked = 0u;
        }

        if(Get_TelltalesLedSts(m_LED_RadiatingOilFilterBlocked)==1u)
        {
            pCANMsg18FEB117->Sig.IP_RadiatingOilFilterBlocked = 1u;
        }
        else
        {
            pCANMsg18FEB117->Sig.IP_RadiatingOilFilterBlocked = 0u;
        }

        if(Get_TelltalesLedSts(m_LED_LCD_Transmission_failure)==1u)
        {
            pCANMsg18FEB117->Sig.IP_TransmissionFailure = 1u;
        }
        else
        {
            pCANMsg18FEB117->Sig.IP_TransmissionFailure = 0u;
        }

        if(Get_EngineOilPressure_Flash_status() == 1u)
        {
            pCANMsg18FEB117->Sig.IP_EngineOilPressureWarning = 1u;
        }
        else
        {
            pCANMsg18FEB117->Sig.IP_EngineOilPressureWarning = 0u;
        }
        if(Get_TransmissionOilPressure_Status() == 1u)
        {
            pCANMsg18FEB117->Sig.IP_TransmissionOilPressureWarning = 1u;
        }
        else
        {
            pCANMsg18FEB117->Sig.IP_TransmissionOilPressureWarning = 0u;
        }
        if(Get_TelltalesLedSts(m_LED_AutoShiftGear) == 1u)
        {
            pCANMsg18FEB117->Sig.IP_AutoShiftGear = 1u;
        }
        else
        {
            pCANMsg18FEB117->Sig.IP_AutoShiftGear = 0u;
        }
        if(Get_EldingLevelPercent_Flash_status() == 1u)
        {
            pCANMsg18FEB117->Sig.IP_EldingLevelLow = 1u;
        }
        else
        {
            pCANMsg18FEB117->Sig.IP_EldingLevelLow = 0u;
        }
        if(Get_TelltalesLedSts(m_LED_Parking_Braking)==1u)
        {
            pCANMsg18FEB117->Sig.IP_ParkingBrake= 1u;
        }
        else
        {
            pCANMsg18FEB117->Sig.IP_ParkingBrake= 0u;
        }
	}
}

void Can_Set_Buff_18057F17(uint8_t CopyData [])
{
	uint8_t i = 0;
	CANMsg18057F17Union *pCANMsg18057F17;
	pCANMsg18057F17 = ( CANMsg18057F17Union * )CopyData;
	if ( pCANMsg18057F17 != ( void * )0 )
	{
		for ( i = 0u; i < 8u; i++ )
		{
			pCANMsg18057F17->Msg [ i ] = 0;
		}
        if (Get_Display_Brake_Pressure_WrongS_Status() == 1)
        {
            pCANMsg18057F17->Sig.IP_AirPressure = 0xFF;
        }
        else
        {
            if (ADC_Read_Signal(ADC_CH_BRAKEAIRPRESSURE_VOLTAGE) >= 3221 ||
                ADC_Read_Signal(ADC_CH_BRAKE_AIRPRESSURE) >= 1840)
            {
                pCANMsg18057F17->Sig.IP_AirPressure = 0xFA;
            }
        }

        if(ADC_Read_Signal(ADC_CH_WETBRAKE_VOLTAGE) >= 5000)
        {
            pCANMsg18057F17->Sig.IP_WetBrake = 0xFA;
        }
        else
        {
            pCANMsg18057F17->Sig.IP_WetBrake = 0xFF;
        }

        if(Get_OilTem_Flash_status() == 1)
        {
            pCANMsg18057F17->Sig.IP_TransmissionOilTemperature_L = 0xFF;
            pCANMsg18057F17->Sig.IP_TransmissionOilTemperature_H = 0xFF;
        }
        if ((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FD95_Msg_Count) == CAN_SIG_NORMAL) )
        {
            if((Get_CAN_CH0_ID_18FD9503_Sig_TransmissionOilTemperature()/32) > 2008)                //温度上限
            {
                pCANMsg18057F17->Sig.IP_TransmissionOilTemperature_L = 0xFF;
                pCANMsg18057F17->Sig.IP_TransmissionOilTemperature_H = 0xFF;
            }
            else
            {
                if((Get_CAN_CH0_ID_18FD9503_Sig_TransmissionOilTemperature()/32) <= 223)
                {
                    pCANMsg18057F17->Sig.IP_TransmissionOilTemperature_L = 0u;
                    pCANMsg18057F17->Sig.IP_TransmissionOilTemperature_H = 0u;
                }
                if((Get_CAN_CH0_ID_18FD9503_Sig_TransmissionOilTemperature()/32) > 223 && 
                   (Get_CAN_CH0_ID_18FD9503_Sig_TransmissionOilTemperature()/32) <= 473)
                {
                    pCANMsg18057F17->Sig.IP_TransmissionOilTemperature_L = ((Get_CAN_CH0_ID_18FD9503_Sig_TransmissionOilTemperature()/32) - 223);
                    pCANMsg18057F17->Sig.IP_TransmissionOilTemperature_H = 0u; 
                }
                if((Get_CAN_CH0_ID_18FD9503_Sig_TransmissionOilTemperature()/32) > 473)
                {
                    pCANMsg18057F17->Sig.IP_TransmissionOilTemperature_L = 250u;
                    pCANMsg18057F17->Sig.IP_TransmissionOilTemperature_H = 0u;
                }
            }
        }
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_DANA_Msg_Count) == CAN_SIG_NORMAL)
        {
            pCANMsg18057F17->Sig.IP_TransmissionOilTemperature_L = Get_CAN_CH0_ID_0CFF3003_Sig_TransmissionOilTemperature();
            pCANMsg18057F17->Sig.IP_TransmissionOilTemperature_H = 0u;
        }
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_TOT_Msg_Count) == CAN_SIG_NORMAL)
        {
            pCANMsg18057F17->Sig.IP_TransmissionOilTemperature_L = Get_CAN_CH0_ID_18FF1F03_Sig_TransmissionOilTemperatureofZF();
            pCANMsg18057F17->Sig.IP_TransmissionOilTemperature_H = 0u;
        }


	}
}



// TODO  下电超过2小时，再次上次调用一次
void Set_ShortTermClrFlg(uint8_t Flag)
{
    ShortTermClrFlg      = Flag;
    ShortTermClrFlgTimer = Flag;
}

void Set_LongTermClrFlg(uint8_t Flag)
{
    LongTermClrFlg      = 1u;
    LongTermClrFlgTimer = 0u;
}

// TODO  加油超过最小加油量，调用一次，最小加油量没找到
void Set_RefuelEndClrFlg(uint8_t Flag)
{
    RefuelEndClrFlg      = 1u;
    RefuelEndClrFlgTimer = 0u;
}

// TODO  综合平均电耗清零，没找到调用的地方
void Set_WholeTermClrFlg(uint8_t Flag)
{
    WholeTermClrFlg      = 1u;
    WholeTermClrFlgTimer = 0u;
}
