#include  "CAN_CH0_CAN_Communication_Matrix.h"
#include "CAN_APP.h"

/* 2023/08/28 10:14:54 */
st_CanMsgOp CAN_CH0_CanMsgOp;
st_CanMsgTxOp CAN_CH0_CanMsgTxOp;
#define CAN_CH0 &CAN_CH0_CanMsgOp

const st_CAN_SendAttribute    CAN_CH0_CANSendAttr[CAN_CH0_ID_SEND_TOTAL] =
{
    {0x0CFE6C17ul,   50ul * 1000ul,   0ul, 0u, 1, 2u, 8u, 0,    Can_Set_Buff_0CFE6C17, ( void * )0},
    {0x0CFE6CEEul,   50ul * 1000ul,   0ul, 0u, 1, 3u, 8u, 0,    Can_Set_Buff_0CFE6CEE, ( void * )0},
	{0x18EA0017ul,   50ul * 1000ul,   0ul, 0u, 1, 4u, 8u, 0,    Can_Set_Buff_18EA0017, ( void * )0},
	{0x18EA0021ul,   50ul * 1000ul,   0ul, 0u, 1, 5u, 8u, 0,    Can_Set_Buff_18EA0021, ( void * )0},
	{0x18FEFB17ul,  200ul * 1000ul,   0ul, 0u, 1, 6u, 8u, 0,    Can_Set_Buff_18FEFB17, ( void * )0},
	{0x18FEB117ul,  200ul * 1000ul,   0ul, 0u, 1, 7u, 8u, 0,    Can_Set_Buff_18FEB117, ( void * )0},
	{0x18057F17ul,  200ul * 1000ul,   0ul, 0u, 1, 8u, 8u, 0,    Can_Set_Buff_18057F17, ( void * )0},
};

const st_CANMsgAttribute CAN_CH0_CAN_MSG_CONST_ARRAY[CAN_CH0_ID_TOTAL_MAX] =
{
    {
        {0x00u, 0x0Fu, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FECA00ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FECA21ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FECA03ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18057F17ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEB117ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEFB17ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18EA0021ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18EA0017ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0xCFE6CEEul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x0Du, 0x00u, 0x15u, 0x15u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FF0103ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FF1E03ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEF803ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0xFFu, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FF1F03ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        50ul,
        0xCF00203ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FF2203ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEE400ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        50000ul,
        0x18FEFF00ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FDC700ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FEE227ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FEE200ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEE900ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEDC00ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        2500ul,
        0x18FEF600ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEE500ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FBFBF1ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FFFF00ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FF4503ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x18FF4421ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x18FF4321ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x18FF4221ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x18FF4121ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FF3203ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0xFFu, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FF3103ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x18FE6C27ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FD9503ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x18FD7B00ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0xFFu, 0xFFu, 0x00u, 0x00u, 0x00u, 0xFFu, 0xFFu},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FC2A00ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0xF00503ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FE4A03ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEEE00ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18F00029ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FF0800ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        2500ul,
        0x18FEEF00ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        250ul,
        0xCF00300ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        100ul,
        0xCF00400ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18EB0800ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FD7C00ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FD0700ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        100ul,
        0xCFF3003ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FFC100ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FEF100ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEF527ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEF500ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x10FBF5AAul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FE56A3ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FE563Dul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FE5600ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
};

uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_FlashMalfuctionIndicatorLamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_DM1_ECU_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_FlashRedWarningLamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_DM1_ECU_Msg_Count, 1u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_FlashAmberWarningLamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_DM1_ECU_Msg_Count, 1u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_FlashProtectLamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_DM1_ECU_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_MalfuctionIndicatorLampStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_DM1_ECU_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_RedWarningLampStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_DM1_ECU_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_AmberWarningLampStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_DM1_ECU_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_ProtectLampStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_DM1_ECU_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FECA21_Sig_RedWarningLampStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_DM1_BCU_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FECA21_Sig_ProtectLampStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_DM1_BCU_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FECA03_Sig_RedWarningLampStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_DM1_AMT_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FECA03_Sig_AmberWarningLampStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_DM1_AMT_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint16_t Get_CAN_CH0_ID_18057F17_Sig_TransmissionOilTemperature(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_057F_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_057F_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18057F17_Sig_AirPressure(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_057F_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18057F17_Sig_WetBrake(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_057F_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18057F17_Sig_EldingLevelPercent(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_057F_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_CoolantLevelLow(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 7u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_Seatbelt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 7u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_AutoShiftGear(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 7u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_AxleDifferentialLocked(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 7u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_DEFResistanceHigh(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 7u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_ForbiddenRegenerationIndicator(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 7u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_RegenerationIndicator(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 7u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_EmergencySteeringSolenoidValve(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 7u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_ExhaustedGasTemperatureHigh(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 6u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_CoolingFanReversal(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 6u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_EngineStop(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 6u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_TransmissionFailure(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 6u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_RadiatingOilFilterBlocked(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 6u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_HydraulicOilFilterBlocked(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 6u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_WaterInFuelPreheating(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 6u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_AxleFilterBlocked(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 6u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_HydraulicOilTemperature(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 5u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_FuelFilterBlocked(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 5u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_TransmissionOilFilterBlocked(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 5u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_PowerCutoff(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 5u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_TransmissionOilPressureWarning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 5u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_AxleOilTemperature(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 5u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_AirFilterBlocked(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 5u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_ParkingBrake(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 5u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_TransmissionOilTemperatureHigh(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 4u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_FuelLevelLow(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 4u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_CoolantTemperatureHigh(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 4u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_EngineOilPressureWarning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 4u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_AirPressureWarning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 4u) >> 0u) & 0x01u));
}

uint32_t Get_CAN_CH0_ID_18FEB117_Sig_Odometer(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEB1_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEFB17_Sig_HydraulicOilTemperature(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_FEFB_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint32_t Get_CAN_CH0_ID_18EA0021_Sig_PGN(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_Request_21_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_Request_21_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_Request_21_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint32_t Get_CAN_CH0_ID_18EA0017_Sig_PGN(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_Request_17_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_Request_17_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_Request_17_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_0CFE6CEE_Sig_TachographVehicleSpeed(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_TCO1_Msg_Count, 7u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Tx_TCO1_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF0103_Sig_CalibrationStartConditions(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_ZFCC_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF0103_Sig_ClutchStatusCR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_ZFCC_Msg_Count, 4u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF0103_Sig_ClutchStatusCG(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_ZFCC_Msg_Count, 4u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF0103_Sig_ClutchStatusCF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_ZFCC_Msg_Count, 4u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF0103_Sig_ClutchStatusCC(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_ZFCC_Msg_Count, 3u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF0103_Sig_ClutchStatusCB(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_ZFCC_Msg_Count, 3u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF0103_Sig_ClutchStatusCA(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_ZFCC_Msg_Count, 3u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF0103_Sig_CalibrationBrakeConditions(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_ZFCC_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF0103_Sig_CalibrationFinished(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_ZFCC_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF1E03_Sig_GearDirection(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_ZF_Msg_Count, 6u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF1E03_Sig_GearNumber(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_ZF_Msg_Count, 6u) >> 0u) & 0x0Fu));
}

uint16_t Get_CAN_CH0_ID_18FF1E03_Sig_OutputShaftSpeed(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_ZF_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_ZF_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEF803_Sig_TransmissionOilPressure(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_TRF1_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18FEF803_Sig_TransmissionOilTankTemperature(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_TRF1_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_TRF1_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF1F03_Sig_TransmissionOilTankTemofZF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_TOT_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF1F03_Sig_AEBSubCode(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_TOT_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF1F03_Sig_AEBMainCode(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_TOT_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF1F03_Sig_TransmissionOilTemperatureofZF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_TOT_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_0CF00203_Sig_TorqueConverterInputShaftSpeed(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_TC2_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_TC2_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_0CF00203_Sig_TorqueConverterOutputShaftSpeed(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_TC2_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_TC2_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0CF00203_Sig_TransmissionDrivelineEngaged(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_TC2_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint16_t Get_CAN_CH0_ID_18FF2203_Sig_TorqueConverterTurboTorque(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_TC1_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_TC1_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18FF2203_Sig_TorqueConverterPumpWheelTorque(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_TC1_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_TC1_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEE400_Sig_EngineWaittoStartLamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_Shutdown_Msg_Count, 3u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FEFF00_Sig_DriverWarningSystem(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_OI_Msg_Count, 1u) >> 0u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_18FEFF00_Sig_WaterInFuel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_OI_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FEFF00_Sig_DrivabilityLimitationSystem(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_OI_Msg_Count, 1u) >> 3u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_18FDC700_Sig_EngineAlternateRatingSelectState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_OHCSS_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18FEE227_Sig_InstantaneousFuelConsumption(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_LFE_27_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_LFE_27_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18FEE200_Sig_InstantaneousFuelConsumption(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_LFE_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_LFE_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint32_t Get_CAN_CH0_ID_18FEE900_Sig_TotalFuelConsumption(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_LFC_Msg_Count, 7u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_LFC_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_LFC_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_LFC_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint32_t Get_CAN_CH0_ID_18FEDC00_Sig_EngineTotalIdleHours(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_IO_Msg_Count, 7u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_IO_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_IO_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_IO_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint32_t Get_CAN_CH0_ID_18FEDC00_Sig_EngineTotalIdleFuelUsed(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_IO_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_IO_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_IO_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_IO_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEF600_Sig_IntakeManifoldAirTemperature(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_IC1_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint32_t Get_CAN_CH0_ID_18FEE500_Sig_EngineTotalHoursofOperation(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_RX_HOURS_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_RX_HOURS_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_RX_HOURS_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_RX_HOURS_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FBFBF1_Sig_GPSCommand(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_GPS_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FBFBF1_Sig_GPSLockedShield(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_GPS_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint32_t Get_CAN_CH0_ID_18FFFF00_Sig_TotalGasConsumption(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_Gas_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_Gas_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_Gas_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18FFFF00_Sig_InstantaneousGasConsumption(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_Gas_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_Gas_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF4503_Sig_TorqueConverterOilTemHigh(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF45_Msg_Count, 4u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF4503_Sig_TransmissionOilPanTemHigh(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF45_Msg_Count, 4u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF4503_Sig_OutputShaftTorqueTooHigh(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF45_Msg_Count, 3u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF4503_Sig_InputShaftTorqueTooHigh(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF45_Msg_Count, 3u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF4503_Sig_OutputShaftOverSpeed(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF45_Msg_Count, 2u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF4503_Sig_EngineOverSpeed(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF45_Msg_Count, 2u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF4503_Sig_GearFailure(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF45_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_SteeringWheelLockStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF44_Msg_Count, 2u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_InPositionStatusIndication(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF44_Msg_Count, 2u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_ECO(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF44_Msg_Count, 2u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_AutoShiftGear(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF44_Msg_Count, 1u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_FNRIndication(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF44_Msg_Count, 1u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_PowerCutoff(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF44_Msg_Count, 1u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_MachineQuickChange(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF44_Msg_Count, 1u) >> 3u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_EmergencySteering(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF44_Msg_Count, 1u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_StableModuleIndication(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF44_Msg_Count, 1u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_FanReversal(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF44_Msg_Count, 1u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_RearviewMirrorHeating(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF44_Msg_Count, 0u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_OneButtonShaking(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF44_Msg_Count, 0u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_TheTranslationalLifting(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF44_Msg_Count, 0u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_BucketAutoReturn(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF44_Msg_Count, 0u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_BucketAutoFlip(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF44_Msg_Count, 0u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_MovableArmInching(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF44_Msg_Count, 0u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_MovableArmAutoRise(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF44_Msg_Count, 0u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_MovableArmAutoDown(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF44_Msg_Count, 0u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4321_Sig_BucketMotionStatusIndication(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF43_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF4321_Sig_MovableArmMotionStatusIndication(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF43_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18FF4321_Sig_ClampCloseSolenoidValve(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF43_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF43_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18FF4321_Sig_ClampOpenSolenoidValve(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF43_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF43_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18FF4321_Sig_FanSpeedSolenoidValve(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF43_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF43_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18FF4221_Sig_MovableArmDeclineValve(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF42_Msg_Count, 7u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF42_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18FF4221_Sig_MovableArmRisingValve(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF42_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF42_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18FF4221_Sig_PullBucketSolenoidValve(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF42_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF42_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18FF4221_Sig_FlipBucketSolenoidValve(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF42_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF42_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF4121_Sig_StabilityModuleOutSolenoidVa2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF41_Msg_Count, 6u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4121_Sig_StabilityModuleOuttSolenoidVal1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF41_Msg_Count, 6u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4121_Sig_EmergencySteeringSolenoidValve(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF41_Msg_Count, 6u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4121_Sig_FanReversingValve(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF41_Msg_Count, 6u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4121_Sig_HydraulicLockStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF41_Msg_Count, 6u) >> 0u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_18FF3203_Sig_TransmissionOilPressure(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF32_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF32_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF3203_Sig_FNRIndicator(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF32_Msg_Count, 4u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF3203_Sig_TransmissionOilFilterBlocked(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF32_Msg_Count, 4u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF3203_Sig_NeutralGear(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF32_Msg_Count, 4u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF3203_Sig_PowerCutoff(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF32_Msg_Count, 4u) >> 2u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_18FF3203_Sig_MiddleShaftSpeed(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF32_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF32_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF3203_Sig_AutoShiftGear(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF32_Msg_Count, 4u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF3103_Sig_CurrentCalibrationClutch(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF31_Msg_Count, 0u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_18FF3103_Sig_OfflineCalibrationStates(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FF31_Msg_Count, 0u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_18FE6C27_Sig_GPSLockVehicleStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FE6C_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint16_t Get_CAN_CH0_ID_18FD9503_Sig_TransmissionOilTemperature(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FD95_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FD95_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FD7B00_Sig_DPFInternalsootLoad(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FD7B_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18FC2A00_Sig_SeverelyLimitSysActiRemaTime(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FC2A_Msg_Count, 7u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FC2A_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18FC2A00_Sig_PriLimitSysActRemainingTime(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FC2A_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_FC2A_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_00F00503_Sig_TransmissionStates(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_F005_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_F005_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_00F00503_Sig_TransmissionGear(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_F005_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FE4A03_Sig_TransmissionMode5Indicator(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_ETC7_Msg_Count, 4u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FE4A03_Sig_TransmissionMode3Indicator(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_ETC7_Msg_Count, 2u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FE4A03_Sig_TransmissionMode1Indicator(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_ETC7_Msg_Count, 2u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FE4A03_Sig_TransmissionMode4Indicator(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_ETC7_Msg_Count, 2u) >> 0u) & 0x03u));
}

uint16_t Get_CAN_CH0_ID_18FEEE00_Sig_EngineOilTemperature(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_ET1_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_ET1_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEEE00_Sig_FuelTemperature(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_ET1_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEEE00_Sig_CoolantTemperature(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_ET1_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18F00029_Sig_ActualRetarderPercentTorque(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_ERC1_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF0800_Sig_EnginePreheating(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_EP_Msg_Count, 2u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_18FEEF00_Sig_EngineOilPressure(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_EFLP1_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0CF00300_Sig_AcceleratorPedalPosition1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_EEC2_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_0CF00400_Sig_EngineSpeed(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_EEC1_0C_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_EEC1_0C_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0CF00400_Sig_ActualEnginePercentTorque(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_EEC1_0C_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18EB0800_Sig_LockVehicleStatusofYunnei(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_EB08_Msg_Count, 2u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FD7C00_Sig_ExhaustedGasTemperatureHigh(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_DPFC_Msg_Count, 6u) >> 2u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_18FD7C00_Sig_ForbiddenRegenDuetoSysFaultAc(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_DPFC_Msg_Count, 4u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FD7C00_Sig_AftertreatDieselPartiFilterPas(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_DPFC_Msg_Count, 1u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FD7C00_Sig_ForbiddenRegenerationIndictor(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_DPFC_Msg_Count, 2u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FD7C00_Sig_ForbiddenRegenerationDueto(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_DPFC_Msg_Count, 2u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FD7C00_Sig_DPFLampCommand(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_DPFC_Msg_Count, 0u) >> 0u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_18FD0700_Sig_OBDMalfunctionIndiLampCom(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_DLCC1_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FD0700_Sig_EngineProtectLampCommand(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_DLCC1_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_0CFF3003_Sig_VehicleSpeed(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_DANA_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0CFF3003_Sig_TransmissionOilPressure(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_DANA_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0CFF3003_Sig_TransmissionOilTemperature(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_DANA_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0CFF3003_Sig_GearNumber(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_DANA_Msg_Count, 0u) >> 2u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_0CFF3003_Sig_GearDirection(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_DANA_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FFC100_Sig_EnginePTOStatusLamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_CLUSTER_Msg_Count, 4u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FFC100_Sig_DPFAutoRegLamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_CLUSTER_Msg_Count, 3u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FFC100_Sig_DPFManualRegLamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_CLUSTER_Msg_Count, 3u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FFC100_Sig_PMLevel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_CLUSTER_Msg_Count, 2u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_CruiseControlStates(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_CCVS1_00_Msg_Count, 6u) >> 5u) & 0x07u));
}

uint16_t Get_CAN_CH0_ID_18FEF527_Sig_AmbientAirTemperature(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_AMB_27_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_AMB_27_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEF527_Sig_AtmosphericPressure(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_AMB_27_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18FEF500_Sig_AmbientAirTemperature(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_AMB_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_AMB_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEF500_Sig_AtmosphericPressure(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_AMB_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_10FBF5AA_Sig_VehicleSpeed(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_A1DOC2_Msg_Count, 7u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_A1DOC2_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_10FBF5AA_Sig_TirePressure(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_A1DOC2_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_A1DOC2_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_10FBF5AA_Sig_BackwardMinimumCurrent(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_A1DOC2_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_A1DOC2_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_10FBF5AA_Sig_ForwardMinimumCurrent(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_A1DOC2_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Rx_A1DOC2_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FE56A3_Sig_AdBlueTemperature(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_AT1TI1_A3_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FE56A3_Sig_AdBlueLevel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_AT1TI1_A3_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FE563D_Sig_AdBlueLevel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_AT1TI1_3D_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FE5600_Sig_DEFHighResistance(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_AT1TI1_00_Msg_Count, 4u) >> 5u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_18FE5600_Sig_AdBlueTemperature(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_AT1TI1_00_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FE5600_Sig_AdBlueLevel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_AT1TI1_00_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Co_Can_ConvertSubID_CAN_CH0(uint32_t MsgID)
{
    uint8_t u8Result = CAN_CH0_ID_TOTAL_MAX;
    switch (MsgID)
    {
    case CAN_CH0_ID_DM1_ECU_Msg:
        u8Result = CAN_CH0_ID_DM1_ECU_Msg_Count;
        break;
    case CAN_CH0_ID_DM1_BCU_Msg:
        u8Result = CAN_CH0_ID_DM1_BCU_Msg_Count;
        break;
    case CAN_CH0_ID_DM1_AMT_Msg:
        u8Result = CAN_CH0_ID_DM1_AMT_Msg_Count;
        break;
    case CAN_CH0_ID_Tx_057F_Msg:
        u8Result = CAN_CH0_ID_Tx_057F_Msg_Count;
        break;
    case CAN_CH0_ID_Tx_FEB1_Msg:
        u8Result = CAN_CH0_ID_Tx_FEB1_Msg_Count;
        break;
    case CAN_CH0_ID_Tx_FEFB_Msg:
        u8Result = CAN_CH0_ID_Tx_FEFB_Msg_Count;
        break;
    case CAN_CH0_ID_Tx_Request_21_Msg:
        u8Result = CAN_CH0_ID_Tx_Request_21_Msg_Count;
        break;
    case CAN_CH0_ID_Tx_Request_17_Msg:
        u8Result = CAN_CH0_ID_Tx_Request_17_Msg_Count;
        break;
    case CAN_CH0_ID_Tx_TCO1_Msg:
        u8Result = CAN_CH0_ID_Tx_TCO1_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_ZFCC_Msg:
        u8Result = CAN_CH0_ID_Rx_ZFCC_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_ZF_Msg:
        u8Result = CAN_CH0_ID_Rx_ZF_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_TRF1_Msg:
        u8Result = CAN_CH0_ID_Rx_TRF1_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_TOT_Msg:
        u8Result = CAN_CH0_ID_Rx_TOT_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_TC2_Msg:
        u8Result = CAN_CH0_ID_Rx_TC2_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_TC1_Msg:
        u8Result = CAN_CH0_ID_Rx_TC1_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_Shutdown_Msg:
        u8Result = CAN_CH0_ID_Rx_Shutdown_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_OI_Msg:
        u8Result = CAN_CH0_ID_Rx_OI_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_OHCSS_Msg:
        u8Result = CAN_CH0_ID_Rx_OHCSS_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_LFE_27_Msg:
        u8Result = CAN_CH0_ID_Rx_LFE_27_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_LFE_Msg:
        u8Result = CAN_CH0_ID_Rx_LFE_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_LFC_Msg:
        u8Result = CAN_CH0_ID_Rx_LFC_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_IO_Msg:
        u8Result = CAN_CH0_ID_Rx_IO_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_IC1_Msg:
        u8Result = CAN_CH0_ID_Rx_IC1_Msg_Count;
        break;
    case CAN_CH0_ID_RX_HOURS_Msg:
        u8Result = CAN_CH0_ID_RX_HOURS_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_GPS_Msg:
        u8Result = CAN_CH0_ID_Rx_GPS_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_Gas_Msg:
        u8Result = CAN_CH0_ID_Rx_Gas_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_FF45_Msg:
        u8Result = CAN_CH0_ID_Rx_FF45_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_FF44_Msg:
        u8Result = CAN_CH0_ID_Rx_FF44_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_FF43_Msg:
        u8Result = CAN_CH0_ID_Rx_FF43_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_FF42_Msg:
        u8Result = CAN_CH0_ID_Rx_FF42_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_FF41_Msg:
        u8Result = CAN_CH0_ID_Rx_FF41_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_FF32_Msg:
        u8Result = CAN_CH0_ID_Rx_FF32_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_FF31_Msg:
        u8Result = CAN_CH0_ID_Rx_FF31_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_FE6C_Msg:
        u8Result = CAN_CH0_ID_Rx_FE6C_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_FD95_Msg:
        u8Result = CAN_CH0_ID_Rx_FD95_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_FD7B_Msg:
        u8Result = CAN_CH0_ID_Rx_FD7B_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_FC2A_Msg:
        u8Result = CAN_CH0_ID_Rx_FC2A_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_F005_Msg:
        u8Result = CAN_CH0_ID_Rx_F005_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_ETC7_Msg:
        u8Result = CAN_CH0_ID_Rx_ETC7_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_ET1_Msg:
        u8Result = CAN_CH0_ID_Rx_ET1_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_ERC1_Msg:
        u8Result = CAN_CH0_ID_Rx_ERC1_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_EP_Msg:
        u8Result = CAN_CH0_ID_Rx_EP_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_EFLP1_Msg:
        u8Result = CAN_CH0_ID_Rx_EFLP1_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_EEC2_Msg:
        u8Result = CAN_CH0_ID_Rx_EEC2_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_EEC1_0C_Msg:
        u8Result = CAN_CH0_ID_Rx_EEC1_0C_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_EB08_Msg:
        u8Result = CAN_CH0_ID_Rx_EB08_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_DPFC_Msg:
        u8Result = CAN_CH0_ID_Rx_DPFC_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_DLCC1_Msg:
        u8Result = CAN_CH0_ID_Rx_DLCC1_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_DANA_Msg:
        u8Result = CAN_CH0_ID_Rx_DANA_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_CLUSTER_Msg:
        u8Result = CAN_CH0_ID_Rx_CLUSTER_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_CCVS1_00_Msg:
        u8Result = CAN_CH0_ID_Rx_CCVS1_00_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_AMB_27_Msg:
        u8Result = CAN_CH0_ID_Rx_AMB_27_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_AMB_Msg:
        u8Result = CAN_CH0_ID_Rx_AMB_Msg_Count;
        break;
    case CAN_CH0_ID_Rx_A1DOC2_Msg:
        u8Result = CAN_CH0_ID_Rx_A1DOC2_Msg_Count;
        break;
    case CAN_CH0_ID_AT1TI1_A3_Msg:
        u8Result = CAN_CH0_ID_AT1TI1_A3_Msg_Count;
        break;
    case CAN_CH0_ID_AT1TI1_3D_Msg:
        u8Result = CAN_CH0_ID_AT1TI1_3D_Msg_Count;
        break;
    case CAN_CH0_ID_AT1TI1_00_Msg:
        u8Result = CAN_CH0_ID_AT1TI1_00_Msg_Count;
        break;
    default :
        u8Result = CAN_CH0_ID_TOTAL_MAX;
        break;
    }
    return u8Result;
}
