#include "Configuration.h"
#include "Analog_Signals.h"
#include "CAN_CH0_CAN_Communication_Matrix.h"
#include <stdio.h>
#include "EOL_Para.h"
//发动机类型
Starter_Type Get_Stater_Type(void)
{
    uint8_t Type = 0;
    Type = Val_EOL_0300_Engine_Type_Configuration();
    if(Type == 0)
    {
        return WEICHAI;
    }
    else if(Type == 1)
    {
        return SHANGCHAI;
    }
    else if(Type == 2)
    {
        return KANGMINGSI;
    }
    else if(Type == 3)
    {
        return YUNNEI;
    }
    else if(Type == 4)
    {
        return YUCHAI;
    }
    else if(Type == 5)
    {
        return LUOTUO;
    }
    return NULLSTARTER;
}

//车速使能配置
Enable_Type VSpeed_Enable(void)
{
    return valid;
}

//车速误差系数配置
uint16_t VSpeed_Error_Value(void)
{
    uint16_t Speed_Error_Factor = 0;
    Speed_Error_Factor = Val_EOL_0300_Vehicle_Speed_Error_Factor_Configufation();
    return Speed_Error_Factor;
}

//K值配置
uint32_t K_Value(void)
{
    uint32_t K_Value_Configuration = 0;
    K_Value_Configuration = Val_EOL_0300_K_Value_Configuration();
    return K_Value_Configuration;
}

//电池电压低阈值配置（十倍参数）
uint16_t Get_Voltage_Threshold_Low(void)
{
    uint16_t Voltage_Threshold_Configuration = 0;
    Voltage_Threshold_Configuration = Val_EOL_0300_Battery_Voltage_Low_Threshold_Configuration();
    return Voltage_Threshold_Configuration;
}

//电池电压高阈值配置（十倍参数）
uint16_t Get_Voltage_Threshold_High(void)
{
    uint16_t Voltage_Threshold_Configuration = 0;
    Voltage_Threshold_Configuration = Val_EOL_0300_Battery_Voltage_High_Threshold_Configuration();
    return Voltage_Threshold_Configuration;
}
//动力切断配置函数
uint16_t Get_Power_Cut_Off_Configuration_Valid_High(void)
{
    uint16_t Power_Cutoff = 0;
    Power_Cutoff = Val_EOL_0300_Power_Cutoff();
    return Power_Cutoff;
}

//制动气压低阈值配置（十倍参数）
uint16_t Get_Barometric_Threshold_Low(void)
{
    uint16_t Threshold_Configuration = 0;
    Threshold_Configuration = Val_EOL_0300_Air_Pressure_Low_Threshold_Configuration();
    Threshold_Configuration *= 4;
    Threshold_Configuration /= 100;       //kpa转换bar
    Threshold_Configuration *= 10;        //十倍参数
    return Threshold_Configuration;
}

//制动气压高阈值配置（十倍参数）
uint16_t Get_Barometric_Threshold_High(void)
{
    uint16_t Threshold_Configuration = 0;
    Threshold_Configuration = Val_EOL_0300_Air_Pressure_High_Threshold_Configuration();
    Threshold_Configuration *= 4;
    Threshold_Configuration /= 100;     //kpa转换bar
    Threshold_Configuration *= 10;      //十倍参数
    return Threshold_Configuration;
}

//湿式制动气压低阈值配置（一倍）
uint16_t Wet_Get_Barometric_Threshold_Low(void)
{
    uint16_t Wet_Threshold_Configuration = 0;
    Wet_Threshold_Configuration = Val_EOL_0300_Wet_Brake_Low_Threshold_Configuration();
    Wet_Threshold_Configuration *= 4;
    Wet_Threshold_Configuration /= 100;     //kpa转换bar
    return Wet_Threshold_Configuration;
}

//变速箱油温高阈值配置
uint16_t Get_Transmission_Oil_Temperature_threshold_High(void)
{
    uint16_t Oil_Temperature_Threshold_Configuration = 0;
    Oil_Temperature_Threshold_Configuration = Val_EOL_0300_Transmission_Oil_Temperature_High_Threshold_Configuration();
    if(Oil_Temperature_Threshold_Configuration < 50)
    {
        Oil_Temperature_Threshold_Configuration = 0;
    }
    else
    {
        Oil_Temperature_Threshold_Configuration -= 50;
    }

    return Oil_Temperature_Threshold_Configuration;
}

//水温高阈值配置
uint16_t Get_Coolant_Temperature_threshold_High(void)
{
    uint16_t Coolant_Temperature_Threshold_Configuration = 0;
    Coolant_Temperature_Threshold_Configuration = Val_EOL_0300_Coolant_Temperature_High_Threshold_Configuration();
    if(Coolant_Temperature_Threshold_Configuration < 40)
    {
       Coolant_Temperature_Threshold_Configuration = 0;
    }
    else
    {
       Coolant_Temperature_Threshold_Configuration -= 40;
    }
    
    return Coolant_Temperature_Threshold_Configuration;
}

//制动气压电压换算成气压
uint16_t Brake_Pressure_Acquisition(uint16_t Brake_Pressure_Voltage )
{
    uint16_t Brake_Pressure = 0;
    if (Brake_Pressure_Voltage < 500)
    {
        Brake_Pressure = 0;
    }
    else
    {
        Brake_Pressure = (Brake_Pressure_Voltage - 500) / 27;
    }
    if (Brake_Pressure > 100)
    {
        Brake_Pressure = 100;
    }

    return Brake_Pressure;
}

//制动气压电阻换算成气压
uint16_t Brake_Pressure_Acquisition_Resistance(uint16_t Brake_Pressure_Resistance )
{
    uint16_t Brake_Pressure = 0;    //换算后的气压值
     if(Brake_Pressure_Resistance<100)                                          //输入电阻小于10欧，默认每段电阻之间是线性关系
    {
        Brake_Pressure = 0;
    }
    else if(100<=Brake_Pressure_Resistance && Brake_Pressure_Resistance<480)    //输入电阻10欧-48欧
    {
        Brake_Pressure = (Brake_Pressure_Resistance - 100)/19;
    }
     else if(480<=Brake_Pressure_Resistance && Brake_Pressure_Resistance<900)   //输入电阻48欧-90欧
    {
        Brake_Pressure = (Brake_Pressure_Resistance - 480)/21+20;
    }
     else if(900<=Brake_Pressure_Resistance && Brake_Pressure_Resistance<1240)   //输入电阻90欧-124欧
    {
        Brake_Pressure = (Brake_Pressure_Resistance - 900)/17+40;
    }
     else if(1240<=Brake_Pressure_Resistance && Brake_Pressure_Resistance<1560)   //输入电阻124欧-156欧
    {
        Brake_Pressure = (Brake_Pressure_Resistance - 1240)/16+60;
    }
     else if(1560<=Brake_Pressure_Resistance && Brake_Pressure_Resistance<1840)    //输入电阻156欧-184欧
    {
        Brake_Pressure = (Brake_Pressure_Resistance - 1560)/14+80;
    }
    else                                                                            //输入电阻大于184欧
    {
        Brake_Pressure = 100;
    }
    return Brake_Pressure;
}

//湿式制动气压电压换算成气压
uint16_t Wet_Brake_Pressure_Acquisition(uint16_t Wet_Brake_Pressure_Voltage )
{
    uint16_t Brake_Pressure = 0;
    Brake_Pressure = Wet_Brake_Pressure_Voltage /25;
    if(Brake_Pressure > 100)
    {
        Brake_Pressure = 100;
    }
    return Brake_Pressure;
}

//变速箱油温电阻换算成温度
uint16_t Transmission_Oil_Temperature_Resistance(uint16_t Oil_Temperature_Resistance )
{
    uint16_t Oil_Temperature = 0;
    Oil_Temperature_Resistance *=10;    //扩大10倍
    if(Oil_Temperature_Resistance<2480) //温度超过上限
    {
        Oil_Temperature = 140;
    }
    else if(2480<=Oil_Temperature_Resistance && Oil_Temperature_Resistance<3990)    //温度在120-140
    {
        Oil_Temperature = (20-((Oil_Temperature_Resistance - 2480)/75))+120;
    }
     else if(3990<=Oil_Temperature_Resistance && Oil_Temperature_Resistance<6580)   //温度在100-120
    {
        Oil_Temperature = (20-((Oil_Temperature_Resistance - 3990)/129))+100;
    }
     else if(6580<=Oil_Temperature_Resistance && Oil_Temperature_Resistance<12300)  //温度在80-100
    {
        Oil_Temperature = (20-((Oil_Temperature_Resistance - 6580)/286))+80;
    }
     else if(12300<=Oil_Temperature_Resistance && Oil_Temperature_Resistance<24230) //温度在60-80
    {
        Oil_Temperature = (20-((Oil_Temperature_Resistance - 12300)/596))+60;
    }
     else if(24230<=Oil_Temperature_Resistance && Oil_Temperature_Resistance<29140) //温度在55-60
    {
        Oil_Temperature = (5-((Oil_Temperature_Resistance - 24230)/982))+55;
    }
    else        //温度低于55
    {
        Oil_Temperature = 55;
    }
    return Oil_Temperature;
}
//机油压力低阈值配置（百倍参数）
uint16_t Get_EngineOilPressure_Threshold_Low(void)
{
    uint16_t EngineOilPressure_Value = 0;
    EngineOilPressure_Value = Val_EOL_0300_Engine_Oil_Pressure_Low_Threshold_Configuration();
    EngineOilPressure_Value *= 4;
    // EngineOilPressure_Value /= 100;   //单位转换
    // EngineOilPressure_Value *= 100;   //百倍参数
    return EngineOilPressure_Value;
}

//机油压力高阈值配置（百倍参数）
uint16_t Get_EngineOilPressure_Threshold_High(void)
{
    uint16_t EngineOilPressure_Value = 0;
    EngineOilPressure_Value = Val_EOL_0300_Engine_Oil_Pressure_High_Threshold_Configuration();
    EngineOilPressure_Value *= 4;
    // EngineOilPressure_Value /= 100;   //单位转换
    // EngineOilPressure_Value *= 100;   //百倍参数
    return EngineOilPressure_Value;
}

//尿素液位低阈值配置  （十倍参数）
uint16_t Get_Urea_Threshold_Low(void)
{
    uint16_t Threshold_Value = 0;
    Threshold_Value = Val_EOL_0300_AdBlue_Level_Low_Threshold_Configuration();
    Threshold_Value *= 10;
    return Threshold_Value; 
}

//燃油液位低阈值配置 （千倍参数）
uint16_t Get_EldingLevel_Low(void)
{
    uint16_t AdBlueLevelThreshold_Value = 0;
    AdBlueLevelThreshold_Value = Val_EOL_0300_Elding_Level_Low_Threshold_Configuration();
    // AdBlueLevelThreshold_Value *= 1000;  //千倍参数
    // AdBlueLevelThreshold_Value /= 10000;  //Value in EEPROM: Data * 10000
    AdBlueLevelThreshold_Value /= 10;
    return AdBlueLevelThreshold_Value; 
}

//液压油温高阈值配置  
uint16_t Get_Hydraulic_Oil_Temperature_High(void)
{
    uint16_t Temperature = 0;
    Temperature = Val_EOL_0300_Hydraulic_Oil_Temperature_High_Threshold_Configuration();
    if(Temperature < 40)
    {
        Temperature = 0;
    }
    else
    {
        Temperature -= 40;
    }
    return Temperature;
}

//变速箱油压低阈值配置  （百倍参数）
uint16_t Get_TransmissionOilPressure_Low(void)
{
    uint32_t Value = 0;
    Value = Val_EOL_0300_Transmission_Oil_Pressure_Low_Threshold_Configuration();
    Value *= 4;
    return Value;
}

//变速箱油压高阈值配置  （百倍参数）
uint16_t Get_TransmissionOilPressure_High(void)
{
    uint32_t Value = 0;
    Value = Val_EOL_0300_Transmission_Oil_Pressure_High_Threshold_Configuration();
    Value *= 4;
    return Value;
}


// 根据两个点计算一次函数
LinearFunction calculateLinearFunction(double x1, double y1, double x2, double y2) 
{
    LinearFunction num;
    if (x1 == x2)     // 处理错误情况，这里简单地返回0斜率和截距
    {
        num.slope = 0;
        num.intercept = 0;
        return num;
    }
    num.slope = (y2 - y1) / (x2 - x1);     // 计算斜率 
    num.intercept = y1 - num.slope * x1;    // 计算截距 
    return num;
}

/*燃油液位低指示灯 电阻转液位 1000倍*/
uint32_t Get_EldingLevel_status(void)  
{
    uint32_t Elding_level_resistance = ADC_Read_Signal(ADC_CH_FUEL_LEVEL);     //硬线采集电阻
    static uint16_t timer = 0u;                    //取5次AD采集值时间
    static uint32_t Avg_Elding_level_resistance = 0u;
    static uint32_t AvgEldingLevelResistance = 0u;  //5次平均值
    static uint32_t Liquid_Level_Value = 0u;        //返回液位值 (千倍)  ,正常值：0-1000；错误值：2000
    static uint16_t Resistance_State_Old = 1u;   //上一次采集电阻的状态  1有效   2错误
     /*获取5次平均值*/
    Avg_Elding_level_resistance += Elding_level_resistance;
    timer++;
    if(timer >= 5)
    {
        timer = 0;
        Avg_Elding_level_resistance /= 5;
        AvgEldingLevelResistance = Avg_Elding_level_resistance;
        Avg_Elding_level_resistance = 0u;
    }
    if(AvgEldingLevelResistance >= 3500)     //错误状态   >350Ω
    {
        Liquid_Level_Value = 2000;            //错误时返回2000
        Resistance_State_Old = 2;
    }
    else if(AvgEldingLevelResistance > 3000)   //回滞    300Ω——350Ω   
    {
        if(Resistance_State_Old == 2)
        {
            Liquid_Level_Value = 2000;        //错误时返回2000
        }
        else
        {
            Liquid_Level_Value = 1000;       //有效时返回最大值1000（大于高阈值配置）
            Resistance_State_Old = 1;
        }
    }
    else if(AvgEldingLevelResistance > 1760)  //有效    176Ω——300Ω
    {
        Liquid_Level_Value = 1000;          //有效时返回最大值1000（大于高阈值配置）
        Resistance_State_Old = 1;
    }
    else                               //有效     0Ω——176Ω   返回值：0——1000   下列计算中电阻放大10倍，液位放大千倍，其中x为电阻，y为液位
    {
        if(AvgEldingLevelResistance < 330)   //0Ω——33Ω
        {
            LinearFunction num = calculateLinearFunction(0, 0,330, 125);  //由(0,0)及(330,125)两点算得的线性方程，将上述两点带入y=kx+b，算得k值为0.3788，b为0
            Liquid_Level_Value = (num.slope * AvgEldingLevelResistance) + num.intercept;  //点(30,0)中，30为电阻(电阻放大10倍)，0为在3Ω电阻中对应的液位(液位放大千倍)，即(30,0)代表3Ω电阻对应0液位
        }
        else if((AvgEldingLevelResistance >= 330) && (AvgEldingLevelResistance < 570))   //33Ω——57Ω
        {
            LinearFunction num = calculateLinearFunction(330, 125,570, 250);   //由(330,125)及(570,250)两点算得的线性方程
            Liquid_Level_Value = (num.slope * AvgEldingLevelResistance) + num.intercept;
        }
        else if((AvgEldingLevelResistance >= 570) && (AvgEldingLevelResistance < 910))   //57Ω——91Ω
        {
            LinearFunction num = calculateLinearFunction(570, 250,910, 500);  //由(570,250)及(910,500)两点算得的线性方程
            Liquid_Level_Value = (num.slope * AvgEldingLevelResistance) + num.intercept;
        }
        else if((AvgEldingLevelResistance >= 910) && (AvgEldingLevelResistance < 1248))   //91Ω——124.8Ω
        {
            LinearFunction num = calculateLinearFunction(910, 500,1248, 750);  //由(910,500)及(1248,750)两点算得的线性方程
            Liquid_Level_Value = (num.slope * AvgEldingLevelResistance) + num.intercept;
        }
        else                                                                           //124.8Ω——176Ω
        {
            LinearFunction num = calculateLinearFunction(1248, 750,1760, 1000);  //由(1248,750)及(1760,1000)两点算得的线性方程
            Liquid_Level_Value = (num.slope * AvgEldingLevelResistance) + num.intercept;
        }
        Resistance_State_Old = 1;
    }
    return Liquid_Level_Value;
}

/*变速箱油压   由电压值获取油压值  100倍*/
uint32_t Get_Transmission_Oil_Pressure(void)
{
    static uint32_t TransmissionOilPressureVoltage = 0u;     //5次AD采集电压
    static uint32_t AVE_Transmission_Oil_Pressure_Voltage = 0u;   //5次AD采集电压平均值
    static uint16_t Ave_Time = 0u;                    //5次AD计时时间
    uint32_t Transmission_Oil_Pressure_Voltage = 0u;   //AD采集电压
    static uint32_t Oil_Pressure_Value = 0u;     // 返回值  正常：0——2500，错误：1000000  已经判断0.2-0.5、4.6-4.8之间回滞
    static uint16_t Voltage_State_Old = 1u; // 上一次采集电压的状态  1有效  2低错  3高错
    Transmission_Oil_Pressure_Voltage = ADC_Read_Signal(ADC_CH_TRANSMISSION_OILPRESSURE_VOLTAGE);
    TransmissionOilPressureVoltage += Transmission_Oil_Pressure_Voltage;
    Ave_Time++;
    if(Ave_Time >= 5)
    {
        Ave_Time = 0u;
        TransmissionOilPressureVoltage /= 5u;
        AVE_Transmission_Oil_Pressure_Voltage = TransmissionOilPressureVoltage;
        TransmissionOilPressureVoltage = 0u;
    }
    if((AVE_Transmission_Oil_Pressure_Voltage <= 200))  //低错误            <=0.2v
    {
        Oil_Pressure_Value = 1000000u;
        Voltage_State_Old = 2u;
    }
    else if( (AVE_Transmission_Oil_Pressure_Voltage >= 4800))  //高错误     >=4.8v
    {
        Oil_Pressure_Value = 1000000u;
        Voltage_State_Old = 3u;
    }
    else if((AVE_Transmission_Oil_Pressure_Voltage > 200) && (AVE_Transmission_Oil_Pressure_Voltage < 500))  //低回滞   0.2v——0.5v
    {
        if(Voltage_State_Old == 2u)  //回滞 低错误
        {
            Oil_Pressure_Value =1000000u;
        }
        else                            //回滞 0.2-0.5v,对应气压计算公式
        {
            LinearFunction num = calculateLinearFunction(100, 0,850, 500);  //由(100,0)及(850,500)两点算得的线性方程，100为电压，0为油压
            Oil_Pressure_Value = (num.slope * AVE_Transmission_Oil_Pressure_Voltage) + num.intercept;
            Voltage_State_Old = 1u;
        }
    }
    else if((AVE_Transmission_Oil_Pressure_Voltage > 4600) && (AVE_Transmission_Oil_Pressure_Voltage < 4800))  //高回滞  4.6v-4.8v
    {
        if(Voltage_State_Old == 3u)  //回滞 高错误
        {
            Oil_Pressure_Value =1000000u;
        }
        else                            //回滞 4.6-4.8v，显示25bar
        {
            Oil_Pressure_Value = 2500u;
            Voltage_State_Old = 1u;
        }
    }
    else                                             //0.5v——4.6v    下列计算中电压放大1000倍，油压放大100倍，其中x为电压，y为油压
    {
        if(AVE_Transmission_Oil_Pressure_Voltage < 850)   // 0.5v——0.85V
        {
            LinearFunction num = calculateLinearFunction(100, 0,850, 500);  //由(100,0)及(850,500)两点算得的线性方程，100为电压，0为油压
            Oil_Pressure_Value = (num.slope * AVE_Transmission_Oil_Pressure_Voltage) + num.intercept;
        }
        else if(AVE_Transmission_Oil_Pressure_Voltage < 1600) // 0.85v——1.6V
        {
            LinearFunction num = calculateLinearFunction(850,500,1600,1000);  //由(850,500)及(1600,1000)两点算得的线性方程
            Oil_Pressure_Value = (num.slope * AVE_Transmission_Oil_Pressure_Voltage) + num.intercept;
        }
        else if(AVE_Transmission_Oil_Pressure_Voltage < 2350) // 1.6v——2.35V
        {
            LinearFunction num = calculateLinearFunction(1600,1000,2350,1500);  //由(1600,1000)及(2350,1500)两点算得的线性方程
            Oil_Pressure_Value = (num.slope * AVE_Transmission_Oil_Pressure_Voltage) + num.intercept;
        }
        else if(AVE_Transmission_Oil_Pressure_Voltage < 3100) // 2.35v——3.1V
        {
            LinearFunction num = calculateLinearFunction(2350,1500,3100,2000);  //由(2350,1500)及(3100,2000)两点算得的线性方程
            Oil_Pressure_Value = (num.slope * AVE_Transmission_Oil_Pressure_Voltage) + num.intercept;
        }
        else if(AVE_Transmission_Oil_Pressure_Voltage < 3850) // 3.1v——3.85V
        {
            LinearFunction num = calculateLinearFunction(3100,2000,3850,2500);  //由(3100,2000)及(3850,2500)两点算得的线性方程
            Oil_Pressure_Value = (num.slope * AVE_Transmission_Oil_Pressure_Voltage) + num.intercept;
        }
        else     //3.85-4.6v   返回25bar
        {
            Oil_Pressure_Value = 2500;
        }
        Voltage_State_Old = 0u;
    }
    return Oil_Pressure_Value;
}

/*变速箱油压   由输入值（CAN、硬线）获取油压值  100倍*/
uint32_t Get_TransmissionOilPressure(void)
{
    uint32_t Transmission_Oil_Pressure = 0u;         // 返回值  正常：0——64255，错误：1000000 
    if((CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_DANA_Msg_Count) == CAN_SIG_NORMAL))
    {
        Transmission_Oil_Pressure = Get_CAN_CH0_ID_0CFF3003_Sig_TransmissionOilPressure();
        if(Transmission_Oil_Pressure <= 0xFA)
        {
            if(Transmission_Oil_Pressure < 100u)
            {
                Transmission_Oil_Pressure *= 1;
            }
            else if(Transmission_Oil_Pressure < 200u)
            {
                Transmission_Oil_Pressure -= 100;
                Transmission_Oil_Pressure *= 2;
                Transmission_Oil_Pressure += 100;
            }
            else
            {
                Transmission_Oil_Pressure -= 200;
                Transmission_Oil_Pressure *= 10;
                Transmission_Oil_Pressure += 300;
            }
            Transmission_Oil_Pressure *= 10;
            if(Transmission_Oil_Pressure > 2500)   //有效范围内超过最大值按最大值显示
            {
                Transmission_Oil_Pressure = 2500;
            }   
        }
        else
        {
            Transmission_Oil_Pressure = 1000000;  //错误状态
        }
    }
    else 
    { 
        if((CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_FF32_Msg_Count) == CAN_SIG_NORMAL))
        {
            Transmission_Oil_Pressure = Get_CAN_CH0_ID_18FF3203_Sig_TransmissionOilPressure();
            if (Transmission_Oil_Pressure <= 0xFAFF)
            {
                // Transmission_Oil_Pressure *= 100;     //100倍输出
                // Transmission_Oil_Pressure /= 100;     //单位换算
                if (Transmission_Oil_Pressure > 2500) // 有效范围内超过最大值按最大值显示
                {
                    Transmission_Oil_Pressure = 2500;
                }
            }
            else
            {
                Transmission_Oil_Pressure = 1000000;  //错误状态
            }
        }
        else
        {
            if((CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_TRF1_Msg_Count) == CAN_SIG_NORMAL))
            {
                Transmission_Oil_Pressure = Get_CAN_CH0_ID_18FEF803_Sig_TransmissionOilPressure();
                if (Transmission_Oil_Pressure <= 0xFA)
                {
                    Transmission_Oil_Pressure *= 16;
                    // Transmission_Oil_Pressure *= 100;    //100倍输出
                    // Transmission_Oil_Pressure /= 100;    //单位换算
                    if (Transmission_Oil_Pressure > 2500) // 有效范围内超过最大值按最大值显示
                    {
                        Transmission_Oil_Pressure = 2500;
                    }
                }
                else
                {
                    Transmission_Oil_Pressure = 1000000; // 错误状态
                }
            }
            else
            {
                Transmission_Oil_Pressure = Get_Transmission_Oil_Pressure();
            }
        } 
    }
    return Transmission_Oil_Pressure;
}

/*由液压油温高的电阻值得到对应温度  1倍*/
uint32_t Get_Hydraulic_Oil_Resistance_Temperature(void)
{
    static uint32_t HydraulicOilTemperature = 0u;     //5次AD采集电阻
    static uint32_t AVE_Hydraulic_Oil_Temperature = 0u;   //5次AD采集电阻平均值
    static uint16_t Ave_Time = 0u;                    //5次AD计时时间
    uint32_t Hydraulic_Oil_Temperature_Resistance = 0u;   //AD采集电阻
    static uint32_t Oil_Temperature_Value = 0u;     // 返回值  正常：40——120，错误：500
    static uint16_t Resistance_State_old = 1u; //上一次采集电阻的状态  1正确 2错误
    Hydraulic_Oil_Temperature_Resistance = ADC_Read_Signal(ADC_CH_HYDRAULIC_OILTEMPERATURE);
    HydraulicOilTemperature += Hydraulic_Oil_Temperature_Resistance;
    Ave_Time++;
    if(Ave_Time >= 5)
    {
        Ave_Time = 0u;
        HydraulicOilTemperature *= 10u;
        HydraulicOilTemperature /= 5u;
        AVE_Hydraulic_Oil_Temperature = HydraulicOilTemperature;
        HydraulicOilTemperature = 0u;
    }
    if(AVE_Hydraulic_Oil_Temperature <= 300u)  //错误状态           <=3Ω
    {
        Oil_Temperature_Value = 500u;
        Resistance_State_old = 2u;
    }
    else if(AVE_Hydraulic_Oil_Temperature < 1000u)  //回滞          3Ω——10Ω
    {
        if(Resistance_State_old == 2u)        //返回错误状态 
        {
            Oil_Temperature_Value = 500u;
        }
        else 
        {
            Oil_Temperature_Value = 120u;    //返回最大值120
            Resistance_State_old = 1u;
        }
    }
    else if(AVE_Hydraulic_Oil_Temperature <= 2244u)            //10Ω——22.44Ω
    {
        Oil_Temperature_Value = 120u;
        Resistance_State_old = 1u;
    }
    else
    {
        if(AVE_Hydraulic_Oil_Temperature < 3847u)        //22.44Ω——38.47Ω  下列计算中电阻100倍，温度1倍，其中x为电阻，y为温度
        {
            LinearFunction num = calculateLinearFunction(2244,120,3847,100);  //由(2244,120)及(3847,100)两点算得的线性方程
            Oil_Temperature_Value = (num.slope * AVE_Hydraulic_Oil_Temperature) + num.intercept;
        }
        else if(AVE_Hydraulic_Oil_Temperature < 7012u)   //38.47Ω——70.12Ω
        {
            LinearFunction num = calculateLinearFunction(3847,100,7012,80);  //由(3847,100)及(7012,80)两点算得的线性方程
            Oil_Temperature_Value = (num.slope * AVE_Hydraulic_Oil_Temperature) + num.intercept;
        }
        else if(AVE_Hydraulic_Oil_Temperature < 13403u)   //70.12Ω——134.03Ω
        {
            LinearFunction num = calculateLinearFunction(7012,80,13403,60);  //由(7012,80)及(13403,60)两点算得的线性方程
            Oil_Temperature_Value = (num.slope * AVE_Hydraulic_Oil_Temperature) + num.intercept;
        }
        else if(AVE_Hydraulic_Oil_Temperature < 29146u)   //134.03Ω——291.46Ω
        {
            LinearFunction num = calculateLinearFunction(13403,60,29146,40);  //由(13403,60)及(29146,40)两点算得的线性方程
            Oil_Temperature_Value = (num.slope * AVE_Hydraulic_Oil_Temperature) + num.intercept;
        }
        else                                              //>291.46Ω
        {
            Oil_Temperature_Value = 40u;
        }
        Resistance_State_old = 1u;
    }
    return Oil_Temperature_Value;
}
