#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "Display.h"
#include "Common_Interface.h"
#include "BackLight.h"
#include "EOL_Para.h"
#include "Data_DTE.h"
#include "DisplaySch.h"
#include "Data_Gear.h"
#include "RTE_GPIO.h"
#include "Services_Mileage.h"
#include "Data_VSpeed.h"
#include "RTE_LED.h"
#include "Data_ESpeed.h"
#include "Telltales_user.h"
#include "Flash_synchronizer.h"
#include "LED_Map.h"
#include "Task.h"
#include "Analog_Signals.h"
#include "Data_Water_Tem_Table.h"
#include "Transmission_oil_Tem_Table.h"
#include "Fuel_Level_Table.h"
#include "Brake_Pressure_Table.h"
#include "Brake_Pressure_Voltage_Table.h"
#include "Configuration.h"
#include "Data_Time.h"

uint8_t         UDS_Ctrl_Right_F         = 0u;
uint8_t         UDS_Ctrl_Right_C         = 0u;
uint8_t         UDS_Ctrl_Right_F_Factory = 0u;
uint8_t         UDS_Ctrl_Right_C_Factory = 0u;
static uint8_t  Animat_Coolant           = 0u;
static uint8_t  Animat_Fuel              = 0u;
static uint16_t Animat_Vspeed            = 0u;
static uint16_t Animat_Espeed            = 0u;
static uint16_t AnimationStep            = 0u;
static uint16_t HOUR_X                   = 0u;
static uint16_t MINUTE_X                 = 0u;
uint8_t TEMP_LAMP_Light_Old = 0u;
static uint8_t Outdoor_Temp_1S = 0u;

uint16_t Display_Temperature = 0u;
static uint8_t Bettery_Voltage_Status = 0;
uint16_t Battery_Voltage = 0u;
static uint16_t Left_Battery_Voltage = 0u;  //左侧大表头电池电压
static uint16_t Voltage = 0;
BatteryVoltage BatteryVoltageCtrl;
static uint16_t Left_Data_Oil_Tem = 0u;  //左侧小表头变速箱油温表
static uint32_t Oil_Tem = 0;
TransmissionOilTemperature TransmissionOilTemperatureCtrl;
static uint16_t Urea_Level = 0;
static uint16_t Last_Urea_Level = 0;
UreaLevel UreaLevelCtrl;
static uint16_t Display_Fuel_Level = 0;
static uint16_t Display_Fuel_Level_Table = 0;
Fuel FuelCtrl;
static uint16_t Oil_Pressure = 0;
OilPressure OilPressureCtrl;
static uint16_t Brake_Pressure = 0;
uint8_t Errostatus = 0;  // 制动气压表0有效状态，1错误状态
static uint16_t Display_Brake_Pressure_Table = 0;
BrakePressure BrakeCtrl;
static uint32_t TirePressure = 0;
static uint32_t DisplayTirePressure = 0;
static uint16_t WetBrake = 0;
static uint16_t DisplayWetBrake = 0;
WetBrakeStruct WetBrakeCtrl;
static uint32_t DisplayTOTFuelCon = 0;
static uint32_t DisplayInsFuelCon = 0;
HydraulicOilTemperature HydraulicLevelCtrl;
TransmissionOilPressuree TransdraulicLevelCtrl;
#pragma ghs section bss = ".myNonInitArea"
#pragma ghs section bss = default

/*上电初始化*/
void Display_KL30_Init(void)
{

}
/*上电初始化*/
void Display_Wakeup_Init(void)
{

}
/*上电初始化*/
void Display_KL15_Init(void)
{

}



void DisplayService(void)
{
} 

void Display_Transmission_Oil_Temperature_Gauge(void) // 左侧小表头变速箱油温表
{
    static uint16_t led_state_old = 0u;
    static uint16_t Transmission_Oil_Temperature_Last = 0u;
    uint16_t TransmissionHigh_resistance = 0u; // 硬线采集获取阻值
    TransmissionHigh_resistance = ADC_Read_Signal(ADC_CH_TRANSMISSION_OIL_TEMPERATURE);

    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        if ((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_TOT_Msg_Count) == CAN_SIG_LOST) &&
            (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_DANA_Msg_Count) == CAN_SIG_LOST) &&
            (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FD95_Msg_Count) == CAN_SIG_LOST))
        {

           Oil_Tem = Transmission_Oil_Temperature_Resistance(TransmissionHigh_resistance); // 变速箱油温电阻换算成温度
            if (TransmissionHigh_resistance <= 30)
            {

                Oil_Tem = 60u;
                led_state_old = 1u;
            }
            else if (TransmissionHigh_resistance < 100)
            {
                if (led_state_old == 1u)
                {

                    Oil_Tem = 60u;
                    led_state_old = 1u;
                }
                else
                {
                    led_state_old = 0u;
                }
            }
            else
            {
                if (Oil_Tem >= 60)
                {
                    
                }
                else
                {
                    Oil_Tem = 60u;
                }
                led_state_old = 0u;
            }
            if (Oil_Tem >= Transmission_Oil_Temperature_Last) // 上升
            {
                Left_Data_Oil_Tem = Oil_Tem;
                Transmission_Oil_Temperature_Last = Oil_Tem;
            }
            else // 下降
            {
                if ((Transmission_Oil_Temperature_Last - Oil_Tem) > 2)
                {
                    Left_Data_Oil_Tem = Oil_Tem;
                    Transmission_Oil_Temperature_Last = Oil_Tem;
                }
                else // 保持上一状态
                {
                    Left_Data_Oil_Tem = Transmission_Oil_Temperature_Last;
                }
            }
        }
        else
        {
            if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FD95_Msg_Count) == CAN_SIG_NORMAL)
            {

                Oil_Tem = Get_CAN_CH0_ID_18FD9503_Sig_TransmissionOilTemperature();
                Oil_Tem *= 100;
                Oil_Tem /= 4;
                Oil_Tem *= 1000;
                Oil_Tem /= 8;
                Oil_Tem /= 100000;
                if (Oil_Tem < 333)
                {
                    Oil_Tem = 60;
                }
                else if (Oil_Tem > 413)
                {
                    Oil_Tem = 140;
                }
                else
                {
                    Oil_Tem -= 273;
                }
            }
            if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_DANA_Msg_Count) == CAN_SIG_NORMAL)
            {

                Oil_Tem = Get_CAN_CH0_ID_0CFF3003_Sig_TransmissionOilTemperature();
                if (Oil_Tem < 110)
                {
                    Oil_Tem = 60;
                }
                else if (Oil_Tem > 190)
                {
                    Oil_Tem = 140;
                }
                else
                {
                    Oil_Tem -= 50;
                }
            }
            if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_TOT_Msg_Count) == CAN_SIG_NORMAL)
            {

                Oil_Tem = Get_CAN_CH0_ID_18FF1F03_Sig_TransmissionOilTemperatureofZF();
                if (Oil_Tem < 110)
                {
                    Oil_Tem = 60;
                }
                else if (Oil_Tem > 190)
                {
                    Oil_Tem = 140;
                }
                else
                {
                    Oil_Tem -= 50;
                }
            }
            Left_Data_Oil_Tem = Oil_Tem;
        }
        TransmissionOilTemperatureCtrl.Goal = Left_Data_Oil_Tem;
        BackLight_PWM_Duty_Cycle_Delta(TransmissionOilTemperatureCtrl.Goal, &TransmissionOilTemperatureCtrl.OilTemperatureCurrent, &TransmissionOilTemperatureCtrl.Time);
    }
}

    void Display_Battery_Voltage_Gauge(void) // 电池电压表
{
        static uint16_t Battery_Voltage_last = 0;
        Voltage = ADC_Read_Signal(ADC_CH_KL30_VOLTAGE) / 100;
        if (Common_Get_IG_Sts() == COMMON_POWER_ON) // 上电
    {
            if (Voltage > 320) // 大于32V
            {
                Left_Battery_Voltage = 320;
            }
            if (Voltage < 160) // 小于16V
            {
                Left_Battery_Voltage = 160;
            }
            if (Voltage >= Battery_Voltage_last) // 上升
            {
                Left_Battery_Voltage = Voltage;
                Battery_Voltage_last = Voltage;
            }
            else // 下降
            {
                if ((Battery_Voltage_last - Voltage) > 5)
                {
                    Left_Battery_Voltage = Voltage;
                    Battery_Voltage_last = Voltage;
                }
                else // 保持上一状态
                {
                    Left_Battery_Voltage = Battery_Voltage_last;
                }
            }
           BatteryVoltageCtrl.Goal = Left_Battery_Voltage;

            BackLight_PWM_Duty_Cycle_Delta(BatteryVoltageCtrl.Goal, &BatteryVoltageCtrl.BatteryVoltageCurrent, &BatteryVoltageCtrl.Time);
    }
}

//电池电压表数显
void Display_Battery_Voltage(void)
{
    uint16_t Voltage = ADC_Read_Signal(ADC_CH_KL30_VOLTAGE) / 100;
    static uint16_t Timer_5s = 0;
    static uint16_t last_status = 0;

    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        // if (Voltage > 320)
        // {
        //     Voltage = 320;
        // }
        // else if (Voltage < 160)
        // {
        //     Voltage = 160;
        // }
        Battery_Voltage = Voltage;

        if ((Battery_Voltage >= (Get_Voltage_Threshold_Low() + 5)) && (Battery_Voltage <= (Get_Voltage_Threshold_High() - 5)))
        {
            Bettery_Voltage_Status = 1;
            Timer_5s = 0;
            last_status = 1;
        }
        else if ((Battery_Voltage <= Get_Voltage_Threshold_Low()) || (Battery_Voltage >= Get_Voltage_Threshold_High()))
        {
            if (Timer_5s >= 50)
            {
                Bettery_Voltage_Status = 2;
                last_status = 2;
            }
            else
            {
                Timer_5s++;
            }
        }

        // 引入回滞效应
        if (((Battery_Voltage > Get_Voltage_Threshold_Low()) && (Battery_Voltage < (Get_Voltage_Threshold_Low() + 5))) ||
            ((Battery_Voltage > Get_Voltage_Threshold_High() - 5) && (Battery_Voltage < Get_Voltage_Threshold_High())))
        {
            if (last_status == 1)
            {
                Bettery_Voltage_Status = 1;
                last_status = 1;
            }
            else if (last_status == 2)
            {
                Bettery_Voltage_Status = 2;
                last_status = 2;
            }
        }
    }
}

//环境温度表数显
void DisplayEnvironmentTemperature(void)
{
    uint32_t Temperature = 0;
    if(Common_Get_IG_Sts( ) == COMMON_POWER_ON )
    {
        if( (Get_Stater_Type() == WEICHAI)    ||
            (Get_Stater_Type() == SHANGCHAI)  ||
            (Get_Stater_Type() == KANGMINGSI) ||
            (Get_Stater_Type() == YUNNEI)     ||
            (Get_Stater_Type() == YUCHAI) )
        {
            if((Get_CAN_CH0_ID_18FEF500_Sig_AmbientAirTemperature() > 0xFAFF) || (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_AMB_Msg_Count) ==CAN_SIG_LOST))
            {
                Temperature = 0xFFFF;
                Display_Temperature = 0xFFFF;
            }
            else
            {
                Temperature = Get_CAN_CH0_ID_18FEF500_Sig_AmbientAirTemperature();
                Temperature *= 100;
                Temperature /= 4;
                Temperature *= 1000;
                Temperature /= 8;
                Temperature /= 100000;

                Display_Temperature = Temperature;
                if(Display_Temperature <= 174) //273-99
                {
                    Display_Temperature = 174;
                }

                if(Display_Temperature >= 372)
                {
                    Display_Temperature = 372;
                }
                Display_Temperature -= 174;
            }
        }
        else if((Get_Stater_Type() == LUOTUO))
        {
            if((Get_CAN_CH0_ID_18FEF527_Sig_AmbientAirTemperature() > 0xFAFF) || (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_AMB_27_Msg_Count) ==CAN_SIG_LOST))
            {
                Temperature = 0xFFFF;
                Display_Temperature = 0xFFFF;
            }
            else
            {
                Temperature = Get_CAN_CH0_ID_18FEF527_Sig_AmbientAirTemperature();
                Temperature *= 100;
                Temperature /= 4;
                Temperature *= 1000;
                Temperature /= 8;
                Temperature /= 100000;

                Display_Temperature = Temperature;
                if(Display_Temperature <= 174) //273-99
                {
                    Display_Temperature = 174;
                }

                if(Display_Temperature >= 372)
                {
                    Display_Temperature = 372;
                }
                Display_Temperature -= 174;
            }
        }
        
    }
}

//尿素液位表
void Display_Urea_Level(void)
{
    if(Common_Get_IG_Sts( ) == COMMON_POWER_ON )
    {
        if((Get_Stater_Type() == WEICHAI)       ||
           (Get_Stater_Type() == KANGMINGSI)    ||
           (Get_Stater_Type() == YUNNEI)        ||
           (Get_Stater_Type() == YUCHAI) )
        {
            Urea_Level = Get_CAN_CH0_ID_18FE5600_Sig_AdBlueLevel();
        }
        else if(Get_Stater_Type() == SHANGCHAI)
        {
            Urea_Level = Get_CAN_CH0_ID_18FE563D_Sig_AdBlueLevel();
        }
        else if(Get_Stater_Type() == LUOTUO)
        {
            Urea_Level = Get_CAN_CH0_ID_18FE56A3_Sig_AdBlueLevel();
        }
        
        Urea_Level *= 4;
        Urea_Level /= 10;
        if(Urea_Level > 100)
        {
            Urea_Level = 0xFF;
        }
        UreaLevelCtrl.Goal = Urea_Level;
        BackLight_PWM_Duty_Cycle_Delta(UreaLevelCtrl.Goal, &UreaLevelCtrl.UreaLevelCurrent, &UreaLevelCtrl.Time);
    }
}

//燃油液位表
void Fuel_Level(void)
{
    static uint16_t Display_Fuel_Level_Table_last = 0; //上一次显示状态
    uint16_t Display_Fuel_Level_Table_current = 0;  //当前显示状态
    uint16_t Fuel_Level_Table = 0;   //传入值
    if (Common_Get_IG_Sts( ) == COMMON_POWER_ON)
    {
        Fuel_Level_Table = Get_EldingLevel_status();
        if(Fuel_Level_Table > 1000)  //错误状态
        {
            Fuel_Level_Table  = 0;
            Display_Fuel_Level_Table_last = 0;
        }
        else
        {
            Fuel_Level_Table /= 10;
            if(Fuel_Level_Table < Display_Fuel_Level_Table_last) //下降
            {
                if((Display_Fuel_Level_Table_last - Fuel_Level_Table) > 2)  //防抖
                {
                    Display_Fuel_Level_Table_current = Fuel_Level_Table;
                }
                else 
                {
                    Display_Fuel_Level_Table_current = Display_Fuel_Level_Table_last;
                }
            }
            else
            {
                Display_Fuel_Level_Table_current = Fuel_Level_Table;
            }
        }
    Display_Fuel_Level_Table_last = Display_Fuel_Level_Table_current;
    FuelCtrl.Goal = Display_Fuel_Level_Table_current;
    BackLight_PWM_Duty_Cycle_Delta(FuelCtrl.Goal, &FuelCtrl.FuelCurrent, &FuelCtrl.Time);
    }
}

//机油压力显示
void Display_Oil_Pressure(void)
{
    if(Common_Get_IG_Sts( ) == COMMON_POWER_ON )
    {
        if((Get_CAN_CH0_ID_18FEEF00_Sig_EngineOilPressure() > 0xFA) || (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_EFLP1_Msg_Count) == CAN_SIG_LOST))
        {
            Oil_Pressure = 0;
        }
        else
        {
            Oil_Pressure = Get_CAN_CH0_ID_18FEEF00_Sig_EngineOilPressure();
            Oil_Pressure *= 4;
            Oil_Pressure /= 10;
            if(Oil_Pressure >= 100)
            {
                Oil_Pressure = 100;
            }
        }
        OilPressureCtrl.Goal = Oil_Pressure;
        BackLight_PWM_Duty_Cycle_Delta(OilPressureCtrl.Goal, &OilPressureCtrl.OilPressureCurrent, &OilPressureCtrl.Time);
    }
}

//湿式制动表
void Display_Wet_Brake(void)
{
    static uint16_t WetBrakeLast = 0;
    static uint8_t  ErroTag = 0;
    WetBrake = ADC_Read_Signal(ADC_CH_WETBRAKE_VOLTAGE) / 100; //采集为mA
    if((WetBrake <= 2) || (WetBrake >= 48))
    {
        ErroTag = 1;
        DisplayWetBrake = 0;
    }

    if((WetBrake >= 5) && (WetBrake <= 46))
    {
        ErroTag = 0;
    }

    WetBrake *= 4;  //换算成制动气压

    if(Common_Get_IG_Sts( ) == COMMON_POWER_ON)
    {
        if(ErroTag == 0)
        {
            if(WetBrake >= WetBrakeLast) //上升
            {
                DisplayWetBrake = WetBrake;
                WetBrakeLast = WetBrake;
            }
            else //下降
            {
                if((WetBrakeLast - WetBrake) > 2)
                {
                    DisplayWetBrake = WetBrake;
                }
                else //保持上一状态
                {
                    DisplayWetBrake = WetBrakeLast;
                }
            }
        }
        else
        {
            DisplayWetBrake = 0;
        }
        WetBrakeCtrl.Goal = DisplayWetBrake;
        BackLight_PWM_Duty_Cycle_Delta(WetBrakeCtrl.Goal, &WetBrakeCtrl.WetBrakeCurrent, &WetBrakeCtrl.Time);
    }
}


void Animation_CB10ms(void)
{
    if ( Common_Get_IG_Sts( ) == COMMON_POWER_OFF )
    {
        AnimationStep  = 0u;
        Animat_Coolant = 0u;
        Animat_Fuel    = 0u;
    }
    else
    {
        if ( Remote_Start_Signal( ) == 0u )    // Remote_Start
        {
          Animation( );
        }
        else
        {
            AnimationStep  = 0u;
            Animat_Coolant = 0u;
            Animat_Fuel    = 0u;
        }
    }
}

// 制动气压表
void Display_Brake_Pressure(void)
{
    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        uint32_t brake_voltage = 0u;    // 电压
        uint32_t brake_resistance = 0u; // 电阻
        static uint16_t brake_pressure_last = 0;
        brake_voltage = ADC_Read_Signal(ADC_CH_BRAKEAIRPRESSURE_VOLTAGE); // 1000倍电压
        brake_resistance = ADC_Read_Signal(ADC_CH_BRAKE_AIRPRESSURE);     // 10倍电阻
        if (brake_voltage > 200)
        {
            if (brake_voltage >= 4800)
            {
                Errostatus = 1;
                Display_Brake_Pressure_Table = 0;
            }

            if ((brake_voltage >= 500) && (brake_voltage <= 4600))
            {
                Errostatus = 0;
            }
            Brake_Pressure = Brake_Pressure_Acquisition(brake_voltage);
        }
        else
        {
            if ((brake_resistance <= 20) || (brake_resistance >= 3500))
            {
                Errostatus = 1;
                Display_Brake_Pressure_Table = 0;
            }

            if ((brake_resistance >= 800) && (brake_resistance <= 3000))
            {
                Errostatus = 0;
            }
            Brake_Pressure = Brake_Pressure_Acquisition_Resistance(brake_resistance);
        }
        if (Errostatus == 0) // 消抖
        {
            if (Brake_Pressure >= brake_pressure_last) // 上升
            {
                Display_Brake_Pressure_Table = Brake_Pressure;
                brake_pressure_last = Brake_Pressure;
            }
            else // 下降
            {
                if ((brake_pressure_last - Brake_Pressure) > 2)
                {
                    Display_Brake_Pressure_Table = Brake_Pressure;
                    brake_pressure_last = Brake_Pressure;
                }
                else // 保持上一状态
                {
                    Display_Brake_Pressure_Table = brake_pressure_last;
                }
            }
        }
    }
    BrakeCtrl.Goal = Display_Brake_Pressure_Table;
    BackLight_PWM_Duty_Cycle_Delta(BrakeCtrl.Goal, &BrakeCtrl.BrakeCurrent, &BrakeCtrl.Time);
}


//胎压表
void Display_Tire_Pressure(void)
{
    static uint8_t Time_1s = 0;
    if(Common_Get_IG_Sts( ) == COMMON_POWER_ON )
    {
        if((Get_CAN_CH0_ID_10FBF5AA_Sig_TirePressure() > 0xFAFF) ||
           (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_A1DOC2_Msg_Count) == CAN_SIG_LOST))
        {
            TirePressure = 0xFFFF;
        }
        else
        {
            TirePressure = Get_CAN_CH0_ID_10FBF5AA_Sig_TirePressure();

            if(TirePressure > 100)
            {
                TirePressure = 100;
            }
        }

        if(Time_1s == 0)
        {
            DisplayTirePressure = TirePressure;
        }

        if(Time_1s >= 10)
        {
            Time_1s = 0;
        }
        else
        {
            Time_1s++;
        }

    }
    else
    {

    }

}

//总计油耗
void TOT_Fuel_Consumption(void)
{
    uint32_t TOTFuelCon = Get_CAN_CH0_ID_18FEE900_Sig_TotalFuelConsumption();
    static uint8_t time_1s = 0;
    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        if (time_1s == 10)
        {
            if ((TOTFuelCon > 0xFAFFFFFF) ||
                (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_LFC_Msg_Count) == CAN_SIG_LOST))
            {
                TOTFuelCon = 0xFFFFFFFF;
            }
            else
            {
                TOTFuelCon /= 2;
            }

            DisplayTOTFuelCon = TOTFuelCon;
            time_1s = 0;
        }
        else
        {
            time_1s++;
        }
    }
}

// 瞬时油耗
void Instantaneous_Fuel_Consumption(void)
{
    uint32_t InsFuelCon = 0;
    uint32_t EngineTimer = 0;
    uint32_t DataDisplayTOTFuelCon = 0;
    static uint8_t time_1s_InsFuelCon = 0;

    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        if (time_1s_InsFuelCon == 10)
        {

            // 输入配置为can输入
            if (Val_EOL_0300_LFE_Input_Configuration() == 0)
            {

                if ((Val_EOL_0300_Engine_Type_Configuration() == 0) ||
                    (Val_EOL_0300_Engine_Type_Configuration() == 1) ||
                    (Val_EOL_0300_Engine_Type_Configuration() == 2) ||
                    (Val_EOL_0300_Engine_Type_Configuration() == 3) ||
                    (Val_EOL_0300_Engine_Type_Configuration() == 4))
                {
                    if (Get_CAN_CH0_ID_18FEE200_Sig_InstantaneousFuelConsumption() > 0xFAFF ||
                        (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_LFE_Msg_Count) == CAN_SIG_LOST))
                    {
                        InsFuelCon = 0xFFFF;
                    }
                    else
                    {
                        InsFuelCon = Get_CAN_CH0_ID_18FEE200_Sig_InstantaneousFuelConsumption();
                        InsFuelCon /= 2; // 精度为0.1
                    }
                }
                else if (Val_EOL_0300_Engine_Type_Configuration() == 5)
                {
                    // 两个信号都异常
                    if ((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_LFE_Msg_Count) == CAN_SIG_LOST) &&
                        (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_LFE_27_Msg_Count) == CAN_SIG_LOST))
                    {
                        InsFuelCon = 0xFFFF;
                    }

                    // 有信号在线时
                    else
                    {
                        if ((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_LFE_27_Msg_Count) == CAN_SIG_NORMAL))
                        {
                            if (Get_CAN_CH0_ID_18FEE227_Sig_InstantaneousFuelConsumption() > 0xFAFF)
                            {
                                InsFuelCon = 0xFFFF;
                            }
                            else
                            {
                                InsFuelCon = Get_CAN_CH0_ID_18FEE227_Sig_InstantaneousFuelConsumption();
                                InsFuelCon /= 2; // 精度为0.1
                            }
                        }
                        if ((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_LFE_Msg_Count) == CAN_SIG_NORMAL))
                        {
                            if (Get_CAN_CH0_ID_18FEE200_Sig_InstantaneousFuelConsumption() > 0xFAFF)
                            {
                                InsFuelCon = 0xFFFF;
                            }
                            else
                            {
                                InsFuelCon = Get_CAN_CH0_ID_18FEE200_Sig_InstantaneousFuelConsumption();
                                InsFuelCon /= 2; // 精度为0.1
                            }
                        }
                    }
                }
            }
            else if (Val_EOL_0300_LFE_Input_Configuration() == 1)
            {
                if (DisplayTOTFuelCon == 0xFFFFFFFF)
                {
                    InsFuelCon = 0xFFFF;
                }
                else
                {
                    EngineTimer = Get_AfterIgnOn_TimeHour() * 10;
                    EngineTimer += Get_TimeMin_Conversion();
                    if (EngineTimer == 0)
                    {
                        InsFuelCon = DataDisplayTOTFuelCon;
                    }
                    else
                    {
                        DataDisplayTOTFuelCon = DisplayTOTFuelCon * 10;
                        InsFuelCon = DataDisplayTOTFuelCon / EngineTimer;
                    }
                }
            }

            DisplayInsFuelCon = InsFuelCon;
            time_1s_InsFuelCon = 0;
        }
        else
        {
            time_1s_InsFuelCon++;
        }
    }
}

void Animation(void)
{
    uint8_t table = 0;

    if ( AnimationStep <= 318 )
    {
        AnimationStep++;

        if ( AnimationStep <= 159 ) /*increase*/
        {
            
            Animat_Fuel++;
            table = Animat_Fuel / 19;
            Water_Tem_Table_Processing(table);
            Oil_Tem_Table_Processing(table);
        }
        else
        {

            if ( Animat_Fuel != 0 )
            {
                Animat_Fuel--;
                table = Animat_Fuel / 19;
                Water_Tem_Table_Processing(table);
                Oil_Tem_Table_Processing(table);
            }
        }
    }
}

uint16_t Get_AnimationStep_Timer(void)
{
    return AnimationStep;
}

void IC_Ctrl_2F(uint8_t Object, uint8_t Data)
{
    switch ( Object )
    {
        case 1u:
            UDS_Ctrl_Right_C = 1u;
            if ( Data == 0u )
            {
            }
            else if ( Data == 1u )
            {
            }
            else if ( Data == 2u )
            {
            }
            else if ( Data == 3u )
            {
            }
            else if ( Data == 4u )
            {
            }
            else if ( Data == 5u )
            {
            }
            else if ( Data == 6u )
            {
            }
            else if ( Data == 7u )
            {
            }
            break;
        case 2u:
            UDS_Ctrl_Right_F = 1u;
            if ( Data == 0u )
            {
            }
            else if ( Data == 1u )
            {
            }
            else if ( Data == 2u )
            {
            }
            else if ( Data == 3u )
            {
            }
            else if ( Data == 4u )
            {
            }
            else if ( Data == 5u )
            {
            }
            else if ( Data == 6u )
            {
            }
            else if ( Data == 7u )
            {
            }
            break;

        default:
            break;
    }
}

void IC_Ctrl_Right(uint8_t Object, uint8_t Command)
{
    switch ( Object )
    {
        case 1u:
            UDS_Ctrl_Right_C = 0u;
            break;
        case 2u:
            UDS_Ctrl_Right_F = 0u;
            break;
        default:
            UDS_Ctrl_Right_F = 0u;
            UDS_Ctrl_Right_C = 0u;
            break;
    }
}
void Display_Data_Init(void)
{
    Animat_Coolant           = 0u;
    Animat_Fuel              = 0u;
    Animat_Vspeed            = 0u;
    AnimationStep            = 0u;
    UDS_Ctrl_Right_F_Factory = 0u;
    UDS_Ctrl_Right_C_Factory = 0u;
    UDS_Ctrl_Right_F         = 0u;
    UDS_Ctrl_Right_C         = 0u;
        Outdoor_Temp_1S          = 9u;
    TEMP_LAMP_Light_Old = LAMP_LIGHT_POSITIVE(1, LED_W_TEMP);
}

void Display_Data_Wakeup_Init(void)
{
    Outdoor_Temp_1S          = 9u;
    TEMP_LAMP_Light_Old = LAMP_LIGHT_POSITIVE(1, LED_W_TEMP);
}

void Display_Factory_Ctrl(void)
{
    UDS_Ctrl_Right_F_Factory = 0x55u;
    UDS_Ctrl_Right_C_Factory = 0x55u;
}
void Display_Factory_Release(void)
{
    UDS_Ctrl_Right_F_Factory = 0x00u;
    UDS_Ctrl_Right_C_Factory = 0x00u;
}

uint8_t Get_Display_Factory(void)
{
    uint8_t Display_Factory;
    if((UDS_Ctrl_Right_F_Factory == 0x55) && (UDS_Ctrl_Right_C_Factory == 0x55))
    {
        Display_Factory = 0x55;
    }
    else 
    {
        Display_Factory = 0;
    }
    return Display_Factory;
}

/******************************************************************
 * ****************************************************************
 *
 * 断码全部点亮控制
 *
 * ****************************************************************
 * ***************************************************************/
void SET_LED_AUTO_TEST(void)
{
}

//液压油温表
void Display_Hydraulic_Oil_Temperature(void)
{
    if(Common_Get_IG_Sts( ) == COMMON_POWER_ON )
    {
        uint16_t Resistance_table = 0;   //传入值
        uint16_t Display_Hydraulic_Oil_Temperature_Table_current = 0;  //当前显示状态
        static uint16_t Display_Hydraulic_Oil_Temperature_Table_last = 0;  //上次显示状态
        Resistance_table = Get_Hydraulic_Oil_Resistance_Temperature();
        if(Resistance_table > 120)    //错误状态   40
        {
            Display_Hydraulic_Oil_Temperature_Table_current = 40;
            Display_Hydraulic_Oil_Temperature_Table_last = 40;
        }
        else                          //有效状态   40-120
        {
            if(Resistance_table < Display_Hydraulic_Oil_Temperature_Table_last)  //下降
            {
                if((Display_Hydraulic_Oil_Temperature_Table_last - Resistance_table) > 2)  //消抖
                {
                    Display_Hydraulic_Oil_Temperature_Table_current = Resistance_table;
                }
                else
                {
                    Display_Hydraulic_Oil_Temperature_Table_current = Display_Hydraulic_Oil_Temperature_Table_last;
                }
            }
            else
            {
                Display_Hydraulic_Oil_Temperature_Table_current = Resistance_table;
            }
        }
        HydraulicLevelCtrl.Goal = Display_Hydraulic_Oil_Temperature_Table_current;
        Display_Hydraulic_Oil_Temperature_Table_last = Display_Hydraulic_Oil_Temperature_Table_current;
        BackLight_PWM_Duty_Cycle_Delta(HydraulicLevelCtrl.Goal, &HydraulicLevelCtrl.HyOilTemCurrent, &HydraulicLevelCtrl.Time);
    }
}

//变速箱油压表
void Display_Transmission_Oil_Pressure(void)
{
    if(Common_Get_IG_Sts( ) == COMMON_POWER_ON )
    {
        uint32_t voltage_table = 0;    //输入值
        uint32_t Display_Transmission_Oil_Pressuree_Table_current = 0;  //当前显示状态
        static uint32_t Display_Transmission_Oil_Pressuree_Last = 0;  //上次显示状态
        voltage_table = Get_TransmissionOilPressure();
        if(voltage_table > 2500)    //错误状态   0
        {
            Display_Transmission_Oil_Pressuree_Table_current = 0;
        }
        else                          //有效状态   0-25
        {
            voltage_table /= 10;  //10倍显示
            if(voltage_table < Display_Transmission_Oil_Pressuree_Last)  //下降
            {
                if((Display_Transmission_Oil_Pressuree_Last - voltage_table ) > 5)  //消抖
                {
                    Display_Transmission_Oil_Pressuree_Table_current = voltage_table;
                }
                else
                {
                    Display_Transmission_Oil_Pressuree_Table_current = Display_Transmission_Oil_Pressuree_Last;
                }
            }
            else
            {
                Display_Transmission_Oil_Pressuree_Table_current = voltage_table;
            }
        }
        TransdraulicLevelCtrl.Goal = Display_Transmission_Oil_Pressuree_Table_current;
        Display_Transmission_Oil_Pressuree_Last = Display_Transmission_Oil_Pressuree_Table_current;
        BackLight_PWM_Duty_Cycle_Delta(TransdraulicLevelCtrl.Goal, &TransdraulicLevelCtrl.TransmisOilPreCurrent, &TransdraulicLevelCtrl.Time);
    }
}

//电池电压数显显示
Battery Get_Battery_Voltage(void)
{
    static Battery BatteryOutput;
    static uint16_t LastVoltage = 0;
    static uint8_t Time_1s = 0;
    static uint8_t Time_2s = 0;

    LastVoltage = BatteryOutput.Voltage;

    if((Battery_Voltage == 0) && (Time_2s <= 40)) //断30电2s内显示上一状态电压值
    {
        Time_2s++;
        BatteryOutput.Voltage = LastVoltage;
        Time_1s = 0;
    }
    else
    {
        if (Time_1s == 0)
        {
            BatteryOutput.Voltage = Battery_Voltage;
            BatteryOutput.Status = Bettery_Voltage_Status;
        }
        if (Time_1s >= 20)
        {
            Time_1s = 0;
        }
        else
        {
            Time_1s++;
        }
    }

    if(Time_2s > 40)
    {
        Time_2s = 0xFF;
    }

    if(Battery_Voltage != 0)
    {
        Time_2s = 0;
    }

    return BatteryOutput;
}

uint32_t Get_Transmission_Oil_Temperature_Display(void) //获取左侧小表头-变速箱油温数值
{
    return TransmissionOilTemperatureCtrl.OilTemperatureCurrent;
}

uint32_t Get_Battery_Voltage_Display(void)              //获取电池电压表数值
{
    return BatteryVoltageCtrl.BatteryVoltageCurrent;
}

uint8_t Get_Display_Environment_Temperature(void)
{
    return Display_Temperature;
}

//尿素液位显示
uint8_t Get_Display_Urea_Level(void)
{
    return UreaLevelCtrl.UreaLevelCurrent;
}

uint8_t Get_Fuel_Level(void)
{
    return FuelCtrl.FuelCurrent;
}

uint16_t Get_Display_Oil_Pressure(void)
{
    return OilPressureCtrl.OilPressureCurrent;
}

//制动压力表（左侧小表头）
uint16_t Get_Display_Brake_Pressure(void)
{
    return BrakeCtrl.BrakeCurrent;
}
//制动压力表错误状态
uint16_t Get_Display_Brake_Pressure_WrongS_Status(void)
{
    return Errostatus;
}

//胎压表（数显）
uint32_t Get_Display_Tire_Pressure(void)
{
    return DisplayTirePressure;
}

//湿式制动表
uint16_t Get_Display_Wet_Brake(void)
{
    return WetBrakeCtrl.WetBrakeCurrent;
}

//总计油耗显示
uint32_t Get_TOT_Fuel_Consumption(void)
{
    return DisplayTOTFuelCon;
}

//瞬时油耗显示
uint32_t Get_Instantaneous_Fuel_Consumption(void)
{
    return DisplayInsFuelCon;
}

//获取液压油温表数显
uint32_t Get_Hydraulic_Oil_Temperature(void)
{
    return HydraulicLevelCtrl.HyOilTemCurrent;
}

//获取变速箱油压表数显
uint32_t Get_Transmission_Oil_Pressure_Display(void)
{
    return TransdraulicLevelCtrl.TransmisOilPreCurrent;
}