#include "LED_Map.h"
#include "LED_Driver.h"
#include "BackLight.h"

const uint8_t LED_Duty_Tbl [ LED_MAX ][ 2u ] = {
    /*LED_Turn_L                      */{100,  50},
    /*LED_Turn_R                      */{100,  50},
    /*LED_Lamplet                     */{100,  50},
    /*LED_W_TEMP                      */{33 , 2},
};

static uint8_t LED_PWM;

uint8_t LAMP_LIGHT_POSITIVE(uint8_t Status, uint8_t indx)
{
    uint8_t Out = 0u;
    if ( Status )
    {
        if ( LED_PWM > 1 )
        {
            LED_PWM = 1u;
        }
        Out = LED_Duty_Tbl [ indx ][ LED_PWM ];
    }
    else
    {
        Out = 0;
    }

    return Out;
}

void SetLED_PWM(uint8_t value)
{
    if ( value )
    {
        LED_PWM = 0u;
    }
    else
    {
        LED_PWM = 1u;
    }
}