#include"Menu_Function.h"
#include "TYW_stdint.h"
#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "Configuration.h"
#include "EOL_Para.h"
#include "Display.h"
#include "Analog_Signals.h"

Transmission_Oil_Temperature Menu;

/*
节气门后进气温度
1.显示范围：-40 ~ 210 ℃，传参为0~250，传入0xFF时显示--- ℃
2.显示分辨率： 1 ℃
3.刷新时间定义： 1秒
*/
uint16_t Intake_Manifold_Air_Tem_Menu(void)
{
    uint16_t IntakeManAirTem = 0;
    if((Get_CAN_CH0_ID_18FEF600_Sig_IntakeManifoldAirTemperature() > 0xFA) ||
    (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_IC1_Msg_Count) == CAN_SIG_LOST))
    {
        IntakeManAirTem = 0xFF;
    }
    else
    {
        IntakeManAirTem = Get_CAN_CH0_ID_18FEF600_Sig_IntakeManifoldAirTemperature();
    }
    return IntakeManAirTem;
}

/*
燃油温度
[配置-发动机类型配置] =潍柴或者上柴或者康明斯或者云内或者洛拖时显示
1.显示范围：-40 ~ 210 ℃，传参为0~250，传入0xFF时显示--- ℃
2.显示分辨率： 1 ℃
3.刷新时间定义： 1秒
*/
uint16_t Fuel_Tem_Menu(void)
{
    uint16_t FuelTem = 0;
    if((Get_CAN_CH0_ID_18FEEE00_Sig_FuelTemperature() > 0xFA) ||
    (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_ET1_Msg_Count) == CAN_SIG_LOST))
    {
        FuelTem = 0xFF;
    }
    else
    {
        FuelTem = Get_CAN_CH0_ID_18FEEE00_Sig_FuelTemperature();
    }
    return FuelTem;
}

/*
机油温度
[配置-发动机类型配置] = 潍柴或者上柴或者康明斯或者云内或者洛拖时显示
1.显示范围：-273 ~ 1735 ℃，传参为0~2008,传入0xFFFF时显示---- ℃
2.显示分辨率： 1 ℃
3.刷新时间定义： 1秒
*/
uint32_t Engine_Oil_Tem_Menu(void)
{
    uint32_t EngineOilTem = 0;
    if((Get_CAN_CH0_ID_18FEEE00_Sig_EngineOilTemperature() > 0xFB00) ||
    (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_ET1_Msg_Count) == CAN_SIG_LOST))
    {
        EngineOilTem = 0xFFFF;
    }
    else
    {
        EngineOilTem = Get_CAN_CH0_ID_18FEEE00_Sig_EngineOilTemperature();
        EngineOilTem *= 1000;
        EngineOilTem /= 8;
        EngineOilTem *= 100;
        EngineOilTem /= 4;
        EngineOilTem /= 100000;

    }
    return EngineOilTem;
}

/*
油门踏板位置
1.显示范围：0 ~ 100 %，传参为0~100，传入0xFF时显示--- %
2.显示分辨率： 1 %
3.刷新时间定义： 1秒。
*/
uint16_t Accelerator_Pedal_Position_Menu(void)
{
    uint16_t PedalPosition = 0;
    if((Get_CAN_CH0_ID_0CF00300_Sig_AcceleratorPedalPosition1() > 0xFA) ||
    (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_EEC2_Msg_Count) == CAN_SIG_LOST))
    {
        PedalPosition = 0xFF;
    }
    else
    {
        PedalPosition = Get_CAN_CH0_ID_0CF00300_Sig_AcceleratorPedalPosition1();
        PedalPosition *= 4;
        PedalPosition /= 10;
    }
    return PedalPosition;
}

uint16_t Fuel_Level_Menu(void) // 燃料液位   正确返回0-100；错误返回0xFF
{
    uint16_t Fuel_Menu = 0u;
    if (Get_EldingLevel_status() > 1000) // 错误状态
    {
        Fuel_Menu = 0xFF;
    }
    else
    {
        Fuel_Menu = FuelCtrl.Goal;
    }

    return Fuel_Menu;
}

uint16_t Water_Temperature_Menu(void) // 水温   正确返回0-250；错误返回0xFF
{
    uint16_t Water_Temperature = 0u;
    if ((Get_CAN_CH0_ID_18FEEE00_Sig_CoolantTemperature() > 0xFA) || (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_ET1_Msg_Count) == CAN_SIG_LOST))  //超时、错误
    {
        Water_Temperature = 0xFF;
    }
    else
    {
        Water_Temperature = Get_CAN_CH0_ID_18FEEE00_Sig_CoolantTemperature();
    }
    return Water_Temperature;
}

uint16_t Oil_Pressure_Menu(void) // 机油压力   正确返回0-100；错误返回0xFF
{
    uint16_t Oil_Pressure = 0u;
    if ((Get_CAN_CH0_ID_18FEEF00_Sig_EngineOilPressure() > 0xFA) || (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_EFLP1_Msg_Count) == CAN_SIG_LOST))  //超时、错误
    {
        Oil_Pressure = 0xFF;
    }
    else
    {
        Oil_Pressure = OilPressureCtrl.Goal;  //从表头获取
    }
    return Oil_Pressure;
}

uint16_t Urea_Level_Menu(void) // 尿素液位   正确返回0-100； 错误返回0xFF
{
    uint16_t UreaLevelMenu = 0u;
    if ((Get_Stater_Type() == WEICHAI) ||
        (Get_Stater_Type() == KANGMINGSI) ||
        (Get_Stater_Type() == YUNNEI) ||
        (Get_Stater_Type() == YUCHAI))
    {
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_AT1TI1_00_Msg_Count) == CAN_SIG_LOST)
        {
            UreaLevelMenu = 0xFF;    //超时
        }
        else
        {
            UreaLevelMenu = Get_CAN_CH0_ID_18FE5600_Sig_AdBlueLevel();
        }
    }
    else if (Get_Stater_Type() == SHANGCHAI)
    {
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_AT1TI1_3D_Msg_Count) == CAN_SIG_LOST)
        {
            UreaLevelMenu = 0xFF;   //超时
        }
        else
        {
            UreaLevelMenu = Get_CAN_CH0_ID_18FE5600_Sig_AdBlueLevel();
        }
    }
    else if (Get_Stater_Type() == LUOTUO)
    {
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_AT1TI1_A3_Msg_Count) == CAN_SIG_LOST)
        {
            UreaLevelMenu = 0xFF;   //超时
        }
        else
        {
            UreaLevelMenu = Get_CAN_CH0_ID_18FE5600_Sig_AdBlueLevel();
        }
    }

    UreaLevelMenu *= 4;
    UreaLevelMenu /= 10;
    if (UreaLevelMenu > 100)
    {
        UreaLevelMenu = 0xFF;   //错误
    }
    return UreaLevelMenu;
}

uint16_t Battery_Voltage_Menu(void) // 电池电压   正确返回160-320
{
    uint16_t BatteryVoltage = 0u;
    BatteryVoltage = Battery_Voltage;
    if (BatteryVoltage > 320)
    {
        BatteryVoltage = 320;
    }
    else if (BatteryVoltage < 160)
    {
        BatteryVoltage = 160;
    }
    return BatteryVoltage;
}

uint16_t DPF_Menu(void) // DPF积尘量   正确返回0-11； 超时返回0xFF
{
    uint16_t DPF = 0u;
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_CLUSTER_Msg_Count) == CAN_SIG_LOST) // 超时
    {
        DPF = 0xFF;
    }
    else
    {
        DPF = Get_CAN_CH0_ID_18FFC100_Sig_PMLevel();
        if (DPF > 11u)
        {
            DPF = 11u;
        }
    }
    return DPF;
}

uint16_t Atmospheric_Pressure_Menu(void) // 大气压力   正确返回0-1250； 错误返回0xFFFF
{
    uint16_t AtmosphericPressure = 0u;
    if ((Get_Stater_Type() == WEICHAI) ||
        (Get_Stater_Type() == SHANGCHAI) ||
        (Get_Stater_Type() == KANGMINGSI) ||
        (Get_Stater_Type() == YUNNEI) ||
        (Get_Stater_Type() == YUCHAI))
    {
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_AMB_Msg_Count) == CAN_SIG_LOST) // 超时
        {
            AtmosphericPressure = 0xFFFF;
        }
        else
        {
            AtmosphericPressure = Get_CAN_CH0_ID_18FEF500_Sig_AtmosphericPressure();
            AtmosphericPressure *= 10;
            AtmosphericPressure /= 2;
            if (AtmosphericPressure > 1250)    //错误
            {
                AtmosphericPressure = 0xFFFF;
            }
        }
    }
    else if (Get_Stater_Type() == LUOTUO)
    {
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_AMB_27_Msg_Count) == CAN_SIG_LOST) // 超时
        {
            AtmosphericPressure = 0xFFFF;
        }
        else
        {
            AtmosphericPressure = Get_CAN_CH0_ID_18FEF527_Sig_AtmosphericPressure();
            AtmosphericPressure *= 10;
            AtmosphericPressure /= 2;
            if (AtmosphericPressure > 1250)  //错误
            {
                AtmosphericPressure = 0xFFFF;
            }
        }
    }
    return AtmosphericPressure;
}

uint32_t Engine_Total_Idle_Hours_Menu(void) // 发动机怠速时间   正确返回0-9999990； 错误返回0xFFFFFFFF
{
    uint32_t EngineTotalIdleHours = 0u;
    if ((Get_Stater_Type() == SHANGCHAI) ||
        (Get_Stater_Type() == KANGMINGSI) ||
        (Get_Stater_Type() == YUNNEI) ||
        (Get_Stater_Type() == YUCHAI) ||
        (Get_Stater_Type() == LUOTUO))
    {
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_IO_Msg_Count) == CAN_SIG_LOST) // 超时
        {
            EngineTotalIdleHours = 0xFFFFFFFF;
        }
        else
        {
            EngineTotalIdleHours = Get_CAN_CH0_ID_18FEDC00_Sig_EngineTotalIdleHours();
            if(EngineTotalIdleHours > 0xFAFFFFFF)  //错误
            {
                EngineTotalIdleHours = 0xFFFFFFFF;
            }
            else if(EngineTotalIdleHours > 0x1E847E)  // 输入（处于[有效状态]）大于最大显示值时，仪表需要显示最大显示值
            {
                EngineTotalIdleHours = 0x1E847E;
                EngineTotalIdleHours *= 100; // 100倍显示
                EngineTotalIdleHours /= 20;  // 精度0.05
            }
            else
            {
                EngineTotalIdleHours *= 100; // 100倍显示
                EngineTotalIdleHours /= 20;  // 精度0.05
            }
        }
    }
    else   //其他配置不显示
    {

    }
    return EngineTotalIdleHours;
}

uint16_t DPF_Internalsoot_Load_Menu(void) // 内部碳烟加载量   正确返回0-250； 错误返回0xFFFF
{
    uint16_t DPFInternalsootLoad = 0u;
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FD7B_Msg_Count) == CAN_SIG_LOST) // 超时
    {
        DPFInternalsootLoad = 0xFFFF;
    }
    else
    {
        DPFInternalsootLoad = Get_CAN_CH0_ID_18FD7B00_Sig_DPFInternalsootLoad();
        if (DPFInternalsootLoad > 0xFA) // 错误
        {
            DPFInternalsootLoad = 0xFFFF;
        }
        else
        {

        }
    }
    return DPFInternalsootLoad;
}


Transmission_Oil_Temperature Transmission_Oil_Temperature_Menu(void) // 变速箱油温   
{
    static uint8_t timer = 0;
    static uint8_t Line_Last_Status = 0; //硬线判断回滞   1有效  2无效
    uint16_t TransmissionHigh_resistance = 0u; // 硬线采集获取阻值
    static uint16_t Avg_TransmissionHigh_resistance = 0u;
    static uint16_t Five_Avg_TransmissionHigh_resistance = 0u;  //5次采集平均值
    TransmissionHigh_resistance = ADC_Read_Signal(ADC_CH_TRANSMISSION_OIL_TEMPERATURE);
    if ((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_TOT_Msg_Count) == CAN_SIG_LOST) &&
        (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_DANA_Msg_Count) == CAN_SIG_LOST) &&
        (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FD95_Msg_Count) == CAN_SIG_LOST))
    {
        timer++;
        Avg_TransmissionHigh_resistance += TransmissionHigh_resistance;
        if (timer >= 5)
        {
            timer = 0;
            Avg_TransmissionHigh_resistance /= 5;
            Five_Avg_TransmissionHigh_resistance = Avg_TransmissionHigh_resistance;
            Avg_TransmissionHigh_resistance = 0u;
        }
        if(Five_Avg_TransmissionHigh_resistance < 30)   //错误状态
        {
            Menu.LINE_Oil_Tem = 0xFFFFFFFF;
            Line_Last_Status = 2;
        }
        else if(Five_Avg_TransmissionHigh_resistance < 100)  //回滞
        {
            if(Line_Last_Status == 2)  //错误状态
            {
                Menu.LINE_Oil_Tem = 0xFFFFFFFF;
            }
            else if(Line_Last_Status == 1)  //有效状态且大于最大显示值
            {
                Menu.LINE_Oil_Tem = 0xFFFF;
            }

        }
        else if(Five_Avg_TransmissionHigh_resistance < 248)  //显示>140℃
        {
            Menu.LINE_Oil_Tem = 0xFFFF;
            Line_Last_Status = 1;
        }
        else if(Five_Avg_TransmissionHigh_resistance > 2914)  //显示<55 ℃
        {
            Menu.LINE_Oil_Tem = 0;
            Line_Last_Status = 1;
        }
        else
        {
            Menu.LINE_Oil_Tem = Transmission_Oil_Temperature_Resistance(Five_Avg_TransmissionHigh_resistance); // 变速箱油温电阻换算成温度
            Line_Last_Status = 1;
        }
        Menu.CAN_or_LINE = 1;
    }
    else
    {
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FD95_Msg_Count) == CAN_SIG_NORMAL)
        {

            Menu.CAN_Oil_Tem = Get_CAN_CH0_ID_18FD9503_Sig_TransmissionOilTemperature();
            if(Menu.CAN_Oil_Tem > 0xFB00)   //错误
            {
                Menu.CAN_Oil_Tem = 0xFFFF;
            }
            else
            {
            Menu.CAN_Oil_Tem *= 100;
            Menu.CAN_Oil_Tem /= 4;
            Menu.CAN_Oil_Tem *= 1000;
            Menu.CAN_Oil_Tem /= 8;
            Menu.CAN_Oil_Tem /= 100000;
            }
        }
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_DANA_Msg_Count) == CAN_SIG_NORMAL)
        {

            Menu.CAN_Oil_Tem = Get_CAN_CH0_ID_0CFF3003_Sig_TransmissionOilTemperature();
            if(Menu.CAN_Oil_Tem > 0xFA)  //错误
            {
                Menu.CAN_Oil_Tem = 0xFFFF;
            }
            else
            {

            }
        
        }
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_TOT_Msg_Count) == CAN_SIG_NORMAL)
        {
            Menu.CAN_Oil_Tem = Get_CAN_CH0_ID_18FF1F03_Sig_TransmissionOilTemperatureofZF();
            if(Menu.CAN_Oil_Tem > 0xFA)  //错误
            {
                Menu.CAN_Oil_Tem = 0xFFFF;
            }
            else
            {

            }
        }
        if(Menu.CAN_Oil_Tem == 0xFFFF)  //错误状态保持
        {

        }
        else if(Menu.CAN_Oil_Tem > 250)  //大于显示最大值且处于有效状态，按最大值显示
        {
            Menu.CAN_Oil_Tem = 250;
        }
        else
        {

        }
        Menu.CAN_or_LINE = 0;
    }
    return Menu;
}

uint16_t Actual_Engine_Percent_Torque_Menu(void) // 发动机扭矩百分比  正确返回0-250； 错误返回0xFF
{
    uint16_t ActualEnginePercentTorque = 0u;
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_EEC1_0C_Msg_Count) == CAN_SIG_LOST) // 超时
    {
        ActualEnginePercentTorque = 0xFF;
    }
    else
    {
        ActualEnginePercentTorque = Get_CAN_CH0_ID_0CF00400_Sig_ActualEnginePercentTorque();
        if (ActualEnginePercentTorque > 0xFA) // 错误
        {
            ActualEnginePercentTorque = 0xFF;
        }
        else
        {

        }
    }
    return ActualEnginePercentTorque;
}

uint16_t Ad_Blue_Temperature_Menu(void) // 尿素温度   正确返回0-250； 错误返回0xFF
{
    uint16_t AdBlueTemperature  = 0u;
    if ((Get_Stater_Type() == WEICHAI) ||
        (Get_Stater_Type() == KANGMINGSI) ||
        (Get_Stater_Type() == YUNNEI) ||
        (Get_Stater_Type() == YUCHAI))
    {
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_AT1TI1_00_Msg_Count) == CAN_SIG_LOST)
        {
            AdBlueTemperature = 0xFF;    //超时
        }
        else
        {
            AdBlueTemperature = Get_CAN_CH0_ID_18FE5600_Sig_AdBlueTemperature();
        }
    }
    else if (Get_Stater_Type() == LUOTUO)
    {
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_AT1TI1_A3_Msg_Count) == CAN_SIG_LOST)
        {
            AdBlueTemperature = 0xFF;   //超时
        }
        else
        {
            AdBlueTemperature = Get_CAN_CH0_ID_18FE56A3_Sig_AdBlueTemperature();
        }
    }
    if (AdBlueTemperature > 250)
    {
        AdBlueTemperature = 0xFF;   //错误
    }
    return AdBlueTemperature;
}

uint32_t  Engine_Total_Idle_Fuel_Used_Menu(void) // 发动机怠速油耗   正确返回0-9999990； 错误返回0xFFFFFFFF
{
    uint32_t EngineTotalIdleFuelUsed = 0u;
    if ((Get_Stater_Type() == SHANGCHAI) ||
        (Get_Stater_Type() == KANGMINGSI) ||
        (Get_Stater_Type() == YUNNEI) ||
        (Get_Stater_Type() == YUCHAI) ||
        (Get_Stater_Type() == LUOTUO))
    {
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_IO_Msg_Count) == CAN_SIG_LOST) // 超时
        {
            EngineTotalIdleFuelUsed = 0xFFFFFFFF;
        }
        else
        {
            EngineTotalIdleFuelUsed = Get_CAN_CH0_ID_18FEDC00_Sig_EngineTotalIdleFuelUsed();
            if(EngineTotalIdleFuelUsed > 0xFAFFFFFF)  //错误
            {
                EngineTotalIdleFuelUsed = 0xFFFFFFFF;
            }
            else if(EngineTotalIdleFuelUsed > 0x1E847E)  // 输入（处于[有效状态]）大于最大显示值时，仪表需要显示最大显示值
            {
                EngineTotalIdleFuelUsed = 0x1E847E;
                EngineTotalIdleFuelUsed *= 10; // 10倍显示
                EngineTotalIdleFuelUsed /= 2;  // 精度0.5
            }
            else
            {
                EngineTotalIdleFuelUsed *= 10; // 10倍显示
                EngineTotalIdleFuelUsed /= 2;  // 精度0.5
            }
        }
    }
    else   //其他配置不显示
    {

    }
    return EngineTotalIdleFuelUsed;
}

uint16_t Transmission_Oil_Pressure_Menu(void)  //变速箱油压  正确返回0-250   错误返回0xFF
{
    uint16_t TransmissionOilPressure = 0u;
    TransmissionOilPressure = Get_TransmissionOilPressure();
    if (TransmissionOilPressure > 2500) // 错误状态   0
    {
        TransmissionOilPressure = 0xFF;
    }
    else // 有效状态   0-250
    {
        TransmissionOilPressure = TransdraulicLevelCtrl.Goal; // 从表头获取
    }
    return TransmissionOilPressure;
}

uint32_t Transmission_Oil_Tank_Temperature_Menu(void) // 变速箱油槽温度   
{
    uint32_t TransmissionOilTankTemperature = 0u;
    if (Val_EOL_0300_Transmission_Type_Configuration() == 1u) // ZF
    {
        if ((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_TOT_Msg_Count) == CAN_SIG_LOST) &&
            (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_TRF1_Msg_Count) == CAN_SIG_LOST))
        {
            TransmissionOilTankTemperature = 0xFFFF;             //超时
        }
        else
        {
            if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_TRF1_Msg_Count) == CAN_SIG_NORMAL)
            {

                TransmissionOilTankTemperature = Get_CAN_CH0_ID_18FEF803_Sig_TransmissionOilTankTemperature();
                if (TransmissionOilTankTemperature > 0xFB00) // 错误
                {
                    TransmissionOilTankTemperature = 0xFFFF;
                }
                else
                {
                    TransmissionOilTankTemperature *= 100;
                    TransmissionOilTankTemperature /= 4;
                    TransmissionOilTankTemperature *= 1000;
                    TransmissionOilTankTemperature /= 8;
                    TransmissionOilTankTemperature /= 100000;
                }
                if(TransmissionOilTankTemperature == 0xFFFF)   //错误状态保持
                {

                }
                else       //偏移量换算  由-273偏移量转为-50偏移量
                {
                    if (TransmissionOilTankTemperature < 223) // 输入（处于[有效状态]）小于最小显示值
                    {
                        TransmissionOilTankTemperature = 0;
                    }
                    else if (TransmissionOilTankTemperature > 473) // 输入（处于[有效状态]）大于最大显示值
                    {
                        TransmissionOilTankTemperature = 473;
                        TransmissionOilTankTemperature -= 223;
                    }
                    else
                    {
                        TransmissionOilTankTemperature -= 223;
                    }
                }
            }
            if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_TOT_Msg_Count) == CAN_SIG_NORMAL)
            {
                TransmissionOilTankTemperature =  Get_CAN_CH0_ID_18FF1F03_Sig_TransmissionOilTankTemofZF();
                if (TransmissionOilTankTemperature > 0xFA) // 错误
                {
                    TransmissionOilTankTemperature = 0xFFFF;
                }
                else
                {

                }
            }
            if (TransmissionOilTankTemperature == 0xFFFF) // 错误状态保持
            {

            }
            else if (TransmissionOilTankTemperature > 250) // 大于显示最大值且处于有效状态，按最大值显示
            {
                TransmissionOilTankTemperature = 250;
            }
            else
            {

            }
        }
    }
    else if (Val_EOL_0300_Transmission_Type_Configuration() == 3u)   //徐工自制
    {
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_TOT_Msg_Count) == CAN_SIG_NORMAL)
        {
            if(Get_CAN_CH0_ID_18FF1F03_Sig_TransmissionOilTankTemofZF() <= 0xFA)
            {
                TransmissionOilTankTemperature =  Get_CAN_CH0_ID_18FF1F03_Sig_TransmissionOilTankTemofZF();
            }
            else
            {
                TransmissionOilTankTemperature = 0xFFFF;      //错误状态
            }
        }
        else
        {
            TransmissionOilTankTemperature = 0xFFFF;      //超时
        }
    }
    return  TransmissionOilTankTemperature;
}

uint16_t Torque_Converter_Turbo_Torque_Menu(void) // 变矩器涡轮扭矩
{
    uint16_t TorqueConverterTurboTorque = 0u;
    if ((Val_EOL_0300_Transmission_Type_Configuration() == 1) || Val_EOL_0300_Transmission_Type_Configuration() == 3)
    {
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_TC1_Msg_Count) == CAN_SIG_NORMAL)
        {
            TorqueConverterTurboTorque = Get_CAN_CH0_ID_18FF2203_Sig_TorqueConverterTurboTorque();
            if (TorqueConverterTurboTorque <= 0xFAFF)
            {

            }
            else
            {
                TorqueConverterTurboTorque = 0xFFFF; // 错误
            }
        }
        else
        {
            TorqueConverterTurboTorque = 0xFFFF; // 超时
        }
    }
    return TorqueConverterTurboTorque;
}

uint16_t Torque_Converter_Output_Shaft_Speed_Menu(void) // 变矩器输出轴转速
{
    uint16_t TorqueConverterOutputShaftSpeed  = 0u;
    if ((Val_EOL_0300_Transmission_Type_Configuration() == 1) ||(Val_EOL_0300_Transmission_Type_Configuration() == 3))
    {
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_TC2_Msg_Count) == CAN_SIG_NORMAL)
        {
            TorqueConverterOutputShaftSpeed  = Get_CAN_CH0_ID_0CF00203_Sig_TorqueConverterOutputShaftSpeed();
            if (TorqueConverterOutputShaftSpeed  <= 0xFAFF)
            {
                TorqueConverterOutputShaftSpeed /= 8;
            }
            else
            {
                TorqueConverterOutputShaftSpeed  = 0xFFFF; // 错误
            }
        }
        else
        {
            TorqueConverterOutputShaftSpeed  = 0xFFFF; // 超时
        }
    }
    return TorqueConverterOutputShaftSpeed;
}

uint16_t Torque_Converter_Iutput_Shaft_Speed_Menu(void) // 变矩器输入轴转速
{
    uint16_t TorqueConverterInputShaftSpeed   = 0u;
    if ((Val_EOL_0300_Transmission_Type_Configuration() == 1) || (Val_EOL_0300_Transmission_Type_Configuration() == 3))
    {
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_TC2_Msg_Count) == CAN_SIG_NORMAL)
        {
            TorqueConverterInputShaftSpeed   = Get_CAN_CH0_ID_0CF00203_Sig_TorqueConverterInputShaftSpeed();
            if (TorqueConverterInputShaftSpeed   <= 0xFAFF)
            {
                TorqueConverterInputShaftSpeed  /= 8;
            }
            else
            {
                TorqueConverterInputShaftSpeed   = 0xFFFF; // 错误
            }
        }
        else
        {
            TorqueConverterInputShaftSpeed   = 0xFFFF; // 超时
        }
    }
    return TorqueConverterInputShaftSpeed ;
}

uint16_t Middle_Shaft_Speed_Menu(void) // 中间轴转速
{
    uint16_t MiddleShaftSpeed = 0u;
    if ((Val_EOL_0300_Transmission_Type_Configuration() == 3))
    {
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF32_Msg_Count) == CAN_SIG_NORMAL)
        {
            MiddleShaftSpeed = Get_CAN_CH0_ID_18FF3203_Sig_MiddleShaftSpeed();
            if (MiddleShaftSpeed <= 0xFAFF)
            {
                MiddleShaftSpeed /= 8;
            }
            else
            {
                MiddleShaftSpeed = 0xFFFF; // 错误
            }
        }
        else
        {
            MiddleShaftSpeed = 0xFFFF; // 超时
        }
    }
    return MiddleShaftSpeed;
}

uint16_t Brake_Pressure_Menu(void) // 制动气压   正确返回0-100；错误返回0xFF
{
    uint16_t Brake_Pressure = 0u;
    if (Errostatus == 1u)  //错误
    {
        Brake_Pressure = 0xFF;
    }
    else
    {
        Brake_Pressure = BrakeCtrl.Goal;  //从表头获取
    }
    return Brake_Pressure;
}

uint16_t Wet_Brake_Menu(void)    //湿式制动
{
    uint16_t WetBrakeNumber = 0u;
    uint16_t WetBrake = 0u;      //单次采集
    static uint32_t Wet_Brake = 0u;     //5次AD采集
    static uint16_t AVE_Wet_Brake = 0u;   //5次AD采集平均值
    static uint8_t Ave_Time = 0u;                    //5次AD计时时间
    WetBrake = ADC_Read_Signal(ADC_CH_WETBRAKE_VOLTAGE)/10; //采集为mA
    Wet_Brake += WetBrake;
    Ave_Time++;
    if(Ave_Time >= 5)
    {
        Ave_Time = 0u;
        Wet_Brake /= 5u;
        AVE_Wet_Brake = Wet_Brake;
        Wet_Brake = 0u;
    }
    if(AVE_Wet_Brake > 500)
    {
        WetBrakeNumber = 0xFFFF;
    }
    else
    {
        WetBrakeNumber = AVE_Wet_Brake;
        WetBrakeNumber *= 4;
    }
    return WetBrakeNumber;
}

uint16_t Hydraulic_Oil_Temperature_Menu(void)   //液压油温
{
    uint16_t HydraulicOilTemperature_Number = 0u;     // 返回值
    static uint32_t HydraulicOilTemperature = 0u;     //5次AD采集电阻
    static uint32_t AVE_Hydraulic_Oil_Temperature = 0u;   //5次AD采集电阻平均值
    static uint16_t Ave_Time = 0u;                    //5次AD计时时间
    uint32_t Hydraulic_Oil_Temperature_Resistance = 0u;   //AD采集电阻
    Hydraulic_Oil_Temperature_Resistance = ADC_Read_Signal(ADC_CH_HYDRAULIC_OILTEMPERATURE);
    HydraulicOilTemperature += Hydraulic_Oil_Temperature_Resistance;
    Ave_Time++;
    if(Ave_Time >= 5)
    {
        Ave_Time = 0u;
        HydraulicOilTemperature *= 10u;
        HydraulicOilTemperature /= 5u;
        AVE_Hydraulic_Oil_Temperature = HydraulicOilTemperature;
        HydraulicOilTemperature = 0u;
    }
    if(Get_Hydraulic_Oil_Resistance_Temperature() > 120)   //错误
    {
        HydraulicOilTemperature_Number = 0xFF;
    }
    else
    {
        if(AVE_Hydraulic_Oil_Temperature < 2244)  // 当模拟量输入（处于有效范围）小于22.44Ω时，仪表需要显示“> 120
        {
            HydraulicOilTemperature_Number = 0;
        }
        else if(AVE_Hydraulic_Oil_Temperature > 29146)   //模拟量输入大于291.46Ω时，仪表需要显示“< 40℃”
        {
            HydraulicOilTemperature_Number = 200;
        }
        else
        {
            HydraulicOilTemperature_Number = HydraulicLevelCtrl.Goal;  //40-120
        }
    }
    return HydraulicOilTemperature_Number;
}

uint16_t FanReversing_Valve_Menu(void)   //风扇换向阀
{
    uint8_t Led_Status = 0u;
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF41_Msg_Count) == CAN_SIG_NORMAL)
    {
        if(Get_CAN_CH0_ID_18FF4121_Sig_FanReversingValve() == 1u)
        {
            Led_Status = 1u;
        }
        else
        {
            Led_Status = 0u;
        }
    }
    else
    {
        Led_Status = 0u;
    }
    return Led_Status;
}

uint16_t Emergency_Steering_Solenoid_Valve_Menu(void)   //应急转向电磁阀
{
    uint8_t Led_Status = 0u;
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF41_Msg_Count) == CAN_SIG_NORMAL)
    {
        if(Get_CAN_CH0_ID_18FF4121_Sig_EmergencySteeringSolenoidValve() == 1u)
        {
            Led_Status = 1u;
        }
        else
        {
            Led_Status = 0u;
        }
    }
    else
    {
        Led_Status = 0u;
    }
    return Led_Status;
}

uint16_t Stability_Module_Output_Solenoid_Valve1_Menu(void)   //稳定模块输出电磁阀1
{
    uint8_t Led_Status = 0u;
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF41_Msg_Count) == CAN_SIG_NORMAL)
    {
        if(Get_CAN_CH0_ID_18FF4121_Sig_StabilityModuleOuttSolenoidVal1() == 1u)
        {
            Led_Status = 1u;
        }
        else
        {
            Led_Status = 0u;
        }
    }
    else
    {
        Led_Status = 0u;
    }
    return Led_Status;
}

uint16_t Stability_Module_Output_Solenoid_Valve2_Menu(void)   //稳定模块输出电磁阀2
{
    uint8_t Led_Status = 0u;
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF41_Msg_Count) == CAN_SIG_NORMAL)
    {
        if(Get_CAN_CH0_ID_18FF4121_Sig_StabilityModuleOutSolenoidVa2() == 1u)
        {
            Led_Status = 1u;
        }
        else
        {
            Led_Status = 0u;
        }
    }
    else
    {
        Led_Status = 0u;
    }
    return Led_Status;
}

uint16_t Pull_Bucket_Solenoid_Valve_Menu(void)  //收铲斗电磁阀
{
    uint16_t PullBucketSolenoidValve = 0u;
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF42_Msg_Count) == CAN_SIG_NORMAL)
    {
        if(Get_CAN_CH0_ID_18FF4221_Sig_PullBucketSolenoidValve() <= 1500u)
        {
            PullBucketSolenoidValve = Get_CAN_CH0_ID_18FF4221_Sig_PullBucketSolenoidValve();
        }
        else
        {
            PullBucketSolenoidValve = 0xFFFFu;   //错误
        }
    }
    else
    {
        PullBucketSolenoidValve = 0xFFFFu;      //超时
    }
    return PullBucketSolenoidValve;
}

uint16_t Flip_Bucket_Solenoid_Valve_Menu(void)  //翻铲斗电磁阀
{
    uint16_t FlipBucketSolenoidValve = 0u;
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF42_Msg_Count) == CAN_SIG_NORMAL)
    {
        if(Get_CAN_CH0_ID_18FF4221_Sig_FlipBucketSolenoidValve() <= 1500u)
        {
            FlipBucketSolenoidValve = Get_CAN_CH0_ID_18FF4221_Sig_FlipBucketSolenoidValve();
        }
        else
        {
            FlipBucketSolenoidValve = 0xFFFFu;   //错误
        }
    }
    else
    {
        FlipBucketSolenoidValve = 0xFFFFu;      //超时
    }
    return FlipBucketSolenoidValve;
}

uint16_t Movable_Arm_Rising_Valve_Menu(void)   //动臂升电磁阀
{
    uint16_t MovableArmRisingValve = 0u;
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF42_Msg_Count) == CAN_SIG_NORMAL)
    {
        if(Get_CAN_CH0_ID_18FF4221_Sig_MovableArmRisingValve() <= 1500u)
        {
            MovableArmRisingValve = Get_CAN_CH0_ID_18FF4221_Sig_MovableArmRisingValve();
        }
        else
        {
            MovableArmRisingValve = 0xFFFFu;   //错误
        }
    }
    else
    {
        MovableArmRisingValve = 0xFFFFu;      //超时
    }
    return MovableArmRisingValve;
}

uint16_t Movable_Arm_Decline_Valve_Menu(void)  //动臂降电磁阀
{
    uint16_t MovableArmDeclineValve = 0u;
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF42_Msg_Count) == CAN_SIG_NORMAL)
    {
        if(Get_CAN_CH0_ID_18FF4221_Sig_MovableArmDeclineValve() <= 1500u)
        {
            MovableArmDeclineValve = Get_CAN_CH0_ID_18FF4221_Sig_MovableArmDeclineValve();
        }
        else
        {
            MovableArmDeclineValve = 0xFFFFu;   //错误
        }
    }
    else
    {
        MovableArmDeclineValve = 0xFFFFu;      //超时
    }
    return MovableArmDeclineValve;
}

uint16_t Fan_Speed_Solenoid_Valve_Menu(void)   //风扇调速电磁阀
{
    uint16_t FanSpeedSolenoidValve = 0u;
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF43_Msg_Count) == CAN_SIG_NORMAL)
    {
        if(Get_CAN_CH0_ID_18FF4321_Sig_FanSpeedSolenoidValve() <= 1500u)
        {
            FanSpeedSolenoidValve = Get_CAN_CH0_ID_18FF4321_Sig_FanSpeedSolenoidValve();
        }
        else
        {
            FanSpeedSolenoidValve = 0xFFFFu;   //错误
        }
    }
    else
    {
        FanSpeedSolenoidValve = 0xFFFFu;      //超时
    }
    return FanSpeedSolenoidValve;
}

uint16_t Clamp_Open_Solenoid_Valve_Menu(void)   //夹钳开电磁阀
{
    uint16_t ClampOpenSolenoidValve = 0u;
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF43_Msg_Count) == CAN_SIG_NORMAL)
    {
        if(Get_CAN_CH0_ID_18FF4321_Sig_ClampOpenSolenoidValve() <= 1500u)
        {
            ClampOpenSolenoidValve = Get_CAN_CH0_ID_18FF4321_Sig_ClampOpenSolenoidValve();
        }
        else
        {
            ClampOpenSolenoidValve = 0xFFFFu;   //错误
        }
    }
    else
    {
        ClampOpenSolenoidValve = 0xFFFFu;      //超时
    }
    return ClampOpenSolenoidValve;
}

uint16_t Clamp_Close_Solenoid_Valve_Menu(void)   //夹钳关电磁阀
{
    uint16_t ClampCloseSolenoidValve = 0u;
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF43_Msg_Count) == CAN_SIG_NORMAL)
    {
        if(Get_CAN_CH0_ID_18FF4321_Sig_ClampCloseSolenoidValve() <= 1500u)
        {
            ClampCloseSolenoidValve = Get_CAN_CH0_ID_18FF4321_Sig_ClampCloseSolenoidValve();
        }
        else
        {
            ClampCloseSolenoidValve = 0xFFFFu;   //错误
        }
    }
    else
    {
        ClampCloseSolenoidValve = 0xFFFFu;      //超时
    }
    return ClampCloseSolenoidValve;
}

uint16_t Movable_Arm_Motion_Status_Indication_Menu(void)   //动臂运动状态指示
{
    uint16_t MovableArmMotionStatusIndication = 0u;
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF43_Msg_Count) == CAN_SIG_NORMAL)
    {
        if(Get_CAN_CH0_ID_18FF4321_Sig_MovableArmMotionStatusIndication() <= 200u)
        {
            MovableArmMotionStatusIndication = Get_CAN_CH0_ID_18FF4321_Sig_MovableArmMotionStatusIndication();
        }
        else
        {
            MovableArmMotionStatusIndication = 0xFFFFu;   //错误
        }
    }
    else
    {
        MovableArmMotionStatusIndication = 0xFFFFu;      //超时
    }
    return MovableArmMotionStatusIndication;
}

uint16_t Bucket_Motion_Status_Indication_Menu(void)   //铲斗运动状态指示
{
    uint16_t BucketMotionStatusIndication = 0u;
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF43_Msg_Count) == CAN_SIG_NORMAL)
    {
        if(Get_CAN_CH0_ID_18FF4321_Sig_BucketMotionStatusIndication() <= 200u)
        {
            BucketMotionStatusIndication = Get_CAN_CH0_ID_18FF4321_Sig_BucketMotionStatusIndication();
        }
        else
        {
            BucketMotionStatusIndication = 0xFFFFu;   //错误
        }
    }
    else
    {
        BucketMotionStatusIndication = 0xFFFFu;      //超时
    }
    return BucketMotionStatusIndication;
}
