#include  "CAN_CH0_CAN_Communication_Matrix.h"
#include "CAN_APP.h"
#include "Common_Interface.h"
#include "Services_Mileage.h"
#include "EOL_Para.h"
#include "Popup_Scheduler.h"
#include "Popup_List.h"
#include "Popups.h"
#include "Sound_Scheduler.h"
#include "Sound_List.h"
#include "Line_In_user.h"
#include "Line_in.h"
#include "TYW_stdint.h"

#pragma ghs section bss = ".myNonInitArea"
uint8_t             PopupIGNONTimer;
uint8_t             PopupIGNOFFTimer;
#pragma ghs section bss = default;
static uint16_t g_notbreakpowerTime      = 0; /* 断开电源计时 */
static uint32_t g_Maintenance_TipsTime = 0;    /* 报警事件-保养提示计时 */
static uint8_t g_Maintenance_Tipsstate = 0;    /* 报警事件-保养提示标志位 */
static uint16_t g_Timer = 0;                     /*持续时间*/
static uint16_t g_Oldstaus = 0;                  /*进行弹出次数*/
uint16_t PrimaryLimitSystemActivationRemainingTime; //初级限制系统激活剩余时间
uint16_t SeverelyLimitSystemActivationRemainingTime;//严重限制系统激活剩余时间
static uint16_t       g_PopupMsg      = 0xFFFFu;
static uint16_t       g_PopupID       = 0xFFFFu;

static void Popups_Polling_IGN_ON(void);
static void Popups_Polling_IGN_OFF(void);
static void Popups_Polling_IGN_ONOFF(void);
static void Popups_Sound_Playing(uint32_t PopupSnd);

void Popups_Management_KL30_Init(void)
{
    g_Maintenance_TipsTime   = 0; /* 报警事件-保养提示计时 */
    g_Oldstaus = 0;                  /*进行弹出次数*/
    g_Timer = 0;                     /*持续时间*/
    g_Maintenance_Tipsstate = 0;    /* 报警事件-保养提示标志位 */
}

void Popups_Management_Wakeup_Init(void)
{
    
}

void Popups_Ig_OFF(void)
{
   Popup_Request(POPUP_ID_Not_Disconnect_The_Power); 
}

void Popups_Management_KL15_Init(void)
{
    g_notbreakpowerTime      = 0; /* 断开电源计时 */
    g_Timer                  = 0;                     /*持续时间*/
}

void Popups_Management_Service(void)
{
    uint32_t PopupSnd = 0xFFFFFFFFUL;

    if ( Common_Get_IG_Sts( ) == COMMON_POWER_ON )
    {
        PopupIGNOFFTimer = 0;

        if ( PopupIGNONTimer < POPUP_DELAY_TIMER )
        {
            PopupIGNONTimer++;
        }

        // Direct_TPMS_Logic( );    //直接式胎压

        if ( /*(Get_HMI_Sys_Type( ) > Disp_SelfCheck) && */(PopupIGNONTimer >= POPUP_DELAY_TIMER) )
        {
            Popups_Polling_IGN_ON( );
            Popups_Polling_IGN_ONOFF( );
            Popup_Scheduling_Service( );
            g_PopupMsg = Popup_Get_Current_Message( );
            g_PopupID  = Popup_Get_Current_PopupID( );
            PopupSnd   = Popup_Get_Current_Sound( );
            if ( PopupSnd < SND_NONE )
            {
                Popups_Sound_Playing(PopupSnd);
            }
        }
        else
        {
            g_PopupMsg = 0xFFFF;
            g_PopupID  = 0xFFFFu;
            PopupSnd   = SND_NONE;
        }
    }
    else
    {
        if ( PopupIGNONTimer != 0 )
        {
            PopupIGNONTimer = 0;
        }
        Popups_Polling_IGN_OFF( );
        Popups_Polling_IGN_ONOFF( );

        if ( PopupIGNOFFTimer < 30 )
        {
            PopupIGNOFFTimer++;
        }

        if ( /*(Get_HMI_Sys_Type( ) == Disp_WelcomeAnimation) || */(PopupIGNOFFTimer < 30) )
        {
            g_PopupMsg = 0xFFFF;
            g_PopupID  = 0xFFFFu;
            PopupSnd   = SND_NONE;
        }
        else
        {
            Popup_Scheduling_Service( );
            g_PopupMsg = Popup_Get_Current_Message( );
            g_PopupID  = Popup_Get_Current_PopupID( );
            PopupSnd   = Popup_Get_Current_Sound( );
            if ( PopupSnd < SND_NONE )
            {
                Popups_Sound_Playing(PopupSnd);
            }
        }
    }

}

uint16_t Popup_Get_Current_Message_Ex(void)
{
    return g_PopupMsg;
}

uint16_t Popup_Get_Current_PopupID_Ex(void)
{
    return g_PopupID;
}

static void Popups_Polling_IGN_ON(void)
{
   Popups_Maintenance_Tips();
   Get_Transmission_Self_Learning_ZF();
   Popups_PrimaryLimitSystemActivationRemainingTime();  //初级限制系统激活剩余时间
   Popups_SeverelyLimitSystemActivationRemainingTime();  //严重限制系统激活剩余时间
   Get_Xugong_gearbox_self_learning();         //徐工自制变速箱弹出事件
}

static void Popups_Polling_IGN_OFF(void)
{
    if (Common_Get_IG_Sts() == COMMON_POWER_OFF)
    {

        if (g_notbreakpowerTime >= 1800)
        {
            Popup_Delete(POPUP_ID_Not_Disconnect_The_Power);
        }
        else
        {
            g_notbreakpowerTime++;
            Popup_Request(POPUP_ID_Not_Disconnect_The_Power);
        }
    }
    else
    {
        g_notbreakpowerTime = 0;
    }
    if (Common_Get_IG_Sts() == COMMON_POWER_OFF)
    {
        if (g_Oldstaus == 0)
        {
            g_Maintenance_TipsTime = 0;
            g_Timer = 0;
        }
        if (g_Oldstaus == 1)
        {
            g_Maintenance_TipsTime = 51;
            g_Timer = 0;
        }
        if (g_Oldstaus == 2)
        {
            g_Maintenance_TipsTime = 72051;
            g_Timer = 0;
        }
    }
}

static void Popups_Polling_IGN_ONOFF(void)
{
}

static void Popups_Sound_Playing(uint32_t PopupSnd)
{
    uint8_t ReqCode;

    ReqCode = Popup_Get_Current_Sound_Req_Code( );
    if ( ReqCode )
    {
        Sound_Request(PopupSnd, ReqCode);
    }
    else
    {
        {
            Sound_Delete(PopupSnd);
        }
    }
}

static void Popups_PrimaryLimitSystemActivationRemainingTime(void)  //初级限制系统激活剩余时间
{
    static uint8_t signal1 = 0u;   //第一次信号进入标志位
    static uint16_t Timer1 = 0u;    //第一次信号进入时间
    static uint16_t Timer2 = 0u;    //每小时显示一次进入时间
    PrimaryLimitSystemActivationRemainingTime = Get_CAN_CH0_ID_18FC2A00_Sig_PriLimitSysActRemainingTime();  //初级限制系统激活剩余时间
    if( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FC2A_Msg_Count) == CAN_SIG_NORMAL )
    {
        if(Get_CAN_CH0_ID_18FC2A00_Sig_PriLimitSysActRemainingTime() <= 0xFAFF)
        {
            if(signal1 == 0)    //第一次信号进入
            {
                signal1 = 1;
            }
            if(signal1 == 1)   //第一次信号进入，弹出5秒
            {
                if(Timer1 <= 50)
                {
                    Popup_Request(POPUP_ID_Primary_limits_the_remaining_time);
                    Timer1++;
                }
                else
                {
                    signal1 = 2;
                    Timer1 = 0;
                    Popup_Delete(POPUP_ID_Primary_limits_the_remaining_time);
                }
            }
            else           //每小时弹出5秒
            {
                Timer2++;
                if((Timer2 > 36000) && (Timer2 <= 36050))
                {
                    Popup_Request(POPUP_ID_Primary_limits_the_remaining_time);
                }
                else
                {
                    Popup_Delete(POPUP_ID_Primary_limits_the_remaining_time);
                }
                if(Timer2 > 36050)
                {
                    Timer2 = 0;
                }
            }
        }
        else
        {
            if(signal1 == 1)   //第一次进入弹出期间信号变为无效状态，继续显示
            {
                if(Timer1 <= 50)
                {
                    Popup_Request(POPUP_ID_Primary_limits_the_remaining_time);
                }
                else
                {
                    Timer1 = 0;
                    signal1 = 0;
                    Popup_Delete(POPUP_ID_Primary_limits_the_remaining_time);
                }
            }
            if((Timer2 > 36000) && (Timer2 <= 36050))   //每小时进入弹出期间信号变为无效状态，继续显示
            {
                signal1 = 0;
                Timer2++;
                Popup_Request(POPUP_ID_Primary_limits_the_remaining_time);
            }
            else
            {
                signal1 = 0;
                Timer2 = 0;
                Popup_Delete(POPUP_ID_Primary_limits_the_remaining_time);
            }
            if(Timer2 > 36050)
            {
                signal1 = 0;
                Timer2 = 0;
            }
        }
    }
    else
    {
        Timer1 = 0;
        signal1 = 0;
        Timer2 = 0;
        Popup_Delete(POPUP_ID_Primary_limits_the_remaining_time);
    }
}

uint16_t Get_Popups_PrimaryLimitSystemActivationRemainingTime(void)  //返回初级限制系统激活剩余的时间
{
    return PrimaryLimitSystemActivationRemainingTime;
}


static void Popups_SeverelyLimitSystemActivationRemainingTime(void)  //严重限制系统激活剩余时间
{
    static uint8_t signal1 = 0u;   //第一次信号进入标志位
    static uint16_t Timer1 = 0u;    //第一次信号进入时间
    static uint16_t Timer2 = 0u;    //每小时显示一次进入时间
    SeverelyLimitSystemActivationRemainingTime = Get_CAN_CH0_ID_18FC2A00_Sig_SeverelyLimitSysActiRemaTime();  //严重限制系统激活剩余时间
    if( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FC2A_Msg_Count) == CAN_SIG_NORMAL )
    {
        if(Get_CAN_CH0_ID_18FC2A00_Sig_SeverelyLimitSysActiRemaTime() <= 0xFAFF)
        {
            if(signal1 == 0)    //第一次信号进入
            {
                signal1 = 1;
            }
            if(signal1 == 1)   //第一次信号进入，弹出5秒
            {
                if(Timer1 <= 50)
                {
                    Popup_Request(POPUP_ID_Severely_limits_the_remaining_time);
                    Timer1++;
                }
                else
                {
                    signal1 = 2;
                    Timer1 = 0;
                    Popup_Delete(POPUP_ID_Severely_limits_the_remaining_time);
                }
            }
            else           //每小时弹出5秒
            {
                Timer2++;
                if((Timer2 > 36000) && (Timer2 <= 36050))
                {
                    Popup_Request(POPUP_ID_Severely_limits_the_remaining_time);
                }
                else
                {
                    Popup_Delete(POPUP_ID_Severely_limits_the_remaining_time);
                }
                if(Timer2 > 36050)
                {
                    Timer2 = 0;
                }
            }
        }
        else
        {
            if(signal1 == 1)   //第一次进入弹出期间信号变为无效状态，继续显示
            {
                if(Timer1 <= 50)
                {
                    Popup_Request(POPUP_ID_Severely_limits_the_remaining_time);
                }
                else
                {
                    Timer1 = 0;
                    signal1 = 0;
                    Popup_Delete(POPUP_ID_Severely_limits_the_remaining_time);
                }
            }
            if((Timer2 > 36000) && (Timer2 <= 36050))   //每小时进入弹出期间信号变为无效状态，继续显示
            {
                signal1 = 0;
                Timer2++;
                Popup_Request(POPUP_ID_Severely_limits_the_remaining_time);
            }
            else
            {
                signal1 = 0;
                Timer2 = 0;
                Popup_Delete(POPUP_ID_Severely_limits_the_remaining_time);
            }
            if(Timer2 > 36050)
            {
                signal1 = 0;
                Timer2 = 0;
            }
        }
    }
    else
    {
        Timer1 = 0;
        signal1 = 0;
        Timer2 = 0;
        Popup_Delete(POPUP_ID_Severely_limits_the_remaining_time);
    }
}

uint16_t Get_Popups_SeverelyLimitSystemActivationRemainingTime(void)  //返回严重限制系统激活剩余的时间
{
    return SeverelyLimitSystemActivationRemainingTime;
}

uint8_t Get_Xugong_gearbox_self_learning(void)  //徐工自制变速箱弹出事件
{
    uint8_t Popup_Event = 0;
    if(Val_EOL_0300_Transmission_Type_Configuration() == 3)
    {
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF31_Msg_Count) == CAN_SIG_NORMAL)
        {
            if(Get_CAN_CH0_ID_18FF3103_Sig_OfflineCalibrationStates() <= 2)
            {
                Popup_Event = Get_CAN_CH0_ID_18FF3103_Sig_OfflineCalibrationStates();
            }
            else if(Get_CAN_CH0_ID_18FF3103_Sig_OfflineCalibrationStates() == 3)
            {
                if((Get_CAN_CH0_ID_18FF3103_Sig_CurrentCalibrationClutch() <= 6) && (Get_CAN_CH0_ID_18FF3103_Sig_CurrentCalibrationClutch() != 0))
                {
                    Popup_Event = (Get_CAN_CH0_ID_18FF3103_Sig_CurrentCalibrationClutch() + 2);
                }
            }
            else if(Get_CAN_CH0_ID_18FF3103_Sig_OfflineCalibrationStates() == 4)
            {
                if((Get_CAN_CH0_ID_18FF3103_Sig_CurrentCalibrationClutch() <= 6) && (Get_CAN_CH0_ID_18FF3103_Sig_CurrentCalibrationClutch() != 0))
                {
                    Popup_Event = (Get_CAN_CH0_ID_18FF3103_Sig_CurrentCalibrationClutch() + 8);
                }
            }
            else
            {
                Popup_Event = 0;
            }
        }
        else
        {
            Popup_Event = 0;
        }
    }
    else
    {
        Popup_Event = 0;
    }
    return Popup_Event;
}

/*弹屏报警事件-保养提示*/
void Popups_Maintenance_Tips(void)
{
    uint32_t Engine_Running_Time = 0; /* 发动机运行时间 */
    uint16_t condition = 0;           /*条件2 */
    Engine_Running_Time = 3000;
    if(Engine_Running_Time > Val_EOL_0300_First_Maintenance_Time_Configuration())
    {
        condition = (Engine_Running_Time - Val_EOL_0300_First_Maintenance_Time_Configuration()) % Val_EOL_0300_Renewal_Maintenance_Interval_Time_Configuration();
    }
    else
    {
        condition = 1;
    }
    
    if (Val_EOL_0300_Maintenance_Service_Enable_Configuration() == 1)
    {

        if ((Engine_Running_Time == Val_EOL_0300_First_Maintenance_Time_Configuration()) || condition == 0)
        {
            g_Maintenance_Tipsstate = 1;
        } 
        if(g_Maintenance_Tipsstate == 1)  
        { 
            g_Maintenance_TipsTime++;
            if ((g_Maintenance_TipsTime >= 1 && g_Maintenance_TipsTime <= 51) ||
                (g_Maintenance_TipsTime >= 72000 && g_Maintenance_TipsTime <= 72051) ||
                (g_Maintenance_TipsTime >= 144000 && g_Maintenance_TipsTime <= 144051))
            {
                if (g_Timer >= 50)
                {
                    g_Oldstaus++;
                    Popup_Delete(POPUP_ID_Maintenance_Tips);
                }
                else
                {
                    g_Timer++;
                    Popup_Request(POPUP_ID_Maintenance_Tips);
                }
            }
            else
            {
                g_Timer = 0;
            }
            if (g_Oldstaus >= 3)
            {
                g_Oldstaus = 0;
                g_Maintenance_TipsTime = 0;
                g_Maintenance_Tipsstate = 0;
            }
        }
    }
    else
    {
        g_Maintenance_TipsTime = 0;
    }
}

uint8_t Get_Transmission_Self_Learning_ZF(void)
{
    uint8_t Learning_State = 0;
    uint8_t ZFCC_Msg_Count = 0;
    uint8_t TOT_Msg_Count = 0;
    uint8_t AEBMainCodeState = 0;
    uint8_t AEBSubCode = 0;
    uint8_t ClutchStatusCA = 0;
    uint8_t ClutchStatusCB = 0;
    uint8_t ClutchStatusCC = 0;
    uint8_t ClutchStatusCF = 0;
    uint8_t ClutchStatusCG = 0;
    uint8_t ClutchStatusCR = 0;
    uint8_t CalibrationFinished = 0;
    uint8_t CalibrationBrakeConditions = 0;
    uint8_t CalibrationStartConditions = 0;
    ZFCC_Msg_Count = (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_ZFCC_Msg_Count) == CAN_SIG_NORMAL) ;
    TOT_Msg_Count = (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_TOT_Msg_Count) == CAN_SIG_NORMAL);
    CalibrationStartConditions = Get_CAN_CH0_ID_18FF0103_Sig_CalibrationStartConditions();
    CalibrationBrakeConditions = Get_CAN_CH0_ID_18FF0103_Sig_CalibrationBrakeConditions();
    CalibrationFinished = Get_CAN_CH0_ID_18FF0103_Sig_CalibrationFinished();
    ClutchStatusCF = Get_CAN_CH0_ID_18FF0103_Sig_ClutchStatusCR();
    ClutchStatusCG = Get_CAN_CH0_ID_18FF0103_Sig_ClutchStatusCG();
    ClutchStatusCR = Get_CAN_CH0_ID_18FF0103_Sig_ClutchStatusCF();
    ClutchStatusCC = Get_CAN_CH0_ID_18FF0103_Sig_ClutchStatusCC();
    ClutchStatusCB = Get_CAN_CH0_ID_18FF0103_Sig_ClutchStatusCB();
    ClutchStatusCA = Get_CAN_CH0_ID_18FF0103_Sig_ClutchStatusCA();
    AEBSubCode = Get_CAN_CH0_ID_18FF1F03_Sig_AEBSubCode();
    AEBMainCodeState = Get_CAN_CH0_ID_18FF1F03_Sig_AEBMainCode();
    if (Val_EOL_0300_Transmission_Type_Configuration() == 1)
    {
        if ((ClutchStatusCA == 0 && ZFCC_Msg_Count) || (AEBMainCodeState == 1 && TOT_Msg_Count))
        {
            Learning_State = 1;
        }
        if ((ClutchStatusCB == 0 && ZFCC_Msg_Count) || (AEBMainCodeState == 2 && TOT_Msg_Count))
        {
            Learning_State = 2;
        }
        if ((ClutchStatusCC == 0 && ZFCC_Msg_Count) || (AEBMainCodeState == 3 && TOT_Msg_Count))
        {
            Learning_State = 3;
        }
        if ((ClutchStatusCR == 0 && ZFCC_Msg_Count) || (AEBMainCodeState == 4 && TOT_Msg_Count))
        {
            Learning_State = 4;
        }
        if ((ClutchStatusCG == 0 && ZFCC_Msg_Count) || (AEBMainCodeState == 5 && TOT_Msg_Count))
        {
            Learning_State = 5;
        }
        if ((ClutchStatusCF == 0 && ZFCC_Msg_Count) || (AEBMainCodeState == 6 && TOT_Msg_Count))
        {
            Learning_State = 6;
        }
        if ((ClutchStatusCA == 2 && ZFCC_Msg_Count) || (AEBMainCodeState == 9 && TOT_Msg_Count))
        {
            Learning_State = 7;
        }
        if ((ClutchStatusCB == 2 && ZFCC_Msg_Count) || (AEBMainCodeState == 10 && TOT_Msg_Count))
        {
            Learning_State = 8;
        }
        if ((ClutchStatusCC == 2 && ZFCC_Msg_Count) || (AEBMainCodeState == 11 && TOT_Msg_Count))
        {
            Learning_State = 9;
        }
        if ((ClutchStatusCR == 2 && ZFCC_Msg_Count) || (AEBMainCodeState == 12 && TOT_Msg_Count))
        {
            Learning_State = 10;
        }
        if ((ClutchStatusCG == 2 && ZFCC_Msg_Count) || (AEBMainCodeState == 13 && TOT_Msg_Count))
        {
            Learning_State = 11;
        }
        if ((ClutchStatusCF == 2 && ZFCC_Msg_Count) || (AEBMainCodeState == 14 && TOT_Msg_Count))
        {
            Learning_State = 12;
        }
        if ((CalibrationBrakeConditions == 1 && ZFCC_Msg_Count) || (AEBMainCodeState == 8 && TOT_Msg_Count))
        {
            Learning_State = 13;
        }
        if ((CalibrationBrakeConditions == 2 && ZFCC_Msg_Count) || (AEBSubCode == 8 && TOT_Msg_Count) || (CalibrationStartConditions == 2 && ZFCC_Msg_Count))
        {
            Learning_State = 14;
        }
        if ((CalibrationBrakeConditions == 3 && ZFCC_Msg_Count) || (AEBSubCode == 7 && TOT_Msg_Count) || (CalibrationStartConditions == 3 && ZFCC_Msg_Count))
        {
            Learning_State = 15;
        }
        if ((CalibrationBrakeConditions == 4 && ZFCC_Msg_Count) || (AEBSubCode == 6 && TOT_Msg_Count) || (CalibrationStartConditions == 4 && ZFCC_Msg_Count))
        {
            Learning_State = 16;
        }
        if ((CalibrationBrakeConditions == 5 && ZFCC_Msg_Count) || (AEBSubCode == 5 && TOT_Msg_Count) || (CalibrationStartConditions == 5 && ZFCC_Msg_Count))
        {
            Learning_State = 17;
        }
        if ((CalibrationBrakeConditions == 6 && ZFCC_Msg_Count) || (AEBSubCode == 2 && TOT_Msg_Count))
        {
            Learning_State = 18;
        }
        if ((CalibrationBrakeConditions == 7 && ZFCC_Msg_Count) || (AEBSubCode == 4 && TOT_Msg_Count))
        {
            Learning_State = 19;
        }
        if ((CalibrationBrakeConditions == 8 && ZFCC_Msg_Count) || (AEBSubCode == 1 && TOT_Msg_Count))
        {
            Learning_State = 20;
        }
        if ((CalibrationBrakeConditions == 9 && ZFCC_Msg_Count) || (AEBSubCode == 3 && TOT_Msg_Count))
        {
            Learning_State = 21;
        }
        if ((CalibrationFinished == 1 && ZFCC_Msg_Count) || (AEBMainCodeState == 7 && TOT_Msg_Count))
        {
            Learning_State = 22;
        }
    }
    else
    {
        Learning_State = 0;
    }
    return Learning_State;
}

