#include "RTE_CAN.h"
#include "RTE_GPIO.h"
#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "Diag_ID_Def.h"
#include "DoCAN_ISO15765.h"
#include "UDS_Common.h"
#include "RSCAN.h"
// #include "NM_Config.h"
#include "RSCAN_Table.h"
#include "RSCAN.h"
#include "PowerManag_user.h"
#include "CAN_CFG.h"
BusOffMonitorStruct BusOffMonitor;              // BusOff监控结构体
static uint8_t      BusOffCnt = 0u;
uint8_t APP_CanBusStatus = 0;
uint16_t APP_CanBus5S;
uint8_t BUS_OFF_FLAG;

//初始化Bus Off监控结构体
void BusOff_Init(void)
{
    //重置相关信息
    BusOffMonitor.Status = BUS_OFF_STATUS_STABLE;
    BusOffMonitor.Timer  = 0;
    BusOffMonitor.Cnt    = 0;
    BusOffCnt            = 0;
    // end
}

// OSEK BusOff的判断，只需判断无需进行恢复操作
void BusOff_Service(void)
{
    if ( GetBusOffState( ) != 0u )
    {
        if ( BusOffMonitor.Status == BUS_OFF_STATUS_STABLE )
        {
            BusOffMonitor.Status = BUS_OFF_STATUS_LV1;
        }

        if ( BusOffMonitor.Status == BUS_OFF_STATUS_LV1 )
        {
            BusOffMonitor.Timer++;
            if ( BusOffMonitor.Timer >= RSCAN0_BUS_OFF_LV1_RECOVERY_TIME / 10U )
            {
                BusOffMonitor.Timer = 0U;

                BusOffMonitor.Cnt++;
                if ( BusOffMonitor.Cnt >= 10U )
                {

                    BusOffMonitor.Cnt = 0U;

                    BusOffMonitor.Status = BUS_OFF_STATUS_LV2;
                }
                CanBusoffRecover( );
            }
        }
        else if ( BusOffMonitor.Status == BUS_OFF_STATUS_LV2 )
        {
            BUS_OFF_FLAG = 1U;
            BusOffMonitor.Timer++;

            if ( BusOffMonitor.Timer >= RSCAN0_BUS_OFF_LV2_RECOVERY_TIME / 10U )
            {
                BusOffMonitor.Timer = 0U;
                CanBusoffRecover( );
            }
        }
    }
    // end
}

void Can_BusOffRecover(void)
{
    // BusOffEvent = 0u;
    BusOffMonitor.Cnt = 0u;
    // BusOffMonitor.ReportDTCCnt = 0u;
    BusOffMonitor.Status = 0u;
    BusOffMonitor.Timer  = 0u;
}
/***Middle***/
void Can_Init(void)
{
    RSCAN0_Config_st_t loc_can = {0};

    loc_can.stRSCANCh4.u32RSCANChEn            = 1U;
    loc_can.stRSCANCh4.enRSCANChBps            = RSCAN_Baud_Rate_250K;
    loc_can.stRSCANCh4.u32RSCANChRuleSize      = CANFD0_CH4_RX_RULE_SIZE;
    loc_can.stRSCANCh4.pfnRSCANConfirmCallBack = Can_Confirm;
    loc_can.stRSCANCh4.pfnRSCANReadMsgCallBack = Can_Read_Msg;
    B_CAN_STB                                   = 0;
    RSCAN0_CH_Init(CANFD_RX_RULE_TABLE_LIST, &loc_can);
}

void Can_DeInit(void)
{
}

void Can_Write(_CAN_Msg *Msg)
{
    CAN_Frame_st_t m_msg;
    uint32_t       i;
    m_msg.u32CANID      = Msg->MsgID;
    m_msg.u8CANLEN      = Msg->MsgDLC;
    m_msg.u8CANFrameIDE = 1;
    for ( i = 0; i < m_msg.u8CANLEN; i++ )
    {
        m_msg.unCANData.u8CANData [ i ] = Msg->Msg [ i ];
    }
    RSCAN0_CH4_Set_TXBUF_Data((RSCAN_Channel_Buf_en_t)(Msg->MsgPro), &m_msg);
    if ( (m_msg.u32CANID == 0x709) && (Msg->MsgPro == 1u) )
    {
        // DoCAN_L_Data_Confirm(0x709, 1);
    }
}

void Can_Sleep_Fun(void)
{
}

void Can_SleepController_Fun(void)
{
}

void Can_Wakeup_Fun(void)
{
}

void Can_Uds_Abort(void)
{
}

void Can_Abort_All(void)
{
}

/*****Lower*******/
// extern uint8_t CanReceiveFlag;
// void Can_Read_Msg(uint32_t m_id, uint8_t m_dlc, uint8_t m_Msg [])
// {
//     if(CanReceiveFlag == 2)
//     {
//         Co_Can_Buff_Set(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(m_id), m_dlc, m_Msg);
//         ReceivedMsg(m_id, m_dlc);
//         if ( (m_id >= 0x400) && (m_id <= 0x4ff) )
//         {
//             APP_CanBusStatus = 1;
//             APP_CanBus5S = 0;
//             if ( CAN_GET_NM_REC( ) == 0u )
//             {
//                 NM_Receive_isr_Fun(m_id, m_Msg);
//             }
//         }
//         if ( (m_id == DIAG_ID_Rx_FUN) || (m_id == DIAG_ID_Rx_PHY) )
//         {
//             DoCAN_L_Data_Indication(m_id, m_dlc, m_Msg);
//         }
//     }
//     else 
//     {
//         CanReceiveFlag = 1u;
//     }
// }
// extern uint8_t NMWakeupFalg;
void Can_Read_Msg(uint32_t m_id, uint8_t m_dlc, uint8_t m_Msg [])
{
    //  if(NMWakeupFalg == 1u)
    // {
    //     NM_RemoteWakeup_Fun();
    //     NMWakeupFalg = 0u;
    // }
    // else
    // {
    //   ;
    // }
    Co_Can_Buff_Set(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(m_id), m_dlc, m_Msg);
    Sleep_Count_Clr( );
    ReceivedMsg(m_id, m_dlc);
    if ( (m_id >= 0x400) && (m_id <= 0x4ff) )
    {
        APP_CanBusStatus = 1;
        APP_CanBus5S = 0;
        // if ( CAN_GET_NM_REC( ) == 0u )
        // {
        //     NM_Receive_isr_Fun(m_id, m_Msg);
        // }
    }
    if ( (m_id == DIAG_ID_Rx_FUN) || (m_id == DIAG_ID_Rx_PHY) )
    {
        DoCAN_L_Data_Indication(m_id, m_dlc, m_Msg);
    }
}
void Set_APP_CanBus5S(void)
{
    if(APP_CanBusStatus == 1)
    {
        if(APP_CanBus5S < 50)
        {
            APP_CanBus5S ++;
        }
        else 
        {
            APP_CanBusStatus = 0;
        }
    }
}

uint8_t Get_APP_CanBusStatus(void)
{
    uint8_t m_APP_401;
    m_APP_401 = APP_CanBusStatus;
    return m_APP_401;
}

void Can_Confirm(uint32_t Identifier, uint8_t TransferStatus)
{
    uint32_t MSG_ID;
    MSG_ID = 0ul;
    switch ( Identifier )
    {
        case RSCAN_CHANNEL_BUF_2:
            break;
        case RSCAN_CHANNEL_BUF_3:
            break;
        case RSCAN_CHANNEL_BUF_4:
            break;
        case RSCAN_CHANNEL_BUF_5:
            break;
        case RSCAN_CHANNEL_BUF_6:
            break;
        case RSCAN_CHANNEL_BUF_7:
            break;
        case RSCAN_CHANNEL_BUF_8:
            break;
        case RSCAN_CHANNEL_BUF_9:
            break;
        case RSCAN_CHANNEL_BUF_10:
            break;
        case RSCAN_CHANNEL_BUF_11:
            break;
        case RSCAN_CHANNEL_BUF_12:
            break;
        case RSCAN_CHANNEL_BUF_13:
            break;
        case RSCAN_CHANNEL_BUF_14:
            break;
        case RSCAN_CHANNEL_BUF_15:
            break;
        case RSCAN_CHANNEL_BUF_16:
            break;
        case RSCAN_CHANNEL_BUF_17:
            break;
        case RSCAN_CHANNEL_BUF_18:
            break;
        case RSCAN_CHANNEL_BUF_19:
            break;

        case RSCAN_CHANNEL_BUF_1:
            MSG_ID = DIAG_ID_Tx;
            DoCAN_L_Data_Confirm(MSG_ID, DIAG_COMPLETE);

            break;
        // case RSCAN_CHANNEL_BUF_0:
        // MSG_ID = 0x709ul;
        // DoCAN_L_Data_Confirm(MSG_ID, TransferStatus);
        // break;
        default:
            break;
    }

    if ( TransferStatus == 0x00 )
    {
        // NmSetLastId(MSG_ID);
        // ( void )NM_TranMsgSuccessDetect( );
        // // DoCAN_L_Data_Confirm(Identifier, 1);
    }
    else
    {
    }
}
