
#ifndef RTE_MEMORY_H
#define RTE_MEMORY_H

#include "TYW_stdint.h"

#define D_Flash_Block_1 0x100000
#define D_Flash_Block_2 0x100000 + 256
#define D_Flash_Block_3 0x100000 + 512
#define D_Flash_Block_4 0x100000 + 768
#define D_Flash_Block_5 0x100000 + 1024
#define D_Flash_Block_6 0x100000 + 1280
#define D_Flash_Block_7 0x100000 + 1536
#define D_Flash_Block_8 0x100000 + 1792

#define OK                  0x00u
#define ERR                 0x01u
#define MISALIGNED_ADDRESS  0x03u
#define ACCESS_ERROR        0x04u
#define VERIFICATION_FAILED 0x05u
#define LENGTH_OUT_OF_RANGE 0x06u
uint8_t DFlash_ReadData(uint32_t Adrr, uint32_t *Data, uint16_t len, uint8_t ReadType);
uint8_t DFlash_WriteData(uint32_t Adrr, uint32_t *Data, uint16_t len, uint8_t WriteType);

#endif
