/**
 * @file        Services_Mileage.c
 * @brief       ��̷�����
 * @details     ��̷�������������ơ�С��
 * @author      myliu
 * @date        2022.05.10
 * @version     V1.0
 * @copyright   myiu
 */
#ifndef SERVICE_MILEAGE_H
#define SERVICE_MILEAGE_H

/*
Platform_32Bit
Platform_16Bit
*/

#ifdef Platform_16Bit
    #define Millib_uint8_t  unsigned char
    #define Millib_uint16_t unsigned int
    #define Millib_uint32_t unsigned long

#else
    #define Millib_uint8_t  unsigned char
    #define Millib_uint16_t unsigned short
    #define Millib_uint32_t unsigned int
    #define Millib_uint64_t unsigned long long
#endif

#ifndef Millib_NULL
    #define Millib_NULL ( void * )0u
#endif /* NULL */

/**@enum     С�����ö��
 * @brief    ��������ÿ��С�������
 */
typedef enum
{
    EM_TRIP_A,
    EM_TRIP_B,
    EM_TRIP_C,
    EM_TRIP_D,
    EM_TRIP_MAX,
} DataTripEnum_t;

/**@enum     EEPROM�洢��ö������
 * @brief    ��������EEPORM�洢����
 */
typedef enum
{
    EM_MILEAGE_BLOCK = 0u,
    EM_ODO_BLOCK,
    EM_TRIP_BLOCK,
    EM_Eng_Time_BLOCK,
    EM_Maintenance_BLOCK,
} Data_EEPROM_Enum_t;

typedef void (*EEPromWrite)(Data_EEPROM_Enum_t BlockID, Millib_uint32_t u32Data [], Millib_uint16_t u16Len);

typedef struct
{
    Millib_uint8_t (*Get_Sys_IG_Sts)(void);        /**< ��ȡϵͳ��Դ״̬���������д��������NULL */
    Millib_uint8_t (*Get_Act_V_Speed_Valid)(void); /**< ʵ�ʳ�����Чλ���������д��������NULL */
    Millib_uint16_t (*Get_Act_V_Speed)(void);      /**< ʵ�ʳ��٣��������д��������NULL */
    Millib_uint16_t (*Get_TireSize)(void);         /**< ��̥ϵ�����������д��������NULL */
    EEPromWrite EEPromWrite_Cbk;                   /**< дEEPROM�ص��������������д��������NULL */
} Mileage_Func_t;

typedef struct
{
    Millib_uint32_t Mileage; /**< KL30��ʼ��ʱ����EEPROM��ȡ������ */
} Mileage_Init_t;

typedef struct
{
    Millib_uint32_t Stamp;    /**< ��Mileage�ϼ�¼����̴� */
    Millib_uint32_t Offset;   /**< ���ƫ�������ݲ�ʹ�ã�Ԥ�� */
    Millib_uint32_t MaxValue; /**< �����ܼ���̣���λ100m */
} ODO_Init_t;

typedef struct
{
    Millib_uint32_t Stamp;    /**< ��Mileage�ϼ�¼����̴� */
    Millib_uint32_t MaxValue; /**< ����С����̣���λ100m */
    Millib_uint8_t IsRestart; /**< С����̴ﵽ���ֵ���Ƿ��Զ���0��ʼ�������ۼ�С����� */
} Trip_Init_t;

#define Data_MEM_Block_Mileage ((Millib_uint8_t)12u)
#define Data_MEM_Block_ODO ((Millib_uint8_t)16u)
#define Data_MEM_Block_Trip ((Millib_uint8_t)16u)
/*
total size =Data_MEM_Block_Trip*EM_TRIP_MAX
*/

/**
 * @brief ��̷����ʼ����KL30���ã�������ã�������ɿ�ָ��
 * @param[in] pMemSpace �ڴ�ռ䣬��Ҫ�Ŀռ��С���ٴ���Data_MEM_Block_Mileage�����ڴ��������߻��Ѻ󲻶�ʧ
 * @param[in] pInitData ��EEPROM��ȡ�ϴ��µ�ǰ�ۼƵ����
 * @param[in] pFunc �ײ㷢�ͻص�����, ���Mileage_Func_t
 *
 * @warning �˺����������EEPROM��ʼ������ΪҪ��ȡEEPROM���ݣ�����ÿ�ζ��Ǵ�0��ʼ
 *
 * @since 1.0.0
 */
void Data_Mileage_KL30_Init(Millib_uint8_t *pMemSpace,
                            Mileage_Init_t *pInitData, Mileage_Func_t *pFunc);
/**
 * @brief ��̷����ʼ��������ʱ���ã�������ã�������ɿ�ָ��
 * @param[in] pMemSpace �ڴ�ռ䣬��Ҫ�Ŀռ��С���ٴ���Data_MEM_Block_Mileage�����ڴ��������߻��Ѻ󲻶�ʧ
 * @param[in] pFunc �ײ㷢�ͻص�����, ���Mileage_Func_t
 *
 * @since 1.0.0
 */
void Data_Mileage_Wakeup_Init(Millib_uint8_t *pMemSpace, Mileage_Func_t *pFunc);
/**
 * @brief ����ۼƷ�����100ms�жϵ���
 *
 * @since 1.0.0
 */
void Data_Mileage_ISR(void);
/**
 * @brief   ��̶�ȡ
 * @return  ��ǰ�ۼ����������λ100m
 * @warning �����ݷ��ܼ���̣��ܼ�������ڴ��������һ����
 *
 * @since 1.0.0
 */
Millib_uint32_t Data_Mileage_Read(void);
/**
 * @brief   д���
 * @param[in] NewMileage �����������λ100m
 * @return  �ɹ� - 1 ʧ�� - 0
 * @warning ���ô˺���ǰ����Ҫ����Data_Mileage_Clear����
 *
 * @since 1.0.0
 */
Millib_uint8_t Data_Mileage_Write(Millib_uint32_t NewMileage);
/**
 * @brief   ����̣�����ʱʹ��
 * @warning �˺����������ܣ���Mileage����ODO�Լ���trip�����ô˺�������Ҫ��λ����̲Ż�����߶�
 *
 * @since 1.0.0
 */
void Data_Mileage_Clear(void);
/**
 * @brief   ����̣�����ʱʹ��
 * @warning �˺����������ܣ���Mileage����ODO�Լ���Trip�����ô˺�������Ӱ����̵��߶�
 *
 * @since 1.0.0
 */
void Data_Mileage_Clear_GoOn(void);
/**
 * @brief   ���ۼƵ���̴���EEPROM, 10ms�����е���
 *
 * @since 1.0.0
 */
void Data_Mileage_Write_EEPROM(void);
/**
 * @brief   ��ȡ��̿������汾��
 * @return  �汾�� 1.01
 * @since 1.0.0
 */
Millib_uint8_t *Get_Data_Mileage_Version(void);

/**
 * @brief �ܼ���̳�ʼ����KL30���ã�������ã�������ɿ�ָ��
 * @param[in] pMemSpace �ڴ�ռ䣬��Ҫ�Ŀռ��С���ٴ���Data_MEM_Block_ODO�����ڴ��������߻��Ѻ󲻶�ʧ
 * @param[in] pInitData ���ODO_Init_t
 * @param[in] Func дEEPROM�ص�����
 *
 * @warning ��Data_Mileage_KL30_Init֮�����
 *
 * @since 1.0.0
 */
void Data_ODO_KL30_Init(Millib_uint8_t *pMemSpace, ODO_Init_t *pInitData, EEPromWrite Func);
/**
 * @brief �ܼ���̳�ʼ�������ѵ��ã�������ã�������ɿ�ָ��
 * @param[in] pMemSpace �ڴ�ռ䣬��Ҫ�Ŀռ��С���ٴ���Data_MEM_Block_ODO�����ڴ��������߻��Ѻ󲻶�ʧ
 * @param[in] Func дEEPROM�ص�����
 *
 * @warning ��Data_Mileage_Wakeup_Init֮�����
 *
 * @since 1.0.0
 */
void Data_ODO_Wakeup_Init(Millib_uint8_t *pMemSpace, EEPromWrite Func);
/**
 * @brief �ܼ���̼������Ϊ�����������ȡ�ܼ������0.1m��ƫ���Ҫ�˷�����
 *
 * @warning ��100ms�����ص���
 *
 * @since 1.0.0
 */
void Data_ODO_Processing(void);
/**
 * @brief   �ܼ���̶�ȡ
 * @return  ��ǰ�ܼ����������λ100m
 * @warning ������Ϊ�ϴ�Data_ODO_Clear�󣬵����ô˺���Ϊֹ���ۼƵ�Mileage������Mileage��һ����
 *
 * @since 1.0.0
 */
Millib_uint32_t Data_ODO_Read(void);

/**
 * @brief   ���ܼ���̣�����ʹ��
 * @warning �˺���ֻ�ǽ��ܼ���̵���̴����Ϊ��ǰ��Mileage����������ȫ���������������Data_Mileage_Clear
 *
 * @since 1.0.0
 */
void Data_ODO_Clear(void);

/**
 * @brief   �ܼ����ƫ������ȡ
 * @return  ��ǰƫ��������λ100m
 * @warning ��̱���ʱʹ��
 *
 * @since 1.0.0
 */
Millib_uint32_t Data_Offset_Read(void);

/**
 * @brief   �ܼ����ƫ�����޸�
 * @return  ��ǰƫ��������λ100m
 * @warning ��̱���ʱʹ��
 *
 * @since 1.0.0
 */
void Data_ODO_Modify(Millib_uint32_t Offset);

/**
 * @brief С����̳�ʼ����KL30���ã�������ã�������ɿ�ָ��
 * @param[in] pMemSpace �ڴ�ռ䣬��Ҫ�Ŀռ��С���ٴ���Data_MEM_Block_Trip*EM_TRIP_MAX�����ڴ��������߻��Ѻ󲻶�ʧ
 * @param[in] pInitData Trip_Init_t
 * @param[in] TotalTrip С�������������磺1��С�ƣ� 2��С�ƣ�3��С�ƣ�
 * @param[in] Func дEEPROM�ص�����
 *
 * @warning ��Data_Mileage_KL30_Init֮�����
 *
 * @since 1.0.0
 */
void Data_Trip_KL30_Init(Millib_uint8_t *pMemSpace, Trip_Init_t *pInitData, Millib_uint8_t TotalTrip, EEPromWrite pFunc);
/**
 * @brief С����̳�ʼ�������ѵ��ã�������ã�������ɿ�ָ��
 * @param[in] pMemSpace �ڴ�ռ䣬��Ҫ�Ŀռ��С���ٴ���Data_MEM_Block_Trip*EM_TRIP_MAX�����ڴ��������߻��Ѻ󲻶�ʧ
 * @param[in] TotalTrip С�������������磺1��С�ƣ� 2��С�ƣ�3��С�ƣ�
 * @param[in] Func дEEPROM�ص�����
 *
 * @warning ��Data_Mileage_Wakeup_Init֮�����
 *
 * @since 1.0.0
 */
void Data_Trip_Wakeup_Init(Millib_uint8_t *pMemSpace, Millib_uint8_t TotalTrip, EEPromWrite pFunc);
/**
 * @brief С����̼������Ϊ�����������ȡС�������0.1m��ƫ���Ҫ�˷�����
 *
 * @warning ��100ms�����ص���
 *
 * @since 1.0.0
 */
void Data_Trip_Processing(void);
/**
 * @brief   ��С�����
 * @param[in] TripN DataTripEnum_t
 * @warning �˺���ֻ�ǽ�С����̵���̴����Ϊ��ǰ��Mileage����������ȫ���������������Data_Mileage_Clear
 *
 * @since 1.0.0
 */
void Data_Clear_Trip(DataTripEnum_t TripN);
/**
 * @brief   ��С�����
 * @warning �˺���ֻ�ǽ�С����̵���̴����Ϊ��ǰ��Mileage����������ȫ���������������Data_Mileage_Clear
 *
 * @since 1.0.0
 */
void Data_Clear_Trip_All(void);
/**
 * @brief   С����̶�ȡ
 * @param[in] TripN DataTripEnum_t
 * @return  ��ǰС�����������λ100m
 * @warning ������Ϊ�ϴ�Data_ODO_Clear�󣬵����ô˺���Ϊֹ���ۼƵ�Mileage������Mileage��һ����
 *
 * @since 1.0.0
 */
Millib_uint32_t Data_Read_Trip(DataTripEnum_t TripN);

#endif
