

#include "Simulated_SPI_Master.h"

SimSPIConfigStruct SimSPIConfig;
uint8_t            SPI_MOSI;
uint8_t            SPI_SCLK;
uint8_t            SPI_MISO;
/******************************************************************************
SPI_Master_Start
  ܣʼSPIģʽ
  ModeSPIģʽ         SIM_SPI_MODE_0
                                    SIM_SPI_MODE_1
                                    SIM_SPI_MODE_2
                                    SIM_SPI_MODE_3

        FirstBitȷ͵λSIM_SPI_MSB_FIRST
                                    SIM_SPI_LSB_FIRST
ֵ
******************************************************************************/
void Sim_SPI_Master_Start(uint8_t Mode, uint8_t FirstBit)
{
    switch ( Mode )
    {
        case SIM_SPI_MODE_0:
            SimSPIConfig.CPOL = 0;
            SimSPIConfig.CPHA = 0;
            break;

        case SIM_SPI_MODE_1:
            SimSPIConfig.CPOL = 0;
            SimSPIConfig.CPHA = 1;
            break;

        case SIM_SPI_MODE_2:
            SimSPIConfig.CPOL = 1;
            SimSPIConfig.CPHA = 0;
            break;

        case SIM_SPI_MODE_3:
            SimSPIConfig.CPOL = 1;
            SimSPIConfig.CPHA = 1;
            break;

        default:
            SimSPIConfig.CPOL = 0;
            SimSPIConfig.CPHA = 0;
            break;
    }
    SimSPIConfig.FirstBit = FirstBit;

    SPI_SCLK = SimSPIConfig.CPOL;
    SPI_MOSI = 0;
}

/******************************************************************************
Sim_SPI_Master_Byte_Write
  ܣSPIдһֽ
  Data:Ҫд
ֵ
******************************************************************************/
void Sim_SPI_Master_Byte_Write(uint8_t Data)
{
    uint8_t BitPos;

    if ( SimSPIConfig.FirstBit == SIM_SPI_MSB_FIRST )
    {
        for ( BitPos = 0x80; BitPos >= 0x01; BitPos >>= 1 )
        {
            if ( SimSPIConfig.CPHA == 0 )
            {
                if ( Data & BitPos )
                    SPI_MOSI = 1;
                else
                    SPI_MOSI = 0;
            }

            SPI_SCLK ^= 0x01;

            if ( SimSPIConfig.CPHA )
            {
                if ( Data & BitPos )
                    SPI_MOSI = 1;
                else
                    SPI_MOSI = 0;
            }

            SPI_SCLK ^= 0x01;
        }
    }
    else
    {
        for ( BitPos = 0x01; BitPos <= 0x80; BitPos <<= 1 )
        {
            if ( SimSPIConfig.CPHA == 0 )
            {
                if ( Data & BitPos )
                    SPI_MOSI = 1;
                else
                    SPI_MOSI = 0;
            }

            SPI_SCLK ^= 0x01;

            if ( SimSPIConfig.CPHA )
            {
                if ( Data & BitPos )
                    SPI_MOSI = 1;
                else
                    SPI_MOSI = 0;
            }

            SPI_SCLK ^= 0x01;
        }
    }
}

/******************************************************************************
Sim_SPI_Master_Byte_Read
  ܣSPI϶ȡһֽ
  TxDataڶȡͬʱд
ֵ
******************************************************************************/
uint8_t Sim_SPI_Master_Byte_Read(uint8_t TxData)
{
    uint8_t RxData;
    uint8_t BitPos;

    RxData = 0x00;

    if ( SimSPIConfig.FirstBit == SIM_SPI_MSB_FIRST )
    {
        for ( BitPos = 0x80; BitPos >= 0x01; BitPos >>= 1 )
        {
            if ( SimSPIConfig.CPHA == 0 )
            {
                if ( TxData & BitPos )
                    SPI_MOSI = 1;
                else
                    SPI_MOSI = 0;
            }

            SPI_SCLK ^= 0x01;

            if ( SimSPIConfig.CPHA )
            {
                if ( TxData & BitPos )
                    SPI_MOSI = 1;
                else
                    SPI_MOSI = 0;
            }
            else
            {
                if ( SPI_MISO )
                    RxData |= BitPos;
            }

            SPI_SCLK ^= 0x01;

            if ( SimSPIConfig.CPHA )
            {
                if ( SPI_MISO )
                    RxData |= BitPos;
            }
        }
    }
    else
    {
        for ( BitPos = 0x01; BitPos <= 0x80; BitPos <<= 1 )
        {
            if ( SimSPIConfig.CPHA == 0 )
            {
                if ( TxData & BitPos )
                    SPI_MOSI = 1;
                else
                    SPI_MOSI = 0;
            }

            SPI_SCLK ^= 0x01;

            if ( SimSPIConfig.CPHA )
            {
                if ( TxData & BitPos )
                    SPI_MOSI = 1;
                else
                    SPI_MOSI = 0;
            }
            else
            {
                if ( SPI_MISO )
                    RxData |= BitPos;
            }

            SPI_SCLK ^= 0x01;

            if ( SimSPIConfig.CPHA )
            {
                if ( SPI_MISO )
                    RxData |= BitPos;
            }
        }
    }

    return RxData;
}

/******************************************************************************
Sim_SPI_Master_Word_Write
  ܣSPIдһ(16bit)
  Data:Ҫд
ֵ
******************************************************************************/
void Sim_SPI_Master_Word_Write(uint16_t Data)
{
    uint16_t BitPos;

    if ( SimSPIConfig.FirstBit == SIM_SPI_MSB_FIRST )
    {
        for ( BitPos = 0x8000; BitPos >= 0x0001; BitPos >>= 1 )
        {
            if ( SimSPIConfig.CPHA == 0 )
            {
                if ( Data & BitPos )
                    SPI_MOSI = 1;
                else
                    SPI_MOSI = 0;
            }

            SPI_SCLK ^= 0x01;

            if ( SimSPIConfig.CPHA )
            {
                if ( Data & BitPos )
                    SPI_MOSI = 1;
                else
                    SPI_MOSI = 0;
            }

            SPI_SCLK ^= 0x01;
        }
    }
    else
    {
        for ( BitPos = 0x0001; BitPos <= 0x8000; BitPos <<= 1 )
        {
            if ( SimSPIConfig.CPHA == 0 )
            {
                if ( Data & BitPos )
                    SPI_MOSI = 1;
                else
                    SPI_MOSI = 0;
            }

            SPI_SCLK ^= 0x01;

            if ( SimSPIConfig.CPHA )
            {
                if ( Data & BitPos )
                    SPI_MOSI = 1;
                else
                    SPI_MOSI = 0;
            }

            SPI_SCLK ^= 0x01;
        }
    }
}

/******************************************************************************
Sim_SPI_Master_Word_Read
  ܣSPI϶ȡһ(16bit)
  TxDataڶȡͬʱд
ֵ
******************************************************************************/
uint16_t Sim_SPI_Master_Word_Read(uint16_t TxData)
{
    uint16_t RxData;
    uint16_t BitPos;

    RxData = 0x00;

    if ( SimSPIConfig.FirstBit == SIM_SPI_MSB_FIRST )
    {
        for ( BitPos = 0x8000; BitPos >= 0x0001; BitPos >>= 1 )
        {
            if ( SimSPIConfig.CPHA == 0 )
            {
                if ( TxData & BitPos )
                    SPI_MOSI = 1;
                else
                    SPI_MOSI = 0;
            }

            SPI_SCLK ^= 0x01;

            if ( SimSPIConfig.CPHA )
            {
                if ( TxData & BitPos )
                    SPI_MOSI = 1;
                else
                    SPI_MOSI = 0;
            }
            else
            {
                if ( SPI_MISO )
                    RxData |= BitPos;
            }

            SPI_SCLK ^= 0x01;

            if ( SimSPIConfig.CPHA )
            {
                if ( SPI_MISO )
                    RxData |= BitPos;
            }
        }
    }
    else
    {
        for ( BitPos = 0x0001; BitPos <= 0x8000; BitPos <<= 1 )
        {
            if ( SimSPIConfig.CPHA == 0 )
            {
                if ( TxData & BitPos )
                    SPI_MOSI = 1;
                else
                    SPI_MOSI = 0;
            }

            SPI_SCLK ^= 0x01;

            if ( SimSPIConfig.CPHA )
            {
                if ( TxData & BitPos )
                    SPI_MOSI = 1;
                else
                    SPI_MOSI = 0;
            }
            else
            {
                if ( SPI_MISO )
                    RxData |= BitPos;
            }

            SPI_SCLK ^= 0x01;

            if ( SimSPIConfig.CPHA )
            {
                if ( SPI_MISO )
                    RxData |= BitPos;
            }
        }
    }

    return RxData;
}
