#include "UDS_22Service_Filter.h"

// clang-format off

const uint8_t  S22DLC [] = {
                            2u, 2u, 2u, 2u,
                           };
const uint16_t S22DID [] = {
    0xF193u, /*硬件版本号                     R  */
    0xF195u, /*软件版本信息                   R  */
    0x0300u, /*配置1                          WR */
    0x0301u, /*配置2                          WR */
};

/**
 *22�����Ƿ�֧�ֹ���Ѱַ
 *����Ѱַ�����θø�����
 *@return ���������
 */
uint8_t UDS_22Service_NRC11(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
 *22����Ự�Ƿ�֧����֤
 *����Ѱַ�����θø�����
 *@return ���������
 */
uint8_t UDS_22Service_NRC7F(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
 *22��������ȼ���֤
 *@return ���������
 */
uint8_t UDS_22Service_NRC33(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
 *22������С������֤
 *@return ���������
 */
uint8_t UDS_22Service_NRC13_MinLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if ( DiagMSG.msgDLC != 2u )
    {
        NRC = incorrectMessageLength;
        UDS_Service_Response(0x22u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
 *22���񳬳�����Χ��֤
 *����Ѱַ�����θø�����
 *@return ���������
 */
uint8_t UDS_22Service_NRC31(void)
{
    uint8_t i;
    uint8_t NRC   = requestOutOfRange;
    uint8_t count = 0u;

    // if(GetTsetCtrl())
    if ( 1 )
    {
        count = DIM(S22DID);
    }
    else
    {
        count = DIM(S22DID) - 2u;
    }
    for ( i = 0u; i < count; ++i )
    {
        if ( getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == S22DID [ i ] )
        {
            NRC = positiveResponse;
            break;
        }
    }
    if ( (NRC == requestOutOfRange) && (DiagMSG.msgID == DIAG_ID_Rx_PHY) )
    {
        UDS_Service_Response(0x22u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
    }
    return NRC;
}

/**
 *22�����ܳ��ȳ�����֤
 *@return ���������
 */
uint8_t UDS_22Service_NRC13_TotalLengthCheck(void)
{
    uint8_t i;
    uint8_t NRC = positiveResponse;
    // for(i = 0u; i < DIM(S22DID); ++i)
    //{
    // if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == S22DID[i])
    //{
    if ( DiagMSG.msgDLC != 2 )
    {
        NRC = incorrectMessageLength;
        UDS_Service_Response(0x22u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    // break;
    // }
    // }
    return NRC;
}

/**
 *22����������֤
 *@return ���������
 */
uint8_t UDS_22Service_NRC22(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}
