#include "UDS_2FService_Main.h"
#include "UDS_2FService_Internal.h"

/**
 *2F服务函数入口
 *@param A_TA_type 收到数据的地址
 *@param A_Length 收到数据的长度
 *@param A_Data 收到数据的数据
 */
void UDS_Service_2F_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data [])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if ( NRC == positiveResponse )
    {
        NRC = UDS_2FService_NRC11( ); /*2F服务是否支持功能寻址*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_2FService_NRC7F( ); /*2F服务会话是否支持验证*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_2FService_NRC33( ); /*2F服务解锁等级验证*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_2FService_NRC13_MinLengthCheck( ); /*2F服务最小长度验证*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_2FService_NRC31( ); /*2F服务超出请求范围验证*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_2FService_NRC13_TotalLengthCheck( ); /*2F服务总长度长度验证*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_2FService_NRC22( ); /*2F服务条件验证*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_2FService_NRC12( ); /*2F???????????*/
    }
    if ( NRC == positiveResponse )
    {
        UDS_2FService_DID( ); /*2F����DID�ж�*/
    }
    clearDiagMSG( ); /*清除诊断信息*/
}

/**
 *2F服务子功能
 */
void UDS_2FService_DID(void)
{
    switch ( getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) ) /*2F服务DID判断*/
    {
        case 0xF001:
            UDS_2FService_DID_F001( ); /*灯1*/
            break;
        case 0xF002:
            UDS_2FService_DID_F002( ); /*灯2*/
        break;
        case 0xF003:
            UDS_2FService_DID_F003( ); /*灯3*/
            break;
        case 0xF004:
            UDS_2FService_DID_F004( ); /*灯4*/
            break;
        case 0xF005:
            UDS_2FService_DID_F005( ); /*灯4*/
            break;
        case 0xF006:
            UDS_2FService_DID_F006( ); /*灯4*/
            break;
        case 0xF007:
            UDS_2FService_DID_F007( ); /*灯4*/
            break;

        case 0x6201:
            UDS_2FService_DID_6201( ); /*断码测试*/
            break;
        case 0x6202:
            UDS_2FService_DID_6202( ); /*声音测试*/
            break;
        case 0x6203:
            UDS_2FService_DID_6203( ); /*左右盲区控制测试*/
            break;
        case 0x6205:
            UDS_2FService_DID_6205( ); /*TFTLCD测试*/
            break;
        case 0x6206:
            UDS_2FService_DID_6206();/*背光测试*/
            break;
        default:
            break;
    }
}

/**
  *2F服务DIDF001
  *LEDCtrl_1
  */
void UDS_2FService_DID_F001(void)
{
    LEDCtrl_1 ControlOption;
    LEDCtrl_1_Mask ControlEnableMask;
    ControlOption.Byte[0] = DiagMSG.msgData.DidDetail.Data[1];
    ControlEnableMask.Byte[0] = DiagMSG.msgData.DidDetail.Data[2];
    Lamp1WarningTest(DiagMSG.msgData.DidDetail.Data  [ 0 ],ControlOption,ControlEnableMask);
    if(DiagMSG.msgData.DidDetail.Data [ 0 ] == 0u)
    {
        UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 3u, DiagMSG.msgData.Data);
    }
    else
    {
        UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 5u, DiagMSG.msgData.Data);
    }
    
}

/**
  *2F服务DIDF002
  *LEDCtrl_2
  */
void UDS_2FService_DID_F002(void)
{
    LEDCtrl_2 ControlOption;
    LEDCtrl_2_Mask ControlEnableMask;
    ControlOption.Byte[0] = DiagMSG.msgData.DidDetail.Data[1];
    ControlEnableMask.Byte[0] = DiagMSG.msgData.DidDetail.Data[2];
    Lamp2WarningTest(DiagMSG.msgData.DidDetail.Data  [ 0 ],ControlOption,ControlEnableMask);
    if(DiagMSG.msgData.DidDetail.Data [ 0 ] == 0u)
    {
        UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 3u, DiagMSG.msgData.Data);
    }
    else
    {
        UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 5u, DiagMSG.msgData.Data);
    }
}

/**
  *2F服务DIDF003
  *LEDCtrl_3
  */
void UDS_2FService_DID_F003(void)
{
    LEDCtrl_3 ControlOption;
    LEDCtrl_3_Mask ControlEnableMask;
    ControlOption.Byte[0] = DiagMSG.msgData.DidDetail.Data[1];
    ControlEnableMask.Byte[0] = DiagMSG.msgData.DidDetail.Data[2];
    Lamp3WarningTest(DiagMSG.msgData.DidDetail.Data  [ 0 ],ControlOption,ControlEnableMask);
    if(DiagMSG.msgData.DidDetail.Data [ 0 ] == 0u)
    {
        UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 3u, DiagMSG.msgData.Data);
    }
    else
    {
        UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 5u, DiagMSG.msgData.Data);
    }
}

/**
  *2F服务DIDF004
  *LEDCtrl_4
  */
void UDS_2FService_DID_F004(void)
{
    LEDCtrl_4 ControlOption;
    LEDCtrl_4_Mask ControlEnableMask;
    ControlOption.Byte[0] = DiagMSG.msgData.DidDetail.Data[1];
    ControlEnableMask.Byte[0] = DiagMSG.msgData.DidDetail.Data[2];
    Lamp4WarningTest(DiagMSG.msgData.DidDetail.Data  [ 0 ],ControlOption,ControlEnableMask);
    if(DiagMSG.msgData.DidDetail.Data [ 0 ] == 0u)
    {
        UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 3u, DiagMSG.msgData.Data);
    }
    else
    {
        UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 5u, DiagMSG.msgData.Data);
    }
}

/**
 *2F服务DIDF005
 *LEDCtrl_5
 */
void UDS_2FService_DID_F005(void)
{
    if(DiagMSG.msgData.DidDetail.Data [ 0 ] == 0u)
    {
        UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 3u, DiagMSG.msgData.Data);
    }
    else
    {
        UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 5u, DiagMSG.msgData.Data);
    }
}

/**
 *2F服务DIDF006
 *display fuel meter
 */
void UDS_2FService_DID_F006(void)
{
    FuelMeterControl(DiagMSG.msgData.DidDetail.Data[0],DiagMSG.msgData.DidDetail.Data[2]);
    if(DiagMSG.msgData.DidDetail.Data [ 0 ] == 0u)
    {
        UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 3u, DiagMSG.msgData.Data);
    }
    else
    {
        UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 5u, DiagMSG.msgData.Data);
    }
}

/**
 *2F服务DIDF007
 *1、燃油：水温表 Temperature meter
 *2、混动：电量表 display SOC meter
 */
void UDS_2FService_DID_F007(void)
{
    TemperatureMeterControl(DiagMSG.msgData.DidDetail.Data[0],DiagMSG.msgData.DidDetail.Data[1]);
    if(DiagMSG.msgData.DidDetail.Data [ 0 ] == 0u)
    {
        UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 3u, DiagMSG.msgData.Data);
    }
    else
    {
        UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
    }
}

void UDS_2FService_DID_6201(void)
{
    SegmentLCDTest_Factory(DiagMSG.msgData.DidDetail.Data [ 0 ], DiagMSG.msgData.DidDetail.Data [ 1 ]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}
void UDS_2FService_DID_6202(void)
{
    BuzzerTest_Factory(DiagMSG.msgData.DidDetail.Data [ 0 ], DiagMSG.msgData.DidDetail.Data [ 1 ]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}
void UDS_2FService_DID_6203(void)
{
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}
void UDS_2FService_DID_6205(void)
{
    Factory_ODO_Test(DiagMSG.msgData.DidDetail.Data [ 0 ], DiagMSG.msgData.DidDetail.Data [ 1 ]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}
void UDS_2FService_DID_6206(void)
{
    BackLight_Test(DiagMSG.msgData.DidDetail.Data [ 0 ], DiagMSG.msgData.DidDetail.Data [ 1 ]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}
