#ifndef __UDS_COMMON_H
#define __UDS_COMMON_H

#include "NVM.h"
#include "string.h"
#include "CAN_Lib.h"
#include "TYW_stdint.h"
#include "RTE_CAN.h"
#include "CAN_APP.h"
#include "UDS_DTC.h"
#include "EOL_Para.h"
// #include "NM_Config.h"
#include "rh850_macros.h"
#include "Sound_Player.h"
#include "NVM_Interface.h"
#include "Telltales_user.h"
#include "Telltales_Lib.h"
#include "Internal_EEPROM.h"
#include "Services_Mileage.h"
#include "Common_Interface.h"
#include "Services_Mileage.h"
#include "UDS_ISO14229_Server.h"
#include "DoCAN_ISO15765_Config.h"
#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "UDS_ISO14229_Server_Config.h"

#define CalculateBlockSize(n)  ((n + 63) / 64)

/*每个结构占用的块数*/ 
#define WriteProgramValidFlagBlockSize      CalculateBlockSize(sizeof(DiagFlagUnion))
#define WriteSer27BlockSize                 CalculateBlockSize(sizeof(Ser27_FlowCtrlCntUnion))  
#define WriteEOL0300DataBlockSize           CalculateBlockSize(sizeof(EOL0300ToDFlashInfoUnion)) 
#define WriteEOL0301DataBlockSize           CalculateBlockSize(sizeof(EOL0301ToDFlashInfoUnion)) 
/*实际的存储位置*/
#define WriteProgramValidFlagAddr           (0)
#define WriteSer27Addr                      (WriteProgramValidFlagAddr + WriteProgramValidFlagBlockSize) 
#define WriteEOL0300DataAddr                (WriteSer27Addr + WriteSer27BlockSize)
#define WriteEOL0301DataAddr                (WriteEOL0300DataAddr + WriteEOL0300DataBlockSize)

#define WriteDTCAddr                        INTERNAL_EE_BLOCK_00

/**
  *正负反馈
  */
#define POSITIVE_RSP ( uint8_t )0x00           /*正反馈*/
#define NEGATIVE_RSP (uint8_t)(! POSITIVE_RSP) /*负反馈*/

/**
  *DFlash
  */
#define NoNeedWait   0x00u
#define NeedWait     0x01u
#define JumpToBoot02 0x58856336u
#define JumpToBoot82 0x85583663u
#define JumpToBoot42 0x58583636u

/**
  *10服务和子服务
  *诊断会话
  */
#define DiagnosticSessionControl  0x10u
#define DefaultSession            0x01u
#define ProgrammingSession        0x02u
#define ExtendedDiagnosticSession 0x03u

/**
  *11服务和子服务
  *ECU复位
  */
#define ECUReset  0x11u
#define HardReset 0x01u
#define SoftReset 0x03u

/**
  *14服务和子服务
  *清除故障信息
  */
#define ClearDiagnosticInformation 0x14u

/**
  *19服务和子服务
  *读取故障信息
  */
#define ReadDTCInformation                 0x19u
#define ReportNumberOfDTCByStatusMask      0x01u
#define ReportDTCByStatusMask              0x02u
#define ReportDTCSnapshotRecordByDTCNumber 0x04u
#define ReportSupportedDTC                 0x0Au

#define NoSupport             0x00u
#define NeedSupport           0x01u
#define NormalVottage         0x00u
#define LowVottage            0x01u
#define HightVottage          0x02u
#define AgeingCount           40u
#define OfflineLoopMultiple   5u
#define MaxDTCPendingCount    1u
#define MinimumVoltage        9000u
#define RestoreMinimumVoltage 9500u
#define MaximumVoltage        16500u
#define RestoreMaximumVoltage 16000u
#define LowVoltageTimer       2000u
#define HightVoltageTimer     2000u

#define DTCError           0x01u
#define DTCErrorThisCycle  0x02u
#define DTCPending         0x04u
#define DTCConfirmed       0x08u
#define DTCNoTestLastClear 0x10u
#define DTCErrorLastClear  0x20u
#define DTCNoTestThisCycle 0x40u
#define DTCNoError         0xFEu

#define DTCMask 0x09u

#define KL15DTCEnableTimer       3000u
#define KL15DTCEnableTimer_4s    4000u
#define H_LVoltageDTCEnableTimer 1000u
#define BusOffDTCEnableTimer     1000u

/**
  *22服务和子服务
  *通过DID来读数据
  */
#define ReadDataByIdentifier 0x22u

/**
  *27服务和子服务
  *安全访问
  */
#define SecurityAccess             0x27u
#define requestSeed_LV1            0x01u
#define sendKey_LV1                0x02u
#define requestSeed_LV11           0x11u
#define sendKey_LV11               0x12u
#define NormalKeyUnlock            0x01u
#define NormalKeyLock              0x00u
#define BootKeyUnlock              0x02u
#define BootKeyLock                0x00u
#define SER27_MAX_REQ_SEED_NUM     0x03u
#define SER27_MAX_INVAILD_KEY_NUM  0x03u
#define SER27_CLEAR_REQ_SEEDED     0x00u
#define SER27_REQ_SEEDED           0x01u
#define SER27_ERR_DELAY_TIMER_EN   0x01u
#define SER27_ERR_DELAY_SER_PERIOD 100u
#define SER27_ERR_DELAY_TIMEOUT    10000u

/**
  *28服务和子服务
  *通讯控制
  */
#define CommunicationControl             0x28u
#define enableRxAndTx                    0x00u
#define enableRxAndDisableTx             0x01u
#define disableRxAndEnableTx             0x02u
#define disableRxAndTx                   0x03u
#define normalMsg                        0x01u
#define networkManagementMsg             0x02u
#define networkManagementMsgAndnormalMsg 0x03u

/**
  *2E服务和子服务
  *通过DID来写数据
  */
#define WriteDataByIdentifier     0x2Eu
#define WriteEOL0300Data          0x02u
#define WriteEOL0301Data          0x02u

/**
  *2F服务和子服务
  *通过DID来控制ECU
  */
#define InputOutputControlByIdentifier 0x2Fu
#define WhiteColor                     0x01u
#define BlackColor                     0x02u
#define RedColor                       0x03u
#define GreenColor                     0x04u
#define BlueColor                      0x05u
#define GaugeSpeed                     0x01u
#define GaugeTacho                     0x02u
#define GaugeFuel                      0x03u
#define GaugeEngCoolantTemp            0x04u
#define ZeroPosition                   0x00u
#define HalfPosition                   0x01u
#define FullPosition                   0x02u
#define Contrl                         0x03u
#define Resume                         0x00u

/**
  *31服务和子服务
  *历程控制
  */
#define RoutineControl                 0x31u
#define startRoutine                   0x01u
#define stopRoutine                    0x02u
#define requestRoutineResults          0x03u
#define MaintenanceReset               0X62F1u
#define CheckMemory                    0x0202u
#define UpdateConditionCheck           0x0203u
#define ECU_selftest                   0xDFF0u
#define EraseMemory                    0xFF00u
#define CheckProgrammingDependencies   0xFF01u
#define RoutineCompletedSuccessfully   0x04u
#define RoutineCompletedUnsuccessfully 0x05u

/**
  *3E服务和子服务
  *维持当前会话
  */
#define TesterPresent   0x3Eu
#define ZeroSubFunction 0x00u

/**
  *85服务和子服务
  *故障检测控制
  */
#define ControlDTCSetting 0x85u
#define DTCSettingOn      0x01u
#define DTCSettingOff     0x02u

/**
  *诊断支持的否定响应代码
  */
#define positiveResponse                        0x00u
#define serviceNotSupported                     0x11u
#define subFunctionNotSupported                 0x12u
#define incorrectMessageLength                  0x13u
#define responseTooLong                         0x14u
#define conditionsNotCorrect                    0x22u
#define requestSequenceError                    0x24u
#define requestOutOfRange                       0x31u
#define securityAccessDenied                    0x33u
#define invalidKey                              0x35u
#define exceedNumberOfAttempts                  0x36u
#define requiredTimeDelayNotExpired             0x37u
#define uploadDownloadNotAccepted               0x70u
#define transferDataSuspended                   0x71u
#define generalProgrammingFailure               0x72u
#define wrongBlockSequenceCounter               0x73u
#define requestCorrectlyReceivedResponsePending 0x78u
#define subfunctionNotSupportinActiveSession    0x7Eu
#define serviceNotSupportedInActiveSession      0x7Fu
#define engineIsRunning                         0x83u
#define engineIsNotRunning                      0x84u
#define engineRunTimeTooLow                     0x85u
#define voltageTooHigh                          0x92u
#define voltageTooLow                           0x93u

#define getDID(DID_H, DID_L)                   (( uint16_t )((( uint16_t )(DID_H)) << 8u) | ( uint16_t )(DID_L))
#define toUint16_t(data0, data1)               (( uint16_t )((( uint16_t )(data0)) << 8u) | ( uint16_t )(data1))
#define toUint32_t(data0, data1, data2, data3) (( uint32_t )((( uint32_t )(data0)) << 24u) | ( uint32_t )((( uint32_t )(data1)) << 16u) | ( uint32_t )((( uint32_t )(data2)) << 8u) | ( uint32_t )(data3))
#define isBCD(data)                            (((( uint8_t )(( data )&0x0Fu)) < 0x0Au) && ((( uint8_t )((( uint8_t )(( data )&0xF0u)) >> 4u)) < 0x0Au))
#define DIM(X)                                 (sizeof(X) / sizeof((X) [ 0 ]))
#define L2B32(Little) (((Little & 0xff) << 24) | (((Little >> 8) & 0xff) << 16) | (((Little >> 16) & 0xff) << 8) | ((Little >> 24) & 0xff))
#define L2B16(Little) (((Little >> 8) & 0xff)) | ((Little & 0xff) << 8)
/**
  * TYPEDEFS
  */
typedef union
{
    uint8_t Data [ 100 ];
    struct
    {
        uint8_t SubID               : 7;
        uint8_t PositiveSuppression : 1;
        uint8_t Data [ 99 ];
    } SidDetail;
    struct
    {
        uint8_t DID_H;
        uint8_t DID_L;
        uint8_t Data [ 98 ];
    } DidDetail;
    struct
    {
        uint32_t Parameter : 24;
        uint8_t  Data [ 97 ];
    } S14Detail;
    struct
    {
        uint8_t SubID;
        uint8_t DID_H;
        uint8_t DID_L;
        uint8_t Data [ 97 ];
    } S31Detail;
    struct
    {
        uint8_t SubID               : 7;
        uint8_t PositiveSuppression : 1;
        uint8_t ContrlType;
        uint8_t Data [ 98 ];
    } S28Detail;

} msgDataUnion;

typedef struct
{
    uint32_t     msgID;
    uint16_t     msgDLC;
    msgDataUnion msgData;
} DiagMSGUnion;

typedef struct
{
    uint8_t  LV1Ctrl;
    uint8_t  LV1DelayCtrl;
    uint16_t LV1DelayTimer;
    uint8_t  LV1SafetyStatus;
    uint8_t  LV1Seed [ 4 ];
    uint8_t  LV1Key [ 4 ];
    uint8_t  LV11Ctrl;
    uint8_t  LV11DelayCtrl;
    uint16_t LV11DelayTimer;
    uint8_t  LV11SafetyStatus;
    uint8_t  LV11Seed [ 4 ];
    uint8_t  LV11Key [ 4 ];
} Ser27_FlowCtrlUnion;

typedef struct
{
    uint32_t Flag;
    uint32_t JumpToBootFlag;
    uint32_t AppValidFlag;
    uint32_t S11Flag;
} DiagFlagUnion;

typedef struct
{
    uint32_t Flag;
    uint8_t  LV1ReqSeedCnt;
    uint8_t  LV1InvaidKyeCnt;
    uint8_t  LV11ReqSeedCnt;
    uint8_t  LV11InvaidKyeCnt;
    uint32_t RandNum;
} Ser27_FlowCtrlCntUnion;

typedef struct
{
  uint32_t Flag;
  uint8_t  DID_0300 [ 90 ];
  uint8_t  Filling  [ 2 ];
}EOL0300ToDFlashInfoUnion;//12

typedef struct
{
  uint32_t Flag;
  uint8_t  DID_0301 [ 224 ];
}EOL0301ToDFlashInfoUnion;//12


/*
typedef struct
{
    uint32_t OdometerValue;
    uint8_t  SystemSupplyVoltage;
    uint16_t VehicleSpeed;
    uint8_t  DTCLocalTime_second;
    uint8_t  DTCLocalTime_minute;
    uint8_t  DTCLocalTime_hour;
    uint8_t  DTCLocalTime_day;
    uint8_t  DTCLocalTime_month;
    uint8_t  DTCLocalTime_year;
} SnapshotUnion;

typedef struct
{
    uint8_t  DTCStatus;
    uint8_t  DTCAgeing;
    uint8_t  DTCCount;
    uint8_t  DTCPendingCount;
    SnapshotUnion Snapshot;
} DTCUnion;

typedef struct
{
    uint32_t Flag;
    DTCUnion DTC[19u];
} DTCToDFlashInfoUnion;

static const DTCUnion NVMDTC_DEFAULT = {0x50,0,0,0,{0,0,0,0,0,0,0,0,},};
*/
typedef void (*InitFunction)(void);

extern uint8_t                    S31DID0203Status;
extern DiagMSGUnion               DiagMSG;
extern DiagFlagUnion              DiagFlag;
extern Ser27_FlowCtrlUnion        Ser27_FlowCtrl;
extern Ser27_FlowCtrlCntUnion     Ser27_FlowCtrlCnt;
extern EOL0300ToDFlashInfoUnion   EOL0300ToDFlashInfo;
extern EOL0301ToDFlashInfoUnion   EOL0301ToDFlashInfo;

void         setSessionType(uint8_t status);
uint8_t      getSessionType(void);
void         setDiagMSG(uint32_t Identifier, uint16_t dlc, uint8_t Data []);
DiagMSGUnion getDiagMSG(void);
void         clearDiagMSG(void);
uint16_t     getSpeed(void);
uint16_t     getESpeed(void);
uint16_t     getKL30Voltage(void);
uint8_t      getKL15Status(void);
uint8_t      getSecurityLevel(void);
void         Ser27_ChangeSessionHandle(void);
void         UDS_RESET(void);
void         UDS_Delay(uint16_t count);
void         UDS_S11_Sand(uint8_t subid);
void         UDS_S11_Confirm(void);
void         UDS_NRC78_Sand(uint8_t sid);
void         UDS_50us_Service(void);
void         UDS_10ms_Service(void);
void         UDS_KL15_init(void);
void         UDS_Slepp(void);
void         MsgLostTimer(uint16_t timer);
void         ReceivedMsg(uint32_t MsgID, uint8_t DLC);
void         S3_Service(uint16_t timer);
void         S3_ServiceClear(void);
void         S3_ServiceWait(void);
void         S3_ServiceTimeOut(void);
void         Ser27_ErrDelayTimerService(uint16_t timer);
void         ControlMessageCommunication(uint8_t Type, uint8_t Status);
void         enableDTCTimer(uint16_t Timer);
uint8_t      isDTCEnable(void);
void         setDTCEnableTimer(uint16_t Timer);
void         OpenDTCTest(void);
void         CloseDTCTest(void);
uint8_t      DTCTestIsOpen(void);
void         DTCAgeing(void);
void         ReadAllDFlashData(void);
uint8_t      ReadDFlashData(uint16_t u16BlockNum, uint32_t u32Data [], uint16_t u16Len, InitFunction initFunction, uint8_t ReadType);
uint8_t      WriteDFlashData(uint16_t u16BlockNum, uint32_t u32Data [], uint16_t u16Len, uint8_t isWait, uint8_t WriteType);
void         AllFlagInit(void);
void         Ser27ToDFlashInfoInit(void);
void         DTCToDFlashInfoInit(void);
void         DTCConfigurationInit(void);
void         CAFDToDFlashInfoInit(void);
/***********************************************************************/
/*********************22DID define**************************************/
#define DE09 0    //对应表格7行  高配的DE10  低配的DE09
#define CW07 1    //对应表格7行  高配的DE16  低配的CW07
#define DE54 0    //对应表格7行  高配的DE18  低配的DE54

typedef struct
{   /*((dl+did+dat+crc+15)/16)*16*/
    uint8_t D_F120  [((2+2+ 4+4+15)/16)*16];
    uint8_t D_F121  [((2+2+ 4+4+15)/16)*16];
    uint8_t D_F122  [((2+2+ 4+4+15)/16)*16];
    uint8_t D_F189  [((2+2+ 9+4+15)/16)*16];
    uint8_t D_F089  [((2+2+ 9+4+15)/16)*16];
    uint8_t D_F187_1[((2+2+21+4+15)/16)*16];
    uint8_t D_F187_2[((2+2+21+4+15)/16)*16];
    uint8_t D_F187_3[((2+2+21+4+15)/16)*16];
    uint8_t D_F188_1[((2+2+20+4+15)/16)*16];
    uint8_t D_F188_2[((2+2+20+4+15)/16)*16];
    uint8_t D_F188_3[((2+2+20+4+15)/16)*16];
    uint8_t D_F18A  [((2+2+ 7+4+15)/16)*16];
    uint8_t D_F18C  [((2+2+13+4+15)/16)*16];//
    uint8_t D_F170  [((2+2+ 8+4+15)/16)*16];
    uint8_t D_F171  [((2+2+ 4+4+15)/16)*16];//
    uint8_t D_F123  [((2+2+20+4+15)/16)*16];//
    uint8_t D_F201  [((2+2+ 1+4+15)/16)*16];//
    uint8_t D_F1FA  [((2+2+ 6+4+15)/16)*16];
}ReadOnlayStructure;

typedef struct
{
  uint32_t Data22Addr ;
  uint32_t DidTotalNum ;
}DIDInfoStucture;

extern ReadOnlayStructure *DID_Data;
#define DID_INFO_ADDR 0x38100

extern uint8_t UDS_22_ButtonStatus;

uint32_t Check_Infordata_CRC_32(uint8_t p[],uint32_t len);
uint8_t IGNON_4S(void);
#endif
