
#include "eepromManage.h"
#include "RTE_WDT.h"
#include "RTE_GPIO.h"
#include "rh850_macros.h"

//���� SCL��SDA��IO �ܽ�

#define SCL_INPUT EEORIN_SCL_INPUT
#define SCL_OUT   EEORIN_SCL_OUT
#define SDA_INPUT EEORIN_SDA_INPUT
#define SDA_OUT   EEORIN_SDA_OUT
#define SCLDIR    EEORIN_SCLDIR
#define SDADIR    EEORIN_SDADIR
/*-------------------------------------------------------------------------
* Function Name  : EE_FeedDog
* Description    : ���� DOG
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/

void EE_SDA_OutConfig(void);

void EE_FeedDog(void)
{
    //���Ź�Keep
    WDT_Clear( );
}

/*-------------------------------------------------------------------------
* Function Name  : EE_NOP
* Description    : nop ָ��
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_NOP(void)
{
    int i = 0;
    for ( i = 0; i < 10; i++ )
    {
        nop( );
    }
}

/*-------------------------------------------------------------------------
* Function Name  : eeprom_StoreInfo_Init
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void eeprom_StoreInfo_Init(void)
{
    EE_SDA_OutConfig( );
    eeprom_SetParameter(AT24C16, distance_10m);
}

/*-------------------------------------------------------------------------
* Function Name  : eeprom_comm_DelayUs
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void eeprom_comm_DelayUs(unsigned long time)
{
    unsigned long i;

    for ( i = 0; i <= time; i++ )
    {
        EE_NOP( );
        EE_FeedDog( );
    }
}

/*-------------------------------------------------------------------------
* Function Name  : EE_SDA_InConfig
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_SDA_InConfig(void)
{
    SDADIR = 1;
}
/*-------------------------------------------------------------------------
* Function Name  : EE_SDA_OutConfig
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_SDA_OutConfig(void)
{
    SDADIR = 0;
}
/*-------------------------------------------------------------------------
* Function Name  : EE_SDA_GetValue
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
unsigned char EE_SDA_GetValue(void)
{
    return SDA_INPUT;
}

/*-------------------------------------------------------------------------
* Function Name  : EE_SCL_OUT
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_SCL_OUT(unsigned char data)
{
    SCLDIR  = 0;
    SCL_OUT = data;
}

/*-------------------------------------------------------------------------
* Function Name  : EE_SDA_OUT
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_SDA_OUT(unsigned char data)
{
    SDA_OUT = data;
}
