#include "AMT630H.h"
#include "TYW_stdint.h"
#include "UartProtocol.h"
#include "RTE_GPIO.h"
#include "PicBin.h"
#include "RTE_WDT.h"
#include "Common_Interface.h"

#define AMT630H_ERR_TIME            10000U
#define AMT630H_RELEASE_MODE        1U
unsigned int AMT630H_InitTime = 0;
uint8_t g_sysFlag_Lcdcheck = 0;
/* Initialization */
LCD_TFT_SOUND_PARA_ST LcdSoundParamterData;
SOFTWARE_VERSION_ST amt630Version;

uint8_t Amt630hInitFinishFlag = 0;

uint32_t Amt630hInitTimerCnts = 0;
uint32_t Amt630hSequentialTimerCnts = 0;
uint32_t Amt630hFlashCheckTimerCnts = 0;
uint32_t Amt630hServiceTimerCnts = 0;


/* SOC Error */
uint16_t AMT630H_REQ_Time[ALIVE_COUNTER_TOTAL] = { 0 };
uint8_t AMT630H_Err = 0U;
uint8_t AMT630H_AliveCounter[ALIVE_COUNTER_TOTAL] = { 0 };
uint16_t AMT630H_CrcErrTime = 0;
uint32_t AMT630H_CrcErrCounter = 0;
uint8_t AMT630H_CrcErrMaxCounter = 0;

/* Flash Check */
#define  FLASH_CHECK_TIME_NUM       20000
s_AMT630H_FlashCheck_t AMT630H_FlashCheck;

/* Delay Time */
unsigned long Delay_Time = 0;
unsigned long Delay_Time_Set = 0;

/* Refresh Time */
unsigned long AMT630H_RefreshTime = 0;
static uint8_t AMT630H_Animation_Start = 0;
static uint8_t AMT630H_Animation_Finish = 0;
static uint16_t AMT630H_Animation_DispPic = 0;
static uint16_t AMT630H_Animation_RefreshTime = 0;
static uint16_t AMT630H_Animation_RefreshTime_default = 0;
static const uint16_t BootAnimationList[AMT630H_ANIMATION_PIC_NUM] = {
    Pic_0066_0_0,  Pic_0065_0_0,  Pic_0064_0_0,  Pic_0063_0_0,  Pic_0062_0_0,  Pic_0061_0_0,  Pic_0007_0_0,  
};
void AMT630H_Animation_PlayProc(uint16_t PicIndex)
{
    unsigned char *pBuf;
    uint32_t tmpLen = 0;
    SetPageGuid(GRAPHICS_PAGE_0, 1, 1, 1); 
    SetPageBackground(GRAPHICS_PAGE_0, PicIndex);
    PackedTransfer_Page();
    PackedTransfer_GetSwVer();

}
/* Timer */
void AMT630H_Timer(unsigned char Tms)
{
    unsigned char i = 0U;

    for(i = 0; i < ALIVE_COUNTER_TOTAL; i++)
    {
        if(AMT630H_REQ_Time[i] < AMT630H_ERR_TIME)
        {
            AMT630H_REQ_Time[i] += Tms;
        }
    }
    if(AMT630H_RefreshTime < AMT630H_REFRESH_TIME)
    {
        AMT630H_RefreshTime += Tms;
    }
    if(Delay_Time < Delay_Time_Set)
    {
        Delay_Time += Tms;
    }
    if(AMT630H_InitTime < 5000)
    {
        AMT630H_InitTime += Tms;
    }
    if(AMT630H_Animation_Finish == 0)
    {
        if(AMT630H_Animation_RefreshTime < AMT630H_ANIMATION_TIME)
        {
            AMT630H_Animation_RefreshTime += Tms;
        }
    }
    else
    {
        AMT630H_Animation_RefreshTime = 0;
    }
}
void Delay_Time_Ctrl(unsigned long Tms)
{
    Delay_Time = 0;
    Delay_Time_Set = Tms;

    while(Delay_Time < Delay_Time_Set)
    {
        WDT_Clear();
    }

    Delay_Time = 0;
    Delay_Time_Set = 0;
}

uint8_t UartRevBuff[0x1000] = { 0 };
uint32_t UartRevCnts = 0;
void Amt630hUartRecvData(uint16_t u16UARTData)
{
    UartRevBuff[UartRevCnts++] = (u16UARTData & 0xff);
    if (UartRevCnts >= 0x1000) 
    {
        UartRevCnts = 0;
    }
}
void AMT630H_RstCtrl(void)
{
    VCC_3V3_EN = 0;
    VCC_1V3_EN = 0;
    MCU_STBYB_LCD = 0;
    MCU_RSTB_LCD = 0;   
    Delay_Time_Ctrl(10);
    VCC_1V3_EN = 1;
    Delay_Time_Ctrl(15);
    VCC_3V3_EN = 1;
    AMT_PWRCTL_3V3 = 1;
    Power_3V3_Ctrl = 1;
    Delay_Time_Ctrl(170);
    MCU_RSTB_LCD = 1;      
    Delay_Time_Ctrl(12);             
    MCU_STBYB_LCD = 1;        
    Delay_Time_Ctrl(20);
    PWR_1530_EN = 1;
}
void Amt630hInit(void)
{
    uint8_t i = 0;
    AMT630H_RstCtrl();
    AMT630H_RefreshTime = AMT630H_REFRESH_TIME;
    // Error State Init
    AMT630H_Err = 0U;
    for(i = 0; i < ALIVE_COUNTER_TOTAL; i++)
    {
        AMT630H_REQ_Time[i] = 0U;
        AMT630H_AliveCounter[i] = 0;
    }
    AMT630H_CrcErrTime = 0;
    AMT630H_CrcErrCounter = 0;

    // Param Config
    LcdSoundParamterData.LcdWidth = 800;
    LcdSoundParamterData.LcdHeight = 480;
    LcdSoundParamterData.LcdBpp = 32;
    LcdSoundParamterData.LcdVideoInputValid = 0;
    LcdSoundParamterData.Ark7116ResetPin = 0;
    LcdSoundParamterData.LcdInterfaceType = LCD_INTERFACE_TTL;
    LcdSoundParamterData.LcdWiringMode = LCD_WIRING_MODE_BGR;
    LcdSoundParamterData.LcdWiringBitOrder = LCD_WIRING_BIT_ORDER_LSB;
    LcdSoundParamterData.LcdDotClkReverse = 1;
    LcdSoundParamterData.LvdsPanelFormat = LVDS_PANEL_FORMAT_TI;
    LcdSoundParamterData.LvdsPanelData = LVDS_PANEL_DATA_8BIT;
    LcdSoundParamterData.LcdTimingVBP = 20;
    LcdSoundParamterData.LcdTimingVFP = 25;
    LcdSoundParamterData.LcdTimingVSW = 3;
    LcdSoundParamterData.LcdTimingHBP = 48;
    LcdSoundParamterData.LcdTimingHFP = 210;
    LcdSoundParamterData.LcdTimingHSW = 3;
    LcdSoundParamterData.LcdClkFreq = 27700000;
    LcdSoundParamterData.SoundChannelNum = 0;
    LcdSoundParamterData.SoundFreq = AUDIO_FREQ_NONE;
    SetLcdSoundParameter(&LcdSoundParamterData);
    SetSwVerBuf((uint8_t*)&amt630Version);
    User_PicIndexDataInit();
    ResetInitedState();    

    AnalysisUartData();

    AMT630H_InitTime = 0;

    AMT630H_Animation_Start = 0;
    AMT630H_Animation_Finish = 0;
    AMT630H_Animation_DispPic = 0;
    AMT630H_Animation_RefreshTime = 0;
    AMT630H_Animation_RefreshTime_default = AMT630H_ANIMATION_REFRESHTIME_DEF(0);

    Amt630hInitFinishFlag = 0;

    AMT630H_FlashCheck.Flag = 0;
    AMT630H_FlashCheck.InquireTime = 0;
    AMT630H_FlashCheck.CheckStateTime = 0;
    AMT630H_FlashCheck.Result = 0;
}
void AMT630H_Sleep(void)
{
    MCU_STBYB_LCD = 0;
    Delay_Time_Ctrl(30);
    VCC_3V3_EN = 0;
    AMT_PWRCTL_3V3 = 0;
    Power_3V3_Ctrl = 0;
    PWR_1530_EN = 0;
    VCC_1V3_EN = 0;
    MCU_RSTB_LCD = 0; 
}
static void AMT630H_AliveCounterMonitor(void)
{
    uint8_t i = 0;
    if(AMT630H_CrcErrCounter != GetCrcErrCnts())
    {
        AMT630H_CrcErrCounter = GetCrcErrCnts();
        AMT630H_CrcErrTime++;
        if(AMT630H_CrcErrTime >= 120)
        {
            AMT630H_Err = 1;
        }
        for(i = 0; i < ALIVE_COUNTER_TOTAL; i++)
        {
            AMT630H_REQ_Time[i] = 0;
        }
    }
    for(i = 0; i < ALIVE_COUNTER_TOTAL; i++)
    {
        if(AMT630H_AliveCounter[i] != GetAliveCounter(i))
        {
            AMT630H_AliveCounter[i] = GetAliveCounter(i);
            AMT630H_REQ_Time[i] = 0;
            if(AMT630H_CrcErrMaxCounter < AMT630H_CrcErrTime)
            {
                AMT630H_CrcErrMaxCounter = (unsigned char)AMT630H_CrcErrTime;
            }
            AMT630H_CrcErrTime = 0;
        }
        if(AMT630H_REQ_Time[i] >= AMT630H_ERR_TIME)
        {
            AMT630H_Err = 1;
        }
    }
}

void AMT630H_Main(void)
{
    unsigned char i;
    AnalysisUartData();
    if(GetLcdInitSt() != 1)
    {
        for(i = 0; i < ALIVE_COUNTER_TOTAL; i++)
        {
            AMT630H_REQ_Time[i] = 0U;           
        }
        return;
    }
    AMT630H_AliveCounterMonitor();
    if(AMT630H_Err == 1U)
    {
        AMT630H_Err = 0;
        Amt630hInit();
        AMT630H_Animation_Finish = 1;
        return;
    }
    if(g_sysFlag_Lcdcheck == 1)
    {
        if(AMT630H_FlashCheck.Flag == 0)
        {
            AMT630H_FlashCheck.Flag = 1;
            AMT630H_FlashCheck.InquireTime = 0;
            AMT630H_FlashCheck.CheckStateTime = 0;
            PackedTransfer_CheckFlash();           
            AMT630H_FlashCheck.Result = 0xFF;
        }
        if(AMT630H_FlashCheck.Flag == 1)
        {
            if(AMT630H_FlashCheck.InquireTime >= 100)
            {
                AMT630H_FlashCheck.InquireTime = 0;
                AMT630H_FlashCheck.Result = PackedTransfer_CheckFlashGetResult();
                if(AMT630H_FlashCheck.Result != 0xFF)
                {
                    if(AMT630H_FlashCheck.Result == 1)
                    {
                        PackedTransfer_CheckFlashForceDisplay(DISPLAY_CHECK_PASS, 3000);
                        AMT630H_FlashCheck.Flag = 2;
                    }
                    else if (AMT630H_FlashCheck.CheckStateTime >= FLASH_CHECK_TIME_NUM)
                    {
                        PackedTransfer_CheckFlashForceDisplay(DISPLAY_CHECK_FAIL, 60000);
                        AMT630H_FlashCheck.Flag = 2;
                    }
                }
                
            }
            else
            {
                PackedTransfer_CheckFlashForceDisplay(DISPLAY_CHECKING, 60000);
            }
        }
    }
    if (Common_Get_IG_Sts( ) == COMMON_POWER_ON)
    {
        if(AMT630H_Animation_Finish == 1)
        {
            AMT630H_Animation_RefreshTime = 0;
            if(AMT630H_RefreshTime >= AMT630H_REFRESH_TIME)
            {                
                AMT630H_RefreshTime = 0;
                //AMT630H_GUI_DisplayProc();
            }
        }
        else
        {
            AMT630H_RefreshTime = 0;
            if(AMT630H_Animation_Start == 0)
            {
                AMT630H_Animation_Start = 1;                
                AMT630H_Animation_RefreshTime_default = AMT630H_ANIMATION_REFRESHTIME_DEF(0);
            }
            if(AMT630H_Animation_RefreshTime >= AMT630H_Animation_RefreshTime_default)
            {
                AMT630H_Animation_RefreshTime = 0;
                AMT630H_Animation_PlayProc(BootAnimationList[AMT630H_Animation_DispPic]);
                AMT630H_Animation_DispPic++;
                if(AMT630H_Animation_DispPic >= AMT630H_ANIMATION_PIC_NUM)
                {
                    AMT630H_Animation_Finish = 1;
                }
            }
        } 
    }
    else
    {
        AMT630H_Animation_RefreshTime = 0;
        if(AMT630H_RefreshTime >= AMT630H_REFRESH_TIME)
        {
            AMT630H_RefreshTime = 0;
            //AMT630H_GUI_DisplayProc();
        }
    }
}

unsigned char AMT630H_isInitFinish(void)
{
    if((AMT630H_InitTime >= 600) || (GetLcdInitSt() == 1))
    {
        return 1;
    }
    else
    {
        return 0;
    }
}